/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines.records;

import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.EngineRecords;
import java.util.ArrayList;
import java.util.List;

public final class SSHCmdRecords
extends EngineRecords {
    private StringBuilder stdOutBuffer = new StringBuilder();
    private List<String> lineSpitMessages = new ArrayList<String>();
    private StringBuilder stdErrBuffer = new StringBuilder();
    private List<String> lineSpitError = new ArrayList<String>();

    public SSHCmdRecords(String recordID) {
        super(recordID);
    }

    @Override
    public SSHCmdRecords setStates(EngineRecordStates states) {
        this.states = states;
        return this;
    }

    public SSHCmdRecords addMessages(String mesg) {
        this.stdOutBuffer.append(mesg).append("\n");
        this.lineSpitMessages.add(mesg);
        return this;
    }

    public SSHCmdRecords addErrors(String mesg) {
        this.stdErrBuffer.append(mesg).append("\n");
        this.lineSpitError.add(mesg);
        return this;
    }

    public String getResults() {
        return this.stdOutBuffer.toString();
    }

    public List<String> getLineMessages() {
        return this.lineSpitMessages;
    }

    public String getErrors() {
        return this.stdErrBuffer.toString();
    }

    public List<String> getLineErrors() {
        return this.lineSpitError;
    }

    public boolean containsError() {
        return !this.lineSpitError.isEmpty();
    }

    public void clearMesg() {
        this.stdOutBuffer.setLength(0);
        this.lineSpitMessages.clear();
        this.stdErrBuffer.setLength(0);
        this.lineSpitError.clear();
    }
}

