/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers;

import Gbt.core.engines.records.LocalCmdRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.AbstractCommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.utility.Common.CommonFunction;

public class GctIpmitoolCommandReceiver
extends AbstractCommandReceiver {
    private static volatile GctIpmitoolCommandReceiver ipmitoolCommandReceiver;
    private static final String DEFAULT_WIN_TOOL_PATH = "tools\\gctipmitool\\gbt_IpmiTool_v1_0_6-win.exe";
    private static final String DEFAULT_LNX_TOOL_PATH = "tools/gctipmitool/gbt_IpmiTool_v1_0_6-linux";
    private static String winToolPath;
    private static String lnxToolPath;

    private GctIpmitoolCommandReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final GctIpmitoolCommandReceiver getInstance() {
        if (ipmitoolCommandReceiver != null) return ipmitoolCommandReceiver;
        Class<GctIpmitoolCommandReceiver> clazz = GctIpmitoolCommandReceiver.class;
        synchronized (GctIpmitoolCommandReceiver.class) {
            if (ipmitoolCommandReceiver != null) return ipmitoolCommandReceiver;
            ipmitoolCommandReceiver = new GctIpmitoolCommandReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ipmitoolCommandReceiver;
        }
    }

    @Override
    public String getReceiverName() {
        return "GbtIpmitoolCommand Receiver";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeReceivers() {
        if (ipmitoolCommandReceiver != null) {
            Class<GctIpmitoolCommandReceiver> clazz = GctIpmitoolCommandReceiver.class;
            synchronized (GctIpmitoolCommandReceiver.class) {
                if (ipmitoolCommandReceiver != null) {
                    try {
                        ipmitoolCommandReceiver.close();
                        ipmitoolCommandReceiver = null;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return true;
                    }
                    catch (Exception e) {
                        this.taskPool.shutdownNow();
                        this.taskPool = null;
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), this.getReceiverName(), "Close " + this.getReceiverName() + " fail.", e);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return false;
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
        return true;
    }

    public LocalCmdRecords executeCommand(String bmcIP, String bmcAccount, String bmcPassword, String cmd, GbtLogLevel logLevel, String commandName, String commandID) {
        String command = (CommonFunction.isWindows() ? GctIpmitoolCommandReceiver.getWinToolPath() : GctIpmitoolCommandReceiver.getLnxToolPath()) + " -H " + bmcIP + " -U " + bmcAccount + " -P " + bmcPassword + " " + cmd;
        return GbtLocalCommandReceiver.getInstance().executeLocalCommand(command, logLevel, commandName, commandID);
    }

    public static void setWinToolPath(String path) {
        winToolPath = path;
    }

    public static void setLnxToolPath(String path) {
        lnxToolPath = path;
    }

    public static final String getWinToolPath() {
        return winToolPath.equals("") ? DEFAULT_WIN_TOOL_PATH : winToolPath;
    }

    public static final String getLnxToolPath() {
        return lnxToolPath.equals("") ? DEFAULT_LNX_TOOL_PATH : lnxToolPath;
    }

    static {
        winToolPath = "";
        lnxToolPath = "";
    }
}

