/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers.async;

import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.SolMessageRecords;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import com.veraxsystems.vxipmi.api.sol.SerialOverLan;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;

public final class SolMessageListener
implements Callable<SolMessageRecords> {
    private final SerialOverLan serialOverLan;
    private final AbstractLoggerWriter loggerWriter;
    private final String commandName;
    private final String remoteBMCIP;
    private volatile SolMessageRecords solRecords;

    public SolMessageListener(SerialOverLan serialOverLan, String commandName) {
        this.serialOverLan = serialOverLan;
        this.loggerWriter = new DefaultLoggerWriter(this.getClass());
        this.commandName = commandName;
        this.remoteBMCIP = this.serialOverLan.getSession().getConnectionHandle().getRemoteAddress().getHostAddress();
        this.solRecords = new SolMessageRecords(this.remoteBMCIP + "_" + this.commandName);
    }

    @Override
    public SolMessageRecords call() throws CancellationException {
        while (!Thread.currentThread().isInterrupted()) {
            this.solRecords.setStates(EngineRecordStates.Running);
            String text = this.serialOverLan.readString();
            if (text.isEmpty()) continue;
            text = text.replaceAll("\\x1b\\[[0-9;]*H", "");
            text = text.replaceAll("\\x1b\\[[0-9;]*m", "");
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.INFO, this.solRecords.getRecordsID(), text);
            this.solRecords.appendMessages(text);
        }
        try {
            this.loggerWriter.close();
            return this.solRecords.setStates(EngineRecordStates.Pass);
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.solRecords.getRecordsID(), "[" + this.remoteBMCIP + "] Log writer not closed.");
            return this.solRecords.setStates(EngineRecordStates.Fail);
        }
    }

    public final synchronized SolMessageRecords getSolRecords() {
        return this.solRecords;
    }
}

