/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.protocol;

import Gbt.core.vmedia.protocol.Cmd10;
import Gbt.core.vmedia.protocol.Cmd12;
import java.nio.ByteBuffer;

public class SCSICommandPacket {
    public static final int SCSI_TEST_UNIT_READY = 0;
    public static final int SCSI_READ_CAPACITY = 37;
    public static final int SCSI_READ_10 = 40;
    public static final int SCSI_READ_12 = 168;
    public static final int SCSI_READ_TOC = 67;
    public static final int SCSI_START_STOP_UNIT = 27;
    public static final int SCSI_MEDIUM_REMOVAL = 30;
    private int opCode;
    private byte lun;
    private int lba;
    private Cmd10 cmd10;
    private Cmd12 cmd12;

    public SCSICommandPacket(ByteBuffer request) {
        this.setOpCode(request.get() & 0xFF);
        this.setLun(request.get());
        this.setLba(request.getInt());
        if (this.getOpCode() == 40 || this.getOpCode() == 67) {
            this.setCmd10(new Cmd10());
            this.getCmd10().setReserved6(request.get());
            this.getCmd10().setLength(request.getShort());
            int bufferLength = this.getCmd10().getReserved9().length;
            byte[] test = new byte[bufferLength];
            this.getCmd10().setReserved9(new byte[bufferLength]);
            request.get(test, 0, bufferLength);
            System.arraycopy(test, 0, this.getCmd10().getReserved9(), 0, test.length);
        } else if (this.getOpCode() == 168) {
            this.setCmd12(new Cmd12());
            this.getCmd12().setLength32(request.getInt());
            int bufferLength = this.getCmd12().getReserved10().length;
            byte[] testReserve = new byte[bufferLength];
            this.getCmd12().setReserved10(new byte[bufferLength]);
            request.get(testReserve, 0, bufferLength);
            System.arraycopy(testReserve, 0, this.getCmd12().getReserved10(), 0, testReserve.length);
        }
    }

    public SCSICommandPacket() {
    }

    public Cmd10 getCmd10() {
        return this.cmd10;
    }

    public void setCmd10(Cmd10 cmd10) {
        this.cmd10 = cmd10;
    }

    public Cmd12 getCmd12() {
        return this.cmd12;
    }

    public void setCmd12(Cmd12 cmd12) {
        this.cmd12 = cmd12;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    public byte getLun() {
        return this.lun;
    }

    public void setLun(byte lun) {
        this.lun = lun;
    }

    public int getLba() {
        return this.lba;
    }

    public void setLba(int lba) {
        this.lba = lba;
    }
}

