/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.CUPS;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.CUPS.CUPSIPMIOptions;
import Gbt.utility.CUPS.CUPSReadingData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class CUPSCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "cups";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected CUPSCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        CUPSIPMIOptions[] cupsArray = new CUPSIPMIOptions[]{CUPSIPMIOptions.GET_INDEX, CUPSIPMIOptions.GET_CPU, CUPSIPMIOptions.GET_MEMORY, CUPSIPMIOptions.GET_IO};
        boolean result = true;
        if (((Builder)this.commandArgs).sensorNumber == -1) {
            for (CUPSIPMIOptions option : cupsArray) {
                if (this.sendCUPSCommand(handle, option)) continue;
                result = false;
            }
        } else {
            result = this.sendCUPSCommand(handle, CUPSIPMIOptions.GET_CUSTOM);
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        return result;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private boolean sendCUPSCommand(ConnectionHandle handle, CUPSIPMIOptions option) {
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, option, this.commandArgs, this.getCommandName(), this.commandID);
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            this.commandResults.add(temp);
            return !temp.isError();
        }
        if (resp instanceof CUPSReadingData) {
            CUPSReadingData temp = resp.castConcreteJSON(CUPSReadingData.class);
            switch (option) {
                case GET_CUSTOM: {
                    temp.setSensorNumber(((Builder)this.commandArgs).sensorNumber);
                }
            }
            this.commandResults.add(temp);
            return true;
        }
        this.commandResults.add(new NullJSONData().setError(true).setMessages("CUPS command respone fail."));
        return false;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private int sensorNumber;

        @Override
        public boolean checkArgs() {
            return this.bmcIP != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public AbstractCommand<Builder> build() {
            return new CUPSCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.sensorNumber = -1;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setSensorNumber(int sensorNum) {
            this.sensorNumber = sensorNum;
            return this.getThis();
        }

        public int getSensorNumber() {
            return this.sensorNumber;
        }
    }
}

