/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.Common.GbtFileReadDoc;
import Gbt.utility.Common.GbtFileReadDocx;
import Gbt.utility.Common.GbtFileReadPDF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.net.tftp.TFTPClient;

public final class CommonFunction {
    private CommonFunction() {
    }

    public static final void createFolder(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            System.out.println("creating directory: " + path);
            if (dir.mkdirs()) {
                System.out.println(path + " folder created");
            }
        }
    }

    public static final List<String> readFile(String fileName) {
        String tempStr = null;
        ArrayList<String> records = new ArrayList<String>();
        try {
            FileReader src = new FileReader(fileName);
            BufferedReader br = new BufferedReader(src);
            while ((tempStr = br.readLine()) != null) {
                records.add(tempStr);
            }
            src.close();
            br.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("No such file.");
            return records;
        }
        catch (IOException e) {
            System.out.println("I/O read error.");
            return records;
        }
        return records;
    }

    public static final String byteMACtoString(byte[] data) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            byte[] bytes = new byte[]{data[i]};
            if (i != data.length - 1) {
                sbuilder.append(GbtCommonConverters.bytesToHex(bytes)).append(":");
                continue;
            }
            sbuilder.append(GbtCommonConverters.bytesToHex(bytes));
        }
        return sbuilder.toString();
    }

    public static final String getPlatform() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static final boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static final boolean isUnix() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.contains("nix") || OS.contains("nux") || OS.contains("mac") || OS.indexOf("aix") > 0;
    }

    public static final boolean isValidateIP(String ipAddress) {
        try {
            if (ipAddress.indexOf(":") > 0) {
                ipAddress = ipAddress.split(":")[0];
            }
            InetAddress.getByName(ipAddress);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static final boolean isIPv4(String ipAddress) {
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            switch (address.getAddress().length) {
                case 4: {
                    return true;
                }
                case 16: {
                    return false;
                }
            }
            return false;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static final boolean isIPv6(String ipAddress) {
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            switch (address.getAddress().length) {
                case 4: {
                    return false;
                }
                case 16: {
                    return true;
                }
            }
            return false;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static final List<File> searchFilesInDirector(String dir, String fileNameToSearch, boolean contain) {
        return CommonFunction.searchFilesInDirector(new File(dir), fileNameToSearch, contain);
    }

    public static final List<File> searchFilesInDirector(File dir, String fileNameToSearch, boolean contain) {
        ArrayList<File> results = new ArrayList<File>();
        if (!dir.isDirectory()) {
            return results;
        }
        if (!dir.canRead()) {
            return results;
        }
        for (File subfile : dir.listFiles()) {
            if (subfile.isDirectory()) {
                List<File> caches = CommonFunction.searchFilesInDirector(subfile, fileNameToSearch, contain);
                if (caches.isEmpty()) continue;
                results.addAll(caches);
                continue;
            }
            if (!contain) {
                if (!subfile.getName().equalsIgnoreCase(fileNameToSearch)) continue;
                results.add(subfile);
                continue;
            }
            if (!subfile.getName().toLowerCase().contains(fileNameToSearch.toLowerCase())) continue;
            results.add(subfile);
        }
        return results;
    }

    public static final List<String> readDocumentsAsLineList(String path) {
        if (path.endsWith(".docx")) {
            return GbtFileReadDocx.getReadList(path);
        }
        if (path.endsWith(".doc")) {
            return GbtFileReadDoc.getReadList(path);
        }
        if (path.endsWith(".pdf")) {
            return GbtFileReadPDF.getReadList(path);
        }
        return null;
    }

    public static final String readDocumentsAsString(String path) {
        if (path.endsWith(".docx")) {
            return GbtFileReadDocx.getReadText(path);
        }
        if (path.endsWith(".doc")) {
            return GbtFileReadDoc.getReadText(path);
        }
        if (path.endsWith(".pdf")) {
            return GbtFileReadPDF.getReadText(path);
        }
        return null;
    }

    public static final String grepLineMessages(List<String> lineMessages, String keywords) {
        if (lineMessages == null) {
            return "";
        }
        if (lineMessages.isEmpty()) {
            return "";
        }
        for (String lineMessage : lineMessages) {
            if (!lineMessage.contains(keywords)) continue;
            return lineMessage;
        }
        return "";
    }

    public static final String grepLineMessages(List<String> lineMessages, String startKey, boolean containStartKeyLine, String endKey, boolean containEndKeyLine) {
        StringBuilder builder = new StringBuilder();
        if (lineMessages == null) {
            return builder.toString();
        }
        if (lineMessages.isEmpty()) {
            return builder.toString();
        }
        boolean lock = false;
        for (String lineMessage : lineMessages) {
            if (lineMessage.contains(startKey)) {
                lock = true;
            }
            if (!(!lock || !containStartKeyLine && lineMessage.contains(startKey) || !containEndKeyLine && lineMessage.contains(endKey))) {
                builder.append(lineMessage);
            }
            if (!lineMessage.contains(endKey)) continue;
            lock = false;
            break;
        }
        return builder.toString();
    }

    public static final String getStringFromByteList(ArrayList<Byte> data, int startIndex, int EndIndex) {
        byte[] temp = new byte[EndIndex - startIndex + 1];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = data.get(startIndex + i);
        }
        return new String(temp);
    }

    public static final int getIntegerFromByteList(ArrayList<Byte> data, int startIndex, int EndIndex) {
        byte[] temp = new byte[EndIndex - startIndex + 1];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = data.get(startIndex + i);
        }
        return GbtCommonConverters.ByteArraytoInt(temp);
    }

    public static final List<InetAddress> getCurrentMachineIPAddresses() {
        ArrayList<InetAddress> suitableIPAddresses = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = netInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.isSiteLocalAddress() || address.isLoopbackAddress() || address.getHostAddress().contains(":")) continue;
                    suitableIPAddresses.add(address);
                }
            }
            return suitableIPAddresses;
        }
        catch (SocketException se) {
            return suitableIPAddresses;
        }
    }

    public static final Inet4Address getClosestIPv4Address(List<InetAddress> ipAddresses, String targetIP) throws UnknownHostException {
        for (int i = 3; i > 0; --i) {
            for (InetAddress ipAddress : ipAddresses) {
                if (!(ipAddress instanceof Inet4Address)) continue;
                InetAddress comparedIP = Inet4Address.getByName(targetIP);
                int matchCount = 0;
                for (int j = 0; j < i; ++j) {
                    if ((ipAddress.getAddress()[j] & 0xFF) != (comparedIP.getAddress()[j] & 0xFF)) continue;
                    ++matchCount;
                }
                if (matchCount != i) continue;
                return (Inet4Address)ipAddress;
            }
        }
        return null;
    }

    public static final Inet4Address getClosestIPv4Address(List<InetAddress> ipAddresses, Inet4Address targetIP) {
        for (int i = 3; i > 0; --i) {
            for (InetAddress ipAddress : ipAddresses) {
                if (!(ipAddress instanceof Inet4Address)) continue;
                int matchCount = 0;
                for (int j = 0; j < i; ++j) {
                    if ((ipAddress.getAddress()[j] & 0xFF) != (targetIP.getAddress()[j] & 0xFF)) continue;
                    ++matchCount;
                }
                if (matchCount != i) continue;
                return (Inet4Address)ipAddress;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void downloadFileFromTFTP(String hostname, String localFilename, String remoteFilename) {
        FileOutputStream output = null;
        TFTPClient tftp = new TFTPClient();
        tftp.setDefaultTimeout(20000);
        try {
            Thread.sleep(3000L);
            tftp.open();
            File file = new File(localFilename);
            if (file.exists()) {
                file.delete();
            }
            output = new FileOutputStream(file);
            tftp.receiveFile(remoteFilename, 1, (OutputStream)output, hostname);
        }
        catch (SocketException e) {
            System.out.println("[TFTPclient] getFileFromTFTP - SocketException: could not open local UDP socket. " + e.getMessage());
        }
        catch (UnknownHostException e) {
            System.out.println("[TFTPclient] getFileFromTFTP - UnknownHostException: could not resolve hostname." + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("[TFTPclient] getFileFromTFTP - IOException: could not open local file for writing." + e.getMessage());
        }
        catch (InterruptedException e) {
            System.out.println("[TFTPclient] getFileFromTFTP - InterruptedException: could not open local file for writing." + e.getMessage());
        }
        finally {
            tftp.close();
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                System.err.println("[TFTPclient] IOException: error closing file." + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void uploadFiletoTFTP(String hostname, String localFilename, String remoteFilename) {
        FileInputStream input = null;
        TFTPClient tftp = new TFTPClient();
        tftp.setDefaultTimeout(60000);
        try {
            tftp.open();
            input = new FileInputStream(localFilename);
            tftp.sendFile(remoteFilename, 1, (InputStream)input, hostname);
        }
        catch (SocketException e) {
            System.out.println("[TFTPclient] sendFiletoTFTP - SocketException: could not open local UDP socket. " + e.getMessage());
        }
        catch (UnknownHostException e) {
            System.err.println("[TFTPclient] sendFiletoTFTP - UnknownHostException: could not resolve hostname. " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("[TFTPclient] sendFiletoTFTP - IOException: I/O exception occurred while sending file. " + e.getMessage());
        }
        finally {
            tftp.close();
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                System.err.println("[TFTPclient] sendFiletoTFTP - IOException: error closing file.");
                System.err.println(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean downloadFromURL(URL remoteURL, File dstPath) {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = remoteURL.openStream();
            out = new FileOutputStream(dstPath);
            CommonFunction.copy(in, out);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isVersionEqual(String ver1, String ver2) {
        String[] ver2Split;
        String[] ver1Split = ver1.split("\\.");
        if (ver1Split.length != (ver2Split = ver2.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < ver1Split.length; ++i) {
            if (Integer.parseInt(ver1Split[i]) == Integer.parseInt(ver2Split[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isVersionEqual(String ver1, String ver2, int compareAccount) {
        String[] ver1Split = ver1.split("\\.");
        String[] ver2Split = ver2.split("\\.");
        if (ver1Split.length < compareAccount || ver2Split.length < compareAccount) {
            return false;
        }
        for (int i = 0; i < compareAccount; ++i) {
            if (Integer.parseInt(ver1Split[i]) == Integer.parseInt(ver2Split[i])) continue;
            return false;
        }
        return true;
    }

    private static final void copy(InputStream in, OutputStream out) throws IOException, InterruptedException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) != -1) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interrupt download file.");
            }
            out.write(buffer, 0, readCount);
        }
    }
}

