/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.ws.rs.client.Client;

public final class SocketUtil {
    private static final int MAXIMUM_RETRY_COUNT = 10;
    private static final int SSL_HANDSHAKE_TIMEOUT = 5000;
    private static final int SOCKET_CONNECT_TIMEOUT = 900;

    private SocketUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized int getFreePort() throws SocketException {
        boolean success = false;
        int retry = 0;
        int port = 0;
        DatagramSocket ds = null;
        while (!success) {
            try {
                ds = new DatagramSocket(0);
                port = ds.getLocalPort();
                success = true;
            }
            catch (SocketException se) {
                if (++retry != 10) continue;
                throw se;
            }
            finally {
                if (ds == null) continue;
                ds.close();
            }
        }
        return port;
    }

    public static final synchronized DatagramSocket getAvailableDatagramSocket(InetAddress IPAddress) throws SocketException {
        int retry = 0;
        int port = 0;
        DatagramSocket ds = null;
        while (true) {
            try {
                ds = new DatagramSocket(0, IPAddress);
                ds.setReuseAddress(true);
                port = ds.getLocalPort();
                return ds;
            }
            catch (SocketException e) {
                System.out.println("DatagramSocket bind Port " + port + " get bind exception, retry: " + ++retry);
                if (retry != 10) continue;
                throw e;
                if (retry < 10) continue;
                return ds;
            }
            break;
        }
    }

    public static final synchronized List<String> getAllNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws SocketException {
        ArrayList<String> IPAddress = new ArrayList<String>();
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    IPAddress.add(addr.getHostAddress());
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                IPAddress.add(addr.getHostAddress());
            }
        }
        return IPAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized boolean isPortAvailable(int port) {
        boolean portAvaliable = true;
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket(port);
        }
        return portAvaliable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized boolean isTCPPortAvailable(int port) {
        ServerSocket socket = null;
        boolean portAvaliable = true;
        try {
            socket = new ServerSocket(port);
        }
        catch (IOException e) {
            portAvaliable = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    portAvaliable = false;
                }
            }
        }
        return portAvaliable;
    }

    public static final Socket createHttpSocket(Client httpClient, String ipaddress, int port) {
        Socket sock = null;
        sock = SocketUtil.createSSLSocket(httpClient, ipaddress, port);
        if (sock == null) {
            sock = SocketUtil.createNonSSLSocket(ipaddress, port);
        }
        return sock;
    }

    public static final Socket createNonSSLSocket(String ipaddress, int port) {
        try {
            Socket sock = new Socket();
            sock.connect(new InetSocketAddress(ipaddress, port), 900);
            return sock;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final SSLSocket createSSLSocket(Client httpClient, String ipaddress, int port) {
        SSLSocket socket = null;
        boolean handShakeSuccess = true;
        HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault());
        SSLSocketFactory factory = HttpsURLConnection.getDefaultSSLSocketFactory();
        try {
            socket = (SSLSocket)factory.createSocket(ipaddress, port);
        }
        catch (IOException | NullPointerException e) {
            return null;
        }
        if (socket != null) {
            try {
                socket.setSoTimeout(5000);
                socket.startHandshake();
            }
            catch (IOException ste) {
                handShakeSuccess = false;
            }
            finally {
                try {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        socket = null;
                    }
                    catch (IOException ioe) {
                        handShakeSuccess = false;
                        socket = null;
                    }
                }
                catch (Throwable throwable) {
                    socket = null;
                    throw throwable;
                }
            }
        }
        if (handShakeSuccess) return socket;
        try {
            socket = (SSLSocket)httpClient.getSslContext().getSocketFactory().createSocket();
            socket.connect(new InetSocketAddress(ipaddress, port), 900);
            System.out.println("Target : " + ipaddress + ":" + port + " connected.");
            return socket;
        }
        catch (IOException e) {
            System.out.println("Target : " + ipaddress + ":" + port + " fail.");
            return null;
        }
    }
}

