/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static final boolean decompress(String srcPath) {
        File srcFile = new File(srcPath);
        return ZipUtils.decompress(srcFile);
    }

    public static final boolean decompress(File srcFile) {
        String basePath = srcFile.getParent();
        return ZipUtils.decompress(srcFile, basePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean decompress(File srcFile, File destFile) {
        if (!ZipUtils.checkSubDirectory(srcFile)) {
            String subName = FilenameUtils.removeExtension((String)srcFile.getName());
            destFile = new File(srcFile.getParent() + File.separator + subName);
        }
        FilterInputStream cis = null;
        ZipInputStream zis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(srcFile), new CRC32());
            zis = new ZipInputStream(cis);
            ZipUtils.decompress(destFile, zis);
        }
        catch (FileNotFoundException fne) {
            System.out.println(srcFile.getAbsolutePath() + " not found.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (cis != null && zis != null) {
                try {
                    cis.close();
                    zis.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean decompress(String srcFilePath, boolean NotCreateSubFolder) {
        File srcFile = new File(srcFilePath);
        File destFile = new File(srcFile.getParent());
        if (!NotCreateSubFolder && !ZipUtils.checkSubDirectory(srcFile)) {
            String subName = FilenameUtils.removeExtension((String)srcFile.getName());
            destFile = new File(srcFile.getParent() + File.separator + subName);
        }
        FilterInputStream cis = null;
        ZipInputStream zis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(srcFile), new CRC32());
            zis = new ZipInputStream(cis);
            ZipUtils.decompress(destFile, zis);
        }
        catch (FileNotFoundException e) {
            System.out.println(srcFile.getAbsolutePath() + " not found.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (cis != null && zis != null) {
                try {
                    cis.close();
                    zis.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return true;
    }

    public static final boolean decompress(File srcFile, String destPath) {
        return ZipUtils.decompress(srcFile, new File(destPath));
    }

    public static final boolean decompress(String srcPath, String destPath) {
        File srcFile = new File(srcPath);
        return ZipUtils.decompress(srcFile, destPath);
    }

    private static final boolean decompress(File destFile, ZipInputStream zis) {
        ZipEntry entry = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                String dir = destFile.getPath() + File.separator + entry.getName();
                File dirFile = new File(dir);
                ZipUtils.fileProber(dirFile);
                if (entry.isDirectory()) {
                    dirFile.mkdirs();
                } else {
                    ZipUtils.decompressFile(dirFile, zis);
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static final void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            ZipUtils.fileProber(parentFile);
            parentFile.mkdir();
        }
    }

    private static final void decompressFile(File destFile, ZipInputStream zis) {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));){
            int count;
            byte[] data = new byte[1024];
            while ((count = zis.read(data, 0, 1024)) != -1) {
                bos.write(data, 0, count);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final boolean checkSubDirectory(File srcFile) {
        File subDirPath;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile);
        }
        catch (Exception e1) {
            return false;
        }
        String subName = FilenameUtils.removeExtension((String)srcFile.getName());
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        boolean findSubDir = false;
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            for (String s : entry.getName().split("/")) {
                if (!subName.equals(s)) continue;
                findSubDir = true;
                break;
            }
            if (!findSubDir) continue;
            break;
        }
        if (!findSubDir && !(subDirPath = new File(srcFile.getParent() + File.separator + subName)).exists()) {
            subDirPath.mkdir();
            try {
                zipFile.close();
                return false;
            }
            catch (IOException e1) {
                return false;
            }
        }
        try {
            zipFile.close();
        }
        catch (IOException e1) {
            return false;
        }
        return true;
    }
}

