/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.FRU;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.FRU.GbtPowerCapacityJSONData;
import Gbt.utility.FRU.GetFRUCommand;

public enum GbtPowerCapacityIpmiOptions implements GbtIPMIOptions<GetFRUCommand.Builder>
{
    GET(0, "Get GBT power capacity", -101);

    private static final String GET_ITEM = "Get GBT power capacity";
    private static final byte NetFn = 46;
    private static final byte cmd = 17;
    private final int optionCode;
    private final String item;
    private byte operateByte;

    private GbtPowerCapacityIpmiOptions(int optionCode, String item, byte operateByte) {
        this.optionCode = optionCode;
        this.item = item;
        this.operateByte = operateByte;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return 17;
    }

    @Override
    public byte[] rebuildRequestData(GetFRUCommand.Builder commandArgs) {
        return new byte[]{10, 60, 0, this.operateByte};
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        GbtPowerCapacityJSONData gbtPowerCapacityJSONData = new GbtPowerCapacityJSONData();
        byte psuNumber = gbtResponseData.getAllResponseData()[3];
        gbtPowerCapacityJSONData.setPsuNmuber(psuNumber);
        return gbtPowerCapacityJSONData;
    }
}

