/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.FRU.record;

import Gbt.utility.FRU.record.FruRecord;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;

public final class ProductInfo
extends FruRecord {
    private String manufacturerName;
    private String productName;
    private String productModelNumber;
    private String productVersion;
    private String productSerialNumber;
    private String assetTag;
    private byte[] fruFileId;
    private String customProductInfo;

    public ProductInfo(byte[] fruData, int offset) {
        if (fruData[offset] != 1) {
            throw new IllegalArgumentException("Invalid format version");
        }
        int languageCode = TypeConverter.byteToInt(fruData[offset + 2]);
        int partNumber = TypeConverter.byteToInt(fruData[offset + 3]);
        this.readCustomInfo(fruData, languageCode, partNumber, offset + 4);
    }

    private void readCustomInfo(byte[] fruData, int languageCode, int partNumber, int offset) {
        int index = 0;
        int currentOffset = offset;
        int currentPartNumber = partNumber;
        StringBuilder buffer = new StringBuilder();
        block9: while (currentPartNumber != 193 && currentOffset < fruData.length) {
            int partType = (currentPartNumber & 0xC0) >> 6;
            int partDataLength = currentPartNumber & 0x3F;
            if (this.partDataLengthWithinBounds(fruData, currentOffset, partDataLength)) {
                byte[] partNumberData = new byte[partDataLength];
                System.arraycopy(fruData, currentOffset, partNumberData, 0, partDataLength);
                currentOffset += partDataLength;
                switch (index) {
                    case 0: {
                        this.setManufacturerName(ProductInfo.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 1: {
                        this.setProductName(ProductInfo.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 2: {
                        this.setProductModelNumber(ProductInfo.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 3: {
                        this.setProductVersion(ProductInfo.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 4: {
                        this.setProductSerialNumber(ProductInfo.decodeString(partType, partNumberData, true));
                        break;
                    }
                    case 5: {
                        this.setAssetTag(ProductInfo.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 6: {
                        this.setFruFileId(partNumberData);
                        break;
                    }
                    default: {
                        if (partDataLength == 0) {
                            currentPartNumber = TypeConverter.byteToInt(fruData[currentOffset]);
                            ++currentOffset;
                            continue block9;
                        }
                        buffer.append(ProductInfo.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                    }
                }
            }
            currentPartNumber = TypeConverter.byteToInt(fruData[currentOffset]);
            ++currentOffset;
            ++index;
        }
        if (buffer.length() > 0) {
            this.customProductInfo = buffer.toString();
        }
    }

    private boolean isEnglishLanguageCode(int languageCode) {
        return languageCode != 0 && languageCode != 25;
    }

    private boolean partDataLengthWithinBounds(byte[] fruData, int currentOffset, int partDataLength) {
        return partDataLength > 0 && partDataLength + currentOffset < fruData.length;
    }

    @JsonProperty(value="ManufacturerName")
    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    @JsonProperty(value="ProductName")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @JsonProperty(value="ProductModelNumber")
    public String getProductModelNumber() {
        return this.productModelNumber;
    }

    public void setProductModelNumber(String productModelNumber) {
        this.productModelNumber = productModelNumber;
    }

    @JsonProperty(value="ProductVersion")
    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    @JsonProperty(value="ProductSerialNumber")
    public String getProductSerialNumber() {
        return this.productSerialNumber;
    }

    public void setProductSerialNumber(String productSerialNumber) {
        this.productSerialNumber = productSerialNumber;
    }

    @JsonProperty(value="AssetTag")
    public String getAssetTag() {
        return this.assetTag;
    }

    public void setAssetTag(String assetTag) {
        this.assetTag = assetTag;
    }

    @JsonProperty(value="FruFileId")
    public byte[] getFruFileId() {
        return this.fruFileId;
    }

    public void setFruFileId(byte[] fruFileId) {
        this.fruFileId = fruFileId;
    }

    @JsonProperty(value="CustomProductInfo")
    public String getCustomProductInfo() {
        return this.customProductInfo;
    }

    public void setCustomProductInfo(String customProductInfo) {
        this.customProductInfo = customProductInfo;
    }
}

