/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HDDInfo.parsers;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.HDDInfo.HwInfoCollection;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class HwInfoParser {
    protected final File binFile;
    protected final int offset;

    public HwInfoParser(File binFile, HwInfoCollection hwInfoCollection) {
        this.binFile = binFile;
        this.offset = this.parseOffset(hwInfoCollection.getHeader());
    }

    public abstract List<AbstractJSONPOJO> parseHwInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int parseOffset(String header) {
        FilterInputStream dis = null;
        try {
            int i;
            dis = new DataInputStream(new FileInputStream(this.binFile));
            byte[] buffer = new byte[dis.available()];
            byte[] offsetByteBuffer = new byte[header.getBytes().length];
            ((DataInputStream)dis).readFully(buffer);
            for (i = 0; i < buffer.length - offsetByteBuffer.length; ++i) {
                System.arraycopy(buffer, i, offsetByteBuffer, 0, offsetByteBuffer.length);
                String temp = new String(offsetByteBuffer, StandardCharsets.UTF_8);
                if (!temp.equals(header)) continue;
                int n = i;
                return n;
            }
            i = -1;
            return i;
        }
        catch (IOException ioe) {
            int n = -1;
            return n;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ioe) {
                    dis = null;
                }
            }
        }
    }
}

