/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SmbiosType130
extends SmbiosTypeBase {
    private String fwVersion;
    private String deviceID;
    private String vendorID;
    private String classCode;
    private String slotNumber;
    private String portNumber;
    private String onBoardIndex;

    public SmbiosType130(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        byte[] deviceIDRaw = this.nextBYTES(2);
        byte[] vendorIDRaw = this.nextBYTES(2);
        byte[] classCodeRaw = this.nextBYTES(4);
        byte[] slotNumberRaw = this.nextBYTES(2);
        byte[] portNumberRaw = this.nextBYTES(2);
        this.skipBYTE();
        byte[] onBoardIndexRaw = this.nextBYTES(2);
        this.fwVersion = this.nextString();
        this.deviceID = GbtCommonConverters.bytesToHexReverse(deviceIDRaw);
        this.vendorID = GbtCommonConverters.bytesToHexReverse(vendorIDRaw);
        this.classCode = GbtCommonConverters.bytesToHexReverse(classCodeRaw);
        this.slotNumber = GbtCommonConverters.bytesToHexReverse(slotNumberRaw);
        this.portNumber = GbtCommonConverters.bytesToHexReverse(portNumberRaw);
        this.onBoardIndex = GbtCommonConverters.bytesToHexReverse(onBoardIndexRaw);
    }

    @JsonProperty(value="FwVersion")
    public String getFwVersion() {
        return this.fwVersion;
    }

    @JsonProperty(value="DeviceID")
    public String getDeviceID() {
        return this.deviceID;
    }

    @JsonProperty(value="VendorID")
    public String getVendorID() {
        return this.vendorID;
    }

    @JsonProperty(value="ClassCode")
    public String getClassCode() {
        return this.classCode;
    }

    @JsonProperty(value="SlotNumber")
    public String getSlotNumber() {
        return this.slotNumber;
    }

    @JsonProperty(value="PortNumber")
    public String getPortNumber() {
        return this.portNumber;
    }

    @JsonProperty(value="OnBoardIndex")
    public String getOnBoardIndex() {
        return this.onBoardIndex;
    }
}

