/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.parsers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.PldmUpdateFWInfo;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class PldmSuitableFwParser
extends SuitableFwParser {
    private final UpdateType updateType;

    public PldmSuitableFwParser(AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress, UpdateType updateType) {
        super(loggerWriter, commandName, commandId, bmcIpAddress);
        this.updateType = updateType;
    }

    @Override
    public PldmUpdateFWInfo parseSuitableFw(List<File> fwPackages, BoardInfo boardInfo, ProductInfo productInfo, BMCInfoJSONData mcinfo) {
        String boardProduct = boardInfo.getBoardProductName();
        String productName = productInfo.getProductName();
        ArrayList<PldmUpdateFWInfo> chosenPkgs = new ArrayList<PldmUpdateFWInfo>();
        for (File fwPkg : fwPackages) {
            String dirPath = FilenameUtils.removeExtension((String)fwPkg.getAbsolutePath());
            try {
                StringBuilder builder;
                PldmUpdateFWInfo pldmUpdateFWInfo = new PldmUpdateFWInfo();
                pldmUpdateFWInfo.setBmcVendor(mcinfo.getBmcVendor());
                pldmUpdateFWInfo.setTargetBmcIp(this.bmcIpAddress);
                pldmUpdateFWInfo.setUpdateType(this.updateType);
                pldmUpdateFWInfo.setFwFolderPath(dirPath);
                pldmUpdateFWInfo.setReleaseNote(null);
                pldmUpdateFWInfo.setIsPldmCase(true);
                List<File> projectTxt = CommonFunction.searchFilesInDirector(dirPath, "projects.txt", true);
                if (projectTxt.isEmpty()) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any projects.txt.");
                    return null;
                }
                List<String> pnames = CommonFunction.readFile(projectTxt.get(0).getAbsolutePath());
                if (!pnames.isEmpty()) {
                    builder = new StringBuilder();
                    for (String pname : pnames) {
                        builder.append(pname);
                    }
                } else {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any support projects in projects.txt!");
                    continue;
                }
                pldmUpdateFWInfo.setSupportedProductName(builder.toString().replace(" ", ""));
                builder.setLength(0);
                String fwExtension = ".fwpkg";
                String fwDirPath = dirPath + File.separator + (Object)((Object)this.updateType);
                if (!new File(fwDirPath).exists()) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] " + fwDirPath + " is not exist.");
                    continue;
                }
                List<File> fwpkgList = CommonFunction.searchFilesInDirector(fwDirPath, fwExtension, true);
                if (fwpkgList != null && fwpkgList.size() > 0) {
                    pldmUpdateFWInfo.setImagePath(fwpkgList.get(0).getAbsolutePath());
                }
                if (pldmUpdateFWInfo.getImagePath() == null || pldmUpdateFWInfo.getImagePath().equals("")) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any suitable .fwpkg from: " + dirPath);
                    continue;
                }
                if (this.compareBMCFWProductName(boardProduct, productName, pldmUpdateFWInfo, mcinfo)) {
                    chosenPkgs.add(pldmUpdateFWInfo);
                    continue;
                }
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any matched product name or board product from : \"" + pldmUpdateFWInfo.getFwFolderPath() + "\"");
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + pldmUpdateFWInfo.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Parse " + fwPkg.getAbsolutePath() + " fail.");
            }
        }
        if (chosenPkgs.isEmpty()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any suitable PLDM FW.");
            return null;
        }
        return (PldmUpdateFWInfo)chosenPkgs.get(0);
    }

    private boolean compareBMCFWProductName(String boardProduct, String productName, PldmUpdateFWInfo pldmUpdFwInfo, BMCInfoJSONData bmcInfoJSONData) {
        String _boardProduct;
        if (boardProduct == null && productName == null) {
            return false;
        }
        if (pldmUpdFwInfo.getSupportedProductName() == null) {
            return false;
        }
        if (pldmUpdFwInfo.getSupportedProductName().isEmpty()) {
            return false;
        }
        boardProduct = boardProduct.replace(" ", "");
        productName = productName.replace(" ", "");
        String string = bmcInfoJSONData.isAST2400() ? (boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-XX") : (_boardProduct = boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-00");
        String _productName = bmcInfoJSONData.isAST2400() ? (productName.split("-").length == 3 ? productName : productName + "-XX") : (productName.split("-").length == 3 ? productName : productName + "-00");
        for (String name : pldmUpdFwInfo.getSupportedProductName()) {
            String _name;
            String string2 = bmcInfoJSONData.isAST2400() ? (name.split("-").length == 3 ? name : name + "-XX") : (_name = name.split("-").length == 3 ? name : name + "-00");
            if (_name.equals(_productName)) {
                return true;
            }
            if (!_name.equals(_boardProduct)) continue;
            return true;
        }
        return false;
    }
}

