/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.monitor;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;

public class MonitorMemoryUsage {
    ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
    MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();

    public void printThreadMemoryUsage(AbstractLoggerWriter loggerWriter, String COMMAND_NAME, String COMMAND_ID, GbtLogLevel logLevel) {
        long[] threadIds = this.threadMXBean.getAllThreadIds();
        ThreadInfo[] threadInfos = this.threadMXBean.getThreadInfo(threadIds);
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "==================================");
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread Information:");
        for (ThreadInfo threadInfo : threadInfos) {
            loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread ID: " + threadInfo.getThreadId());
            loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread Name: " + threadInfo.getThreadName());
            loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread State: " + (Object)((Object)threadInfo.getThreadState()));
            loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread Memory Usage:" + this.threadMXBean.getThreadAllocatedBytes(threadInfo.getThreadId()) / 1024L / 1024L + " MB");
            loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "-----------------------");
        }
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, COMMAND_ID, "==================================");
    }

    public void printNowThreadMemoryUsage(AbstractLoggerWriter loggerWriter, String COMMAND_NAME, String COMMAND_ID, GbtLogLevel logLevel, long threadId) {
        ThreadInfo threadInfo = this.threadMXBean.getThreadInfo(threadId);
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "==================================");
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Now Thread Information:");
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread ID: " + threadInfo.getThreadId());
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread Name: " + threadInfo.getThreadName());
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread State: " + (Object)((Object)threadInfo.getThreadState()));
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Thread Memory Usage:" + this.threadMXBean.getThreadAllocatedBytes(threadInfo.getThreadId()) / 1024L / 1024L + " MB");
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "-----------------------------------");
    }

    public void printMemoryInfo(AbstractLoggerWriter loggerWriter, String COMMAND_NAME, String COMMAND_ID, GbtLogLevel logLevel) {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Memory Information:");
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Heap Memory Usage init = " + heapMemoryUsage.getInit() / 1024L / 1024L + " MB, committed = " + heapMemoryUsage.getCommitted() / 1024L / 1024L + " MB, max = " + heapMemoryUsage.getMax() / 1024L / 1024L + " MB");
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "Non-Heap Memory Usage init = " + nonHeapMemoryUsage.getInit() / 1024L / 1024L + " MB, committed = " + nonHeapMemoryUsage.getCommitted() / 1024L / 1024L + " MB, max = " + nonHeapMemoryUsage.getMax() / 1024L / 1024L + " MB");
        loggerWriter.appendPath(COMMAND_NAME).writeLogs(logLevel, COMMAND_ID, "==================================");
    }
}

