/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum ThermalApiOptions implements RedfishApiOptions
{
    UNKNOWN("/redfish/v1/Chassis/<id>/Thermal"),
    FAN("/redfish/v1/Chassis/<id>/Thermal"),
    TEMP("/redfish/v1/Chassis/<id>/Thermal");

    private static final String THERMAL_URI = "/redfish/v1/Chassis/<id>/Thermal";
    private final String mainUri;

    private ThermalApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            default: 
        }
        return "Unsupport option of thermal API.";
    }

    public String replaceSystemId(String systemID) {
        return this.getMainUri().replace("<id>", systemID);
    }

    public static final ThermalApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return ThermalApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

