/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.solconfig;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.solconfig.SolConfigData;
import Gbt.utility.solconfig.SolConfigIpmiOptions;
import Gbt.utility.solconfig.SolVolatileBitRates;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public final class SolConfigCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "solconfig";
    private volatile GbtIPMICommandReceiver ipmiReceiver;

    protected SolConfigCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start execute IPMI SOL configurations.");
        if (((Builder)this.commandArgs).getSolConfigData() == null) {
            SolConfigData solConfigData = new SolConfigData();
            for (int i = 0; i <= 8; ++i) {
                Method[] methods;
                if (i == 7) {
                    solConfigData.setPayloadChannel(new BigDecimal(1));
                    continue;
                }
                AbstractJSONPOJO responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, SolConfigIpmiOptions.parseOptionByCode(i, true), this.commandArgs, COMMAND_NAME, this.commandID);
                if (responseData instanceof NullJSONData) {
                    NullJSONData temp = responseData.castConcreteJSON(NullJSONData.class);
                    if (temp.isError()) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + SolConfigIpmiOptions.parseOptionByCode(i, true).getItem() + " fail.");
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                }
                for (Method method : methods = solConfigData.getClass().getMethods()) {
                    if (!method.isAnnotationPresent(JsonProperty.class)) continue;
                    try {
                        Object fieldValue = method.invoke((Object)responseData, new Object[0]);
                        if (fieldValue == null) continue;
                        String jsonPropertyName = method.getAnnotation(JsonProperty.class).value();
                        String fieldName = jsonPropertyName.substring(0, 1).toLowerCase() + jsonPropertyName.substring(1);
                        PropertyDescriptor propertyOrder = new PropertyDescriptor(fieldName, solConfigData.getClass());
                        propertyOrder.getWriteMethod().invoke((Object)solConfigData, fieldValue);
                    }
                    catch (IntrospectionException | IllegalAccessException | InvocationTargetException ies) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Error for parse the pojo field values", ies);
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                        return false;
                    }
                }
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, solConfigData.toString());
            this.commandResults.add(solConfigData);
        } else {
            for (int i = 0; i <= 8; ++i) {
                AbstractJSONPOJO responseData;
                if (i > 6 || !((responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, SolConfigIpmiOptions.parseOptionByCode(i, false), this.commandArgs, COMMAND_NAME, this.commandID)) instanceof NullJSONData)) continue;
                NullJSONData temp = responseData.castConcreteJSON(NullJSONData.class);
                this.commandResults.add(temp);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + SolConfigIpmiOptions.parseOptionByCode(i, false).getItem() + " fail.");
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private SolConfigData solConfigData;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 1) {
                    return false;
                }
                switch (this.args[0]) {
                    case "get": {
                        break;
                    }
                    case "set": {
                        this.solConfigData = new SolConfigData().initDefaults();
                        block18: for (int i = 1; i < this.args.length; ++i) {
                            String[] temp = this.args[i].split("=");
                            switch (temp[0]) {
                                case "enabled": {
                                    if (temp[1].equals("true")) {
                                        this.solConfigData.setEnabled(Boolean.TRUE);
                                        continue block18;
                                    }
                                    this.solConfigData.setEnabled(Boolean.FALSE);
                                    continue block18;
                                }
                                case "rate": {
                                    this.solConfigData.setVolatileBitRate(SolVolatileBitRates.parseByInt(Integer.parseInt(temp[1])));
                                    this.solConfigData.setNonVolatileBitRate(SolVolatileBitRates.parseByInt(Integer.parseInt(temp[1])));
                                    continue block18;
                                }
                                case "priv": {
                                    this.solConfigData.setPrivilegeLevel(PrivilegeLevel.parseByByte(GbtCommonConverters.stringToByte(temp[1])));
                                    continue block18;
                                }
                            }
                        }
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SolConfigCommand build() {
            return new SolConfigCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setSolConfigData(SolConfigData solConfigData) {
            this.solConfigData = solConfigData;
            return this.getThis();
        }

        public SolConfigData getSolConfigData() {
            return this.solConfigData;
        }
    }
}

