/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.protocol.encoder;

import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.encoder.IpmiEncoder;
import com.veraxsystems.vxipmi.common.TypeConverter;

public abstract class ProtocolEncoder
implements IpmiEncoder {
    protected byte encodeAuthenticationType(AuthenticationType authenticationType) {
        return TypeConverter.intToByte(authenticationType.getCode());
    }

    protected void encodeInt(int value, byte[] message, int offset) {
        byte[] array = TypeConverter.intToLittleEndianByteArray(value);
        if (array.length + offset > message.length) {
            throw new IndexOutOfBoundsException("Message is too short");
        }
        System.arraycopy(array, 0, message, offset, array.length);
    }

    protected void encodeSessionSequenceNumber(int value, byte[] message, int offset) {
        this.encodeInt(value, message, offset);
    }

    protected void encodeSessionId(int value, byte[] message, int offset) {
        this.encodeInt(value, message, offset);
    }

    protected abstract void encodePayloadLength(int var1, byte[] var2, int var3);

    protected int encodePayload(byte[] payload, byte[] message, int offset) {
        if (payload == null) {
            return offset;
        }
        if (payload.length + offset > message.length) {
            throw new IndexOutOfBoundsException("Message is too short");
        }
        System.arraycopy(payload, 0, message, offset, payload.length);
        return offset + payload.length;
    }
}

