/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection;

import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.payload.sol.SolAckState;
import com.veraxsystems.vxipmi.coding.payload.sol.SolInboundMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.connection.Connection;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.MessageHandler;
import com.veraxsystems.vxipmi.sm.StateMachine;
import com.veraxsystems.vxipmi.sm.events.Sendv20Message;

public class SolMessageHandler
extends MessageHandler {
    public SolMessageHandler(Connection connection, int timeout) {
        super(connection, timeout, 1, 15, "Sol");
    }

    @Override
    public int sendMessage(PayloadCoder payloadCoder, StateMachine stateMachine, int sessionId, boolean isOneWay) throws ConnectionException {
        int seq;
        this.validateSessionState(stateMachine);
        int n = seq = isOneWay ? this.messageQueue.getLastSequenceNumber() : this.messageQueue.add(payloadCoder);
        if (seq > 0) {
            stateMachine.doTransition(new Sendv20Message(payloadCoder, sessionId, seq, this.connection.getNextSessionSequenceNumber()));
        }
        return seq;
    }

    @Override
    protected void handleIncomingMessageInternal(Ipmiv20Message message) {
        SolInboundMessage payload = (SolInboundMessage)message.getPayload();
        if (payload.isAcknowledgeMessage()) {
            this.handleIncomingAcknowledgeMessage(message, payload);
        }
        if (payload.isDataCarrier()) {
            this.handleIncomingDataMessage(payload);
        }
    }

    private void handleIncomingAcknowledgeMessage(Ipmiv20Message message, SolInboundMessage payload) {
        PayloadCoder coder = this.messageQueue.getMessageFromQueue(payload.getAckNackSequenceNumber());
        byte tag = payload.getAckNackSequenceNumber();
        if (coder == null) {
            return;
        }
        try {
            ResponseData responseData = coder.getResponseData(message);
            this.connection.notifyResponseListeners(tag, responseData, null);
        }
        catch (Exception e) {
            this.connection.notifyResponseListeners(tag, null, e);
        }
        if (payload.getStatusField().getAckState() == SolAckState.ACK || payload.getAcceptedCharacterCount() > 0) {
            this.messageQueue.remove(payload.getAckNackSequenceNumber());
        }
    }

    private void handleIncomingDataMessage(SolInboundMessage payload) {
        this.connection.notifyRequestListeners(payload);
    }
}

