/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection.queue;

import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.connection.Connection;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.queue.QueueElement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class MessageQueue
extends TimerTask {
    private static final int CLEANING_FREQUENCY = 500;
    private static final int QUEUE_SIZE = 8;
    private final List<QueueElement> queue;
    private int timeout;
    private final Timer timer;
    private final Connection connection;
    private List<Integer> reservedTags;
    private int lastSequenceNumber;
    private Object lastSequenceNumberLock = new Object();
    private int minSequenceNumber = 1;
    private int sequenceNumberUpperBound = 64;

    public MessageQueue(Connection connection, int timeout, int minSequenceNumber, int maxSequenceNumber, String queueName) {
        this.minSequenceNumber = minSequenceNumber;
        this.sequenceNumberUpperBound = maxSequenceNumber + 1;
        this.reservedTags = new ArrayList<Integer>();
        this.lastSequenceNumber = minSequenceNumber - 1;
        this.connection = connection;
        this.queue = new ArrayList<QueueElement>();
        this.timeout = timeout;
        this.timer = new Timer("IPMI " + queueName + " Message Queue Timer [" + this.connection.getRemoteMachineAddress().getHostAddress() + "]");
        this.timer.schedule((TimerTask)this, 500L, 500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(PayloadCoder request) {
        this.run();
        boolean first = true;
        List<QueueElement> list = this.queue;
        synchronized (list) {
            Object object = this.lastSequenceNumberLock;
            synchronized (object) {
                if (this.queue.size() < 8) {
                    int sequenceNumber = this.incrementSequenceNumber(this.lastSequenceNumber);
                    while (this.isReserved(sequenceNumber)) {
                        sequenceNumber = this.incrementSequenceNumber(sequenceNumber);
                        if (!first) {
                            try {
                                this.lastSequenceNumberLock.wait(1L);
                            }
                            catch (InterruptedException ie) {
                                Thread.yield();
                            }
                        }
                        if (sequenceNumber == this.lastSequenceNumber) {
                            return -1;
                        }
                        first = false;
                    }
                    this.reserveTag(sequenceNumber);
                    this.lastSequenceNumber = sequenceNumber;
                    QueueElement element = new QueueElement(sequenceNumber, request);
                    this.queue.add(element);
                    return sequenceNumber;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int tag) {
        this.run();
        List<QueueElement> list = this.queue;
        synchronized (list) {
            int i = 0;
            int index = -1;
            for (QueueElement element : this.queue) {
                if (element.getId() == tag) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == 0) {
                this.queue.remove(0);
                this.releaseTag(tag);
                while (!this.queue.isEmpty() && this.queue.get(0).getRequest() == null) {
                    int additionalTag = this.queue.get(0).getId();
                    this.queue.remove(0);
                    this.releaseTag(additionalTag);
                }
            } else if (index > 0) {
                this.queue.get(index).setRequest(null);
            }
        }
    }

    public void removeAt(int index) {
        if (index >= this.queue.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds : " + index);
        }
        this.remove(this.queue.get(index).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsId(int sequenceNumber) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != sequenceNumber || element.getRequest() == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSequenceNumber() {
        Object object = this.lastSequenceNumberLock;
        synchronized (object) {
            int sequenceNumber;
            this.lastSequenceNumber = sequenceNumber = this.incrementSequenceNumber(this.lastSequenceNumber);
            return sequenceNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastSequenceNumber() {
        Object object = this.lastSequenceNumberLock;
        synchronized (object) {
            return this.lastSequenceNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayloadCoder getMessageFromQueue(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != tag || element.getRequest() == null) continue;
                return element.getRequest();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageIndexFromQueue(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            int i = 0;
            for (QueueElement element : this.queue) {
                if (element.getId() == tag && element.getRequest() != null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getMessageRetries(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != tag || element.getRequest() == null) continue;
                return element.getRetries();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageSequenceNumber(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != tag || element.getRequest() == null) continue;
                return element.getId();
            }
        }
        return -1;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void tearDown() {
        this.timer.cancel();
        this.timer.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.queue != null) {
            List<QueueElement> list = this.queue;
            synchronized (list) {
                boolean process = true;
                while (process && !this.queue.isEmpty()) {
                    boolean done;
                    QueueElement oldestQueueElement = this.queue.get(0);
                    boolean bl = done = oldestQueueElement.getRequest() == null;
                    if (this.messageJustTimedOut(oldestQueueElement) || done) {
                        this.processObsoleteMessage(oldestQueueElement, done);
                        continue;
                    }
                    process = false;
                }
            }
        }
    }

    private synchronized boolean isReserved(int tag) {
        return this.reservedTags.contains(tag);
    }

    private synchronized boolean reserveTag(int tag) {
        if (this.isReserved(tag)) {
            this.reservedTags.add(tag);
            return true;
        }
        return false;
    }

    private synchronized void releaseTag(int tag) {
        this.reservedTags.remove((Object)tag);
    }

    private int incrementSequenceNumber(int currentSequenceNumber) {
        int newSequenceNumber = (currentSequenceNumber + 1) % this.sequenceNumberUpperBound;
        if (newSequenceNumber == 0) {
            newSequenceNumber = this.minSequenceNumber;
        }
        return newSequenceNumber;
    }

    private boolean messageJustTimedOut(QueueElement oldestQueueElement) {
        Date now = new Date();
        return now.getTime() - oldestQueueElement.getTimestamp().getTime() > (long)this.timeout;
    }

    private void processObsoleteMessage(QueueElement message, boolean done) {
        int tag = message.getId();
        boolean previouslyTimedOut = message.isTimedOut();
        if (previouslyTimedOut || done) {
            this.queue.remove(0);
            this.releaseTag(tag);
        } else if (!done) {
            message.makeTimedOut();
            message.refreshTimestamp();
            this.connection.notifyResponseListeners(tag, null, new ConnectionException("Message timed out"));
        }
    }
}

