/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.sm.states;

import com.veraxsystems.vxipmi.coding.Encoder;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelCipherSuites;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.protocol.decoder.ProtocolDecoder;
import com.veraxsystems.vxipmi.coding.protocol.decoder.Protocolv20Decoder;
import com.veraxsystems.vxipmi.coding.protocol.encoder.Protocolv20Encoder;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import com.veraxsystems.vxipmi.sm.StateMachine;
import com.veraxsystems.vxipmi.sm.actions.ErrorAction;
import com.veraxsystems.vxipmi.sm.actions.ResponseAction;
import com.veraxsystems.vxipmi.sm.events.DefaultAck;
import com.veraxsystems.vxipmi.sm.events.GetChannelCipherSuitesPending;
import com.veraxsystems.vxipmi.sm.events.StateMachineEvent;
import com.veraxsystems.vxipmi.sm.events.Timeout;
import com.veraxsystems.vxipmi.sm.states.Ciphers;
import com.veraxsystems.vxipmi.sm.states.State;
import com.veraxsystems.vxipmi.sm.states.Uninitialized;

public class CiphersWaiting
extends State {
    private int index;
    private int tag;

    public CiphersWaiting(int index, int tag) {
        this.index = index;
        this.tag = tag;
    }

    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof Timeout) {
            stateMachine.setCurrent(new Uninitialized());
        } else if (machineEvent instanceof GetChannelCipherSuitesPending) {
            GetChannelCipherSuitesPending event = (GetChannelCipherSuitesPending)machineEvent;
            GetChannelCipherSuites cipherSuites = new GetChannelCipherSuites(TypeConverter.intToByte(14), TypeConverter.intToByte(this.index + 1));
            try {
                this.tag = event.getSequenceNumber();
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), cipherSuites, event.getSequenceNumber(), 0, 0));
                ++this.index;
            }
            catch (Exception e) {
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else if (machineEvent instanceof DefaultAck) {
            stateMachine.setCurrent(new Ciphers());
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
        if (ProtocolDecoder.decodeAuthenticationType(message) != AuthenticationType.RMCPPlus) {
            return;
        }
        if (Protocolv20Decoder.decodeSessionID(message) != 0) {
            return;
        }
        if (Protocolv20Decoder.decodePayloadType(message.getData()[1]) != PayloadType.Ipmi) {
            return;
        }
        Protocolv20Decoder decoder = new Protocolv20Decoder(CipherSuite.getEmpty());
        if (decoder.decodeAuthentication(message.getData()[1])) {
            return;
        }
        IpmiMessage ipmiMessage = null;
        try {
            ipmiMessage = decoder.decode(message);
            GetChannelCipherSuites suites = new GetChannelCipherSuites();
            if (suites.isCommandResponse(ipmiMessage) && TypeConverter.byteToInt(((IpmiLanResponse)ipmiMessage.getPayload()).getSequenceNumber()) == this.tag) {
                stateMachine.doExternalAction(new ResponseAction(suites.getResponseData(ipmiMessage)));
            }
        }
        catch (Exception e) {
            stateMachine.doExternalAction(new ErrorAction(e));
        }
    }
}

