/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.DebugLogFileChooser;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Debug {
    public static Debug out = new Debug();
    public static int MODE;
    public static int VERIFYSSLCERTS;
    public static final int CREATE_LOG = 0;
    public static final int DEBUG = 1;
    public static final int RELEASE = 2;
    public static final int SKIP_VERIFICATION = 0;
    public static final int VERIFY = 1;
    private File logFile = null;
    private FileWriter fWriter = null;
    private PrintWriter pWriter = null;
    private boolean runTimeLogging = false;
    private static final char[] kHexChars;

    private Debug() {
        MODE = 2;
        VERIFYSSLCERTS = 1;
        if (MODE == 0) {
            this.initLog(this.logFile);
        }
    }

    public void print(Object object) {
        if (MODE == 1) {
            if (object.getClass().getName().contains("Exception")) {
                Exception exception = (Exception)object;
                System.err.println("\nEXCEPTION !!!");
                exception.printStackTrace();
            } else if (object.getClass().getName().contains("Error")) {
                Error error = (Error)object;
                System.err.println("\nERROR !!!");
                error.printStackTrace();
            } else {
                System.out.print(object);
            }
        } else if (MODE == 0) {
            try {
                if (this.fWriter == null) {
                    this.fWriter = new FileWriter(this.logFile, true);
                }
                if (object.getClass().getName().contains("Exception")) {
                    Exception exception = (Exception)object;
                    if (this.pWriter == null) {
                        this.pWriter = new PrintWriter((Writer)this.fWriter, true);
                    }
                    this.pWriter.append("\nEXCEPTION !!!\n");
                    exception.printStackTrace(this.pWriter);
                    this.pWriter.append('\n');
                } else if (object.getClass().getName().contains("Error")) {
                    Error error = (Error)object;
                    if (this.pWriter == null) {
                        this.pWriter = new PrintWriter((Writer)this.fWriter, true);
                    }
                    this.pWriter.append("\nERROR !!!\n");
                    error.printStackTrace(this.pWriter);
                    this.pWriter.append('\n');
                } else {
                    this.fWriter.append((CharSequence)object);
                }
            }
            catch (IOException iOException) {
                System.err.println("ERROR WHILE WRITTING TO LOG FILE!!!");
                iOException.printStackTrace();
                this.closeLog();
            }
            catch (ClassCastException classCastException) {
                try {
                    this.fWriter.append(object.toString());
                }
                catch (IOException iOException) {
                    System.err.println("ERROR WHILE WRITTING TO LOG FILE!!!");
                    iOException.printStackTrace();
                    this.closeLog();
                }
            }
            catch (Exception exception) {
                System.err.println("ERROR WHILE WRITTING TO LOG FILE!!!");
                exception.printStackTrace();
                this.closeLog();
            }
        }
    }

    public void println(Object object) {
        if (MODE == 1) {
            if (object.getClass().getName().contains("Exception")) {
                Exception exception = (Exception)object;
                System.err.println("\nEXCEPTION !!!");
                exception.printStackTrace();
            } else if (object.getClass().getName().contains("Error")) {
                Error error = (Error)object;
                System.err.println("\nERROR !!!");
                error.printStackTrace();
            } else {
                System.out.println(object);
            }
        } else if (MODE == 0) {
            try {
                if (this.fWriter == null) {
                    this.fWriter = new FileWriter(this.logFile, true);
                }
                if (object.getClass().getName().contains("Exception")) {
                    Exception exception = (Exception)object;
                    if (this.pWriter == null) {
                        this.pWriter = new PrintWriter((Writer)this.fWriter, true);
                    }
                    this.pWriter.append(("[ " + new Date()).toString() + " ] ");
                    this.pWriter.append("\nEXCEPTION !!!\n");
                    exception.printStackTrace(this.pWriter);
                    this.pWriter.append('\n');
                } else if (object.getClass().getName().contains("Error")) {
                    Error error = (Error)object;
                    if (this.pWriter == null) {
                        this.pWriter = new PrintWriter((Writer)this.fWriter, true);
                    }
                    this.pWriter.append(("[ " + new Date()).toString() + " ] ");
                    this.pWriter.append("\nERROR !!!\n");
                    error.printStackTrace(this.pWriter);
                    this.pWriter.append('\n');
                } else {
                    this.fWriter.append(("[ " + new Date()).toString() + " ] ");
                    this.fWriter.append((CharSequence)object);
                    this.fWriter.append('\n');
                }
            }
            catch (IOException iOException) {
                System.err.println("ERROR WHILE WRITTING TO LOG FILE!!!");
                iOException.printStackTrace();
                this.closeLog();
            }
            catch (ClassCastException classCastException) {
                try {
                    this.fWriter.append(object.toString());
                }
                catch (IOException iOException) {
                    System.err.println("ERROR WHILE WRITTING TO LOG FILE!!!");
                    iOException.printStackTrace();
                    this.closeLog();
                }
            }
            catch (Exception exception) {
                System.err.println("ERROR WHILE WRITTING TO LOG FILE!!!");
                exception.printStackTrace();
                this.closeLog();
            }
        }
    }

    public void printError(Object object) {
        if (MODE == 1) {
            System.err.println(object);
        } else if (MODE == 0) {
            this.println(object);
        }
    }

    public void dump(byte[] byArray) {
        if (MODE == 1 || MODE == 0) {
            this.dump(byArray, byArray.length);
        }
    }

    public void dump(byte[] byArray, int n) {
        if (MODE == 1 || MODE == 0) {
            this.dump(byArray, 0, n);
        }
    }

    public void dump(byte[] byArray, int n, int n2) {
        if (MODE == 1 || MODE == 0) {
            int n3;
            if (byArray.length - n < n2) {
                this.println("Invalid buffer");
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(2 * n2);
            for (n3 = n; n3 < n + n2; ++n3) {
                Debug.appendHexPair(byArray[n3], stringBuffer);
            }
            for (n3 = 0; n3 < stringBuffer.length(); n3 += 60) {
                int n4 = n3 + 60;
                if (n4 > stringBuffer.length()) {
                    n4 = stringBuffer.length();
                }
                this.println(stringBuffer.substring(n3, n4));
            }
        }
    }

    public String dumpIPMI(byte[] byArray, int n, int n2) {
        String string = "";
        if (byArray.length - n < n2) {
            this.println("Invalid buffer");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(2 * n2);
        for (int i = n; i < n + n2; ++i) {
            Debug.appendHexPair(byArray[i], stringBuffer);
        }
        String string2 = stringBuffer.substring(3, stringBuffer.length());
        for (int i = 0; i < string2.length(); i += 48) {
            int n3 = i + 48;
            if (n3 > string2.length()) {
                n3 = string2.length();
            }
            string = string + string2.substring(i, n3) + "\n";
        }
        return string;
    }

    public static void appendHexPair(byte by, StringBuffer stringBuffer) {
        char c = kHexChars[(by & 0xF0) >> 4];
        char c2 = kHexChars[by & 0xF];
        stringBuffer.append(c);
        stringBuffer.append(c2);
        stringBuffer.append(' ');
    }

    public String getTimeStamp() {
        String string = "";
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'on_'dd-MM-yyyy'_at_'HH-mm-ss-SSS");
        string = simpleDateFormat.format(date);
        return string;
    }

    public void closeLog() {
        try {
            if (this.pWriter != null) {
                this.pWriter.close();
            }
            this.pWriter = null;
            if (this.fWriter != null) {
                this.fWriter.close();
            }
            this.fWriter = null;
            if (this.runTimeLogging) {
                InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("AH_1_DBG") + this.logFile, LocaleStrings.getString("AH_2_DBG"), 1);
                this.runTimeLogging = false;
            }
        }
        catch (IOException iOException) {
            System.err.println("ERROR WHILE CLOSING LOG FILE WRITTER!!!");
            this.pWriter = null;
            this.fWriter = null;
            iOException.printStackTrace();
        }
    }

    public void initDebugLogFileChooser() {
        DebugLogFileChooser debugLogFileChooser = new DebugLogFileChooser();
        this.initLogFile();
        debugLogFileChooser.start();
    }

    public void initLog(File file) {
        if (file == null) {
            this.initLogFile();
        } else {
            this.logFile = file;
            this.runTimeLogging = true;
        }
        try {
            this.fWriter = new FileWriter(this.logFile, true);
        }
        catch (IOException iOException) {
            System.err.println("ERROR WHILE CREATING LOG FILE!!!");
            iOException.printStackTrace();
            this.fWriter = null;
        }
        MODE = 0;
    }

    public void initLogFile() {
        this.logFile = new File(System.getProperty("user.home") + File.separator + "JViewer_log_to-" + JViewer.getIp() + "-" + this.getTimeStamp() + ".log");
    }

    public File getLogFile() {
        return this.logFile;
    }

    public boolean isRunTimeLogging() {
        return this.runTimeLogging;
    }

    public void setRunTimeLogging(boolean bl) {
        this.runTimeLogging = bl;
    }

    static {
        kHexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

