/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.ami.kvm.jviewer.ClientConfig;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.StandAloneConnectionDialog;
import com.ami.vmedia.VMApp;
import java.awt.Dimension;
import java.awt.List;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JViewer {
    public static final String APP_TYPE_JVIEWER = "JViewer";
    public static final String APP_TYPE_VMAPP = "VMApp";
    public static final String APP_TYPE_PLAYER = "PlayVideo";
    public static final String APP_TYPE_DOWNLOAD_SAVE = "SaveVideo";
    public static final String APP_TYPE_STAND_ALONE = "StandAlone";
    public static final String APP_TYPE_WEB_PREVIEW = "WebPreview";
    public static final String APP_TYPE_BSOD_VIEWER = "BSODScreen";
    public static final String DEFAULT_LOCALE = "EN";
    public static final int HTTPS_PORT = 443;
    public static final int INVALID_PORT = -1;
    public static final int MIN_FRAME_WIDTH = 800;
    public static final int MIN_FRAME_HEIGHT = 600;
    public static final int EXT_PRIV_UNDEF = -1;
    public static final int KVM_DEF_RECONN_RETRY = 3;
    public static final int KVM_DEF_RECONN_INTERVAL = 15;
    public static final int MEDIA_SERVICE_ENABLED = 1;
    public static final int MIN_JAVA_VERSION = 7;
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    public static final byte KVM_ENABLED = 0;
    public static final byte VMEDIA_ENABLED = 1;
    public static final byte POWER_OPTION_PRIV = 8;
    public static final int LICENSED = 1;
    public static final String AUTO_DETECT_KEYBOARD = "AD";
    public static String[] SOC = new String[]{"PILOT", "AST"};
    private static String OPTION_USAGE = LocaleStrings.getString("1_2_JVIEWER") + "JViewer.jar" + " < -apptype StandAlone> < -hostname " + LocaleStrings.getString("S_2_SACD") + " > < -u " + LocaleStrings.getString("S_4_SACD") + " > < -p " + LocaleStrings.getString("S_5_SACD") + "> < -webport " + LocaleStrings.getString("S_3_SACD") + "> <-localization/-lang " + LocaleStrings.getString("S_21_SACD") + "> <-launch " + LocaleStrings.getString("S_34_SACD") + ">";
    private static JFrame mainFrame;
    private static JDesktopPane mainPane;
    private static String apptype;
    private static boolean standalone;
    private static String title;
    private static String ip;
    private static byte[] ServerIp;
    private static int kvmPort;
    private static int SecureChannel;
    private static int VMSecureChannel;
    private static int cdserver_port;
    private static int hdserver_port;
    private static byte Num_CD;
    private static byte Num_HD;
    private static int CD_State;
    private static int HD_State;
    private static boolean useSSL;
    private static boolean VMUseSSL;
    private static String webSessionToken;
    private static String kvmToken;
    private static int kvmTokenType;
    private static String lang;
    private static int webPort;
    private static int webSecure;
    private static String keyboardLayout;
    private static String[] videoFile;
    private static boolean isKVMReconnectEnabled;
    private static int retryCount;
    private static int retryInterval;
    private static String username;
    private static String password;
    private static String launch;
    private static boolean isSinglePortEnabled;
    private static int argLength;
    private static int kvmPrivilege;
    private static boolean unknownParam;
    private static String unknownParams;
    private static long OEMFeatureStatus;
    private static byte KVMLicenseStatus;
    private static byte MediaLicenseStatus;
    private static boolean isClientAdmin;
    private static byte KVM_Num_CD;
    private static byte KVM_Num_HD;
    private static byte powerSaveMode;
    private static ClientConfig clientCfg;
    private static final Set<String> KEYBOARD_LAYOUTS;
    private static boolean restService;
    private static boolean defaultlang;

    public static void main(String[] stringArray) {
        String[] stringArray2;
        mainFrame = new JFrame(APP_TYPE_JVIEWER);
        mainFrame.setMinimumSize(new Dimension(800, 600));
        mainFrame.setDefaultCloseOperation(0);
        standalone = true;
        argLength = stringArray.length;
        JViewer.ParseCmd(stringArray);
        if (lang == null) {
            JViewer.setLanguage(DEFAULT_LOCALE);
            JViewer.setDefaultLang(true);
        }
        if (!JViewer.is64bit()) {
            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_11_JVIEWER") + "64-bit " + LocaleStrings.getString("1_10_JVIEWER"), LocaleStrings.getString("1_3_JVIEWER"), 0);
            JViewer.exit(0);
        }
        if (Integer.parseInt((stringArray2 = JAVA_RUNTIME_VERSION.split("\\.|_|-b"))[1], 10) < 7) {
            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_9_JVIEWER") + LocaleStrings.getString("1_10_JVIEWER") + JAVA_RUNTIME_VERSION + "\n" + LocaleStrings.getString("1_11_JVIEWER") + LocaleStrings.getString("1_10_JVIEWER") + 7 + LocaleStrings.getString("1_12_JVIEWER"), LocaleStrings.getString("1_3_JVIEWER"), 0);
            JViewer.exit(0);
        }
        if (apptype == null) {
            apptype = APP_TYPE_STAND_ALONE;
        }
        if (!(JViewer.isStandAloneApp() || JViewer.isBSODViewer() || JViewer.isWebPreviewer() || JViewer.isStandAloneSupportedApps(apptype))) {
            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_4_JVIEWER"), LocaleStrings.getString("S_9_SACD"), 0);
        }
        if (!JViewer.isStandAloneApp() && JViewer.isStandAloneSupportedApps(JViewer.getLaunch())) {
            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_1_JVIEWER"), LocaleStrings.getString("S_9_SACD"), 0);
            JViewer.exit(0);
        }
        if (stringArray.length > 0) {
            Debug.out.println("JViewer Arguments\n");
            for (int i = 0; i < stringArray.length - 1; i += 2) {
                Debug.out.println(stringArray[i] + " : " + stringArray[i + 1]);
            }
        }
        if ((JViewer.getOEMFeatureStatus() & 0x80L) == 128L) {
            VMApp.getInstance().setNumCD(KVM_Num_CD);
            VMApp.getInstance().setNumHD(KVM_Num_HD);
        }
        JViewer.setIsClientAdmin(JViewer.isClientUserAdmin());
        if (JViewer.isjviewerapp()) {
            JViewerApp.getInstance().getConnection().setWebSSLVerify(false);
            Debug.out.println("JViewer Application Initialised");
            JViewer.redirect();
        } else if (JViewer.isplayerapp()) {
            Debug.out.println("Player Application  Initialised");
            JViewer.recording();
        } else if (JViewer.isdownloadapp()) {
            Debug.out.println("Download and save Application  Initialised");
            JViewer.recording();
        } else if (JViewer.isStandAloneApp()) {
            Debug.out.println("Stand Alone Application  Initialised");
            JViewer.launchStandAlone();
        } else if (JViewer.isVMApp()) {
            JViewer.launchStandAlone();
        } else {
            JViewer.printUsage();
        }
    }

    public static boolean isjviewerapp() {
        return apptype != null && apptype.compareToIgnoreCase(APP_TYPE_JVIEWER) == 0;
    }

    public static boolean isplayerapp() {
        return apptype != null && apptype.compareToIgnoreCase(APP_TYPE_PLAYER) == 0;
    }

    public static boolean isdownloadapp() {
        return apptype != null && apptype.compareToIgnoreCase(APP_TYPE_DOWNLOAD_SAVE) == 0;
    }

    public static boolean IsBitSet(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    public static boolean isStandAloneApp() {
        return apptype != null && apptype.compareToIgnoreCase(APP_TYPE_STAND_ALONE) == 0;
    }

    public static String getIp() {
        return ip;
    }

    public static String getLaunch() {
        return launch;
    }

    public static boolean isDefaultLang() {
        return defaultlang;
    }

    public static void setDefaultLang(boolean bl) {
        defaultlang = bl;
    }

    public static boolean isStandAloneSupportedApps(String string) {
        return string != null && (string.compareToIgnoreCase(APP_TYPE_JVIEWER) == 0 || string.compareToIgnoreCase(APP_TYPE_PLAYER) == 0 || string.compareToIgnoreCase(APP_TYPE_DOWNLOAD_SAVE) == 0 || string.compareToIgnoreCase(APP_TYPE_VMAPP) == 0);
    }

    public static void launch(JFrame jFrame, JDesktopPane jDesktopPane, String[] stringArray) {
        standalone = false;
        mainFrame = jFrame;
        mainPane = jDesktopPane;
        JViewer.redirect();
    }

    public static void recording() {
        String string = Integer.toString(webPort);
        JViewerApp.getInstance().Ondisplayvideo(ip, string, webSessionToken, webSecure);
    }

    public static void launchStandAlone() {
        JViewerApp.getInstance().onLaunchStandAloneApp(ip, webPort, username, password);
    }

    public static void launchVMApp() {
        JViewerApp.getInstance().OnvMedia(0);
    }

    public static void redirect() {
        if (JViewer.isKVMEnabled()) {
            if (JViewer.isSinglePortEnabled()) {
                JViewerApp.getInstance().getConnection().setKvmSSLVerify(false);
            }
            JViewerApp.getInstance().OnConnectToServer(ip, kvmPort, kvmToken, kvmTokenType, useSSL, VMUseSSL, cdserver_port, hdserver_port, Num_CD, Num_HD, CD_State, HD_State, webSessionToken, webPort);
            VMApp.getInstance().createIUSBRedirectionSession();
        } else {
            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_5_JVIEWER"), LocaleStrings.getString("1_3_JVIEWER"), 0);
        }
    }

    public static void ParseCmd(String[] stringArray) {
        int n = 0;
        int n2 = -1;
        String string = null;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            block89: {
                try {
                    if ((string = stringArray[n++]).contains("-oem") && JViewerApp.getOEMManager().handleOemArguments(stringArray, n) == 1) continue;
                    if (string.equals("-apptype")) {
                        if (n < stringArray.length) {
                            apptype = stringArray[n++];
                        } else {
                            System.err.println("-apptype" + LocaleStrings.getString("1_4_JVIEWER"));
                        }
                        break block89;
                    }
                    if (string.equals("-launch")) {
                        if (n < stringArray.length && !JViewer.isStandAloneSupportedApps(launch = stringArray[n++])) {
                            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_1_JVIEWER") + " -launch", LocaleStrings.getString("S_9_SACD"), 0);
                            JViewer.printUsage();
                        }
                        break block89;
                    }
                    if (string.equals("-title")) {
                        title = stringArray[n] != null ? stringArray[n] : APP_TYPE_JVIEWER;
                        ++n;
                        break block89;
                    }
                    if (string.equals("-hostname")) {
                        ip = stringArray[n];
                        if ((ServerIp = JViewer.getServerIP(stringArray[n++])) == null && !JViewer.isStandAloneApp()) {
                            JViewer.printUsage();
                            return;
                        }
                        break block89;
                    }
                    if (string.equals("-kvmtoken")) {
                        try {
                            kvmToken = stringArray[n++];
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-kvmtokentype")) {
                        try {
                            kvmTokenType = Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-kvmsecure")) {
                        try {
                            SecureChannel = Integer.parseInt(stringArray[n++]);
                            if (SecureChannel != 0 && SecureChannel != 1) {
                                JViewer.printUsage();
                                return;
                            }
                            useSSL = SecureChannel == 1;
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-kvmport")) {
                        try {
                            kvmPort = Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-vmsecure")) {
                        try {
                            VMSecureChannel = Integer.parseInt(stringArray[n++]);
                            if (VMSecureChannel != 0 && VMSecureChannel != 1) {
                                JViewer.printUsage();
                                return;
                            }
                            VMUseSSL = VMSecureChannel == 1;
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-cdstate")) {
                        try {
                            CD_State = Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-cdport")) {
                        try {
                            cdserver_port = Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-cdnum")) {
                        try {
                            Num_CD = (byte)Integer.parseInt(stringArray[n++]);
                            VMApp.getInstance().setNumCD(Num_CD);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-hdstate")) {
                        try {
                            HD_State = Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-hdport")) {
                        try {
                            hdserver_port = Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-hdnum")) {
                        try {
                            Num_HD = (byte)Integer.parseInt(stringArray[n++]);
                            VMApp.getInstance().setNumHD(Num_HD);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-localization") || string.equals("-lang")) {
                        if ((lang = stringArray[n++]).equals(null) || lang.length() == 0) {
                            if (JViewer.isStandAloneApp()) {
                                JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_1_JVIEWER") + string + " !!!\n" + OPTION_USAGE, LocaleStrings.getString("1_3_JVIEWER"), 0);
                            }
                            JViewer.printUsage();
                            return;
                        }
                        if (Arrays.asList(stringArray).contains("-localization") && Arrays.asList(stringArray).contains("-lang")) {
                            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_8_JVIEWER") + " -localization / -lang", LocaleStrings.getString("A_5_GLOBAL"), 0);
                            JViewer.exit(0);
                        }
                        JViewer.setLanguage(lang.toUpperCase());
                        break block89;
                    }
                    if (string.equals("-webcookie")) {
                        try {
                            webSessionToken = stringArray[n++];
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-websecure")) {
                        try {
                            webSecure = Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-webport")) {
                        webPort = JViewer.getWebPortNumber(stringArray[n++]);
                        break block89;
                    }
                    if (string.equals("-keyboardlayout")) {
                        keyboardLayout = stringArray[n++];
                        break block89;
                    }
                    if (string.equals("-retrycount")) {
                        try {
                            JViewer.setRetryCount(Integer.parseInt(stringArray[n++]));
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-retryinterval")) {
                        try {
                            JViewer.setRetryInterval(Integer.parseInt(stringArray[n++]));
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-videofile")) {
                        try {
                            if (videoFile == null) {
                                videoFile = new String[1];
                            }
                            JViewer.videoFile[0] = stringArray[n++];
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equalsIgnoreCase("-u")) {
                        username = stringArray[n++];
                        break block89;
                    }
                    if (string.equalsIgnoreCase("-p")) {
                        int n3 = n++;
                        try {
                            if (!stringArray[n3].startsWith("-")) {
                                password = stringArray[n3];
                                break block89;
                            }
                            --n;
                        }
                        catch (Exception exception) {}
                        break block89;
                    }
                    if (string.equals("-singleportenabled")) {
                        try {
                            n2 = Integer.parseInt(stringArray[n++]);
                            if (n2 != 0 && n2 != 1) {
                                JViewer.printUsage();
                                return;
                            }
                            isSinglePortEnabled = n2 == 1;
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Debug.out.println(numberFormatException);
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-extendedpriv")) {
                        kvmPrivilege = Integer.parseInt(stringArray[n++]);
                        break block89;
                    }
                    if (string.equals("-kvmcdnum")) {
                        try {
                            KVM_Num_CD = (byte)Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-kvmhdnum")) {
                        try {
                            KVM_Num_HD = (byte)Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JViewer.printUsage();
                            return;
                        }
                    }
                    if (string.equals("-powersavemode")) {
                        try {
                            powerSaveMode = (byte)Integer.parseInt(stringArray[n++]);
                            break block89;
                        }
                        catch (NumberFormatException numberFormatException) {
                            JViewer.printUsage();
                            return;
                        }
                    }
                    unknownParam = true;
                    unknownParams = unknownParams.length() <= 0 ? unknownParams + string : unknownParams + ", " + string;
                    JViewer.printUsage();
                    ++n;
                }
                catch (Exception exception) {
                    Debug.out.println(exception);
                    if (JViewer.isStandAloneApp()) {
                        JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_1_JVIEWER") + string + " !!!\n" + OPTION_USAGE, LocaleStrings.getString("1_3_JVIEWER"), 0);
                    }
                    JViewer.printUsage();
                }
            }
            if (Collections.frequency(Arrays.asList(stringArray), string) <= 1) continue;
            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_8_JVIEWER") + " " + string, LocaleStrings.getString("A_5_GLOBAL"), 0);
            JViewer.exit(0);
        }
        if ((JViewer.isStandAloneApp() || apptype == null) && unknownParams.length() > 0) {
            JOptionPane.showMessageDialog(null, LocaleStrings.getString("1_1_JVIEWER") + unknownParams + " !!!\n" + OPTION_USAGE, LocaleStrings.getString("1_1_JVIEWER"), 1);
        }
    }

    public static void printUsage() {
        if (JViewer.isStandAloneApp() || apptype == null) {
            Debug.out.println(OPTION_USAGE);
        } else {
            Debug.out.println("Invalid arguments, please try again");
            Debug.out.println("Usage: java -jar JViewer.jar <apptype> <ip address> <KVM port number> <token> <ssl for KVM> <ssl for vmedia> <Number of parallel CD/DVD Redirection>  <Number of parallel Hard disk Redirection> <cdserver port> <hdserver port> <user privileges> <language> <token>");
            Debug.out.println("<apptype> JViewer for JViewer App,Player for playing the video,SAveVideo for download and save video in cleint system");
            Debug.out.println("<ssl for KVM> 1 for secure connection and 0 for non-secure ");
            Debug.out.println("<ssl for vmedia> 1 for secure connection and 0 for non-secure ");
            Debug.out.println("<user privileges> ");
            Debug.out.println("                  0x00000020 - VKVM permissions only");
            Debug.out.println("                  0x00000040 - VMedia permissions only");
            Debug.out.println("                  0x00000060 - VKVM & VMedia permissions");
            Debug.out.println("<language> ");
            Debug.out.println("                  EN - English");
        }
        if (JViewer.isStandalone()) {
            if (!unknownParam) {
                JViewer.exit(0);
            } else {
                unknownParam = false;
            }
        } else {
            JViewerApp.getInstance().getMainWindow().dispose();
        }
    }

    public static byte[] getServerIP(String string) {
        byte[] byArray = null;
        try {
            ip = string;
            InetAddress inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostAddress();
            byArray = InetAddress.getByName(string).getAddress();
            Debug.out.println("Resolving to IPAddress " + string);
            for (int i = 0; i < byArray.length; ++i) {
                Debug.out.print(byArray[i]);
            }
        }
        catch (UnknownHostException unknownHostException) {
            ip = null;
            Debug.out.println("Error Resolving IP address");
            Debug.out.println(unknownHostException);
        }
        return byArray;
    }

    public static void setServerIP(byte[] byArray) {
        ServerIp = byArray;
    }

    public static JFrame getMainFrame() {
        return mainFrame;
    }

    public static void setMainFrame(JFrame jFrame) {
        mainFrame = jFrame;
    }

    public static JDesktopPane getMainPane() {
        return mainPane;
    }

    public static void setMainPane(JDesktopPane jDesktopPane) {
        mainPane = jDesktopPane;
    }

    public static boolean isStandalone() {
        return standalone;
    }

    public static void setStandalone(boolean bl) {
        standalone = bl;
    }

    public static void setIp(String string) {
        ip = string;
    }

    public static void setKVMPort(int n) {
        kvmPort = n;
    }

    public static String getKVMToken() {
        return kvmToken;
    }

    public static void setSessionCookies(String string) {
        kvmToken = string;
    }

    public static String getWebSessionToken() {
        return webSessionToken;
    }

    public static void setWebSessionToken(String string) {
        webSessionToken = string;
    }

    public static void setSecureChannel(int n) {
        SecureChannel = n;
    }

    public static void setVMSecureChannel(int n) {
        VMSecureChannel = n;
    }

    public static int getCDPort() {
        return cdserver_port;
    }

    public static void setCdserver_port(int n) {
        cdserver_port = n;
    }

    public static int getHDPort() {
        return hdserver_port;
    }

    public static void setHdserver_port(int n) {
        hdserver_port = n;
    }

    public static boolean isKVMReconnectEnabled() {
        return isKVMReconnectEnabled;
    }

    public static void setKVMReconnectEnabled(boolean bl) {
        isKVMReconnectEnabled = bl;
    }

    public static int getRetryCount() {
        return retryCount;
    }

    public static void setRetryCount(int n) {
        retryCount = n;
    }

    public static int getRetryInterval() {
        return retryInterval;
    }

    public static void setRetryInterval(int n) {
        retryInterval = n * 1000;
    }

    public static byte getNum_CD() {
        return Num_CD;
    }

    public static byte getNum_HD() {
        return Num_HD;
    }

    public static void setNum_CD(byte by) {
        Num_CD = by;
        if ((JViewer.getOEMFeatureStatus() & 0x80L) != 128L) {
            VMApp.getInstance().setNumCD(by);
        }
    }

    public static void setNum_HD(byte by) {
        Num_HD = by;
        if ((JViewer.getOEMFeatureStatus() & 0x80L) != 128L) {
            VMApp.getInstance().setNumHD(by);
        }
    }

    public static int getCDState() {
        return CD_State;
    }

    public static void setCD_State(int n) {
        CD_State = n;
    }

    public static boolean isCdServiceEnabled() {
        return CD_State == 1;
    }

    public static int getHDState() {
        return HD_State;
    }

    public static void setHD_State(int n) {
        HD_State = n;
    }

    public static boolean isHdServiceEnabled() {
        return HD_State == 1;
    }

    public static boolean isUseSSL() {
        return useSSL;
    }

    public static void setUseSSL(boolean bl) {
        useSSL = bl;
    }

    public static boolean isVMUseSSL() {
        return VMUseSSL;
    }

    public static void setVMUseSSL(boolean bl) {
        VMUseSSL = bl;
    }

    public static String getLanguage() {
        return lang;
    }

    public static void setLanguage(String string) {
        try {
            if (!JViewer.getSupportedLocaleCodes().contains(string)) {
                Debug.out.println("Language isn't available: " + JViewer.getLanguage());
                JOptionPane.showMessageDialog(null, LocaleStrings.getString("AC_4_LS"), LocaleStrings.getString("AC_1_LS"), 0);
                string = DEFAULT_LOCALE;
                JViewer.setDefaultLang(true);
            }
        }
        catch (Exception exception) {
            Debug.out.printError(exception);
            string = DEFAULT_LOCALE;
        }
        lang = string;
        LocaleStrings.setLanguageID(lang);
        StandAloneConnectionDialog.setSelectedLocale(lang);
        JComponent.setDefaultLocale(new Locale(lang.toLowerCase()));
    }

    public static int getArgLength() {
        return argLength;
    }

    public static int getWebPortNumber(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
            Debug.out.println("Invalid port number");
            Debug.out.println(numberFormatException);
        }
        return n;
    }

    public static void setWebPort(int n) {
        webPort = n;
    }

    public static boolean isSinglePortEnabled() {
        return isSinglePortEnabled;
    }

    public static void setSinglePortEnabled(boolean bl) {
        isSinglePortEnabled = bl;
    }

    public static void setApptype(String string) {
        apptype = string;
    }

    public static boolean isWebPreviewer() {
        return apptype != null && apptype.compareToIgnoreCase(APP_TYPE_WEB_PREVIEW) == 0;
    }

    public static boolean isBSODViewer() {
        return apptype != null && apptype.compareToIgnoreCase(APP_TYPE_BSOD_VIEWER) == 0;
    }

    public static String getKeyboardLayout() {
        return keyboardLayout;
    }

    public static void setKeyboardLayout(String string) {
        keyboardLayout = KEYBOARD_LAYOUTS.contains(string) ? string : AUTO_DETECT_KEYBOARD;
    }

    public static String[] getVideoFile() {
        return videoFile;
    }

    public static void setVideoFile(String[] stringArray) {
        videoFile = stringArray;
    }

    public static int getKVMPrivilege() {
        return kvmPrivilege;
    }

    public static void setKVMPrivilege(int n) {
        kvmPrivilege = n;
    }

    public static boolean isKVMEnabled() {
        return JViewer.IsBitSet(kvmPrivilege, 0);
    }

    public static boolean isVMediaEnabled() {
        return JViewer.IsBitSet(kvmPrivilege, 1);
    }

    public static boolean isPowerPrivEnabled() {
        return JViewer.IsBitSet(kvmPrivilege, 8);
    }

    public static String getTitle() {
        return title;
    }

    public static long getOEMFeatureStatus() {
        return OEMFeatureStatus;
    }

    public static void setOEMFeatureStatus(long l) {
        OEMFeatureStatus = l;
    }

    public static byte getKVMLicenseStatus() {
        return KVMLicenseStatus;
    }

    public static void setKVMLicenseStatus(byte by) {
        KVMLicenseStatus = by;
    }

    public static byte getMediaLicenseStatus() {
        return MediaLicenseStatus;
    }

    public static void setMediaLicenseStatus(byte by) {
        MediaLicenseStatus = by;
    }

    public static int getWebSecure() {
        return webSecure;
    }

    public static boolean isWebSecure() {
        return JViewer.getWebSecure() == 1;
    }

    public static void setWebSecure(int n) {
        webSecure = n;
    }

    public static void exit(int n) {
        if (Debug.MODE == 0) {
            Debug.out.closeLog();
        }
        System.exit(n);
    }

    public static void setIsClientAdmin(boolean bl) {
        isClientAdmin = bl;
    }

    public static boolean IsClientAdmin() {
        return isClientAdmin;
    }

    private static boolean isClientUserAdmin() {
        Object object;
        boolean bl = false;
        String string = System.getProperty("os.name");
        String string2 = null;
        if (string.startsWith("Windows")) {
            string2 = "reg query \"HKU\\S-1-5-19\"";
        } else if (string.startsWith("Linux")) {
            object = System.getProperty("user.name");
            string2 = "id -u " + (String)object;
        } else if (string.startsWith("Mac")) {
            bl = true;
        }
        if (string2 == null) {
            return bl;
        }
        try {
            object = Runtime.getRuntime().exec(string2);
            ((Process)object).waitFor();
            int n = ((Process)object).exitValue();
            if (string.startsWith("Windows")) {
                if (0 == n) {
                    bl = true;
                }
            } else if (string.startsWith("Linux") || string.startsWith("Mac")) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (!string3.equals("0")) continue;
                    bl = true;
                    break;
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            Debug.out.println("Not able find client user privilege");
        }
        return bl;
    }

    public static byte getKVM_Num_CD() {
        return KVM_Num_CD;
    }

    public static void setKVM_Num_CD(byte by) {
        KVM_Num_CD = by;
        if ((JViewer.getOEMFeatureStatus() & 0x80L) == 128L) {
            VMApp.getInstance().setNumCD(by);
        }
    }

    public static byte getKVM_Num_HD() {
        return KVM_Num_HD;
    }

    public static void setKVM_Num_HD(byte by) {
        KVM_Num_HD = by;
        if ((JViewer.getOEMFeatureStatus() & 0x80L) == 128L) {
            VMApp.getInstance().setNumHD(by);
        }
    }

    public static byte getPowerSaveMode() {
        return powerSaveMode;
    }

    public static void setPowerSaveMode(byte by) {
        powerSaveMode = by;
    }

    public static boolean isPowerSaveModeEnabled() {
        return JViewer.getPowerSaveMode() == 1;
    }

    public static String getUsername() {
        return username;
    }

    public static void setUsername(String string) {
        username = string;
    }

    public static String getPassword() {
        return password;
    }

    public static void setPassword(String string) {
        password = string;
    }

    public static int getWebPort() {
        return webPort;
    }

    public static boolean isVMApp() {
        return apptype != null && apptype.compareToIgnoreCase(APP_TYPE_VMAPP) == 0;
    }

    public static int getKvmPort() {
        return kvmPort;
    }

    public static boolean isRestService() {
        return restService;
    }

    public static void setRestService(boolean bl) {
        restService = bl;
    }

    public static boolean isUnknownArgs() {
        return unknownParams.length() > 0;
    }

    public static String getSOC(int n) {
        return SOC[n - 1];
    }

    public static String[] getSupportedLocales() {
        String[] stringArray = new String[]{"English - [EN]"};
        ArrayList<String> arrayList = JViewer.getClassesNames("com.ami.kvm.jviewer.oem.lang");
        if (!arrayList.isEmpty()) {
            Object[] objectArray = arrayList.toArray();
            List list = new List();
            for (Object object : objectArray) {
                String string = (String)object;
                if (!(string = string.substring(string.indexOf("OEMResources"))).startsWith("OEMResources_", string.lastIndexOf(46) + 1)) continue;
                int n = string.lastIndexOf(95) + 1;
                int n2 = string.length();
                String string2 = string.substring(n, n2);
                Locale locale = new Locale(string2.toLowerCase());
                String string3 = locale.getDisplayLanguage(locale);
                list.add(string3 + " - [" + string2 + "]");
            }
            stringArray = list.getItems();
        }
        return stringArray;
    }

    public static ArrayList<String> getSupportedLocaleCodes() {
        String[] stringArray = JViewer.getSupportedLocales();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (String string : stringArray) {
                int n = string.indexOf(" - [");
                int n2 = string.indexOf("]");
                if (n == -1 || n2 == -1) continue;
                arrayList.add(string.substring(n + " - [".length(), n2));
            }
            if (arrayList.isEmpty()) {
                arrayList.add(DEFAULT_LOCALE);
            }
        }
        catch (Exception exception) {
            Debug.out.printError(exception);
            arrayList.add(DEFAULT_LOCALE);
        }
        return arrayList;
    }

    public static ArrayList<String> getClassesNames(String string) {
        try {
            Serializable serializable;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            assert (classLoader != null);
            String string2 = string.replace('.', '/');
            Enumeration<URL> enumeration = classLoader.getResources(string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                arrayList.add(((URL)serializable).getFile());
            }
            serializable = new TreeSet();
            for (String object2 : arrayList) {
                ((TreeSet)serializable).addAll(JViewer.findClasses(object2, string));
            }
            ArrayList arrayList2 = new ArrayList();
            Iterator iterator = ((TreeSet)serializable).iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                arrayList2.add(string3);
            }
            return arrayList2;
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            return null;
        }
    }

    private static TreeSet<String> findClasses(String string, String string2) {
        Object object;
        Object object2;
        TreeSet<String> treeSet = new TreeSet<String>();
        if (Debug.MODE == 2 || Debug.MODE == 0) {
            if (string.contains("!")) {
                object2 = string.split("!");
                object = null;
                try {
                    object = new URL((String)object2[0]);
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.out.println(malformedURLException);
                }
                Object object3 = null;
                try {
                    object3 = new ZipInputStream(((URL)object).openStream());
                }
                catch (IOException iOException) {
                    Debug.out.println(iOException);
                }
                ZipEntry zipEntry = null;
                try {
                    while ((zipEntry = ((ZipInputStream)object3).getNextEntry()) != null) {
                        String string3;
                        if (!zipEntry.getName().endsWith(".class") || !(string3 = zipEntry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).contains(string2)) continue;
                        treeSet.add(string3);
                    }
                }
                catch (IOException iOException) {
                    Debug.out.println(iOException);
                }
            }
        } else if (Debug.MODE == 1) {
            if (System.getProperty("os.name").startsWith("Windows") && string.startsWith("/")) {
                string = string.substring(string.indexOf(47) + 1, string.length());
            }
            if (string.contains("%20")) {
                string = System.getProperty("os.name").startsWith("Windows") ? string.replaceAll("%20", " ") : string.replaceAll("%20", "\\ ");
            }
        }
        if (!((File)(object2 = new File(string))).exists()) {
            return treeSet;
        }
        for (File file : object = ((File)object2).listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                treeSet.addAll(JViewer.findClasses(file.getAbsolutePath(), string2 + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            treeSet.add(string2 + '.' + file.getName().substring(0, file.getName().length() - 6));
        }
        return treeSet;
    }

    public static ClientConfig getClientCfg() {
        return clientCfg;
    }

    public static void setClientCfg(ClientConfig clientConfig) {
        clientCfg = clientConfig;
    }

    public static String getProtocol() {
        return webSecure == 1 ? "https" : "http";
    }

    public static boolean is64bit() {
        return System.getProperty("os.arch").contains("64");
    }

    static {
        apptype = null;
        title = APP_TYPE_JVIEWER;
        kvmPort = 7578;
        SecureChannel = 0;
        VMSecureChannel = 0;
        cdserver_port = 0;
        hdserver_port = 0;
        Num_CD = 1;
        Num_HD = 1;
        CD_State = 0;
        HD_State = 0;
        useSSL = false;
        VMUseSSL = false;
        webSessionToken = null;
        kvmToken = null;
        kvmTokenType = 0;
        lang = null;
        webPort = -1;
        webSecure = 0;
        keyboardLayout = AUTO_DETECT_KEYBOARD;
        videoFile = null;
        isKVMReconnectEnabled = false;
        retryCount = 3;
        retryInterval = 15;
        username = null;
        password = null;
        launch = null;
        isSinglePortEnabled = false;
        argLength = 0;
        kvmPrivilege = -1;
        unknownParam = false;
        unknownParams = "";
        OEMFeatureStatus = 0L;
        KVMLicenseStatus = 0;
        MediaLicenseStatus = 0;
        isClientAdmin = false;
        KVM_Num_CD = 1;
        KVM_Num_HD = 1;
        powerSaveMode = 0;
        KEYBOARD_LAYOUTS = new HashSet<String>(Arrays.asList(AUTO_DETECT_KEYBOARD, "US", "GB", "FR", "FR-BE", "DE", "DE-CH", "JP", "ES", "IT", "DA", "FI", "NO", "PT", "SV", "NL-NL", "NL-BE", "TR_F", "TR_Q"));
        restService = false;
        defaultlang = false;
    }
}

