/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.avistream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class DataChunkOutputStream
extends FilterOutputStream {
    protected long written;

    public DataChunkOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeType(String string) throws IOException {
        if (string.length() != 4) {
            throw new IllegalArgumentException("type string must have 4 characters");
        }
        try {
            this.out.write(string.getBytes("ASCII"), 0, 4);
            this.incCount(4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
    }

    public final void writeByte(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.incCount(n2);
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public void writeInt(int n) throws IOException {
        this.out.write(n >>> 0 & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 24 & 0xFF);
        this.incCount(4);
    }

    public void writeUInt(long l) throws IOException {
        this.out.write((int)(l >>> 0 & 0xFFL));
        this.out.write((int)(l >>> 8 & 0xFFL));
        this.out.write((int)(l >>> 16 & 0xFFL));
        this.out.write((int)(l >>> 24 & 0xFFL));
        this.incCount(4);
    }

    public void writeShort(int n) throws IOException {
        this.out.write(n >>> 0 & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.incCount(2);
    }

    public void writeLong(long l) throws IOException {
        this.out.write((int)(l >>> 0) & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.incCount(8);
    }

    public void writeUShort(int n) throws IOException {
        this.out.write(n >>> 0 & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.incCount(2);
    }

    protected void incCount(int n) {
        long l = this.written + (long)n;
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        this.written = l;
    }

    public final long size() {
        return this.written;
    }

    public void clearCount() {
        this.written = 0L;
    }
}

