/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.KVMSharing;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;

public class AddMacro {
    private ByteBuffer macroBuffer;
    public static final int MACRO_COUNT = 20;
    public static final int SINGLE_MACRO_LENGTH = 6;
    public static final int SIZE_OF_MACRO = 960;
    protected HashMap<Integer, Integer> standardMapInvert;
    protected HashMap<Integer, Integer> keypadMapInvert;
    protected HashMap<Integer, Integer> leftMapInvert;
    protected HashMap<Integer, Integer> rightMapInvert;
    protected HashMap<String, String> macroMap;
    public static final String UNKNOWN_KEY = "Unknown";

    public AddMacro(ByteBuffer byteBuffer) {
        this.macroBuffer = byteBuffer;
        if (this.macroMap == null) {
            this.macroMap = new HashMap();
        }
    }

    public void parseDataToMenu() {
        this.macroBuffer.position(0);
        this.macroBuffer.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < 20; ++i) {
            String string = new String();
            String string2 = new String();
            for (int j = 0; j < 6; ++j) {
                try {
                    int n = this.macroBuffer.getInt();
                    int n2 = this.macroBuffer.getInt();
                    if (n == 0 || n2 == 0) continue;
                    String string3 = KeyEvent.getKeyText(n);
                    if (string3.startsWith(UNKNOWN_KEY)) {
                        string3 = "";
                        Debug.out.println("UNKNOWN Code : " + n);
                        break;
                    }
                    if (string3.equals("NumPad +")) {
                        string3 = "NumPad Plus";
                    }
                    if (string.length() != 0) {
                        string = string.concat("+");
                    }
                    if (n2 != 1) {
                        if (n2 == 2) {
                            string3 = string3.concat("(Left)");
                        } else if (n2 == 3) {
                            string3 = string3.concat("(Right)");
                        }
                    }
                    string = string.concat(string3);
                    String string4 = new String(Integer.toString(n));
                    String string5 = new String(Integer.toString(n2));
                    if (string2.length() != 0) {
                        string2 = string2.concat("+");
                    }
                    string2 = string2.concat(string4);
                    string2 = string2.concat("+" + string5);
                    continue;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    Debug.out.println(bufferOverflowException);
                    continue;
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    Debug.out.println(bufferUnderflowException);
                }
            }
            if (string.length() == 0 || string2.length() == 0) continue;
            this.macroMap.put(string, string2);
        }
        this.removeMacroMenu();
        this.removeToolbarMacro();
        this.addMacroMenu(this.macroMap);
        this.addToolbarMacro(this.macroMap);
    }

    public void addMacroMenu(HashMap<String, String> hashMap) {
        if (hashMap.size() > 0) {
            Set<Map.Entry<String, String>> set = this.macroMap.entrySet();
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            JViewerApp.getInstance().getJVMenu().getMacroSubMenu().addSeparator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getKey();
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(JViewerApp.getInstance().getJVMenu().m_menuListener);
                JViewerApp.getInstance().getJVMenu();
                jMenuItem.addMouseListener(JVMenu.m_menuStatus);
                jMenuItem.setActionCommand("HK_" + string);
                JViewerApp.getInstance().getJVMenu().getMacroSubMenu().add((Component)jMenuItem, 2);
                JViewerApp.getInstance().getJVMenu().m_menuItems.put(string, jMenuItem);
                JViewerApp.getInstance().getJVMenu();
                JVMenu.m_menuItems_setenabled.put(string, true);
                if (KVMSharing.KVM_REQ_GIVEN != 2 && !JViewerApp.getInstance().isM_userPause()) continue;
                jMenuItem.setEnabled(false);
                JViewerApp.getInstance().getJVMenu();
                JVMenu.m_menuItems_setenabled.put(string, false);
            }
        }
    }

    public void addToolbarMacro(HashMap<String, String> hashMap) {
        if (hashMap.size() > 0) {
            Set<Map.Entry<String, String>> set = this.macroMap.entrySet();
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            JViewerApp.getInstance().getM_wndFrame().getToolbar().getM_popupMenu().addSeparator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getKey();
                JViewerApp.getInstance().getM_wndFrame().getToolbar().addHotkeyPoupMenuItem(string);
            }
        }
    }

    public void removeMacroMenu() {
        JViewerApp.getInstance().getJVMenu().getMacroSubMenu().removeAll();
        JMenuItem jMenuItem = JViewerApp.getInstance().getJVMenu().getMenuItem("Add Hotkeys");
        JViewerApp.getInstance().getJVMenu().getMacroSubMenu().add(jMenuItem);
    }

    public void removeToolbarMacro() {
        JViewerApp.getInstance().getM_wndFrame().getToolbar().removeHotkeyPoupMenuItem();
    }

    public void parseKeycodeSendBMC() {
        byte[] byArray = new byte[960];
        Arrays.fill(byArray, (byte)0);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Set<Map.Entry<String, String>> set = this.macroMap.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String string = entry.getValue();
            String[] stringArray = string.split("[+]");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i >= stringArray.length) continue;
                int n2 = Integer.parseInt(stringArray[i]);
                byteBuffer.putInt(n2);
            }
            byteBuffer.position(n * 12 * 4);
            ++n;
        }
        JViewerApp.getInstance().getKVMClient().sendUserMacroData(byArray);
    }

    public ByteBuffer getMacroBuffer() {
        return this.macroBuffer;
    }

    public void setMacroBuffer(ByteBuffer byteBuffer) {
        this.macroBuffer = byteBuffer;
    }

    public HashMap<String, String> getMacroMap() {
        return this.macroMap;
    }

    public void setMacroMap(HashMap<String, String> hashMap) {
        this.macroMap = hashMap;
    }
}

