/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class CaptureScreen
extends Thread {
    private JFileChooser saveFileChooser;
    private File saveFile;
    private boolean run = true;
    private BufferedImage capturedFrame = null;

    public CaptureScreen(BufferedImage bufferedImage) {
        this.capturedFrame = bufferedImage;
    }

    @Override
    public void run() {
        this.saveFileChooser = new JFileChooser();
        this.saveFile = new File("CapturedScreen.jpeg");
        this.saveFileChooser.setSelectedFile(this.saveFile);
        this.saveFileChooser.setFileFilter(new ImageFilter());
        this.saveFileChooser.setAcceptAllFileFilterUsed(false);
        while (this.run) {
            int n = this.saveFileChooser.showSaveDialog(JViewerApp.getInstance().getRCView());
            if (n == 0) {
                this.saveFile = this.saveFileChooser.getSelectedFile();
                if (!this.saveFile.getName().endsWith(".jpeg")) {
                    this.saveFile = new File(this.saveFile.getPath().concat(".jpeg"));
                }
                this.saveImage();
                continue;
            }
            this.run = false;
        }
    }

    private void saveImage() {
        try {
            if (this.saveFile.exists()) {
                int n = JOptionPane.showConfirmDialog(this.saveFileChooser, LocaleStrings.getString("AF_1_CS") + " \"" + this.saveFile.getName() + "\" " + LocaleStrings.getString("AF_2_CS"), LocaleStrings.getString("F_121_JVM"), 0, 3);
                if (n == 0) {
                    ImageIO.write((RenderedImage)this.capturedFrame, "jpeg", this.saveFile);
                    this.run = false;
                } else {
                    this.run = true;
                }
            } else {
                this.saveFile.createNewFile();
                ImageIO.write((RenderedImage)this.capturedFrame, "jpeg", this.saveFile);
                this.run = false;
            }
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
        }
    }

    private class ImageFilter
    extends FileFilter {
        private ImageFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null) {
                return string.equals("jpeg");
            }
            return false;
        }

        private String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }

        @Override
        public String getDescription() {
            return "JPEG";
        }
    }
}

