/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.FSMenuBar;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;

public class FSFrame
extends JVFrame {
    private static final long serialVersionUID = 1L;
    private FSMenuBar m_menuBar;
    private String m_label;

    public FSFrame() {
        if (JViewer.isStandalone()) {
            JViewer.getMainFrame().setUndecorated(true);
        }
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension);
        this.m_menuBar = new FSMenuBar(this);
    }

    @Override
    public JVMenu getMenu() {
        return this.m_menuBar.getFSMenu();
    }

    @Override
    public void setStatus(String string) {
    }

    @Override
    public void resetStatus() {
    }

    @Override
    public void exitApp() {
        this.windowClosed();
    }

    @Override
    public void setWndLabel(String string) {
        this.m_label = string;
        String string2 = JViewerApp.getInstance().getResolutionStatus();
        if (!Mousecaliberation.THRESHOLDFLAG && !Mousecaliberation.ACCELERATION_FLAG) {
            if (string2 != null) {
                this.m_menuBar.setIDLabel(m_serverIP + " - " + "[" + string2 + "] - " + string);
            } else {
                this.m_menuBar.setIDLabel(m_serverIP + " - " + string);
            }
            if (JViewerApp.getOEMManager().setFSFrameTitle(string) == 0) {
                this.setTitle(JViewer.getTitle() + "[" + m_serverIP + "] - " + string);
            }
        }
    }

    public void showWindow() {
        this.m_menuBar = new FSMenuBar(this);
        this.m_menuBar.showMenu();
        if (JViewer.isStandalone()) {
            URL uRL = JViewer.class.getResource("res/jviewer.jpg");
            JViewer.getMainFrame().setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
    }

    public void hideWindow() {
        this.m_menuBar.cancelTimer();
        this.m_menuBar.dispose();
    }

    @Override
    public void refreshTitle() {
        if (JViewerApp.getOEMManager().setFSFrameTitle(this.m_label) == 0) {
            this.setTitle(JViewer.getTitle() + " [" + m_serverIP + "] - " + this.m_label);
        }
    }

    public FSMenuBar getM_menuBar() {
        return this.m_menuBar;
    }
}

