/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.FSFrame;
import com.ami.kvm.jviewer.gui.FSLEDStatusBar;
import com.ami.kvm.jviewer.gui.FSMenu;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FSMenuBar
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String PIN = "Pin";
    private static final String UNPIN = "Unpin";
    private static final String MENU = LocaleStrings.getString("B_2_FMB");
    private static final String LED_STATUS = "LED Status";
    private static final String MINIMIZE = LocaleStrings.getString("B_4_FMB");
    private static final String TO_FRAME = LocaleStrings.getString("B_5_FMB");
    private static final String CLOSE = LocaleStrings.getString("B_6_FMB");
    private static final int MENUBAR_HEIGHT = 20;
    private FSFrame m_frame;
    private FSMenu m_fsMenu;
    private JPopupMenu m_popupMenu;
    private MouseEnterExit m_msEE;
    private ButtonListener m_btnListener;
    private int m_slide = 0;
    private int slideStatusBar = 0;
    private int m_fsMenuX;
    private int m_fsMenuY;
    private int m_fsMenuWidth;
    private Timer m_timer;
    private Timer ledStatusTimer;
    private boolean m_show;
    private boolean showLEDStatusBar = false;
    private JComponent m_contentPane;
    private JLabel m_idLbl;
    private JButton m_menuBtn;
    private JPanel m_autoPanel;
    private JButton m_autoPin;
    private JButton m_autoUnpin;
    private JButton showLEDStatus;
    private FSLEDStatusBar ledStatusBar;
    private boolean m_auto;
    private boolean fsToolbarEnabled = false;

    public FSMenuBar() {
    }

    public FSMenuBar(FSFrame fSFrame) {
        super(JViewer.getMainFrame());
        this.ledStatusBar = new FSLEDStatusBar(this);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.m_fsMenuWidth = 400;
        this.m_fsMenuX = (dimension.width - this.m_fsMenuWidth) / 2;
        this.setBounds(this.m_fsMenuX, 0, this.m_fsMenuWidth, this.m_slide);
        this.setVisible(false);
        this.setUndecorated(true);
        this.setResizable(false);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        this.m_msEE = new MouseEnterExit();
        this.addMouseListener(this.m_msEE);
        this.addMouseListener(new WindowMouseEvents());
        this.m_btnListener = new ButtonListener();
        this.m_contentPane = (JComponent)this.getContentPane();
        this.m_contentPane.setBackground(new Color(250, 250, 250));
        this.m_contentPane.setLayout(new BoxLayout(this.m_contentPane, 0));
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_autoPin = this.createButton("res/pin.jpg", LocaleStrings.getString("B_1_FMB"), PIN);
        this.m_autoUnpin = this.createButton("res/unpin.jpg", LocaleStrings.getString("B_1_FMB"), UNPIN);
        this.m_autoPanel = new JPanel();
        this.m_autoPanel.setLayout(new BoxLayout(this.m_autoPanel, 0));
        this.m_autoPanel.setPreferredSize(new Dimension(15, 15));
        this.m_autoPanel.setMaximumSize(new Dimension(15, 15));
        this.m_autoPanel.add(this.m_autoPin);
        this.m_auto = false;
        this.m_contentPane.add(this.m_autoPanel);
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_menuBtn = this.createButton("res/menu.jpg", MENU, MENU);
        this.m_fsMenu = new FSMenu();
        this.m_popupMenu = this.m_fsMenu.getPopupMenu();
        this.m_popupMenu.addPopupMenuListener(new PopupMenuEventListener());
        this.m_menuBtn.addMouseListener(new PopupListener());
        this.m_contentPane.add(this.m_menuBtn);
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.showLEDStatus = this.createButton("res/lock.png", LocaleStrings.getString("B_7_FMB"), LED_STATUS);
        this.m_contentPane.add(this.showLEDStatus);
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_contentPane.add(this.createSeparator());
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_idLbl = new JLabel(LocaleStrings.getString("B_3_FMB"));
        this.m_idLbl.setForeground(new Color(0, 100, 100));
        this.m_idLbl.setFont(new Font("SansSerif", 0, 12));
        this.m_idLbl.setHorizontalAlignment(0);
        this.m_idLbl.setPreferredSize(new Dimension(287, 15));
        this.m_idLbl.setMinimumSize(new Dimension(287, 15));
        this.m_idLbl.setMaximumSize(new Dimension(287, 15));
        this.m_contentPane.add(this.m_idLbl);
        this.m_contentPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_contentPane.add(this.createButton("res/min.jpg", MINIMIZE, MINIMIZE));
        this.m_contentPane.add(Box.createRigidArea(new Dimension(1, 0)));
        this.m_contentPane.add(this.createButton("res/max.jpg", TO_FRAME, TO_FRAME));
        this.m_contentPane.add(Box.createRigidArea(new Dimension(1, 0)));
        this.m_contentPane.add(this.createButton("res/close.jpg", CLOSE, CLOSE));
    }

    public JVMenu getFSMenu() {
        return this.m_fsMenu;
    }

    public FSLEDStatusBar getLedStatusBar() {
        return this.ledStatusBar;
    }

    public void showMenu() {
        this.m_show = true;
        if (this.m_timer != null) {
            this.m_timer.cancel();
        }
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new SlideTask(), 0L, 20L);
        if (this.fsToolbarEnabled) {
            this.showLEDStatusBar(true);
        }
    }

    public void hideMenu() {
        this.m_show = false;
        if (this.m_timer != null) {
            this.m_timer.cancel();
        }
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new SlideTask(), 0L, 20L);
        if (this.fsToolbarEnabled) {
            this.showLEDStatusBar(false);
        }
    }

    public void setIDLabel(String string) {
        int n;
        int n2 = 15;
        int n3 = JViewer.getMainFrame().getLocationOnScreen().x;
        Dimension dimension = JViewerApp.getInstance().getCurrentMonitorResolution();
        if (System.getProperty("os.name").startsWith("Mac")) {
            n = 199;
            this.m_fsMenuWidth = 332;
            this.m_fsMenuX = n3 + (dimension.width - this.m_fsMenuWidth) / 2;
            this.m_fsMenuY = 20;
        } else {
            n = 187;
            this.m_fsMenuWidth = 320;
            this.m_fsMenuX = n3 + (dimension.width / 2 - this.m_fsMenuWidth / 2);
            this.m_fsMenuY = 0;
        }
        this.m_idLbl.setPreferredSize(new Dimension(n, n2));
        this.m_idLbl.setMinimumSize(new Dimension(n, n2));
        this.m_idLbl.setMaximumSize(new Dimension(n, n2));
        this.m_idLbl.setText(string);
        this.setBounds(this.m_fsMenuX, this.m_fsMenuY, this.m_fsMenuWidth, this.m_slide);
    }

    public void cancelTimer() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
        if (this.ledStatusTimer != null) {
            this.ledStatusTimer.cancel();
            this.ledStatusTimer = null;
        }
    }

    private void showLEDStatusBar(boolean bl) {
        this.showLEDStatusBar = bl;
        if (this.ledStatusTimer != null) {
            this.ledStatusTimer.cancel();
        }
        this.ledStatusTimer = new Timer();
        this.ledStatusTimer.schedule((TimerTask)new StatusBarSlideTask(), 0L, 20L);
    }

    private void slide() {
        if (System.getProperty("os.name").startsWith("Mac")) {
            this.setBounds(this.m_fsMenuX, 20, this.m_fsMenuWidth, this.m_slide);
        } else {
            this.setBounds(this.m_fsMenuX, 0, this.m_fsMenuWidth, this.m_slide);
        }
        if (this.showLEDStatusBar) {
            this.slideStatusBar();
        }
        this.setVisible(true);
    }

    private void slideStatusBar() {
        if (this.slideStatusBar < 20) {
            int n = this.m_fsMenuX + (this.m_fsMenuWidth - 160) / 2;
            if (System.getProperty("os.name").startsWith("Mac")) {
                this.ledStatusBar.setBounds(n, this.m_slide + 20, 160, this.slideStatusBar);
            } else {
                this.ledStatusBar.setBounds(n, this.m_slide, 160, this.slideStatusBar);
            }
            this.ledStatusBar.setVisible(true);
        }
    }

    private JButton createButton(String string, String string2, String string3) {
        URL uRL = JViewer.class.getResource(string);
        JButton jButton = new JButton();
        if (uRL != null) {
            jButton.setIcon(new ImageIcon(uRL));
        }
        jButton.setToolTipText(string2);
        jButton.setPreferredSize(new Dimension(15, 15));
        jButton.setMinimumSize(new Dimension(15, 15));
        jButton.setMaximumSize(new Dimension(15, 15));
        jButton.addMouseListener(this.m_msEE);
        jButton.setActionCommand(string3);
        jButton.addActionListener(this.m_btnListener);
        return jButton;
    }

    private JLabel createSeparator() {
        JLabel jLabel = new JLabel("|");
        jLabel.setForeground(new Color(200, 200, 200));
        jLabel.setFont(new Font("Arial", 0, 18));
        return jLabel;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JViewerApp jViewerApp = JViewerApp.getInstance();
            String string = actionEvent.getActionCommand();
            if (string.equals(FSMenuBar.UNPIN)) {
                Debug.out.println("Disable Auto hide");
                FSMenuBar.this.m_autoPanel.removeAll();
                FSMenuBar.this.m_autoPanel.add(FSMenuBar.this.m_autoPin);
                FSMenuBar.this.m_autoPanel.repaint();
                FSMenuBar.this.m_auto = false;
                FSMenuBar.this.ledStatusBar.setAutoHide(false);
                JViewerApp.getInstance().getRCView().requestFocus();
            } else if (string.equals(FSMenuBar.PIN)) {
                Debug.out.println("Enable Auto hide");
                FSMenuBar.this.m_autoPanel.removeAll();
                FSMenuBar.this.m_autoPanel.add(FSMenuBar.this.m_autoUnpin);
                FSMenuBar.this.m_auto = true;
                FSMenuBar.this.ledStatusBar.setAutoHide(true);
                JViewerApp.getInstance().getRCView().requestFocus();
            } else if (string.equals(TO_FRAME)) {
                Debug.out.println("Toggle to frame window");
                FSMenuBar.this.m_auto = false;
                jViewerApp.OnVideoFullScreen(false);
            } else if (string.equals(MINIMIZE)) {
                Debug.out.println("Minimize");
                if (JViewer.isStandalone()) {
                    JViewer.getMainFrame().setState(1);
                }
            } else if (string.equals(CLOSE)) {
                Debug.out.println("Close");
                jViewerApp.OnVideoExit();
            } else if (string.equals(MENU)) {
                Debug.out.println("Menu");
            } else if (string.equals(FSMenuBar.LED_STATUS)) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (FSMenuBar.this.showLEDStatusBar) {
                    jButton.setToolTipText(LocaleStrings.getString("B_7_FMB"));
                    FSMenuBar.this.showLEDStatusBar(false);
                } else {
                    jButton.setToolTipText(LocaleStrings.getString("B_8_FMB"));
                    FSMenuBar.this.showLEDStatusBar(true);
                }
                if (FSMenuBar.this.fsToolbarEnabled) {
                    FSMenuBar.this.fsToolbarEnabled = false;
                } else {
                    FSMenuBar.this.fsToolbarEnabled = true;
                }
            } else {
                JViewerApp.getInstance().getRCView().requestFocus();
            }
        }
    }

    class PopupMenuEventListener
    implements PopupMenuListener {
        boolean m_autoCanceled = false;

        PopupMenuEventListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            Debug.out.println("Popup canceled");
            if (this.m_autoCanceled) {
                FSMenuBar.this.m_auto = true;
                this.m_autoCanceled = false;
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Debug.out.println("Popup visible");
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_auto = false;
                this.m_autoCanceled = true;
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            Debug.out.println("Popup invisible");
            if (this.m_autoCanceled) {
                FSMenuBar.this.m_auto = true;
                this.m_autoCanceled = false;
                FSMenuBar.this.hideMenu();
            }
            JViewerApp.getInstance().getRCView().requestFocus();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Debug.out.println("Popup event");
            FSMenuBar.this.m_popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class MouseEnterExit
    extends MouseAdapter {
        MouseEnterExit() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.showMenu();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.hideMenu();
            }
        }
    }

    class WindowMouseEvents
    extends MouseAdapter {
        WindowMouseEvents() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JViewerApp.getInstance().getRCView().requestFocus();
        }
    }

    class StatusBarSlideTask
    extends TimerTask {
        StatusBarSlideTask() {
        }

        @Override
        public void run() {
            if (FSMenuBar.this.showLEDStatusBar) {
                if (FSMenuBar.this.slideStatusBar <= 20) {
                    FSMenuBar.this.slideStatusBar++;
                    FSMenuBar.this.slideStatusBar();
                } else {
                    if (FSMenuBar.this.ledStatusTimer != null) {
                        FSMenuBar.this.ledStatusTimer.cancel();
                    }
                    if (!FSMenuBar.this.m_auto) {
                        JViewerApp.getInstance().getRCView().requestFocus();
                    }
                }
            } else if (FSMenuBar.this.slideStatusBar >= 1) {
                FSMenuBar.this.slideStatusBar--;
                FSMenuBar.this.slideStatusBar();
            } else {
                if (FSMenuBar.this.ledStatusTimer != null) {
                    FSMenuBar.this.ledStatusTimer.cancel();
                }
                if (FSMenuBar.this.m_auto) {
                    JViewerApp.getInstance().getRCView().requestFocus();
                }
            }
        }
    }

    class SlideTask
    extends TimerTask {
        SlideTask() {
        }

        @Override
        public void run() {
            if (FSMenuBar.this.m_show) {
                if (FSMenuBar.this.m_slide < 20) {
                    FSMenuBar.this.m_slide++;
                    FSMenuBar.this.slide();
                } else {
                    FSMenuBar.this.m_timer.cancel();
                    if (!FSMenuBar.this.m_auto) {
                        JViewerApp.getInstance().getRCView().requestFocus();
                    }
                }
            } else if (FSMenuBar.this.m_slide > 1) {
                FSMenuBar.this.m_slide--;
                FSMenuBar.this.slide();
            } else {
                FSMenuBar.this.m_timer.cancel();
                if (FSMenuBar.this.m_auto) {
                    JViewerApp.getInstance().getRCView().requestFocus();
                }
            }
        }
    }
}

