/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.common.IAVIOutputStream;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.VideoRecord;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class ImagesToVideo
extends TimerTask {
    private IAVIOutputStream out = null;
    private String movFile;
    private String imagePath;
    private long numOfFrames;
    private long duration;
    private int i = 1;
    private long count;
    private double scalex;
    private double scaley;
    private File frameFile;
    private BufferedImage image;
    private boolean singleVideo;
    public Timer imagesToVideo;
    private int currentFile = -1;
    private int totalFiles = -1;

    public ImagesToVideo(String string, String string2, long l, long l2) {
        this.movFile = string;
        this.imagePath = string2;
        this.numOfFrames = l;
        this.duration = l2;
        this.singleVideo = JViewerApp.getInstance().getM_videorecord().singleVideo;
        if (JViewerApp.getInstance().getVideorecordapp() != null) {
            this.currentFile = JViewerApp.getInstance().getVideorecordapp().getFileIndex();
            this.totalFiles = JViewerApp.getInstance().getVideorecordapp().getVideotmpstorepath().length;
        }
        if (l > 0L && l > (long)JViewerApp.getInstance().getM_videorecord().getM_videorecord().getNum_blank_frames()) {
            this.out = (IAVIOutputStream)JViewerApp.getInstance().createObject("com.ami.kvm.jviewer.avistream.AVIOutputStream");
            this.out.initVideoFrames();
            this.out.setOutputFile(new File(string));
            this.out.setVideoFormat(IAVIOutputStream.VideoFormat.JPG);
            this.out.setSingleVideo(this.singleVideo);
            this.out.setVideoCompressionQuality(0.75f);
            this.out.setTimeScale(l2);
            this.out.setFrameRate(l);
        }
        this.image = new BufferedImage(1024, 768, 1);
        this.imagesToVideo = new Timer(true);
        this.imagesToVideo.schedule((TimerTask)this, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object;
            if (this.numOfFrames > 0L && this.numOfFrames > (long)JViewerApp.getInstance().getM_videorecord().getM_videorecord().getNum_blank_frames()) {
                this.count = 0L;
                while (this.count < this.numOfFrames) {
                    if (!this.singleVideo && this.out.isStreamClosed()) {
                        this.multipleVideos();
                    }
                    object = "file" + this.count + ".jpeg";
                    this.frameFile = new File(this.imagePath, (String)object);
                    this.image = ImageIO.read(this.frameFile);
                    if (this.singleVideo && (this.image.getWidth() != 1024 || this.image.getHeight() != 768)) {
                        this.image = this.singleVideo(this.image);
                    }
                    if (this.out.writeFrame(this.image)) {
                        this.frameFile.delete();
                    }
                    ++this.count;
                }
            }
            if (this.out != null) {
                this.out.close();
            }
            this.cancel();
            if (!JViewer.isdownloadapp()) {
                JViewerApp.getInstance().getM_wndFrame().getWindowMenu().setMessage("");
            }
            object = JViewerApp.getInstance().getMainWindow();
            VideoRecord.Record_Processing = false;
            if (JViewerApp.getInstance().getM_frame().videoStopError != null) {
                JViewerApp.getInstance().getM_frame().videoStopError.dispose();
            } else if (JViewer.isdownloadapp()) {
                JViewerApp.getInstance().getVideorecordapp().disposeInformationDialog();
                if (VideoRecord.file_creat_success) {
                    JOptionPane.showMessageDialog((Component)object, LocaleStrings.getString("L_1_ITOV") + LocaleStrings.getString("L_7_ITOV") + this.movFile + LocaleStrings.getString("L_2_ITOV"), LocaleStrings.getString("L_3_ITOV"), 1);
                } else {
                    JOptionPane.showMessageDialog((Component)object, LocaleStrings.getString("L_1_ITOV") + LocaleStrings.getString("L_8_ITOV") + LocaleStrings.getString("L_7_ITOV") + this.movFile + LocaleStrings.getString("L_2_ITOV"), LocaleStrings.getString("L_3_ITOV"), 1);
                }
                JViewerApp.getInstance().getVideorecordapp().setFileIndex(++this.currentFile);
                if (this.currentFile < this.totalFiles) {
                    JViewerApp.getInstance().getVideorecordapp().availToConvert = true;
                    Object object2 = JViewerApp.getInstance().getVideorecordapp().convert;
                    synchronized (object2) {
                        JViewerApp.getInstance().getVideorecordapp().convert.notify();
                    }
                } else {
                    JViewerApp.getInstance().getM_frame().windowClosed();
                }
            } else {
                File file = new File(JViewerApp.getInstance().getM_videorecord().Temp_store_Path);
                file.delete();
                if (this.numOfFrames <= 0L || this.numOfFrames <= (long)JViewerApp.getInstance().getM_videorecord().getM_videorecord().getNum_blank_frames()) {
                    InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("L_9_ITOV"), LocaleStrings.getString("L_3_ITOV"), 1);
                } else if (VideoRecord.file_creat_success) {
                    InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("L_7_ITOV") + this.movFile + "\n" + LocaleStrings.getString("L_4_ITOV") + (int)VideoRecord.Avg_fps + LocaleStrings.getString("L_5_ITOV"), LocaleStrings.getString("L_3_ITOV"), 1);
                } else {
                    InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("L_8_ITOV") + LocaleStrings.getString("L_7_ITOV") + this.movFile + "\n" + LocaleStrings.getString("L_4_ITOV") + (int)VideoRecord.Avg_fps + LocaleStrings.getString("L_5_ITOV"), LocaleStrings.getString("L_3_ITOV"), 1);
                }
            }
            if (!(JViewer.isdownloadapp() || JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STARTED && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STARTING)) {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordStart", true);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordSettings", true);
            }
        }
        catch (IOException iOException) {
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException2) {
                Debug.out.println(iOException2);
            }
            this.cancel();
            String string = LocaleStrings.getString("L_6_ITOV");
            JViewerApp.getInstance().getM_videorecord().OnLowDiskSpace(this.frameFile, string);
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
            }
        }
    }

    private BufferedImage singleVideo(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(1024, 768, 1);
        this.scalex = 1024.0 / (double)bufferedImage.getWidth();
        this.scaley = 768.0 / (double)bufferedImage.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.scalex, this.scaley);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    private void multipleVideos() {
        --this.count;
        this.out.setStreamClosed(false);
        this.out = (IAVIOutputStream)JViewerApp.getInstance().createObject("com.ami.kvm.jviewer.avistream.AVIOutputStream");
        this.out.initVideoFrames();
        this.out.setOutputFile(new File(this.movFile + "_" + this.i + ".avi"));
        this.out.setVideoFormat(IAVIOutputStream.VideoFormat.JPG);
        this.out.setSingleVideo(this.singleVideo);
        this.out.setFrameRate(this.numOfFrames);
        this.out.setTimeScale(this.duration);
        this.out.setVideoCompressionQuality(1.0f);
        ++this.i;
    }
}

