/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.AutoKeyboardLayout;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.KVMSharing;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JVToolBar
extends JToolBar
implements MouseListener {
    private JButton altTab;
    private JToolBar m_toolbar = new JToolBar();
    public JButton mouseBtn;
    private JButton cdBtn;
    private JButton hardddiskBtn;
    private JButton kbdBtn;
    private JButton playPauseBtn;
    private JButton fullScreenBtn;
    private JButton videoRecordBtn;
    private JButton powerBtn;
    private JButton hostDisplayBtn;
    private JSlider slider_zoom;
    private JButton zoomBtn;
    private JPopupMenu m_popupMenu;
    private JPopupMenu m_zoomPopupMenu;
    private JButton m_hotKeyBtn;
    private JMenuItem altCtrlDelBtn;
    protected static Hashtable<JButton, String> m_menutoolbar_text = new Hashtable();
    public JButton usersBtn;
    private JPopupMenu userPopupMenu;

    protected JButton createButton(String string, String string2, int n, int n2, int n3, int n4) {
        URL uRL = string == null ? null : JViewer.class.getResource(string);
        JButton jButton = new JButton(){

            @Override
            public Point getToolTipLocation(MouseEvent mouseEvent) {
                return new Point(this.getWidth(), this.getHeight() - 40);
            }
        };
        if (uRL != null) {
            jButton.setIcon(new ImageIcon(uRL));
        }
        jButton.setToolTipText(string2);
        jButton.setPreferredSize(new Dimension(n3, n4));
        jButton.setMaximumSize(new Dimension(n3, n4));
        jButton.setMinimumSize(new Dimension(n3, n4));
        jButton.setVisible(true);
        jButton.setRequestFocusEnabled(false);
        jButton.addMouseListener(this);
        return jButton;
    }

    public JVToolBar() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        this.mouseBtn = this.createButton("res/Mouse2Btn.png", LocaleStrings.getString("Q_1_JVT"), 23, 23, 33, 33);
        m_menutoolbar_text.put(this.mouseBtn, "Q_1_JVT");
        this.setCDBtn(this.createButton("res/CD.png", LocaleStrings.getString("Q_2_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getCDBtn(), "Q_2_JVT");
        this.setHardddiskBtn(this.createButton("res/HD.png", LocaleStrings.getString("Q_4_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getHardddiskBtn(), "Q_4_JVT");
        this.setKbdBtn(this.createButton("res/keyboard.png", LocaleStrings.getString("Q_5_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getKbdBtn(), "Q_5_JVT");
        this.setFullScreenBtn(this.createButton("res/Maxi.png", LocaleStrings.getString("Q_6_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getFullScreenBtn(), "Q_6_JVT");
        this.setVideoRecordBtn(this.createButton("res/start_record.png", LocaleStrings.getString("Q_7_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getVideoRecordBtn(), "Q_7_JVT");
        this.setPlayPauseBtn(this.createButton("res/pause.png", LocaleStrings.getString("Q_8_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getPlayPauseBtn(), "Q_8_JVT");
        this.setM_hotKeyBtn(this.createButton("res/Hot-keys.png", LocaleStrings.getString("Q_10_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getM_hotKeyBtn(), "Q_10_JVT");
        this.usersBtn = this.createButton("res/user.png", LocaleStrings.getString("Q_11_JVT"), 23, 23, 33, 33);
        m_menutoolbar_text.put(this.usersBtn, "Q_11_JVT");
        this.setPowerBtn(this.createButton("res/poweroff.png", LocaleStrings.getString("Q_12_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getPowerBtn(), "Q_12_JVT");
        this.setHostDisplayBtn(this.createButton("res/monitorOn.png", LocaleStrings.getString("Q_21_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getHostDisplayBtn(), "Q_21_JVT");
        this.setZoomBtn(this.createButton("res/zoom.png", LocaleStrings.getString("Q_25_JVT"), 23, 23, 33, 33));
        m_menutoolbar_text.put(this.getZoomBtn(), "Q_25_JVT");
        this.altCtrlDelBtn = new JMenuItem("Ctrl + Alt + Del");
        this.altCtrlDelBtn.setToolTipText(LocaleStrings.getString("Q_13_JVT") + " Ctrl+Alt+Del " + LocaleStrings.getString("Q_14_JVT"));
        this.altCtrlDelBtn.setVisible(true);
        this.altCtrlDelBtn.setRequestFocusEnabled(false);
        this.altCtrlDelBtn.addMouseListener(this);
        this.m_popupMenu = new JPopupMenu();
        this.m_popupMenu.add(this.altCtrlDelBtn);
        this.m_zoomPopupMenu = new JPopupMenu();
        this.m_zoomPopupMenu.add(this.constructZoomMenu());
        this.m_toolbar.add(this.getPlayPauseBtn());
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.getFullScreenBtn());
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.getCDBtn());
        this.m_toolbar.add(this.getHardddiskBtn());
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.mouseBtn);
        this.m_toolbar.add(this.getKbdBtn());
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.getVideoRecordBtn());
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.getM_hotKeyBtn());
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.getZoomBtn());
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(Box.createHorizontalGlue());
        this.m_toolbar.add(this.usersBtn);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.getHostDisplayBtn());
        this.m_toolbar.add(Box.createHorizontalStrut(1));
        this.m_toolbar.add(this.getPowerBtn());
        EtchedBorder etchedBorder = new EtchedBorder(1);
        this.m_toolbar.setBorder(etchedBorder);
        this.m_toolbar.setFloatable(false);
        this.m_toolbar.repaint();
    }

    protected JSlider constructZoomMenu() {
        if (this.getSlider_zoom() == null) {
            this.setSlider_zoom(new JSlider(50, 150));
            this.getSlider_zoom().setValue(100);
            this.getSlider_zoom().setMaximumSize(new Dimension(200, Short.MAX_VALUE));
            this.getSlider_zoom().setMinimumSize(new Dimension(200, Short.MAX_VALUE));
            this.getSlider_zoom().setBorder(BorderFactory.createEtchedBorder());
            this.getSlider_zoom().setPaintLabels(true);
            this.getSlider_zoom().setMajorTickSpacing(50);
            this.getSlider_zoom().setMaximum(150);
            this.getSlider_zoom().setMinimum(50);
            this.getSlider_zoom().setMinorTickSpacing(0);
            this.getSlider_zoom().setToolTipText("100%");
            this.getSlider_zoom().setFocusable(false);
            this.getSlider_zoom().addChangeListener(new MyChangeAction());
            this.getSlider_zoom().setRequestFocusEnabled(false);
            this.getSlider_zoom().addMouseListener(this);
        }
        return this.getSlider_zoom();
    }

    public void setZoomLabel(int n) {
        String string = Integer.toString(n);
        JViewerApp.getInstance().getM_wndFrame().getMenu().setZoomLabelText(string + "%");
        this.getSlider_zoom().setToolTipText(string + "%");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.mouseBtn) {
            if (!JViewerApp.getInstance().getKVMClient().redirection()) {
                return;
            }
            if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("MouseShowCursor").isSelected()) {
                if (!JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("MouseShowCursor").isEnabled()) return;
                JViewerApp.getInstance().OnShowCursor(false);
                return;
            }
            JViewerApp.getInstance().OnShowCursor(true);
            return;
        }
        if (mouseEvent.getSource() == this.getKbdBtn()) {
            AutoKeyboardLayout autoKeyboardLayout;
            if (!JViewerApp.getInstance().getKVMClient().redirection()) {
                return;
            }
            JVMenu jVMenu = JViewerApp.getInstance().getJVMenu();
            if (JViewerApp.getInstance().getAutokeylayout() != null) {
                autoKeyboardLayout = JViewerApp.getInstance().getAutokeylayout();
            } else {
                autoKeyboardLayout = new AutoKeyboardLayout();
                JViewerApp.getInstance().setAutokeylayout(autoKeyboardLayout);
            }
            if (!jVMenu.getMenuSelected("Auto detect").booleanValue()) {
                if (JVMenu.keyBoardLayout >= 0) {
                    JViewerApp.getInstance().OnSkbrdDisplay(JVMenu.keyBoardLayout);
                    return;
                }
            }
            jVMenu.notifyMenuStateSelected("Auto detect", true);
            jVMenu.getMenuItem("NONE").setSelected(true);
            if (autoKeyboardLayout.getKeyboardType() == 1036) {
                JViewerApp.getInstance().OnSkbrdDisplay(3);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1031) {
                JViewerApp.getInstance().OnSkbrdDisplay(4);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1033) {
                JViewerApp.getInstance().OnSkbrdDisplay(0);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1041) {
                JViewerApp.getInstance().OnSkbrdDisplay(16);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1034) {
                JViewerApp.getInstance().OnSkbrdDisplay(2);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 2057) {
                JViewerApp.getInstance().OnSkbrdDisplay(1);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 2055) {
                JViewerApp.getInstance().OnSkbrdDisplay(8);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 2060) {
                JViewerApp.getInstance().OnSkbrdDisplay(13);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1040) {
                JViewerApp.getInstance().OnSkbrdDisplay(5);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1044) {
                JViewerApp.getInstance().OnSkbrdDisplay(9);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1030) {
                JViewerApp.getInstance().OnSkbrdDisplay(6);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1053) {
                JViewerApp.getInstance().OnSkbrdDisplay(11);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1035) {
                JViewerApp.getInstance().OnSkbrdDisplay(7);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1043) {
                JViewerApp.getInstance().OnSkbrdDisplay(21);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 2067) {
                JViewerApp.getInstance().OnSkbrdDisplay(14);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 2070) {
                JViewerApp.getInstance().OnSkbrdDisplay(10);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 66591) {
                JViewerApp.getInstance().OnSkbrdDisplay(17);
                return;
            }
            if (autoKeyboardLayout.getKeyboardType() == 1055) {
                JViewerApp.getInstance().OnSkbrdDisplay(18);
                return;
            }
            JViewerApp.getInstance().OnSkbrdDisplay(0);
            return;
        }
        if (mouseEvent.getSource() == this.altCtrlDelBtn) {
            if (!JViewerApp.getInstance().getKVMClient().redirection()) {
                return;
            }
            if (JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldLeftCtrlKey").booleanValue() || JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldRightCtrlKey").booleanValue()) {
                if (JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldLeftAltKey") != false) return;
                if (JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldRightAltKey").booleanValue()) {
                    return;
                }
            }
            JViewerApp.getInstance().OnKeyboardAltCtrlDel();
            return;
        }
        if (mouseEvent.getSource() == this.getM_hotKeyBtn()) {
            this.m_popupMenu.show(mouseEvent.getComponent(), 0, mouseEvent.getComponent().getHeight());
            return;
        }
        if (mouseEvent.getSource() == this.getPlayPauseBtn()) {
            if (JViewerApp.getInstance().getJVMenu().getMenuItem("VideoResumeRedirection").isEnabled()) {
                JViewerApp.getInstance().OnVideoResumeRedirection();
                return;
            }
            if (!JViewerApp.getInstance().getJVMenu().getMenuItem("VideoPauseRedirection").isEnabled()) return;
            JViewerApp.getInstance().setM_userPause(true);
            JViewerApp.getInstance().OnVideoPauseRedirection();
            return;
        }
        if (mouseEvent.getSource() == this.usersBtn) {
            this.userPopupMenu = new JPopupMenu();
            int n = KVMClient.getNumUsers();
            String[] stringArray = KVMClient.getUserData();
            if (stringArray != null && n != 0) {
                for (int i = 0; i < n; ++i) {
                    URL uRL;
                    ImageIcon imageIcon = null;
                    String string = stringArray[i].substring(stringArray[i].indexOf(":") + 1, stringArray[i].length()).trim();
                    String string2 = stringArray[i].substring(0, stringArray[i].indexOf(":") - 1).trim();
                    if (Integer.parseInt(string2) == JViewerApp.getInstance().getCurrentSessionId() && (uRL = JViewer.class.getResource("res/green.png")) != null) {
                        imageIcon = new ImageIcon(uRL);
                    }
                    this.userPopupMenu.add(JViewerApp.getInstance().getJVMenu().createCustomActiveuserMenuItem(Integer.parseInt(string2), string, imageIcon));
                }
            }
            this.userPopupMenu.show(mouseEvent.getComponent(), 0, mouseEvent.getComponent().getHeight());
            return;
        }
        if (mouseEvent.getSource().equals(this.getPowerBtn())) {
            if (!JViewer.isPowerPrivEnabled()) {
                InfoDialog.showDialog((Component)JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("D_62_JVAPP"), LocaleStrings.getString("A_6_GLOBAL"), 1);
                return;
            }
            if (JViewerApp.getInstance().getM_frame().getMenu().getMenuEnable("Power On Server").booleanValue()) {
                JViewerApp.getInstance().onSendPowerControlCommand("Power On Server");
                return;
            }
            if (JViewerApp.getInstance().getM_frame().getMenu().getMenuEnable("Immediate Shutdown") == false) return;
            JViewerApp.getInstance().onSendPowerControlCommand("Immediate Shutdown");
            return;
        }
        if (!mouseEvent.getSource().equals(this.getHostDisplayBtn())) {
            if (!mouseEvent.getSource().equals(this.getZoomBtn())) return;
            this.m_zoomPopupMenu.show(mouseEvent.getComponent(), 0, mouseEvent.getComponent().getHeight());
            return;
        }
        if (JViewerApp.getInstance().getM_frame().getMenu().getMenuItem("VideoHostDisplayUnlock").isEnabled()) {
            JViewerApp.getInstance().onSendHostLock((byte)0);
            return;
        }
        if (!JViewerApp.getInstance().getM_frame().getMenu().getMenuItem("VideoHostDisplayLock").isEnabled()) return;
        JViewerApp.getInstance().onSendHostLock((byte)1);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.getSlider_zoom()) {
            boolean bl = JViewerApp.getInstance().getJVMenu().getMenuSelected("MouseShowCursor");
            if (this.getSlider_zoom().getValue() == 100 && bl) {
                Mousecaliberation.resetCursor();
            }
        } else if (mouseEvent.getSource() == this.getFullScreenBtn()) {
            if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoFullScreen").isEnabled()) {
                if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoFullScreen").isSelected()) {
                    JViewerApp.getInstance().OnVideoFullScreen(false);
                    JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoFullScreen", false);
                } else {
                    JViewerApp.getInstance().OnVideoFullScreen(true);
                    JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoFullScreen", true);
                }
            } else {
                this.getFullScreenBtn().setToolTipText(LocaleStrings.getString("Q_16_JVT"));
            }
        } else if (mouseEvent.getSource() == this.getCDBtn()) {
            this.invokeVMDialog(0);
        } else if (mouseEvent.getSource() == this.getHardddiskBtn()) {
            this.invokeVMDialog(1);
        } else if (mouseEvent.getSource() == this.getVideoRecordBtn()) {
            if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordStart").isEnabled()) {
                if (JViewerApp.getInstance().getM_videorecord() == null) {
                    JViewerApp.getInstance().setM_videorecord(new VideoRecord());
                    JViewerApp.getInstance().getM_videorecord().StoreLocation = JViewerApp.getInstance().VIDEO_RECORD_DEFAULT_PATH;
                    VideoRecord.RecordStopTimer = JViewerApp.getInstance().VIDEO_RECORD_DEFAULT_TIME;
                }
                JViewerApp.getInstance().getM_videorecord().OnVideoRecordStart();
            } else if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordStop").isEnabled()) {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoRecordStop", false);
                JViewerApp.getInstance().getM_videorecord().OnVideoRecordStop();
            }
            if (!VideoRecord.Recording_Started || !VideoRecord.Record_Processing) {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoRecordSettings", false);
            }
        }
    }

    public void changeMacrowsStatusOnPauseResume(boolean bl) {
        this.setButtonEnabled(this.mouseBtn, bl);
        this.setButtonEnabled(this.getKbdBtn(), bl);
        this.setButtonEnabled(this.getCDBtn(), bl);
        this.setButtonEnabled(this.getHardddiskBtn(), bl);
        this.setButtonEnabled(this.getM_hotKeyBtn(), bl);
        this.setButtonEnabled(this.getVideoRecordBtn(), bl);
        this.setButtonEnabled(this.getPowerBtn(), bl);
        if (KVMSharing.KVM_REQ_GIVEN == 2) {
            this.OnChangeToolbarIconState_KVMPartial();
        }
        if (JViewerApp.getInstance().getZoomOption() == "ActualSize") {
            this.enableZoomSlider(bl);
        }
    }

    public void OnChangeToolbarIconState_KVMPartial() {
        boolean bl = false;
        JVMenu jVMenu = JViewerApp.getInstance().getM_wndFrame().getMenu();
        this.setButtonEnabled(this.getKbdBtn(), jVMenu.getMenuItem("SKBD_English(United States)").isEnabled());
        this.setButtonEnabled(this.mouseBtn, jVMenu.getMenuItem("MouseShowCursor").isEnabled());
        this.setButtonEnabled(this.getM_hotKeyBtn(), jVMenu.getMenuItem("KeyboardCtrlAltDel").isEnabled());
        this.setButtonEnabled(this.getCDBtn(), jVMenu.getMenuItem("DeviceMediaDialog").isEnabled());
        this.setButtonEnabled(this.getHardddiskBtn(), jVMenu.getMenuItem("DeviceMediaDialog").isEnabled());
        if (KVMSharing.KVM_REQ_GIVEN != 2) {
            bl = jVMenu.getMenuItem("Immediate Shutdown").isEnabled() || jVMenu.getMenuItem("Power On Server").isEnabled();
        }
        this.setButtonEnabled(this.getPowerBtn(), bl);
    }

    public void changeToolbarButtonStateOnPowerStatus(boolean bl) {
        JVMenu jVMenu = JViewerApp.getInstance().getM_wndFrame().getMenu();
        this.setButtonEnabled(this.getPlayPauseBtn(), true);
        this.setButtonEnabled(this.getFullScreenBtn(), bl);
        this.setButtonEnabled(this.getKbdBtn(), jVMenu.getMenuItem("SKBD_English(United States)").isEnabled());
        this.setButtonEnabled(this.getCDBtn(), jVMenu.getMenuItem("DeviceMediaDialog").isEnabled());
        this.setButtonEnabled(this.getHardddiskBtn(), jVMenu.getMenuItem("DeviceMediaDialog").isEnabled());
        this.setButtonEnabled(this.mouseBtn, jVMenu.getMenuItem("MouseShowCursor").isEnabled());
        this.setButtonEnabled(this.getM_hotKeyBtn(), jVMenu.getMenuItem("KeyboardCtrlAltDel").isEnabled());
        if (JViewerApp.getInstance().getZoomOption() == "ActualSize") {
            this.enableZoomSlider(bl);
        }
    }

    public void setButtonEnabled(JButton jButton, boolean bl) {
        MouseListener[] mouseListenerArray = jButton.getMouseListeners();
        if (!jButton.equals(this.getPowerBtn())) {
            jButton.setEnabled(bl);
        }
        if (jButton.equals(this.getPlayPauseBtn())) {
            return;
        }
        if (bl) {
            for (MouseListener mouseListener : mouseListenerArray) {
                if (!mouseListener.equals(this)) continue;
                return;
            }
            jButton.addMouseListener(this);
        } else {
            for (MouseListener mouseListener : mouseListenerArray) {
                if (!mouseListener.equals(this)) continue;
                jButton.removeMouseListener(this);
            }
        }
    }

    public void turnOnPowerButton(boolean bl) {
        if (bl) {
            URL uRL = JViewer.class.getResource("res/poweron.png");
            this.getPowerBtn().setIcon(new ImageIcon(uRL));
            this.getPowerBtn().setToolTipText(LocaleStrings.getString("Q_17_JVT"));
        } else {
            URL uRL = JViewer.class.getResource("res/poweroff.png");
            this.getPowerBtn().setIcon(new ImageIcon(uRL));
            this.getPowerBtn().setToolTipText(LocaleStrings.getString("Q_18_JVT"));
        }
    }

    public void turnOnHostDisplayButton(boolean bl) {
        if (bl) {
            URL uRL = JViewer.class.getResource("res/monitorOn.png");
            this.getHostDisplayBtn().setIcon(new ImageIcon(uRL));
            this.getHostDisplayBtn().setToolTipText(LocaleStrings.getString("Q_22_JVT"));
        } else {
            URL uRL = JViewer.class.getResource("res/monitorOff.png");
            this.getHostDisplayBtn().setIcon(new ImageIcon(uRL));
            this.getHostDisplayBtn().setToolTipText(LocaleStrings.getString("Q_23_JVT"));
        }
    }

    public JToolBar getToolBar() {
        return this.m_toolbar;
    }

    public JButton getHardddiskBtn() {
        return this.hardddiskBtn;
    }

    public void setHardddiskBtn(JButton jButton) {
        this.hardddiskBtn = jButton;
    }

    public JPopupMenu getM_popupMenu() {
        return this.m_popupMenu;
    }

    public void changeMacrowsStatus(boolean bl) {
        this.mouseBtn.setEnabled(bl);
        this.getCDBtn().setEnabled(bl);
        this.getHardddiskBtn().setEnabled(bl);
        this.getKbdBtn().setEnabled(bl);
        this.getPlayPauseBtn().setEnabled(bl);
        this.getFullScreenBtn().setEnabled(bl);
        this.altCtrlDelBtn.setEnabled(bl);
        this.getVideoRecordBtn().setEnabled(bl);
        this.getM_hotKeyBtn().setEnabled(bl);
        this.getPowerBtn().setEnabled(bl);
        this.getHostDisplayBtn().setEnabled(bl);
        if (this.getSlider_zoom() != null) {
            this.getSlider_zoom().setValue(100);
        }
    }

    public void addHotkeyPoupMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(JViewerApp.getInstance().getJVMenu().m_menuListener);
        jMenuItem.setActionCommand("HK_" + string);
        this.m_popupMenu.add((Component)jMenuItem, 2);
    }

    public void removeHotkeyPoupMenuItem() {
        this.m_popupMenu.removeAll();
        this.m_popupMenu.add(this.altCtrlDelBtn);
    }

    public void changeToolBarItemLanguage() {
        Set<Map.Entry<JButton, String>> set = m_menutoolbar_text.entrySet();
        Iterator<Map.Entry<JButton, String>> iterator = set.iterator();
        String string = null;
        while (iterator.hasNext()) {
            try {
                Map.Entry<JButton, String> entry = iterator.next();
                string = entry.getValue();
                JButton jButton = entry.getKey();
                jButton.setToolTipText(LocaleStrings.getString(string.toString()));
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    public void enableZoomSlider(boolean bl) {
        boolean bl2 = true;
        if (bl && JViewerApp.getInstance().getRCView().GetUSBMouseMode() != USBMouseRep.OTHER_MOUSE_MODE) {
            if (this.getSlider_zoom().getMouseListeners().equals(null)) {
                this.getSlider_zoom().addMouseListener(this);
            }
            this.setZoomLabel(this.getSlider_zoom().getValue());
            this.zoomBtn.setToolTipText(LocaleStrings.getString("Q_25_JVT"));
            bl2 = true;
        } else if (!bl) {
            this.resetZoom();
            this.getSlider_zoom().removeMouseListener(this);
            this.getSlider_zoom().setToolTipText(LocaleStrings.getString("Q_19_JVT"));
            this.zoomBtn.setToolTipText(LocaleStrings.getString("Q_19_JVT"));
            JViewerApp.getInstance().getM_wndFrame().getMenu().setZoomLabelText(LocaleStrings.getString("Q_20_JVT"));
            bl2 = false;
        }
        this.setButtonEnabled(this.zoomBtn, bl2);
        this.getSlider_zoom().setEnabled(bl2);
        JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("Zoom In", bl2);
        JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("Zoom Out", bl2);
    }

    public void resetZoom() {
        this.getSlider_zoom().setValue(100);
        JViewerApp.getInstance().getRCView().revalidate();
        JViewerApp.getInstance().getRCView().repaint();
        JVMenu.m_scale = 1.0;
        JViewerApp.getInstance().getRCView().setScaleFactor(JVMenu.m_scale, JVMenu.m_scale);
    }

    public void changeShowCursorOnZoom() {
        if (JVMenu.m_scale != 1.0) {
            URL uRL = JViewer.class.getResource("res/Mouse2Btn-gray.png");
            JViewerApp.getInstance().getM_wndFrame().getToolbar().mouseBtn.setIcon(new ImageIcon(uRL));
            JViewerApp.getInstance().getM_wndFrame().getToolbar().mouseBtn.setToolTipText(LocaleStrings.getString("D_48_JVAPP"));
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("MouseShowCursor", false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("MouseShowCursor", false);
            JViewerApp.getInstance();
            JViewerApp.showCursor = false;
        } else if (JVMenu.m_scale == 1.0) {
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("MouseShowCursor", true);
            JViewerApp.getInstance().getM_wndFrame().getToolbar().mouseBtn.setToolTipText(LocaleStrings.getString("D_15_JVAPP"));
        }
    }

    public void removeVMediaButtons() {
        this.m_toolbar.remove(this.getCDBtn());
        this.m_toolbar.remove(this.getHardddiskBtn());
    }

    public void removeHostDisplayStatusButtons() {
        this.m_toolbar.remove(this.getHostDisplayBtn());
    }

    private void invokeVMDialog(int n) {
        Debug.out.println("MEDIA LICENSE STATUS : " + JViewer.getMediaLicenseStatus());
        if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("DeviceMediaDialog").isEnabled()) {
            if (JViewer.getMediaLicenseStatus() == 1) {
                JViewerApp.getInstance().OnvMedia(n);
            } else {
                InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("F_136_JVM"), LocaleStrings.getString("2_4_KVMCLIENT"), 1);
            }
        }
    }

    public JButton getCDBtn() {
        return this.cdBtn;
    }

    public void setCDBtn(JButton jButton) {
        this.cdBtn = jButton;
    }

    public JButton getKbdBtn() {
        return this.kbdBtn;
    }

    public void setKbdBtn(JButton jButton) {
        this.kbdBtn = jButton;
    }

    public JButton getPlayPauseBtn() {
        return this.playPauseBtn;
    }

    public void setPlayPauseBtn(JButton jButton) {
        this.playPauseBtn = jButton;
    }

    public JButton getFullScreenBtn() {
        return this.fullScreenBtn;
    }

    public void setFullScreenBtn(JButton jButton) {
        this.fullScreenBtn = jButton;
    }

    public JButton getVideoRecordBtn() {
        return this.videoRecordBtn;
    }

    public void setVideoRecordBtn(JButton jButton) {
        this.videoRecordBtn = jButton;
    }

    public JButton getPowerBtn() {
        return this.powerBtn;
    }

    public void setPowerBtn(JButton jButton) {
        this.powerBtn = jButton;
    }

    public JButton getHostDisplayBtn() {
        return this.hostDisplayBtn;
    }

    public void setHostDisplayBtn(JButton jButton) {
        this.hostDisplayBtn = jButton;
    }

    public JSlider getSlider_zoom() {
        return this.slider_zoom;
    }

    public void setSlider_zoom(JSlider jSlider) {
        this.slider_zoom = jSlider;
    }

    public JButton getM_hotKeyBtn() {
        return this.m_hotKeyBtn;
    }

    public void setM_hotKeyBtn(JButton jButton) {
        this.m_hotKeyBtn = jButton;
    }

    public void updatePlayPauseButton(boolean bl) {
        if (bl) {
            URL uRL = JViewer.class.getResource("res/play.png");
            this.getPlayPauseBtn().setIcon(new ImageIcon(uRL));
            this.getPlayPauseBtn().setToolTipText(LocaleStrings.getString("Q_9_JVT"));
        } else {
            URL uRL = JViewer.class.getResource("res/pause.png");
            this.getPlayPauseBtn().setIcon(new ImageIcon(uRL));
            this.getPlayPauseBtn().setToolTipText(LocaleStrings.getString("Q_8_JVT"));
        }
        this.getPlayPauseBtn().setEnabled(true);
    }

    public JButton getZoomBtn() {
        return this.zoomBtn;
    }

    public void setZoomBtn(JButton jButton) {
        this.zoomBtn = jButton;
    }

    public JPopupMenu getM_zoomPopupMenu() {
        return this.m_zoomPopupMenu;
    }

    public void setM_zoomPopupMenu(JPopupMenu jPopupMenu) {
        this.m_zoomPopupMenu = jPopupMenu;
    }

    private class MyChangeAction
    implements ChangeListener {
        private MyChangeAction() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!JViewerApp.getInstance().getKVMClient().redirection()) {
                return;
            }
            int n = JVToolBar.this.getSlider_zoom().getValue();
            JVToolBar.this.setZoomLabel(n);
            BigDecimal bigDecimal = BigDecimal.valueOf(n, 1);
            JVMenu.m_scale = bigDecimal.doubleValue() / 10.0;
            JViewerApp.getInstance().getRCView().setScaleFactor(JVMenu.m_scale, JVMenu.m_scale);
            if (n >= 50 && n <= 150) {
                JViewerApp.getInstance().getJVMenu().SetMenuEnable("Zoom In", true);
                JViewerApp.getInstance().getJVMenu().getMenuItem("Zoom In").setEnabled(true);
                JViewerApp.getInstance().getJVMenu().SetMenuEnable("Zoom Out", true);
                JViewerApp.getInstance().getJVMenu().getMenuItem("Zoom Out").setEnabled(true);
            }
            if (n >= 150) {
                JViewerApp.getInstance().getJVMenu().SetMenuEnable("Zoom In", false);
                JViewerApp.getInstance().getJVMenu().getMenuItem("Zoom In").setEnabled(false);
            }
            if (n <= 50) {
                JViewerApp.getInstance().getJVMenu().SetMenuEnable("Zoom Out", false);
                JViewerApp.getInstance().getJVMenu().getMenuItem("Zoom Out").setEnabled(false);
            }
            if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                JVToolBar.this.changeShowCursorOnZoom();
            }
            if (JVMenu.m_scale != 1.0) {
                JViewerApp.getInstance().getJVMenu().getMenuItem("ZoomOption None").setSelected(true);
                JViewerApp.getInstance().setZoomOption("ZoomOption None");
            } else {
                JViewerApp.getInstance().getJVMenu().getMenuItem("ActualSize").setSelected(true);
                JViewerApp.getInstance().setZoomOption("ActualSize");
            }
            JViewerApp.getInstance().getRCView().revalidate();
            JViewerApp.getInstance().getRCView().repaint();
        }
    }
}

