/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.HarddiskRedir;
import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.ClientConfig;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.common.ISOCApp;
import com.ami.kvm.jviewer.common.ISOCCreateBuffer;
import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.common.ISOCKvmClient;
import com.ami.kvm.jviewer.common.ISOCManager;
import com.ami.kvm.jviewer.common.oem.IOEMManager;
import com.ami.kvm.jviewer.communication.Connection;
import com.ami.kvm.jviewer.gui.AddMacro;
import com.ami.kvm.jviewer.gui.AutoBWDlg;
import com.ami.kvm.jviewer.gui.AutoKeyboardLayout;
import com.ami.kvm.jviewer.gui.CaptureScreen;
import com.ami.kvm.jviewer.gui.FSFrame;
import com.ami.kvm.jviewer.gui.FrameRateTask;
import com.ami.kvm.jviewer.gui.IPMICommandDialog;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.KVMRequestDialogThread;
import com.ami.kvm.jviewer.gui.KVMResponseDialogThread;
import com.ami.kvm.jviewer.gui.KVMShareDialog;
import com.ami.kvm.jviewer.gui.KVMSharing;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.OEMResourceURLProcessor;
import com.ami.kvm.jviewer.gui.SinglePortKVM;
import com.ami.kvm.jviewer.gui.SoftKeyboard;
import com.ami.kvm.jviewer.gui.StandAloneConnectionDialog;
import com.ami.kvm.jviewer.gui.UserDefMacro;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.gui.WindowFrame;
import com.ami.kvm.jviewer.hid.KeyProcessor;
import com.ami.kvm.jviewer.hid.USBKeyProcessorEnglish;
import com.ami.kvm.jviewer.hid.USBKeyboardRep;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.jvvideo.JVVideo;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KeepAlive;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import com.ami.kvm.jviewer.videorecord.URLProcessor;
import com.ami.kvm.jviewer.videorecord.VideoRecordApp;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.VMDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JViewerApp {
    private static JViewerApp m_rcApp = new JViewerApp();
    private JVFrame m_frame;
    private KVMClient m_KVMClnt;
    private ISOCKvmClient sockvmclient;
    private static IOEMManager oemManager;
    private VideoRecordApp videorecordapp;
    private JViewerView m_view;
    private String m_encToken;
    private boolean m_wndMode;
    private WindowFrame m_wndFrame;
    private FSFrame m_fsFrame;
    private byte hostLEDStatus;
    private byte clientLEDStatus;
    private byte initClientLEDStatus;
    private boolean kbdLEDSyncing;
    private String m_session_token;
    private int m_session_token_type;
    private byte[] m_serverIP;
    private int m_serverPort;
    private int m_RedirectionState;
    private boolean m_bUseSSL;
    private int m_cdPort;
    private int m_hdPort;
    private int m_cdNum;
    private int m_hdNum;
    private int freeCDNum;
    private int freeHDNum;
    private int KVMCDNum;
    private int KVMHDNum;
    private int m_cdStatus;
    private int m_hdStatus;
    private int selectedVMTab;
    private boolean m_bVMUseSSL;
    private USBKeyboardRep m_USBKeyRep;
    private KeepAlive m_liveListener;
    private KeyProcessor keyprocessor;
    private ISOCApp soc_App;
    private ISOCFrameHdr socframeHdr;
    private static ISOCManager soc_manager;
    private JLabel label;
    private JDialog dialog;
    private VideoRecord m_videorecord;
    private Mousecaliberation Mousecaliberation;
    private String Message;
    private String serverIP;
    private SoftKeyboard softKeyboard;
    private AutoBWDlg m_autoBWDlg;
    public static byte WEB_PREVIEWER_CAPTURE_SUCCESS;
    public static byte WEB_PREVIEWER_CAPTURE_FAILURE;
    public static byte WEB_PREVIEWER_CAPTURE_IN_PROGRESS;
    public static byte WEB_PREVIEWER_CONNECT_FAILURE;
    public static byte WEB_PREVIEWER_INVALID_SERVERIP;
    public static byte WEB_PREVIEWER_HOST_POWER_OFF;
    public static byte WEB_PREVIEWER_INVALID_WEBPORT;
    public static byte WEB_PREVIEWER_INVALID_WEBSECURE;
    public static byte m_webPreviewer_cap_status;
    private KVMShareDialog kVMDialog;
    private int m_zoomSliderValue;
    private boolean m_userPause;
    public static final int MAX_IMAGE_PATH_COUNT = 5;
    public static String[][] Imagepath_CD;
    public static String[][] Imagepath_Harddsik;
    public static boolean showCursor;
    public static int REDIR_STOPPED;
    public static int REDIR_STARTING;
    public static int REDIR_STARTED;
    public static int REDIR_STOPPING;
    public static int REDIR_PAUSING;
    public static final int NUMLOCK = 1;
    public static final int CAPSLOCK = 2;
    public static final int SCROLLLOCK = 4;
    public boolean m_refresh;
    private VMDialog vmDialog;
    public JDialog mediaDlg;
    public JVVideo vidClnt;
    public ISOCCreateBuffer prepare_buf;
    public static final byte OEM_FIT_TO_HOST_SCREEN = 1;
    public static final byte OEM_REDIR_RD_WR_MODE = 2;
    public static final byte OEM_SHOW_HOST_CURSOR_DEFAULT = 4;
    public static final byte OEM_SET_PHYSICAL_KBD_LANG = 8;
    public static final byte OEM_MD5_DIGEST_WEB_AUTH = 16;
    public static final byte KVM_RECONNECT_SUPPORT = 32;
    public static final byte OEM_JAVA_CD_IMAGE_REDIR = 64;
    public static final int OEM_KVM_MAX_DEVICE_COUNT = 128;
    public static final int OEM_SKIP_REPOSITIONING_JVIEWER_WINDOW = 256;
    public static final int OEM_SYNC_WITH_CLIENT_LED_STATUS = 512;
    public static final byte SERVER_POWER_ON = 1;
    public static final byte SERVER_POWER_OFF = 0;
    public static final byte HOST_DISPLAY_UNLOCK = 0;
    public static final byte HOST_DISPLAY_LOCK = 1;
    public static final byte HOST_DISPLAY_UNLOCKED_AND_DISABLED = 2;
    public static final byte HOST_DISPLAY_LOCKED_AND_DISABLED = 3;
    public static final int GET_MAC_ADDRESS = 1;
    public static final int COMPARE_MAC_ADDRESS = 2;
    public static final int VM_DISCONNECT = 0;
    public static final int VM_RECONNECT = 1;
    public static final int LEFT_FRAME_BORDER_SIZE = 8;
    private byte powerStatus;
    private StandAloneConnectionDialog connectionDialog;
    private SinglePortKVM singlePortKvm;
    private AutoKeyboardLayout autokeylayout;
    private String currentVersion;
    private UserDefMacro userDefMacro;
    private AddMacro addMacro;
    private IPMICommandDialog ipmiDialog;
    private String zoomOption;
    private boolean fullKeyboardEnabled;
    private boolean fullPermissionRequest;
    private boolean renderFitToHost;
    private Hashtable<String, JDialog> responseDialogTable;
    public int currentSessionId;
    private long lastPcktSent;
    private long lastPcktRecvd;
    private boolean sessionLive;
    private boolean retryConnection;
    public int currentRetryCount;
    private int localport;
    private String resolutionStatus;
    private Dimension initialDimension;
    private Connection connection;
    private FrameRateTask frameRateTask;
    private String bppString;
    public static final int NonSSLService = 0;
    public static final int WebService = 1;
    public static final int KVMService = 2;
    public String VIDEO_RECORD_DEFAULT_PATH;
    public int VIDEO_RECORD_DEFAULT_TIME;
    private int resolutionChanged;
    private int PRIV_LEVEL_NO_ACCESS;
    private int PRIV_LEVEL_PROPRIETARY;
    private int PRIV_LEVEL_ADMIN;
    private int PRIV_LEVEL_OPERATOR;
    private int PRIV_LEVEL_USER;
    private int PRIV_LEVEL_CALLBACK;
    private int PRIV_LEVEL_RESERVED;
    private InfoDialog hidInitDialog;
    private Object retryCountSync;
    private static final byte SESSION_TYPE_VKVM = 5;

    public Object getRetryCountSync() {
        return this.retryCountSync;
    }

    public Object createObject(String string) {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var2_2 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Debug.out.println(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Debug.out.println(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.out.println(classNotFoundException);
        }
        return var2_2;
    }

    public static JViewerApp getInstance() {
        return m_rcApp;
    }

    private JViewerApp() {
        block3: {
            this.m_wndMode = true;
            this.hostLEDStatus = 0;
            this.clientLEDStatus = 0;
            this.initClientLEDStatus = 0;
            this.kbdLEDSyncing = false;
            this.m_session_token_type = 0;
            this.m_RedirectionState = REDIR_STOPPED;
            this.m_bUseSSL = false;
            this.m_cdNum = 1;
            this.m_hdNum = 1;
            this.freeCDNum = 0;
            this.freeHDNum = 0;
            this.KVMCDNum = 0;
            this.KVMHDNum = 0;
            this.selectedVMTab = 0;
            this.m_bVMUseSSL = false;
            this.m_liveListener = null;
            this.keyprocessor = null;
            this.kVMDialog = null;
            this.m_userPause = false;
            this.m_refresh = false;
            this.vmDialog = null;
            this.mediaDlg = null;
            this.autokeylayout = null;
            this.currentVersion = "2.199.0";
            this.userDefMacro = null;
            this.addMacro = null;
            this.ipmiDialog = null;
            this.fullKeyboardEnabled = false;
            this.fullPermissionRequest = false;
            this.renderFitToHost = true;
            this.responseDialogTable = null;
            this.currentSessionId = -1;
            this.sessionLive = false;
            this.retryConnection = false;
            this.currentRetryCount = 0;
            this.resolutionStatus = null;
            this.initialDimension = new Dimension(-1, -1);
            this.frameRateTask = null;
            this.bppString = null;
            this.VIDEO_RECORD_DEFAULT_PATH = System.getProperty("user.home");
            this.VIDEO_RECORD_DEFAULT_TIME = 20;
            this.resolutionChanged = -1;
            this.PRIV_LEVEL_NO_ACCESS = 15;
            this.PRIV_LEVEL_PROPRIETARY = 5;
            this.PRIV_LEVEL_ADMIN = 4;
            this.PRIV_LEVEL_OPERATOR = 3;
            this.PRIV_LEVEL_USER = 2;
            this.PRIV_LEVEL_CALLBACK = 1;
            this.PRIV_LEVEL_RESERVED = 0;
            this.hidInitDialog = null;
            this.retryCountSync = new Object();
            try {
                soc_manager = (ISOCManager)this.createObject("com.ami.kvm.jviewer.soc.SOCManager");
                oemManager = (IOEMManager)this.createObject("com.ami.kvm.jviewer.oem.OEMManager");
                this.prepare_buf = soc_manager.getSOCCreateBuffer();
                this.soc_App = soc_manager.getSOCApp();
                this.socframeHdr = soc_manager.getSOCFramehdr();
                this.connection = new Connection();
            }
            catch (NullPointerException nullPointerException) {
                Debug.out.println(nullPointerException);
                if (!JViewer.isStandAloneApp()) break block3;
                JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.getString("D_1_JVAPP"), LocaleStrings.getString("D_2_JVAPP"), 0);
                JViewer.exit(0);
            }
        }
        this.m_view = new JViewerView(1600, 1200);
        if (!(JViewer.isStandAloneApp() || JViewer.isWebPreviewer() || JViewer.isBSODViewer())) {
            this.constructUI();
        }
    }

    public void constructUI() {
        this.m_wndFrame = new WindowFrame();
        if (!JViewer.isplayerapp() && !JViewer.isdownloadapp()) {
            this.m_fsFrame = new FSFrame();
            this.m_USBKeyRep = this.m_view.getM_USBKeyRep();
            this.m_zoomSliderValue = 100;
            if (!JViewer.isVMediaEnabled()) {
                this.m_wndFrame.getWindowMenu().getMenuBar().remove(this.m_wndFrame.getWindowMenu().getMenu("Media"));
                this.m_fsFrame.getM_menuBar().remove(this.m_fsFrame.getM_menuBar().getFSMenu().getMenu("Media"));
                this.m_wndFrame.getToolbar().removeVMediaButtons();
            }
            if (!JViewer.isPowerPrivEnabled()) {
                this.m_wndFrame.getWindowMenu().getMenuBar().remove(this.m_wndFrame.getWindowMenu().getMenu("Power"));
                this.m_fsFrame.getM_menuBar().remove(this.m_fsFrame.getM_menuBar().getFSMenu().getMenu("Power"));
            }
        }
    }

    public JViewerView getRCView() {
        return this.m_view;
    }

    public KVMClient getKVMClient() {
        return this.m_KVMClnt;
    }

    public JVMenu getJVMenu() {
        if (this.m_wndMode) {
            return ((JVFrame)this.m_wndFrame).getMenu();
        }
        return ((JVFrame)this.m_fsFrame).getMenu();
    }

    public JVFrame getMainWindow() {
        if (this.m_wndMode) {
            return this.m_wndFrame;
        }
        return this.m_fsFrame;
    }

    public String getToken() {
        return this.m_encToken;
    }

    public String getSessionToken() {
        return this.m_session_token;
    }

    public int getSessionTokenType() {
        return this.m_session_token_type;
    }

    public void setStatus(String string) {
        this.m_frame.setStatus(string);
    }

    public void resetStatus() {
        this.m_frame.resetStatus();
    }

    public boolean isFullScreenMode() {
        return !this.m_wndMode;
    }

    public void refreshAppWndLabel() {
        try {
            this.m_frame.refreshTitle();
        }
        catch (Exception exception) {
            Debug.out.println("Not able to refresh the title");
            Debug.out.println(exception);
        }
    }

    public void setAppWndLabel(String string) {
        try {
            this.m_frame.setWndLabel(string);
        }
        catch (Exception exception) {
            Debug.out.println("Not able to set the Window Label");
            Debug.out.println(exception);
        }
    }

    public int GetRedirectionState() {
        return this.m_RedirectionState;
    }

    public void setRedirectionStatus(int n) {
        this.m_RedirectionState = n;
    }

    public byte getPowerStatus() {
        return this.powerStatus;
    }

    public void setPowerStatus(byte by) {
        this.powerStatus = by;
    }

    public void Ondisplayvideo(String string, String string2, String string3, int n) {
        this.m_frame = this.m_wndFrame;
        this.m_wndFrame.attachView();
        this.attachFrame();
        this.OnVideoRecordStartRedirection(string, string2, string3, n);
    }

    public void initilizeJVVideo() {
        this.vidClnt = new JVVideo();
        this.setVidClnt(this.vidClnt);
        this.sockvmclient.SetVidoclnt(this.vidClnt);
    }

    public void OnVideoRecordStartRedirection(String string, String string2, String string3, int n) {
        Debug.out.println("OnVideoRecordStartRedirection");
        this.m_RedirectionState = REDIR_STARTING;
        this.m_KVMClnt = new KVMClient(this.m_serverIP, this.m_serverPort, this.vidClnt, this.m_bUseSSL);
        this.sockvmclient = JViewerApp.getSoc_manager().getSOCKvmClient();
        this.sockvmclient.SetKVMClient(this.m_KVMClnt);
        this.sockvmclient.SOCKVM_reader();
        this.initilizeJVVideo();
        if (JViewer.isdownloadapp()) {
            this.m_videorecord = new VideoRecord();
        }
        this.videorecordapp = new VideoRecordApp();
        JVFrame.setServerIP(this.m_serverIP, this.m_RedirectionState);
        if (-1 == this.videorecordapp.startVideorecordRedirection(string, string2, n, string3)) {
            JViewerApp.getInstance().getM_frame().windowClosed();
        }
    }

    public void onLaunchStandAloneApp(String string, int n, String string2, String string3) {
        this.connectionDialog = new StandAloneConnectionDialog(null, string, n, string2, string3);
    }

    public StandAloneConnectionDialog getConnectionDialog() {
        return this.connectionDialog;
    }

    public void setConnectionDialog(StandAloneConnectionDialog standAloneConnectionDialog) {
        this.connectionDialog = standAloneConnectionDialog;
    }

    public SinglePortKVM getSinglePortKvm() {
        return this.singlePortKvm;
    }

    public void OnConnectToServer(String string, int n, String string2, int n2, boolean bl, boolean bl2, int n3, int n4, byte by, byte by2, int n5, int n6, String string3, int n7) {
        this.m_serverIP = JViewer.getServerIP(string);
        this.m_serverPort = n;
        this.m_encToken = string2;
        this.m_session_token = string2;
        this.m_session_token_type = n2;
        this.m_frame = this.m_wndFrame;
        this.m_wndMode = true;
        this.m_bUseSSL = bl;
        if (JViewer.isSinglePortEnabled()) {
            this.singlePortKvm = new SinglePortKVM(string, n, n7, this.m_bUseSSL);
            this.singlePortKvm.startConnect();
        } else {
            this.m_cdPort = n3;
            this.m_hdPort = n4;
        }
        this.m_cdStatus = n5;
        this.m_hdStatus = n6;
        this.m_bVMUseSSL = bl2;
        if ((JViewer.getOEMFeatureStatus() & 0x80L) == 128L) {
            this.setFreeCDNum(JViewer.getKVM_Num_CD());
            this.setFreeHDNum(JViewer.getKVM_Num_HD());
        } else {
            this.setFreeCDNum(by);
            this.setFreeHDNum(by2);
        }
        this.m_wndFrame.attachView();
        this.attachFrame();
        JVMenu jVMenu = this.m_frame.getMenu();
        jVMenu.notifyMenuStateEnable("VideoPauseRedirection", false);
        jVMenu.notifyMenuStateEnable("VideoResumeRedirection", true);
        jVMenu.notifyMenuStateSelected("VideoFullScreen", false);
        jVMenu.notifyMenuStateEnable("Add Hotkeys", false);
        this.OnVideoStartRedirection();
        if ((JViewer.getOEMFeatureStatus() & 1L) == 1L) {
            this.setZoomOption("FitToHostResolution");
        }
    }

    public void OnConnectToServer(String string, int n, int n2, String string2, boolean bl, String string3) {
        this.m_serverIP = JViewer.getServerIP(string);
        this.m_serverPort = n;
        this.m_encToken = string2;
        this.m_session_token = string2;
        this.m_bUseSSL = bl;
        if (JViewer.isSinglePortEnabled()) {
            this.singlePortKvm = new SinglePortKVM(string, this.m_serverPort, n2, bl);
            this.singlePortKvm.startConnect();
        }
        this.OnVideoStartRedirection();
    }

    public void OnConnectToServer(byte[] byArray) {
        this.m_serverIP = byArray;
        this.OnVideoStartRedirection();
    }

    private void attachFrame() {
        if (JViewer.isStandalone()) {
            if (!this.isM_wndMode()) {
                JViewer.getMainFrame().dispose();
                if (!JViewer.getMainFrame().isDisplayable()) {
                    JViewer.getMainFrame().setUndecorated(true);
                }
                this.getMainWindow().m_viewSP.setHorizontalScrollBarPolicy(31);
                this.getMainWindow().m_viewSP.setVerticalScrollBarPolicy(21);
            } else if (!JViewer.getMainFrame().isDisplayable()) {
                JViewer.getMainFrame().setUndecorated(false);
            }
            JViewer.getMainFrame().setExtendedState(6);
            JViewer.getMainFrame().setContentPane(this.m_frame);
            Dimension dimension = this.getCurrentMonitorResolution();
            JViewer.getMainFrame().setSize(dimension.width, dimension.height);
            JViewer.getMainFrame().setVisible(true);
            JViewerApp.getInstance().getRCView().requestFocus();
        } else {
            JViewer.getMainPane().add(this.m_frame);
        }
    }

    private void detachFrame() {
        if (JViewer.isStandalone()) {
            JViewer.getMainFrame().getContentPane().remove(this.m_frame);
            JViewer.getMainFrame().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OnVideoStartRedirection() {
        Object object;
        Debug.out.println("OnVideoStartRedirection");
        this.m_RedirectionState = REDIR_STARTING;
        if (this.currentRetryCount <= 0) {
            this.vidClnt = new JVVideo();
            this.setVidClnt(this.vidClnt);
        }
        this.m_KVMClnt = new KVMClient(this.m_serverIP, this.m_serverPort, this.vidClnt, this.m_bUseSSL);
        this.sockvmclient = JViewerApp.getSoc_manager().getSOCKvmClient();
        if (this.currentRetryCount <= 0) {
            this.sockvmclient.SetVidoclnt(this.vidClnt);
        }
        this.sockvmclient.SetKVMClient(this.m_KVMClnt);
        this.sockvmclient.SOCKVM_reader();
        if (!(JViewer.isWebPreviewer() || JViewer.isBSODViewer() || this.m_KVMClnt.redirection())) {
            JViewerApp.getInstance().getM_wndFrame().getToolbar().changeMacrowsStatus(false);
            JViewerApp.getInstance().getM_wndFrame().getM_status().enableStatusBar(false);
        }
        if (!JViewer.isBSODViewer()) {
            if (JViewer.isKVMReconnectEnabled() && (JViewer.isjviewerapp() || JViewer.isStandAloneApp())) {
                while (this.currentRetryCount <= JViewer.getRetryCount() && -1 == this.m_KVMClnt.startRedirection()) {
                    if (InfoDialog.getUndecDialog() == null) {
                        InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("D_64_JVAPP"), 4, JViewer.getRetryInterval());
                    }
                    if (this.currentRetryCount < JViewer.getRetryCount()) {
                        object = this.retryCountSync;
                        synchronized (object) {
                            try {
                                this.retryCountSync.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                Debug.out.println(interruptedException);
                            }
                        }
                    }
                    ++this.currentRetryCount;
                }
                if (this.currentRetryCount > JViewer.getRetryCount()) {
                    Debug.out.println("Maximum number of retry to reconnect is reached");
                    this.m_RedirectionState = REDIR_STOPPED;
                    if (!JViewer.isWebPreviewer() && !JViewer.isBSODViewer()) {
                        JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.getString("D_66_JVAPP"), LocaleStrings.getString("D_4_JVAPP"), 0);
                        JViewerApp.getInstance().getM_frame().windowClosed();
                    } else {
                        JViewerApp.getInstance().setWebPreviewerCaptureStatus(WEB_PREVIEWER_CONNECT_FAILURE);
                    }
                }
            } else if (-1 == this.m_KVMClnt.startRedirection()) {
                this.m_RedirectionState = REDIR_STOPPED;
                if (!JViewer.isWebPreviewer() && !JViewer.isBSODViewer()) {
                    JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.getString("D_3_JVAPP"), LocaleStrings.getString("D_4_JVAPP"), 0);
                    JViewerApp.getInstance().getM_frame().windowClosed();
                } else {
                    JViewerApp.getInstance().setWebPreviewerCaptureStatus(WEB_PREVIEWER_CONNECT_FAILURE);
                }
            }
        }
        if (!JViewer.isWebPreviewer() && !JViewer.isBSODViewer()) {
            JVFrame.setServerIP(this.m_serverIP, this.m_RedirectionState);
            if (JViewer.getKeyboardLayout().equalsIgnoreCase("AD")) {
                this.onAutoKeyboardLayout(true, false);
            }
            this.m_view.addKeyListener();
            object = this.m_frame.getMenu();
            ((JVMenu)object).notifyMenuStateEnable("VideoPauseRedirection", true);
            ((JVMenu)object).notifyMenuStateEnable("VideoResumeRedirection", false);
            this.m_RedirectionState = REDIR_STARTED;
            if (!this.m_KVMClnt.redirection()) {
                String[] stringArray = new String[]{"VideoExit", "HelpAboutJViewer", "VideoFullScreen"};
                String[] stringArray2 = this.getExceptionMenuList(stringArray);
                this.m_frame.getMenu().enableMenu(stringArray2, true, true);
                JViewerApp.getInstance().getM_wndFrame().getToolbar().changeMacrowsStatus(false);
                JViewerApp.getInstance().getM_wndFrame().getM_status().enableStatusBar(false);
            }
            this.m_frame.getMenu().SetMenuSelected("Locale" + JViewer.getLanguage(), true);
            if (this.m_userPause) {
                this.OnVideoPauseRedirection();
            }
        }
    }

    public void OnVideoStopRedirection() {
        Debug.out.println("OnVideoStopRedirection");
        if (this.m_RedirectionState == REDIR_STOPPED) {
            return;
        }
        this.m_RedirectionState = REDIR_STOPPING;
        this.m_KVMClnt.Stop_Cmd_Redirection();
        if (JViewer.isjviewerapp() || JViewer.isStandAloneApp()) {
            if (this.getSoftKeyboard() != null) {
                this.getSoftKeyboard().closeSoftKeyboard();
            }
            JVFrame.setServerIP(null, this.m_RedirectionState);
            this.OnUSBMouseSyncCursor(false);
            this.m_frame.getMenu().notifyMenuStateEnable("VideoPauseRedirection", false);
            this.m_frame.getMenu().notifyMenuStateEnable("VideoResumeRedirection", true);
            if (this.isFullScreenMode()) {
                this.OnVideoFullScreen(false);
            }
        }
        if (!JViewer.isdownloadapp() && !JViewer.isplayerapp()) {
            if (JViewer.isSinglePortEnabled() && JViewer.isStandAloneApp()) {
                this.getConnectionDialog().logoutWebSession();
            }
            this.m_KVMClnt.stopRedirection();
            this.m_view.removeKMListener();
            this.m_RedirectionState = REDIR_STOPPED;
        }
    }

    public boolean isM_userPause() {
        return this.m_userPause;
    }

    public void setM_userPause(boolean bl) {
        this.m_userPause = bl;
    }

    private void changeMenuItemsStatusOnPauseResume(JVMenu jVMenu, boolean bl) {
        Set<String> set = JVMenu.m_menuItems_setenabled.keySet();
        for (String string : set) {
            if (JViewerApp.getOEMManager().getOEMJVMenu().oemchangeMenuItemsStatusOnPauseResume(string) == 1) continue;
            if ("VideoResumeRedirection" == string) {
                jVMenu.notifyMenuStateEnable(string, !bl);
                continue;
            }
            if ("VideoCaptureScreen" == string || "VideoFullScreen" == string || "VideoExit" == string || "HelpAboutJViewer" == string || string.startsWith("Locale")) continue;
            if ("VideoRecordStart" == string || "VideoRecordSettings" == string || "VideoRecordStop" == string) {
                if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordStop").isEnabled() && this.isM_userPause()) {
                    JViewerApp.getInstance().getM_videorecord().OnVideoRecordStop();
                    InfoDialog.showDialog((Component)this.m_frame, LocaleStrings.getString("D_5_JVAPP"), LocaleStrings.getString("D_6_JVAPP"), 2);
                    jVMenu.notifyMenuStateEnable("VideoRecordStop", false);
                    continue;
                }
                if (VideoRecord.Recording_Started || VideoRecord.Record_Processing) continue;
                if ("VideoRecordSettings" == string && JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordStart").isEnabled()) {
                    jVMenu.notifyMenuStateEnable(string, bl);
                    continue;
                }
                if ("VideoRecordSettings" == string) {
                    jVMenu.notifyMenuStateEnable(string, bl);
                    continue;
                }
                if ("VideoRecordStart" != string) continue;
                jVMenu.notifyMenuStateEnable(string, bl);
                continue;
            }
            if ("Calibrate Mouse Threshold" == string) {
                if (JViewerApp.getInstance().getM_view().m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                    jVMenu.notifyMenuStateEnable(string, bl);
                    continue;
                }
                jVMenu.notifyMenuStateEnable(string, false);
                continue;
            }
            if ("VideoHostDisplayUnlock" == string || "VideoHostDisplayLock" == string) {
                if (bl) {
                    this.changeHostDisplayLockStatus(this.getKVMClient().getHostLockStatus());
                    continue;
                }
                jVMenu.getMenuItem(string).setEnabled(bl);
                continue;
            }
            if ("Power On Server" == string && this.powerStatus == 1) {
                if (!bl) continue;
                continue;
            }
            if (bl) {
                try {
                    if (jVMenu.getMenuItem(string) == null || jVMenu.getMenuEnable(string) == null) continue;
                    jVMenu.getMenuItem(string).setEnabled(jVMenu.getMenuEnable(string));
                }
                catch (Exception exception) {
                    Debug.out.println(exception);
                }
                continue;
            }
            try {
                if (jVMenu.getMenuItem(string) == null) continue;
                jVMenu.getMenuItem(string).setEnabled(bl);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
        if (bl) {
            if (KVMSharing.KVM_REQ_GIVEN == 2) {
                this.OnChangeMenuState_KVMPartial(jVMenu, !bl);
            }
            this.getVidClnt().setZoomOptionStatus();
        }
    }

    public void OnVideoPauseRedirection() {
        if (this.m_RedirectionState != REDIR_STARTED) {
            return;
        }
        Debug.out.println("OnVideoPauseRedirection");
        this.m_RedirectionState = REDIR_PAUSING;
        this.m_KVMClnt.pauseRedirection();
        if (!JViewer.isWebPreviewer() || !JViewer.isBSODViewer()) {
            JVFrame.setServerIP(null, this.m_RedirectionState);
            JViewerApp.getInstance().refreshAppWndLabel();
            this.changeMenuItemsStatusOnPauseResume(this.m_frame.getMenu(), false);
            JViewerApp.getInstance().getM_wndFrame().getToolbar().updatePlayPauseButton(true);
            JViewerApp.getInstance().getM_wndFrame().getToolbar().changeMacrowsStatusOnPauseResume(false);
            if (JViewerApp.getInstance().getSoftKeyboard() != null) {
                JViewerApp.getInstance().getSoftKeyboard().OnUpdateKeyState(false);
            }
        }
        this.m_RedirectionState = REDIR_STOPPED;
    }

    public void OnVideoResumeRedirection() {
        Debug.out.println("OnVideoResume");
        this.m_RedirectionState = REDIR_STARTING;
        this.m_KVMClnt.resumeRedirection();
        if (!JViewer.isWebPreviewer() || !JViewer.isBSODViewer()) {
            JVFrame.setServerIP(this.m_serverIP, this.m_RedirectionState);
            JViewerApp.getInstance().refreshAppWndLabel();
            this.setM_userPause(false);
            this.changeMenuItemsStatusOnPauseResume(this.m_frame.getMenu(), true);
            if (this.m_view.GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                this.m_view.m_mouseListener.splitandsend(-this.socframeHdr.getwidth(), -this.socframeHdr.getheight(), true);
            }
            JViewerApp.getInstance().getM_wndFrame().getToolbar().updatePlayPauseButton(false);
            JViewerApp.getInstance().getM_wndFrame().getToolbar().changeMacrowsStatusOnPauseResume(true);
            if (JViewerApp.getInstance().getSoftKeyboard() != null) {
                JViewerApp.getInstance().getSoftKeyboard().OnUpdateKeyState(true);
            }
        }
        this.m_RedirectionState = REDIR_STARTED;
    }

    public void OnVideoRefreshRedirection() {
        Debug.out.println("OnVideoRefresh");
        if (JViewer.isjviewerapp() || JViewer.isStandAloneApp()) {
            if (this.m_RedirectionState == REDIR_STOPPED) {
                if (this.m_KVMClnt.m_isBlank) {
                    this.OnVideoResumeRedirection();
                    this.OnVideoPauseRedirection();
                } else {
                    this.m_refresh = true;
                    this.OnVideoResumeRedirection();
                }
            } else {
                this.OnVideoPauseRedirection();
                this.OnVideoResumeRedirection();
            }
        }
    }

    public void onVideoCaptureScreen() {
        BufferedImage bufferedImage = null;
        bufferedImage = JViewer.isjviewerapp() || JViewer.isStandAloneApp() ? this.copyScreenBuffer(JViewerApp.getInstance().getRCView().getImage()) : this.copyScreenBuffer(JViewerApp.getInstance().getPrepare_buf().getM_image());
        CaptureScreen captureScreen = new CaptureScreen(bufferedImage);
        captureScreen.start();
    }

    public BufferedImage copyScreenBuffer(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = bufferedImage.isAlphaPremultiplied();
        WritableRaster writableRaster = bufferedImage.copyData(null);
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    public void OnVideoFullScreen(boolean bl) {
        Debug.out.println("OnVideoFullScreen");
        if (this.m_wndMode) {
            this.m_wndFrame.detachView();
            this.detachFrame();
            this.m_frame = this.m_fsFrame;
            this.m_wndMode = false;
            this.m_fsFrame.attachView();
            this.attachFrame();
            this.m_fsFrame.showWindow();
            HashMap<String, String> hashMap = null;
            if (this.addMacro != null) {
                hashMap = this.getAddMacro().getMacroMap();
            }
            if (hashMap != null) {
                this.getAddMacro().removeMacroMenu();
                this.getAddMacro().addMacroMenu(hashMap);
            }
            if (KVMSharing.KVM_REQ_GIVEN == 2) {
                this.OnChangeMenuState_KVMPartial(this.m_fsFrame.getMenu(), false);
            }
            this.m_frame.getMenu().notifyMenuStateEnable("FitToClientResolution", false);
            this.m_frame.getMenu().notifyMenuStateEnable("FitToHostResolution", false);
        } else {
            this.m_fsFrame.detachView();
            this.detachFrame();
            this.m_fsFrame.hideWindow();
            this.m_frame = this.m_wndFrame;
            this.m_wndMode = true;
            this.m_wndFrame.attachView();
            this.attachFrame();
            HashMap<String, String> hashMap = null;
            if (this.addMacro != null) {
                hashMap = this.getAddMacro().getMacroMap();
            }
            if (hashMap != null) {
                this.getAddMacro().removeMacroMenu();
                this.getAddMacro().addMacroMenu(hashMap);
            }
            if (KVMSharing.KVM_REQ_GIVEN == 2 && !KVMShareDialog.isMasterSession) {
                this.OnChangeMenuState_KVMPartial(this.m_wndFrame.getMenu(), false);
                this.getM_wndFrame().getToolbar().OnChangeToolbarIconState_KVMPartial();
            }
            if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() == USBMouseRep.OTHER_MOUSE_MODE) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                JViewer.getMainFrame().setMaximizedBounds(graphicsEnvironment.getMaximumWindowBounds());
                JViewer.getMainFrame().setExtendedState(6);
            }
            this.getVidClnt().setZoomOptionStatus();
            this.onChangeZoomOptions("ActualSize");
            this.getJVMenu().notifyMenuStateSelected("ActualSize", true);
        }
        if (this.m_frame.getMenu().getMenuItem("VideoPauseRedirection").isEnabled()) {
            JViewerApp.getInstance().setAppWndLabel("0 fps");
        }
        this.m_frame.getMenu().notifyMenuStateSelected("VideoFullScreen", bl);
        this.m_frame.getMenu().notifyMenuStateEnable("VideoFullScreen", true);
        this.m_frame.getMenu().refreshMenu();
        if (this.userDefMacro != null && this.userDefMacro.isAddMacro()) {
            this.userDefMacro.onCloseDialog();
        }
        if (JViewerApp.getInstance().getJVMenu().getMenuItem("Full Keyborad Support") != null) {
            JViewerApp.getInstance().getJVMenu().getMenuItem("Full Keyborad Support").setSelected(this.isFullKeyboardEnabled());
            JViewerApp.getInstance().getJVMenu().enableMenuAccelerator(this.isFullKeyboardEnabled());
            JViewerApp.getInstance().getJVMenu().enableMenuMnemonics(this.isFullKeyboardEnabled());
        }
        JViewerApp.getInstance().getJVMenu().updateUserMenu();
    }

    public void OnKeyboardHoldRightCtrlKey(boolean bl) {
        Debug.out.println("OnKeyboardHoldRightCtrlKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(17, 3, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardHoldRightCtrlKey", bl);
        if (bl) {
            this.getM_wndFrame().getM_status().getRightCtrl().setForeground(Color.red);
        } else {
            this.getM_wndFrame().getM_status().getRightCtrl().setForeground(Color.gray);
        }
        this.getM_wndFrame().getM_status().getRightCtrl().setSelected(bl);
        if (this.getSoftKeyboard() != null) {
            this.getSoftKeyboard().syncHoldKey();
        }
    }

    public void OnKeyboardHoldRightAltKey(boolean bl) {
        Debug.out.println("OnKeyboardHoldRightAltKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(18, 3, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardHoldRightAltKey", bl);
        if (bl) {
            this.getM_wndFrame().getM_status().getRightAlt().setForeground(Color.red);
        } else {
            this.getM_wndFrame().getM_status().getRightAlt().setForeground(Color.gray);
        }
        this.getM_wndFrame().getM_status().getRightAlt().setSelected(bl);
        if (this.getSoftKeyboard() != null) {
            this.getSoftKeyboard().syncHoldKey();
        }
    }

    public void OnKeyboardHoldLeftShiftKey(boolean bl) {
        Debug.out.println("OnKeyboardHoldLeftShiftKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(16, 2, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnKeyboardHoldRightShiftKey(boolean bl) {
        Debug.out.println("OnKeyboardHoldRightShiftKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(16, 3, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnKeyboardHoldLeftCtrlKey(boolean bl) {
        Debug.out.println("OnKeyboardHoldLeftCtrlKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(17, 2, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardHoldLeftCtrlKey", bl);
        if (bl) {
            this.getM_wndFrame().getM_status().getLeftCtrl().setForeground(Color.red);
        } else {
            this.getM_wndFrame().getM_status().getLeftCtrl().setForeground(Color.gray);
        }
        this.getM_wndFrame().getM_status().getLeftCtrl().setSelected(bl);
        if (this.getSoftKeyboard() != null) {
            this.getSoftKeyboard().syncHoldKey();
        }
    }

    public void OnKeyboardHoldLeftAltKey(boolean bl) {
        Debug.out.println("OnKeyboardHoldLeftAltKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(18, 2, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardHoldLeftAltKey", bl);
        if (bl) {
            this.getM_wndFrame().getM_status().getLeftAlt().setForeground(Color.red);
        } else {
            this.getM_wndFrame().getM_status().getLeftAlt().setForeground(Color.gray);
        }
        this.getM_wndFrame().getM_status().getLeftAlt().setSelected(bl);
        if (this.getSoftKeyboard() != null) {
            this.getSoftKeyboard().syncHoldKey();
        }
    }

    public void OnKeyboardLeftWindowsKeyHoldDown(boolean bl) {
        Debug.out.println("OnKeyboardLeftWindowsKeyHoldDown");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(524, 2, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardLeftWindowsKeyHoldDown", bl);
        if (this.getSoftKeyboard() != null) {
            this.getSoftKeyboard().syncHoldKey();
        }
    }

    public void OnKeyboardLeftWindowsKeyPressRelease() {
        Debug.out.println("OnKeyboardLeftWindowsKeyPressRelease");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(524, 2, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(524, 2, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnKeyboardRightWindowsKeyHoldDown(boolean bl) {
        Debug.out.println("OnKeyboardRightWindowsKeyHoldDown");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(524, 3, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardRightWindowsKeyHoldDown", bl);
        if (this.getSoftKeyboard() != null) {
            this.getSoftKeyboard().syncHoldKey();
        }
    }

    public void OnKeyboardRightWindowsKeyPressRelease() {
        Debug.out.println("OnKeyboardRightWindowsKeyPressRelease");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(524, 3, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(524, 3, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnKeyboardAltCtrlDel() {
        Debug.out.println("OnKeyboardAltCtrlDel");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(17, 2, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(127, 1, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(127, 1, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(17, 2, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnKeyboardContextMenu() {
        this.m_USBKeyRep.set(525, 1, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(525, 1, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void resetModifiers() {
        byte by = USBKeyProcessorEnglish.getModifiers();
        if ((by & 1) == 1 && !JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldLeftCtrlKey").booleanValue()) {
            JViewerApp.getInstance().OnKeyboardHoldLeftCtrlKey(false);
        }
        if ((by & 0x10) == 16 && !JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldRightCtrlKey").booleanValue()) {
            JViewerApp.getInstance().OnKeyboardHoldRightCtrlKey(false);
        }
        if ((by & 4) == 4 && !JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldLeftAltKey").booleanValue()) {
            JViewerApp.getInstance().OnKeyboardHoldLeftAltKey(false);
        }
        if ((by & 0x40) == 64 && !JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldRightAltKey").booleanValue()) {
            JViewerApp.getInstance().OnKeyboardHoldRightAltKey(false);
        }
        if ((by & 2) == 2) {
            JViewerApp.getInstance().OnKeyboardHoldLeftShiftKey(false);
        }
        if ((by & 0x20) == 32) {
            JViewerApp.getInstance().OnKeyboardHoldRightShiftKey(false);
        }
        USBKeyProcessorEnglish.setModifiers(by);
    }

    public void OnsendMacrokeycode(String string) {
        int n;
        int n2;
        String[] stringArray = string.split("[+]");
        int n3 = 0;
        while (n3 < stringArray.length) {
            n2 = Integer.parseInt(stringArray[n3++]);
            n = Integer.parseInt(stringArray[n3++]);
            this.sendKeyEvent(n2, n, true);
        }
        n3 = 0;
        while (n3 < stringArray.length) {
            n2 = Integer.parseInt(stringArray[n3++]);
            n = Integer.parseInt(stringArray[n3++]);
            this.sendKeyEvent(n2, n, false);
        }
    }

    public void sendKeyEvent(int n, int n2, boolean bl) {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(n, n2, bl);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnSkbrdDisplay(int n) {
        if (this.softKeyboard != null) {
            this.softKeyboard.m_skmouselistener.close();
            this.softKeyboard.dispose();
        }
        if (n == -1) {
            if (this.softKeyboard != null) {
                this.softKeyboard.setVisible(false);
                this.softKeyboard = null;
            }
        } else {
            this.softKeyboard = new SoftKeyboard(n, JViewer.getMainFrame());
            if (this.powerStatus == 1) {
                this.softKeyboard.OnUpdateKeyState(true);
            } else {
                this.softKeyboard.OnUpdateKeyState(false);
            }
        }
    }

    public void OnEncryptionStatus() {
        if (!this.m_frame.getMenu().getMenuItem("OptionsKeyboardMouseEncryption").isEnabled()) {
            this.m_frame.getMenu().notifyMenuStateEnable("OptionsKeyboardMouseEncryption", true);
        }
        if (this.m_KVMClnt.isKMEncryptionEnabled()) {
            return;
        }
        this.m_KVMClnt.notifyEncryption(true);
        this.m_frame.getMenu().notifyMenuStateSelected("OptionsKeyboardMouseEncryption", true);
        if (KVMClient.DISABLE_ENCRPT_FLAG) {
            InfoDialog.showDialog((Component)this.m_frame, LocaleStrings.getString("D_11_JVAPP"), LocaleStrings.getString("D_12_JVAPP"), 1);
            KVMClient.DISABLE_ENCRPT_FLAG = false;
            this.m_KVMClnt.getCrypt().initialize(this.m_encToken, 1);
        } else {
            InfoDialog.showDialog((Component)this.m_frame, LocaleStrings.getString("D_13_JVAPP"), LocaleStrings.getString("D_12_JVAPP"), 1);
        }
    }

    public void OnInitialEncryptionStatus() {
        this.m_KVMClnt.notifyEncryption(true);
        this.m_frame.getMenu().notifyMenuStateSelected("OptionsKeyboardMouseEncryption", true);
        this.m_KVMClnt.getCrypt().initialize(this.m_encToken, 1);
        InfoDialog.showDialog((Component)this.m_frame, LocaleStrings.getString("D_13_JVAPP"), LocaleStrings.getString("D_12_JVAPP"), 1);
    }

    public void OnOptionsKeyboardMouseEncryption(boolean bl) {
        Debug.out.println("OnOptionsKeyboardMouseEncryption");
        this.m_KVMClnt.setEncryption(bl);
        this.m_frame.getMenu().notifyMenuStateSelected("OptionsKeyboardMouseEncryption", bl);
        if (this.m_frame.getMenu().getMenuSelected("OptionsKeyboardMouseEncryption").booleanValue()) {
            this.m_frame.getMenu().notifyMenuStateEnable("OptionsKeyboardMouseEncryption", !bl);
        }
        if (bl) {
            this.m_KVMClnt.getCrypt().initialize(this.m_encToken, 1);
        } else {
            this.m_KVMClnt.getCrypt().close();
        }
    }

    public void OnUSBMouseSyncCursor(boolean bl) {
        Debug.out.println("OnUSBMouseSyncCursor");
        showCursor = true;
        this.m_view.USBsyncCursor(bl);
        this.m_frame.getMenu().refreshMenu();
    }

    public void OnShowCursor(boolean bl) {
        Debug.out.println("OnShowCursor");
        this.getJVMenu().notifyMenuStateEnable("MouseShowCursor", true);
        this.getJVMenu().notifyMenuStateSelected("MouseShowCursor", bl);
        if (bl) {
            if (JVMenu.m_scale != 1.0 || this.zoomOption == "FitToClientResolution") {
                if (this.m_view.GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                    showCursor = false;
                    this.getJVMenu().notifyMenuStateSelected("MouseShowCursor", false);
                    this.getJVMenu().notifyMenuStateEnable("MouseShowCursor", false);
                    URL uRL = JViewer.class.getResource("res/Mouse2Btn-gray.png");
                    this.getM_wndFrame().getToolbar().mouseBtn.setIcon(new ImageIcon(uRL));
                    JViewerApp.getInstance().getM_wndFrame().getToolbar().mouseBtn.setToolTipText(LocaleStrings.getString("D_48_JVAPP"));
                    return;
                }
            } else {
                showCursor = true;
                this.m_view.ShowCursor(true);
                URL uRL = JViewer.class.getResource("res/Mouse2Btn.png");
                this.getM_wndFrame().getToolbar().mouseBtn.setIcon(new ImageIcon(uRL));
                JViewerApp.getInstance().getM_wndFrame().getToolbar().mouseBtn.setToolTipText(LocaleStrings.getString("D_14_JVAPP"));
            }
        } else {
            showCursor = false;
            this.m_view.ShowCursor(false);
            URL uRL = JViewer.class.getResource("res/Mouse2Btn-gray.png");
            this.getM_wndFrame().getToolbar().mouseBtn.setIcon(new ImageIcon(uRL));
            if (JVMenu.m_scale != 1.0 || this.zoomOption == "FitToClientResolution") {
                if (this.m_view.GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                    this.getJVMenu().notifyMenuStateSelected("MouseShowCursor", false);
                    this.getJVMenu().notifyMenuStateEnable("MouseShowCursor", false);
                    JViewerApp.getInstance().getM_wndFrame().getToolbar().mouseBtn.setToolTipText(LocaleStrings.getString("D_48_JVAPP"));
                }
            } else {
                JViewerApp.getInstance().getM_wndFrame().getToolbar().mouseBtn.setToolTipText(LocaleStrings.getString("D_15_JVAPP"));
            }
        }
    }

    public void OnOptionsBandwidthAutoDetect() {
        Debug.out.println("OnOptionsBandwidthAutoDetect");
        this.m_KVMClnt.autoDetect();
        if (JViewer.isStandalone()) {
            this.m_autoBWDlg = new AutoBWDlg(JViewer.getMainFrame());
            this.m_autoBWDlg.setVisible(true);
            this.m_autoBWDlg.setLocation(JViewerApp.getInstance().getPopUpWindowPosition(300, 100));
        } else {
            JPanel jPanel = new JPanel();
            this.label = new JLabel(LocaleStrings.getString("9_1_BW") + " ...");
            jPanel.add(this.label);
            JOptionPane jOptionPane = new JOptionPane(jPanel, -1);
            jOptionPane.setOptions(new Object[0]);
            this.dialog = jOptionPane.createDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("9_1_BW") + "...");
            this.dialog.setResizable(false);
            this.dialog.setSize(300, 100);
            this.dialog.setLocation(JViewerApp.getInstance().getPopUpWindowPosition(300, 100));
            this.dialog.setVisible(true);
        }
    }

    public void updateBandwidthMsg(String string) {
        if (JViewer.isStandalone()) {
            if (this.m_autoBWDlg != null && this.m_autoBWDlg.isVisible()) {
                this.m_autoBWDlg.setMessage(LocaleStrings.getString("9_1_BW") + " - " + string);
            }
            this.m_autoBWDlg.done();
        } else {
            try {
                this.label.setText(LocaleStrings.getString("9_1_BW") + " - " + string);
                Thread.sleep(1000L);
                this.label.setText(LocaleStrings.getString("9_3_BW") + "...");
                Thread.sleep(1000L);
                this.label.setText(LocaleStrings.getString("D_16_JVAPP") + string + LocaleStrings.getString("D_17_JVAPP"));
                Thread.sleep(1000L);
                this.dialog.dispose();
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    public void OnOptionsBandwidth(int n) {
        this.m_KVMClnt.setBandwidth(n);
        this.m_frame.getMenu().SetMenuSelected(JVMenu.previous_bandwidth, false);
        switch (n) {
            case 32768: {
                Debug.out.println("OnOptionsBandwidth256Kbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth256Kbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth256Kbps", true);
                break;
            }
            case 65536: {
                Debug.out.println("OnOptionsBandwidth512Kbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth512Kbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth512Kbps", true);
                break;
            }
            case 131072: {
                Debug.out.println("OnOptionsBandwidth1Mbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth1Mbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth1Mbps", true);
                break;
            }
            case 0x140000: {
                Debug.out.println("OnOptionsBandwidth10Mbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth10Mbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth10Mbps", true);
                break;
            }
            case 0xC80000: {
                Debug.out.println("OnOptionsBandwidth100Mbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth100Mbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth100Mbps", true);
            }
        }
    }

    public void invokeIPMICommandDialog() {
        if (this.ipmiDialog != null && this.ipmiDialog.isShowing()) {
            return;
        }
        this.ipmiDialog = new IPMICommandDialog(JViewer.getMainFrame());
        this.ipmiDialog.showDialog();
    }

    public IPMICommandDialog getIPMIDialog() {
        return this.ipmiDialog;
    }

    public void setIPMIDialog(IPMICommandDialog iPMICommandDialog) {
        this.ipmiDialog = iPMICommandDialog;
    }

    public int onSendIPMICommand(byte by, byte[] byArray) {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(48, byArray.length + 1, 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + byArray.length + 1);
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.put(by);
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        byte[] byArray2 = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray2, 0, byteBuffer.limit());
        if (byArray2.length != this.getKVMClient().sendMessage(byArray2, byArray2.length)) {
            Debug.out.println("Failed to send IPMI command");
            return -1;
        }
        return 0;
    }

    public void onGetIPMICommandResponse(ByteBuffer byteBuffer, int n) {
        String string = new String();
        byte by = 0;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        by = byteBuffer.get();
        if (n == 0) {
            byte[] byArray = new byte[byteBuffer.limit() - 1];
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(1);
            byteBuffer.get(byArray);
            string = Debug.out.dumpIPMI(byArray, 0, byArray.length);
            if (string.equals("") || string.length() == 0) {
                String string2 = Integer.toHexString(n & 0xFF);
                string = LocaleStrings.getString("D_50_JVAPP") + " : 0x " + string2.toUpperCase();
            }
        } else {
            String string3 = Integer.toHexString(n & 0xFF);
            string = LocaleStrings.getString("D_50_JVAPP") + " : 0x " + string3.toUpperCase();
        }
        this.ipmiDialog.onIPMICommandRespose(by, string);
    }

    public void OnGUILanguageChange(String string) {
        JViewer.setLanguage(string);
        Locale locale = new Locale(string.toLowerCase());
        JComponent.setDefaultLocale(locale);
        this.getJVMenu().changeMenuLanguage();
        this.getJVMenu().changeMenuItemLanguage();
        this.getJVMenu().changeStatusBarLanguage();
        JViewerApp.getInstance().getM_wndFrame().getToolbar().changeToolBarItemLanguage();
        JViewerApp.getInstance().getM_wndFrame().getToolbar().setZoomLabel(this.getM_wndFrame().getToolbar().getSlider_zoom().getValue());
        JViewerApp.getInstance().getRCView().repaint();
        if (this.ipmiDialog != null) {
            this.ipmiDialog.closeIPMICommandDialog();
            this.ipmiDialog = null;
            this.invokeIPMICommandDialog();
        }
        if (this.getVMDialog() != null) {
            this.vmDialog.reInitialize();
            VMApp.getInstance().getRedirectionController().updateRedirectionStatus(0, VMApp.getInstance().getNumCD());
            VMApp.getInstance().getRedirectionController().updateRedirectionStatus(2, VMApp.getInstance().getNumHD());
        }
    }

    public void onSendFullPermissionRequest() {
        KVMSharing.KVM_CLIENT_USERNAME = null;
        KVMSharing.KVM_CLIENT_IP = null;
        KVMSharing.KVM_CLIENT_SESSION_INDEX = null;
        KVMSharing.KVM_CLIENT_IPMI_PRIV = 0;
        if (this.getKVMClient().sendKVMFullPermissionRequest() < 0) {
            InfoDialog.showDialog((Component)this.m_frame, LocaleStrings.getString("D_53_JVAPP"), LocaleStrings.getString("D_54_JVAPP"), 2);
        }
    }

    public void onGetFullPermissionRequest(short s) {
        this.fullPermissionRequest = true;
        this.OnKvmPrevilage(s);
    }

    public void onSendKeepAliveRequest() {
        if (this.getKVMClient().sendKeepAliveRequest() < 0) {
            JViewerApp.getInstance().onReconnect();
        }
    }

    public Point getWindowPostionToSet() {
        GraphicsDevice[] graphicsDeviceArray;
        Point point = JViewerApp.getOEMManager().getWindowPosition();
        if (point != null) {
            return point;
        }
        if ((JViewer.getOEMFeatureStatus() & 0x100L) == 256L) {
            return JViewer.getMainFrame().getLocationOnScreen();
        }
        JFrame jFrame = JViewer.getMainFrame();
        Point point2 = new Point();
        int n = 0;
        int n2 = 0;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            DisplayMode displayMode = graphicsDevice.getDisplayMode();
            if (displayMode != null) {
                point2.x = displayMode.getWidth();
                point2.y = displayMode.getHeight();
            }
            if (((Component)jFrame).isShowing() && jFrame.getLocationOnScreen().x < (n += point2.x)) break;
            n2 = point2.x + 1;
        }
        point2.x = n2;
        point2.y = 0;
        return point2;
    }

    public Point getPopUpWindowPosition(int n, int n2) {
        JFrame jFrame = null;
        int n3 = 0;
        int n4 = 0;
        jFrame = JViewer.getMainFrame();
        int n5 = jFrame.getLocationOnScreen().x;
        int n6 = jFrame.getLocationOnScreen().y;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        n3 = n5 + (jFrame.getWidth() - n) / 2;
        n4 = n6 > dimension.height ? n6 + (jFrame.getHeight() - n2) / 2 : (n6 + jFrame.getHeight() - n2) / 2;
        Point point = new Point(n3, n4);
        return point;
    }

    public Dimension getCurrentMonitorResolution() {
        GraphicsDevice[] graphicsDeviceArray;
        JFrame jFrame = JViewer.getMainFrame();
        Dimension dimension = new Dimension();
        int n = 0;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            DisplayMode displayMode = graphicsDevice.getDisplayMode();
            if (displayMode != null) {
                dimension.width = displayMode.getWidth();
                dimension.height = displayMode.getHeight();
            }
            if (((Component)jFrame).isShowing() && jFrame.getLocationOnScreen().x + 8 < (n += dimension.width)) break;
        }
        this.initialDimension.setSize(dimension.width, dimension.height);
        return dimension;
    }

    public void OnHelpAboutJViewer() {
        Debug.out.println("OnHelpAboutJViewer");
        OEMResourceURLProcessor oEMResourceURLProcessor = new OEMResourceURLProcessor(this.getM_webSession_token(), JViewer.getIp());
        String string = oEMResourceURLProcessor.getOemCopyright();
        ImageIcon imageIcon = oEMResourceURLProcessor.getOemLogo();
        if (string != null && string.length() > 0) {
            String string2 = "<=socversion=>";
            if (string.contains(string2)) {
                string = string.replace(string2, this.getSoc_manager().getSOCVersion());
            }
            if (string.contains(string2 = "<=soc=>")) {
                string = string.replace(string2, this.getSoc_manager().getSOC());
            }
            if (string.contains(string2 = "<=jviewerversion=>")) {
                string = string.replace(string2, this.currentVersion);
            }
        } else {
            string = LocaleStrings.getString("D_18_JVAPP") + this.currentVersion + "\n" + LocaleStrings.getString("D_19_JVAPP") + JViewerApp.getSoc_manager().getSOCVersion() + LocaleStrings.getString("D_20_JVAPP") + JViewerApp.getSoc_manager().getSOC() + "\n" + LocaleStrings.getString("D_21_JVAPP");
        }
        if (imageIcon == null) {
            imageIcon = new ImageIcon(JViewer.class.getResource("res/ami.jpg"));
        }
        JOptionPane.showMessageDialog(this.m_frame, string, LocaleStrings.getString("D_22_JVAPP") + JViewer.getTitle(), 1, imageIcon);
    }

    public void OnTerminateActiveuser(int n) {
        int n2 = KVMClient.getNumUsers();
        if (n >= n2) {
            return;
        }
        String[] stringArray = KVMClient.getUserData();
        String string = stringArray[n].substring(0, stringArray[n].indexOf(":") - 1).trim();
        int n3 = Integer.parseInt(string);
        if (n3 == JViewerApp.getInstance().getCurrentSessionId()) {
            return;
        }
        this.getKVMClient().SendKillSession((byte)5, n3);
    }

    public void OnVideoExit() {
        Debug.out.println("OnVideoExit");
        this.m_frame.exitApp();
    }

    public void onMaxSession() {
        JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.getString("D_23_JVAPP"), LocaleStrings.getString("D_24_JVAPP"), 1);
        this.m_frame.exitApp();
    }

    public void OnGetMouseMode(byte by) {
        Debug.out.println("Mouse mode response packet received. Mouse Mode:" + by);
        this.m_view.SetUSBMouseMode(by);
        this.OnUSBMouseSyncCursor(true);
        if (by == USBMouseRep.RELATIVE_MOUSE_MODE) {
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("Calibrate Mouse Threshold", true);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("Relative", true);
            if (!JViewer.getMainFrame().isResizable() && !this.isFullScreenMode() && this.zoomOption == "ActualSize") {
                JViewer.getMainFrame().setResizable(true);
                JViewerApp.getInstance().getMainWindow().m_viewSP.setHorizontalScrollBarPolicy(30);
                JViewerApp.getInstance().getMainWindow().m_viewSP.setVerticalScrollBarPolicy(20);
            }
        } else if (by == USBMouseRep.OTHER_MOUSE_MODE) {
            GraphicsConfiguration graphicsConfiguration = JViewerApp.getInstance().getM_wndFrame().getGraphicsConfiguration();
            Dimension dimension = this.getCurrentMonitorResolution();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            int n = dimension.height;
            int n2 = dimension.width;
            int n3 = insets.top + insets.bottom;
            int n4 = insets.left + insets.right;
            int n5 = n - n3;
            int n6 = n2 - n4;
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("Other", true);
            JViewer.getMainFrame().setLocation(this.getWindowPostionToSet());
            JViewerApp.getInstance().getMainWindow().m_viewSP.setHorizontalScrollBarPolicy(31);
            JViewerApp.getInstance().getMainWindow().m_viewSP.setVerticalScrollBarPolicy(21);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            JViewer.getMainFrame().setMaximizedBounds(graphicsEnvironment.getMaximumWindowBounds());
            JViewer.getMainFrame().setSize(n6, n5);
            JViewer.getMainFrame().setResizable(false);
            JViewerApp.getInstance().OnShowCursor(false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("MouseShowCursor", false);
            if (KVMSharing.KVM_REQ_GIVEN == 0) {
                InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("E_7_JVIEW") + LocaleStrings.getString("E_3_JVIEW"), LocaleStrings.getString("F_46_JVM"), 1);
            }
        } else if (by == USBMouseRep.ABSOLUTE_MOUSE_MODE) {
            if (!JViewer.getMainFrame().isResizable() && !this.isFullScreenMode() && this.zoomOption == "ActualSize") {
                JViewer.getMainFrame().setResizable(true);
                JViewerApp.getInstance().getMainWindow().m_viewSP.setHorizontalScrollBarPolicy(30);
                JViewerApp.getInstance().getMainWindow().m_viewSP.setVerticalScrollBarPolicy(20);
            }
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("Absolute", true);
            JViewerApp.getInstance().OnShowCursor(true);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("MouseShowCursor", true);
        }
        this.getVidClnt().setZoomOptionStatus();
        this.getM_wndFrame().getM_status().resetStatus();
        JViewerApp.getInstance().getJVMenu().notifyMouseMode(by);
    }

    public void OnValidateVideoSessionResp(byte by, byte by2) {
        Object[] objectArray;
        String[] stringArray;
        Debug.out.println("OnValidateVideoSessionResp");
        if (by == 0) {
            this.m_frame.generalErrorMessage(LocaleStrings.getString("D_25_JVAPP"), LocaleStrings.getString("D_26_JVAPP"));
            JViewer.exit(0);
        } else if (by == 2) {
            this.m_frame.generalErrorMessage(LocaleStrings.getString("D_25_JVAPP"), LocaleStrings.getString("1_5_JVIEWER"));
            JViewer.exit(0);
        } else if (by == 3) {
            this.m_frame.generalErrorMessage(LocaleStrings.getString("D_25_JVAPP"), LocaleStrings.getString("D_65_JVAPP"));
            JViewer.exit(0);
        } else if (by == 6) {
            this.m_frame.generalErrorMessage(LocaleStrings.getString("D_25_JVAPP"), LocaleStrings.getString("D_70_JVAPP"));
            JViewer.exit(0);
        } else if (by == 7) {
            this.m_frame.generalErrorMessage(LocaleStrings.getString("D_25_JVAPP"), LocaleStrings.getString("D_71_JVAPP"));
            JViewer.exit(0);
        } else if (by == 8) {
            this.m_frame.generalErrorMessage(LocaleStrings.getString("D_25_JVAPP"), LocaleStrings.getString("D_72_JVAPP"));
            JViewer.exit(0);
        }
        if (JViewer.isKVMReconnectEnabled() && (JViewer.isjviewerapp() || JViewer.isStandAloneApp())) {
            if (this.getRetryConnection()) {
                InfoDialog.undecDialogClose();
            } else {
                InfoDialog.undecDialogClose();
                if (JViewer.isPowerSaveModeEnabled() && KVMShareDialog.isMasterSession) {
                    JViewerApp.getInstance().getRCView().removeKMListener();
                    this.hidInitDialog = InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("D_69_JVAPP"), 5000L, 5);
                }
            }
            this.setSessionLive(true);
            if (this.m_liveListener == null) {
                this.m_liveListener = new KeepAlive();
                this.m_liveListener.start();
            }
            this.currentRetryCount = 0;
            if (!this.m_userPause) {
                JViewerApp.getInstance().OnVideoRefreshRedirection();
            }
            if (JViewer.isjviewerapp()) {
                if (!JViewer.isRestService() && !this.validateSessionToken()) {
                    Debug.out.println("Invalid web Session token");
                    this.m_frame.generalErrorMessage(LocaleStrings.getString("AE_10_SPKVM"), LocaleStrings.getString("AE_4_SPKVM"));
                    JViewer.exit(0);
                }
                if (!this.getRetryConnection()) {
                    stringArray = JViewerApp.getInstance().getM_webSession_token();
                    objectArray = new byte[stringArray.length()];
                    objectArray = stringArray.getBytes();
                    Debug.out.dump((byte[])objectArray);
                    IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(21, objectArray.length, 0);
                    ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + objectArray.length);
                    byteBuffer.position(0);
                    byteBuffer.put(iVTPPktHdr.array());
                    byteBuffer.put((byte[])objectArray);
                    byteBuffer.position(0);
                    byte[] byArray = new byte[byteBuffer.limit()];
                    byteBuffer.get(byArray);
                    if (byArray.length != this.getKVMClient().sendMessage(byArray, byArray.length)) {
                        Debug.out.println("Failed to web Session token to the card");
                        return;
                    }
                }
            }
            this.setRetryConnection(false);
        }
        this.m_KVMClnt.setSocketTimeout();
        this.currentSessionId = by2;
        this.m_KVMClnt.OnValidVideoSession();
        if (!JViewer.isWebPreviewer() && this.m_KVMClnt.redirection()) {
            stringArray = new String[]{"VideoExit", "HelpAboutJViewer", "VideoFullScreen"};
            objectArray = this.getExceptionMenuList(stringArray);
            this.m_frame.getMenu().enableMenu((String[])objectArray, true, true);
            if (KVMSharing.KVM_REQ_GIVEN == 2) {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("OptionsKeyboardMouseEncryption", false);
            } else {
                JViewerApp.getInstance().getM_wndFrame().getM_status().enableStatusBar(true);
            }
            JViewerApp.getInstance().getM_wndFrame().getToolbar().changeMacrowsStatus(true);
            if (this.m_userPause) {
                this.m_RedirectionState = REDIR_STARTED;
                this.OnVideoPauseRedirection();
            }
        }
    }

    public void onKeybdLED(byte by) {
        if (this.getClientKeyboardLEDStatus() != by) {
            if (!JViewerView.syncLEDFlag || this.powerStatus == 0) {
                try {
                    if ((JViewer.getOEMFeatureStatus() & 0x200L) != 512L) {
                        this.setClientKeyboardLEDStatus(by);
                    }
                }
                catch (Exception exception) {
                    Debug.out.println(exception);
                }
            }
            this.setHostKeyboardLEDStatus(by);
            if (this.getSoftKeyboard() != null) {
                this.getSoftKeyboard().syncKbdLED();
            }
            if ((JViewer.getOEMFeatureStatus() & 0x200L) == 512L && this.frameRateTask != null && !this.isKbdLEDSyncing()) {
                this.frameRateTask.setSyncLEDFromClient(true);
            }
        }
        if (!com.ami.kvm.jviewer.kvmpkts.Mousecaliberation.THRESHOLDFLAG) {
            if (!com.ami.kvm.jviewer.kvmpkts.Mousecaliberation.ACCELERATION_FLAG) {
                this.m_view.addKeyListener();
            }
        }
    }

    public void resetLEDStatus() {
        if ((JViewer.getOEMFeatureStatus() & 0x200L) != 512L) {
            this.setClientKeyboardLEDStatus((byte)0);
            this.setHostKeyboardLEDStatus((byte)0);
        }
    }

    public byte getHostKeyboardLEDStatus() {
        return this.hostLEDStatus;
    }

    public void setHostKeyboardLEDStatus(byte by) {
        this.hostLEDStatus = by;
    }

    public byte getClientKeyboardLEDStatus() {
        ClientConfig clientConfig = new ClientConfig();
        this.clientLEDStatus = clientConfig.ReadKeybdLEDStatus();
        clientConfig = null;
        return this.clientLEDStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientKeyboardLEDStatus(byte by) {
        try {
            if (!com.ami.kvm.jviewer.kvmpkts.Mousecaliberation.THRESHOLDFLAG) {
                if (!com.ami.kvm.jviewer.kvmpkts.Mousecaliberation.ACCELERATION_FLAG) {
                    this.m_view.removeKeyListener();
                }
            }
            if (!this.isMacClient()) {
                if (this.frameRateTask != null) {
                    this.frameRateTask.updateKeyboardLEDStatus(by);
                } else {
                    ClientConfig clientConfig = new ClientConfig();
                    try {
                        clientConfig.setKeyboardLEDStatus(by);
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                    }
                    finally {
                        clientConfig = null;
                    }
                }
                Thread.sleep(1000L);
            }
            if (this.getSoftKeyboard() != null) {
                this.getSoftKeyboard().syncKbdLED();
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
    }

    public byte getInitClientLEDStatus() {
        return this.initClientLEDStatus;
    }

    public void setInitClientLEDStatus(byte by) {
        this.initClientLEDStatus = by;
    }

    public void sendClientLEDStatus() {
        byte by = this.getClientKeyboardLEDStatus();
        byte by2 = this.getHostKeyboardLEDStatus();
        int n = 0;
        int n2 = 1;
        try {
            this.setKbdLEDSyncing(true);
            if (by2 != by) {
                if ((by & 1) != (by2 & 1)) {
                    n = 144;
                    n2 = 4;
                    this.sendKeyEvent(n, n2, true);
                    this.sendKeyEvent(n, n2, false);
                }
                Thread.sleep(100L);
                if ((by & 2) != (by2 & 2)) {
                    n = 20;
                    n2 = 1;
                    this.sendKeyEvent(n, n2, true);
                    this.sendKeyEvent(n, n2, false);
                }
                Thread.sleep(100L);
                if ((by & 4) != (by2 & 4)) {
                    n = 145;
                    n2 = 1;
                    this.sendKeyEvent(n, n2, true);
                    this.sendKeyEvent(n, n2, false);
                }
                Thread.sleep(100L);
                this.setHostKeyboardLEDStatus(by);
            }
        }
        catch (InterruptedException interruptedException) {
            Debug.out.println(interruptedException);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        this.setKbdLEDSyncing(false);
    }

    public boolean isKbdLEDSyncing() {
        return this.kbdLEDSyncing;
    }

    public void setKbdLEDSyncing(boolean bl) {
        this.kbdLEDSyncing = bl;
    }

    public void stopRedirection_ISoImage() {
        int n;
        int n2 = 0;
        int n3 = 0;
        IUSBRedirSession iUSBRedirSession = VMApp.getInstance().getIUSBRedirSession();
        n2 = VMApp.getInstance().getNumCD();
        n3 = VMApp.getInstance().getNumHD();
        if (iUSBRedirSession.cdromSession != null) {
            for (n = 0; n < n2; ++n) {
                if (!VMApp.getInstance().getIUSBRedirSession().cdromSession[n].isCdImageRedirected() || !iUSBRedirSession.cdromSession[n].isCdImageEjected()) continue;
                iUSBRedirSession.StopISORedir(n, 1);
            }
        }
        if (iUSBRedirSession.hardDiskSession != null) {
            for (n = 0; n < n3; ++n) {
                if (!VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n].isHdImageRedirected() || !VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n].isHdImageEjected()) continue;
                iUSBRedirSession.StopHarddiskImageRedir(n, 1);
            }
        }
    }

    public void OnCalibareteMouse(boolean bl) {
        if (JVMenu.m_scale != 1.0) {
            JOptionPane.showMessageDialog(this.getM_frame(), LocaleStrings.getString("D_27_JVAPP"), LocaleStrings.getString("D_28_JVAPP"), 0);
            this.getJVMenu().notifyMenuStateSelected("Calibrate Mouse Threshold", false);
            return;
        }
        JViewerApp jViewerApp = this;
        jViewerApp.Mousecaliberation.resetCursor();
        if (this.Mousecaliberation == null) {
            this.Mousecaliberation = new Mousecaliberation();
        }
        JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoFullScreen", false);
        JViewerApp.getInstance().getM_wndFrame().getToolbar().getFullScreenBtn().setToolTipText(LocaleStrings.getString("D_29_JVAPP"));
        this.getJVMenu().notifyMenuStateSelected("Calibrate Mouse Threshold", true);
        JViewerApp.getInstance().getRCView().removeKMListener();
        this.Mousecaliberation.OnCalibareteMouseThreshold(bl);
    }

    public void OnSendKVMPrevilage(byte by, String string) {
        if (by == 0 && (JViewerApp.getInstance().IsCDROMRedirRunning() || JViewerApp.getInstance().IsHarddiskRedirRunning()) && !this.getM_frame().stopVMediaRedirection(LocaleStrings.getString("D_58_JVAPP"))) {
            by = (byte)2;
        }
        this.m_KVMClnt.SendKVMPrevilage(by, string);
        if (this.isFullPermissionRequest()) {
            this.setFullPermissionRequest(false);
        }
    }

    public void onStopConcurrentSession() {
        if (KVMSharing.KVM_REQ_GIVEN == 2) {
            InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("D_51_JVAPP"), LocaleStrings.getString("D_52_JVAPP"), 1);
        }
        KVMSharing.KVM_REQ_GIVEN = 1;
        KVMShareDialog.isMasterSession = true;
        if (this.m_KVMClnt.redirection()) {
            this.OnChangeMenuState_KVMPartial(this.getJVMenu(), true);
            JViewerApp.getInstance().getM_wndFrame().getToolbar().OnChangeToolbarIconState_KVMPartial();
        }
    }

    public int OnsendWebsessionToken() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (JViewer.isKVMReconnectEnabled()) {
            if (this.getRetryConnection()) {
                return 0;
            }
            if (this.getKVMClient().OnFormIVTPHdr_Send((short)58, 0, (short)0) == -1) {
                return -1;
            }
        }
        n2 = JViewerApp.getInstance().getSessionTokenType();
        n3 = 381;
        n4 = 130;
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(18, n3, 0);
        String string = JViewerApp.getInstance().getSessionToken();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byte[] byArray = new byte[n4];
        byArray = string.getBytes();
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.put((byte)0);
        byteBuffer.put(string.getBytes());
        Debug.out.println("Hashed token");
        Debug.out.dump(byArray);
        for (n = byteBuffer.position(); n < 8 + n4; ++n) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put(KVMSharing.KVM_CLIENT_OWN_IP.getBytes());
        for (n = byteBuffer.position(); n < 8 + n4 + 65; ++n) {
            byteBuffer.put((byte)0);
        }
        KVMSharing.KVM_CLIENT_OWN_USERNAME = this.getClientUserName();
        byteBuffer.put(KVMSharing.KVM_CLIENT_OWN_USERNAME.getBytes());
        for (n = byteBuffer.position(); n < 8 + n4 + 65 + 129; ++n) {
            byteBuffer.put((byte)0);
        }
        String[] stringArray = null;
        try {
            KVMSharing.KVM_CLIENT_OWN_MAC = this.getMacAddress(1, stringArray);
            if (KVMSharing.KVM_CLIENT_OWN_MAC.contains(":")) {
                KVMSharing.KVM_CLIENT_OWN_MAC = KVMSharing.KVM_CLIENT_OWN_MAC.replaceAll(":", "-");
            }
        }
        catch (Exception exception) {
            Debug.out.println("Failed to get mac Address");
            return -1;
        }
        byteBuffer.put(KVMSharing.KVM_CLIENT_OWN_MAC.getBytes());
        for (int i = byteBuffer.position(); i < byteBuffer.limit(); ++i) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.position(0);
        byte[] byArray2 = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray2);
        if (byArray2.length != this.getKVMClient().sendMessage(byArray2, byArray2.length)) {
            Debug.out.println("Failed to send Session token to the card");
            return -1;
        }
        if (this.getKVMClient().OnFormIVTPHdr_Send((short)6, 0, (short)0) == -1) {
            return -1;
        }
        return 0;
    }

    public int onReconnect() {
        int n;
        int n2 = 0;
        int n3 = 0;
        Debug.out.println("<-Reconnect invoked->");
        if (this.getKVMClient().isStopSignalRecieved() || this.m_RedirectionState == REDIR_STOPPED || this.m_RedirectionState == REDIR_STOPPING) {
            Debug.out.println("Stop signal has been reached so no need reconnect");
            return 0;
        }
        if (KVMSharing.KVM_REQ_GIVEN != 1 && this.currentRetryCount < JViewer.getRetryCount()) {
            this.m_KVMClnt.checkReconnect();
        } else {
            Debug.out.println("<-Reconnect not possbile as max retry count is reached->");
            JViewer.exit(0);
        }
        String[] stringArray = new String[]{"VideoExit", "HelpAboutJViewer", "VideoFullScreen"};
        String[] stringArray2 = this.getExceptionMenuList(stringArray);
        this.m_frame.getMenu().enableMenu(stringArray2, false, false);
        JViewerApp.getInstance().OnVideoStartRedirection();
        n2 = 382;
        n3 = 130;
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(58, 374, 0);
        String string = JViewerApp.getInstance().getSessionToken();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.put(string.getBytes());
        for (n = byteBuffer.position(); n < 8 + n3; ++n) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put(KVMSharing.KVM_CLIENT_OWN_IP.getBytes());
        for (n = byteBuffer.position(); n < 8 + n3 + 65; ++n) {
            byteBuffer.put((byte)0);
        }
        KVMSharing.KVM_CLIENT_OWN_USERNAME = this.getClientUserName();
        byteBuffer.put(KVMSharing.KVM_CLIENT_OWN_USERNAME.getBytes());
        for (n = byteBuffer.position(); n < 8 + n3 + 65 + 129; ++n) {
            byteBuffer.put((byte)0);
        }
        String[] stringArray3 = null;
        try {
            KVMSharing.KVM_CLIENT_OWN_MAC = this.getMacAddress(1, stringArray3);
            if (KVMSharing.KVM_CLIENT_OWN_MAC.contains(":")) {
                KVMSharing.KVM_CLIENT_OWN_MAC = KVMSharing.KVM_CLIENT_OWN_MAC.replaceAll(":", "-");
            }
        }
        catch (Exception exception) {
            Debug.out.println("Failed to get mac Address");
            return -1;
        }
        byteBuffer.put(KVMSharing.KVM_CLIENT_OWN_MAC.getBytes());
        for (int i = byteBuffer.position(); i < 8 + n3 + 65 + 129 + 49; ++i) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put((byte)JViewerApp.getInstance().getCurrentSessionId());
        byteBuffer.position(0);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        if (byArray.length != this.getKVMClient().sendMessage(byArray, byArray.length)) {
            Debug.out.println("Failed to send Reconnect Session token to the card");
            return -1;
        }
        return 1;
    }

    public int onSendWebPreviewerSession() {
        IVTPPktHdr iVTPPktHdr;
        if (JViewer.isKVMReconnectEnabled()) {
            iVTPPktHdr = new IVTPPktHdr(58, 0, 0);
            if (this.getKVMClient().sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
                return -1;
            }
        }
        iVTPPktHdr = new IVTPPktHdr(26, 0, 0);
        if (this.getKVMClient().sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
            return -1;
        }
        return 0;
    }

    public void setWebPreviewerCaptureStatus(byte by) {
        m_webPreviewer_cap_status = by;
    }

    public byte getWebPreviewerCaptureStatus() {
        return m_webPreviewer_cap_status;
    }

    public void OnKvmPrevilage(short s) {
        byte by = (byte)s;
        byte by2 = (byte)(s >> 8);
        if (by == 6) {
            if (this.kVMDialog != null && this.kVMDialog.getKVMShareRequestDialog() != null) {
                this.kVMDialog.disposeKVMShareReqestDialog();
            }
            if (by2 == 0) {
                this.onKVMFullPermission();
            } else {
                this.onKVMPartialPermission((byte)2);
            }
        }
        if (by == 1) {
            String string = KVMSharing.KVM_CLIENT_USERNAME + " : " + KVMSharing.KVM_CLIENT_IP + " : " + KVMSharing.KVM_CLIENT_SESSION_INDEX;
            if (this.getJVMenu().getMenu("BlockFullPermission") == null) {
                this.getJVMenu().addBlockPermissionMenuItem();
            }
            if (this.getJVMenu().getMenuSelected("AllowonlyVideo").booleanValue()) {
                System.out.println("KVM master permission request blocked : Partial Access");
                this.OnSendKVMPrevilage((byte)6, string);
                return;
            }
            if (this.getJVMenu().getMenuSelected("DenyAccess").booleanValue()) {
                System.out.println("KVM master permission request blocked : Deny Access");
                this.OnSendKVMPrevilage((byte)8, string);
                return;
            }
            KVMResponseDialogThread kVMResponseDialogThread = null;
            kVMResponseDialogThread = new KVMResponseDialogThread();
            kVMResponseDialogThread.start();
            KVMSharing.KVM_PRIV_RES_USER = 1;
            return;
        }
        if (by == 2) {
            String[] stringArray = new String[]{"VideoExit", "HelpAboutJViewer"};
            this.kVMDialog = new KVMShareDialog();
            this.kVMDialog.setUserStatus(false);
            if (this.fullPermissionRequest) {
                this.kVMDialog.constructDialog((byte)2);
            } else {
                this.kVMDialog.constructDialog((byte)0);
            }
            this.kVMDialog.showDialog();
            KVMSharing.KVM_PRIV_RES_USER = (byte)2;
            if (!this.fullPermissionRequest) {
                this.getJVMenu().enableMenu(stringArray, false, true);
            }
            return;
        }
        if (by == 0) {
            Debug.out.println("Cancel Packet received");
            if (this.kVMDialog != null) {
                this.kVMDialog.disposeKVMShareResponseDialog();
            }
            if (this.fullPermissionRequest) {
                this.setFullPermissionRequest(false);
            }
            return;
        }
        if (by == 3) {
            KVMRequestDialogThread kVMRequestDialogThread = null;
            kVMRequestDialogThread = new KVMRequestDialogThread();
            this.setMessage(LocaleStrings.getString("D_33_JVAPP") + KVMSharing.KVM_CLIENT_USERNAME + LocaleStrings.getString("D_34_JVAPP") + KVMSharing.KVM_CLIENT_IP + LocaleStrings.getString("D_35_JVAPP"));
            kVMRequestDialogThread.start();
            if (this.getM_frame().getConfirmationLabel() != null) {
                Window window = SwingUtilities.getWindowAncestor(this.getM_frame().getConfirmationLabel());
                window.setVisible(false);
                window.dispose();
            }
            KVMSharing.KVM_REQ_GIVEN = (byte)2;
            KVMShareDialog.isMasterSession = false;
            if (this.kVMDialog != null && this.kVMDialog.getKVMShareRequestDialog() != null) {
                this.kVMDialog.disposeKVMShareReqestDialog();
            }
            this.getM_frame().onStopVMediaRedirection(0);
            if (this.m_wndMode) {
                this.OnChangeMenuState_KVMPartial(this.getM_wndFrame().getMenu(), false);
                this.getM_wndFrame().getToolbar().OnChangeToolbarIconState_KVMPartial();
            } else {
                this.OnChangeMenuState_KVMPartial(this.getM_fsFrame().getMenu(), false);
            }
            if (this.isFullPermissionRequest()) {
                this.setFullPermissionRequest(false);
            } else {
                this.getJVMenu().removeBlockPermissionMenuItem();
                this.getJVMenu().addFullPermissionMenuItem();
            }
            return;
        }
        if (by == 4) {
            Debug.out.println("#########Got from user2########### and usercommand byte is:" + by2);
            if (this.kVMDialog != null) {
                this.kVMDialog.disposeKVMShareReqestDialog();
            }
            KVMRequestDialogThread kVMRequestDialogThread = null;
            kVMRequestDialogThread = new KVMRequestDialogThread();
            if (by2 == 0) {
                this.onKVMFullPermission();
            } else if (by2 == 2 || by2 == 6) {
                this.onKVMPartialPermission(by2);
            } else if (by2 == 5 || by2 == 7) {
                JVFrame jVFrame = JViewerApp.getInstance().getMainWindow();
                if (by2 == 5) {
                    InfoDialog.showDialog((Component)jVFrame, LocaleStrings.getString("D_59_JVAPP"), LocaleStrings.getString("D_32_JVAPP"), 1);
                } else if (by2 == 7) {
                    InfoDialog.showDialog((Component)jVFrame, LocaleStrings.getString("D_68_JVAPP"), LocaleStrings.getString("D_32_JVAPP"), 1);
                }
                this.onKVMPartialPermission((byte)5);
            } else if (by2 == 3) {
                Debug.out.println("IVTPPktHdr.KVM_REQ_TIMEOUT");
                this.kVMDialog.disposeKVMShareReqestDialog();
                this.setMessage(LocaleStrings.getString("D_41_JVAPP") + KVMSharing.KVM_CLIENT_USERNAME + LocaleStrings.getString("D_36_JVAPP") + KVMSharing.KVM_CLIENT_IP);
                kVMRequestDialogThread.start();
                KVMSharing.KVM_REQ_GIVEN = 0;
                KVMShareDialog.isMasterSession = true;
                if (this.m_wndMode) {
                    this.OnChangeMenuState_KVMPartial(this.getM_wndFrame().getMenu(), true);
                    this.getM_wndFrame().getToolbar().OnChangeToolbarIconState_KVMPartial();
                } else {
                    this.OnChangeMenuState_KVMPartial(this.getM_fsFrame().getMenu(), false);
                }
                if (this.isFullPermissionRequest()) {
                    this.setFullPermissionRequest(false);
                    this.getJVMenu().removeFullPermissionMenuItem();
                    this.getJVMenu().addBlockPermissionMenuItem();
                }
            } else if (by2 == 1 || by2 == 8) {
                KVMSharing.KVM_REQ_GIVEN = 1;
                JViewerApp.getInstance().getKVMClient().setM_redirection(true);
                this.OnVideoStopRedirection();
                if (by2 == 1) {
                    Debug.out.println("IVTPPktHdr.KVM_REQ_DENIED");
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("D_42_JVAPP"));
                } else {
                    Debug.out.println("IVTPPktHdr.KVM_REQ_BLOCKED_DENY");
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("D_67_JVAPP") + "\n" + LocaleStrings.getString("D_42_JVAPP"));
                }
                this.kVMDialog.disposeKVMShareReqestDialog();
                JViewerApp.getInstance().getM_frame().windowClosed();
            } else if (by2 == 4) {
                this.onKVMPartialPermission(by2);
                InfoDialog.showDialog((Component)JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("D_55_JVAPP"), LocaleStrings.getString("D_56_JVAPP"), 1);
            }
            return;
        }
    }

    public boolean OnCheckSameClient(String string) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        boolean bl = false;
        try {
            inetAddress = InetAddress.getByName(string);
            inetAddress2 = InetAddress.getByName(KVMSharing.KVM_CLIENT_OWN_IP);
            String string2 = inetAddress.getHostAddress();
            String string3 = inetAddress2.getHostAddress();
            byArray = InetAddress.getByName(string2).getAddress();
            byArray2 = InetAddress.getByName(string3).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Debug.out.println(unknownHostException);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        try {
            if (InetAddress.getByAddress(byArray).equals(InetAddress.getByAddress(byArray2))) {
                Debug.out.println("Equals");
                bl = true;
            } else {
                Debug.out.println("Not Equals");
                bl = false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return bl;
    }

    private void OnChangeMenuState_KVMPartial(JVMenu jVMenu, boolean bl) {
        JViewerApp.getOEMManager().getOEMJVMenu().enableMenuOnKVMPartial(bl);
        if (this.powerStatus == 0) {
            if (KVMSharing.KVM_REQ_GIVEN == 2) {
                this.m_frame.getMenu().notifyMenuStateEnable("Power On Server", false);
                this.m_frame.getMenu().notifyMenuStateEnable("DeviceMediaDialog", false);
            } else if (bl) {
                this.m_frame.getMenu().notifyMenuStateEnable("Power On Server", true);
                this.m_frame.getMenu().notifyMenuStateEnable("DeviceMediaDialog", true);
                this.enablePowerControls(bl);
            }
            return;
        }
        String[] stringArray = JVMenu.KVMPartialExceptionMenuItems;
        String[] stringArray2 = this.getExceptionMenuList(stringArray);
        jVMenu.enableMenu(stringArray2, bl, true);
        if (bl) {
            this.enablePowerControls(bl);
        }
    }

    public int getSelectedVMTab() {
        return this.selectedVMTab;
    }

    public void setSelectedVMTab(int n) {
        this.selectedVMTab = n;
    }

    public void OnvMedia(int n) {
        this.setSelectedVMTab(n);
        if (!JViewer.isVMApp()) {
            this.vmDialog = VMApp.getVMDialog();
            if (this.vmDialog != null && this.vmDialog.isShowing()) {
                return;
            }
            if (this.vmDialog != null && !this.vmDialog.isShowing()) {
                this.vmDialog.setLocation(JViewerApp.getInstance().getPopUpWindowPosition(this.vmDialog.getWidth(), this.vmDialog.getHeight()));
                this.vmDialog.showDialog(true);
                return;
            }
        }
        VMApp.launchApp();
    }

    public VMDialog getVMDialog() {
        return this.vmDialog;
    }

    public void setVMDialog(VMDialog vMDialog) {
        this.vmDialog = vMDialog;
    }

    public void OnVideoRecordSettings() {
        if (this.m_videorecord == null) {
            this.m_videorecord = new VideoRecord();
        }
        this.m_videorecord.VideoRecordsettings();
    }

    public void reportCDROMAbnormal(int n) {
        VMApp.getInstance().getIUSBRedirSession().stopCDROMAbnormal(n);
        if (JViewer.isVMApp()) {
            VMApp.getVMPane().getDeviceControlPanel(0, n).updateDeviceControlPanel();
            VMApp.getInstance().getIUSBRedirSession().updateCDToolbarButtonStatus(false);
        } else if (this.getVMDialog() != null) {
            VMApp.getVMPane().getDeviceControlPanel(0, n).updateDeviceControlPanel();
            if (JViewer.isjviewerapp() || JViewer.isStandalone()) {
                VMApp.getVMPane().updateJVToolbar(0);
            }
        }
    }

    public void reportHarddiskAbnormal(int n) {
        VMApp.getInstance().getIUSBRedirSession().stopHarddiskAbnormal(n);
        if (JViewer.isVMApp()) {
            VMApp.getVMPane().getDeviceControlPanel(2, n).updateDeviceControlPanel();
            VMApp.getInstance().getIUSBRedirSession().updateHDToolbarButtonStatus(false);
        } else if (this.getVMDialog() != null) {
            VMApp.getVMPane().getDeviceControlPanel(2, n).updateDeviceControlPanel();
            if (JViewer.isjviewerapp() || JViewer.isStandalone()) {
                VMApp.getVMPane().updateJVToolbar(2);
            }
        }
    }

    public boolean IsCDROMRedirRunning(int n) {
        try {
            if (VMApp.getInstance().getIUSBRedirSession().getCDROMRedirStatus(n) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        return false;
    }

    public boolean IsCDROMRedirRunning() {
        int n = 0;
        n = VMApp.getInstance().getNumCD();
        for (int i = 0; i < n; ++i) {
            try {
                if (VMApp.getInstance().getIUSBRedirSession().getCDROMRedirStatus(i) != 1) continue;
                return true;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                return false;
            }
        }
        return false;
    }

    public boolean IsHarddiskRedirRunning(int n) {
        try {
            if (VMApp.getInstance().getIUSBRedirSession().getHarddiskRedirStatus(n) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        return false;
    }

    public boolean IsHarddiskRedirRunning() {
        int n = 0;
        n = VMApp.getInstance().getNumHD();
        for (int i = 0; i < n; ++i) {
            try {
                if (VMApp.getInstance().getIUSBRedirSession().getHarddiskRedirStatus(i) != 1) continue;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public int getCDPort() {
        return this.m_cdPort;
    }

    public int getHDPort() {
        return this.m_hdPort;
    }

    public int getCDStatus() {
        return this.m_cdStatus;
    }

    public int getHDStatus() {
        return this.m_hdStatus;
    }

    public String getM_webSession_token() {
        return JViewer.getWebSessionToken();
    }

    public void setM_webSession_token(String string) {
        JViewer.setWebSessionToken(string);
    }

    public JVFrame getM_frame() {
        return this.m_frame;
    }

    public FSFrame getM_fsFrame() {
        return this.m_fsFrame;
    }

    public boolean isM_wndMode() {
        return this.m_wndMode;
    }

    public void setM_wndMode(boolean bl) {
        this.m_wndMode = bl;
    }

    public ISOCApp getSoc_App() {
        return this.soc_App;
    }

    public void setSoc_App(ISOCApp iSOCApp) {
        this.soc_App = iSOCApp;
    }

    public JViewerView getM_view() {
        return this.m_view;
    }

    public void setM_view(JViewerView jViewerView) {
        this.m_view = jViewerView;
    }

    public static ISOCManager getSoc_manager() {
        return soc_manager;
    }

    public ISOCFrameHdr getSocframeHdr() {
        return this.socframeHdr;
    }

    public void setSocframeHdr(ISOCFrameHdr iSOCFrameHdr) {
        this.socframeHdr = iSOCFrameHdr;
    }

    public WindowFrame getM_wndFrame() {
        return this.m_wndFrame;
    }

    public void setM_wndFrame(WindowFrame windowFrame) {
        this.m_wndFrame = windowFrame;
    }

    public JVVideo getVidClnt() {
        return this.vidClnt;
    }

    public void setVidClnt(JVVideo jVVideo) {
        this.vidClnt = jVVideo;
    }

    public ISOCCreateBuffer getPrepare_buf() {
        return this.prepare_buf;
    }

    public ISOCKvmClient getSockvmclient() {
        return this.sockvmclient;
    }

    public void setSockvmclient(ISOCKvmClient iSOCKvmClient) {
        this.sockvmclient = iSOCKvmClient;
    }

    public void onAutoKeyboardLayout(boolean bl, boolean bl2) {
        this.getJVMenu().getMenuItem("NONE").setSelected(true);
        if (bl) {
            JVMenu.keyBoardLayout *= -1;
            this.getJVMenu().notifyMenuStateSelected("Auto detect", true);
            JViewer.setKeyboardLayout("AD");
            if (bl2 && (JViewer.getOEMFeatureStatus() & 8L) == 8L) {
                String string = LocaleStrings.getString("S_22_SACD") + " " + LocaleStrings.getString("S_21_SACD");
                InfoDialog.showDialog(this.m_frame, LocaleStrings.getString("M_1_ID") + string + "?", string, 3, 5000L, 0);
            }
            if (this.getAutokeylayout() == null) {
                this.setAutokeylayout(new AutoKeyboardLayout());
                this.getAutokeylayout().setKeyboardType(0);
                this.getAutokeylayout().setHostKeyboardType(0);
            } else {
                this.getAutokeylayout().setKeyboardType(0);
                this.getAutokeylayout().setHostKeyboardType(0);
                this.getAutokeylayout().initKeyProcessor();
                this.getAutokeylayout().getKeyboardType();
                this.getAutokeylayout().ongetKeyprocessor();
            }
            this.OnSkbrdDisplay(-1);
        } else {
            if (JVMenu.keyBoardLayout != -1) {
                JVMenu.keyBoardLayout *= -1;
            }
            JVMenu.keyBoardLayout = JVMenu.softkeyBoardLayout;
            this.getJVMenu().getMenu("SoftKeyboard").setEnabled(true);
            this.getJVMenu().notifyMenuStateSelected("Auto detect", false);
            this.getJVMenu().SetMenuEnable("SoftKeyboard", true);
            this.getJVMenu();
            JVMenu.m_menuItems_setenabled.put("SoftKeyboard", true);
        }
        JViewerApp.getInstance().getM_USBKeyRep().setM_USBKeyProcessor(JViewerApp.getInstance().getKeyProcesssor());
    }

    public AutoKeyboardLayout getAutokeylayout() {
        return this.autokeylayout;
    }

    public void setAutokeylayout(AutoKeyboardLayout autoKeyboardLayout) {
        this.autokeylayout = autoKeyboardLayout;
    }

    public KeyProcessor getKeyProcesssor() {
        if (this.autokeylayout == null) {
            this.autokeylayout = new AutoKeyboardLayout();
        }
        this.keyprocessor = this.autokeylayout.ongetKeyprocessor();
        this.keyprocessor.setAutoKeybreakMode(true);
        return this.keyprocessor;
    }

    public void setKeyProcessor(String string) {
        int n = 1033;
        if (JViewer.getKeyboardLayout().equals(string)) {
            return;
        }
        if (string.equalsIgnoreCase("US")) {
            n = 1033;
        } else if (string.equalsIgnoreCase("FR")) {
            n = 1036;
        } else if (string.equalsIgnoreCase("DE")) {
            n = 1031;
        } else if (string.equalsIgnoreCase("JP")) {
            n = 1041;
        } else if (string.equalsIgnoreCase("ES")) {
            n = 1034;
        } else if (string.equalsIgnoreCase("GB")) {
            n = 2057;
        } else if (string.equalsIgnoreCase("DE-CH")) {
            n = 2055;
        } else if (string.equalsIgnoreCase("FR-BE")) {
            n = 2060;
        } else if (string.equalsIgnoreCase("IT")) {
            n = 1040;
        } else if (string.equalsIgnoreCase("DA")) {
            n = 1030;
        } else if (string.equalsIgnoreCase("FI")) {
            n = 1035;
        } else if (string.equalsIgnoreCase("NO")) {
            n = 1044;
        } else if (string.equalsIgnoreCase("PT")) {
            n = 2070;
        } else if (string.equalsIgnoreCase("SV")) {
            n = 1053;
        } else if (string.equalsIgnoreCase("NL-NL")) {
            n = 1043;
        } else if (string.equalsIgnoreCase("NL-BE")) {
            n = 2067;
        } else if (string.equalsIgnoreCase("TR_F")) {
            n = 66591;
        } else if (string.equalsIgnoreCase("TR_Q")) {
            n = 1055;
        }
        if (this.autokeylayout == null) {
            this.autokeylayout = new AutoKeyboardLayout();
        }
        this.getJVMenu().notifyMenuStateSelected("Auto detect", false);
        if (!this.getJVMenu().getMenuEnable("SoftKeyboard").booleanValue()) {
            this.getJVMenu().notifyMenuEnable("SoftKeyboard", true);
            JVMenu.keyBoardLayout *= -1;
        }
        if (this.softKeyboard != null) {
            this.softKeyboard.m_skmouselistener.close();
            this.softKeyboard.dispose();
        }
        this.autokeylayout.setHostKeyboardType(n);
        JViewer.setKeyboardLayout(string);
        this.getM_USBKeyRep().setM_USBKeyProcessor(this.getKeyProcesssor());
        if ((JViewer.getOEMFeatureStatus() & 8L) == 8L) {
            String string2 = LocaleStrings.getString("S_22_SACD") + " " + LocaleStrings.getString("S_21_SACD");
            InfoDialog.showDialog(this.m_frame, LocaleStrings.getString("M_1_ID") + string2 + "?", string2, 3, 5000L, 0);
        }
    }

    public USBKeyboardRep getM_USBKeyRep() {
        return this.m_USBKeyRep;
    }

    public void setM_USBKeyRep(USBKeyboardRep uSBKeyboardRep) {
        this.m_USBKeyRep = uSBKeyboardRep;
    }

    public SoftKeyboard getSoftKeyboard() {
        return this.softKeyboard;
    }

    public void setSoftKeyboard(SoftKeyboard softKeyboard) {
        this.softKeyboard = softKeyboard;
    }

    public VideoRecord getM_videorecord() {
        return this.m_videorecord;
    }

    public void setM_videorecord(VideoRecord videoRecord) {
        this.m_videorecord = videoRecord;
    }

    public AddMacro getAddMacro() {
        return this.addMacro;
    }

    public void setAddMacro(AddMacro addMacro) {
        this.addMacro = addMacro;
    }

    public UserDefMacro getUserDefMacro() {
        return this.userDefMacro;
    }

    public void OnAddMacro() {
        if (JViewerApp.getInstance().getAddMacro() == null) {
            return;
        }
        this.userDefMacro = new UserDefMacro(JViewer.getMainFrame());
    }

    public void OnVideoZoomIn() {
        boolean bl;
        this.m_zoomSliderValue = this.getM_wndFrame().getToolbar().getSlider_zoom().getValue();
        if (JVMenu.m_scale <= 1.5) {
            BigDecimal bigDecimal = new BigDecimal(JVMenu.m_scale);
            BigDecimal bigDecimal2 = new BigDecimal("0.1");
            BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2).setScale(2, 4);
            JVMenu.m_scale = bigDecimal3.floatValue();
            this.m_zoomSliderValue += 10;
            this.getM_wndFrame().getToolbar().getSlider_zoom().setValue(this.m_zoomSliderValue);
            JViewerApp.getInstance().getRCView().revalidate();
            JViewerApp.getInstance().getRCView().repaint();
        }
        if (JVMenu.m_scale >= 0.5) {
            this.getJVMenu().SetMenuEnable("Zoom Out", true);
            this.getJVMenu().getMenuItem("Zoom Out").setEnabled(true);
        }
        if (JVMenu.m_scale >= 1.5) {
            this.getJVMenu().SetMenuEnable("Zoom In", false);
            this.getJVMenu().getMenuItem("Zoom In").setEnabled(false);
        }
        if (this.m_zoomSliderValue == 100 && (bl = JViewerApp.getInstance().getJVMenu().getMenuSelected("MouseShowCursor").booleanValue())) {
            JViewerApp jViewerApp = this;
            jViewerApp.Mousecaliberation.resetCursor();
        }
    }

    public void OnVideoZoomOut() {
        boolean bl;
        this.m_zoomSliderValue = this.getM_wndFrame().getToolbar().getSlider_zoom().getValue();
        if (JVMenu.m_scale >= 0.5) {
            BigDecimal bigDecimal = new BigDecimal(JVMenu.m_scale);
            BigDecimal bigDecimal2 = new BigDecimal("0.1");
            BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2).setScale(2, 4);
            JVMenu.m_scale = bigDecimal3.floatValue();
            this.m_zoomSliderValue -= 10;
            this.getM_wndFrame().getToolbar().getSlider_zoom().setValue(this.m_zoomSliderValue);
            JViewerApp.getInstance().getRCView().revalidate();
            JViewerApp.getInstance().getRCView().repaint();
        }
        if (JVMenu.m_scale <= 0.5) {
            this.getJVMenu().SetMenuEnable("Zoom Out", false);
            this.getJVMenu().getMenuItem("Zoom Out").setEnabled(false);
        }
        if (JVMenu.m_scale >= 0.5) {
            this.getJVMenu().SetMenuEnable("Zoom In", true);
            this.getJVMenu().getMenuItem("Zoom In").setEnabled(true);
        }
        if (this.m_zoomSliderValue == 100 && (bl = JViewerApp.getInstance().getJVMenu().getMenuSelected("MouseShowCursor").booleanValue())) {
            JViewerApp jViewerApp = this;
            jViewerApp.Mousecaliberation.resetCursor();
        }
    }

    public void onChangeZoomOptions(String string) {
        if (JViewerView.syncLEDFlag) {
            JViewerApp.getInstance().setResolutionChanged(1);
            return;
        }
        GraphicsConfiguration graphicsConfiguration = JViewerApp.getInstance().getM_wndFrame().getGraphicsConfiguration();
        Dimension dimension = this.getCurrentMonitorResolution();
        Point point = this.getWindowPostionToSet();
        Insets insets = new Insets(0, 0, 0, 0);
        try {
            insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int n = insets.top + insets.bottom;
        int n2 = insets.left + insets.right;
        int n3 = dimension.height - n;
        int n4 = dimension.width - n2;
        if (string.equals("ActualSize")) {
            if (this.zoomOption != "ZoomOption None") {
                if (!this.isRenderFitToHost() && this.m_wndFrame.isResizeFrame()) {
                    JViewer.getMainFrame().setSize(this.m_wndFrame.getFrameDimension());
                } else {
                    JViewer.getMainFrame().setSize(n4, n3);
                    JViewer.getMainFrame().setLocation(point);
                }
            }
            this.setZoomOption(string);
            this.getM_wndFrame().getToolbar().resetZoom();
            if (this.getRCView().GetUSBMouseMode() != USBMouseRep.OTHER_MOUSE_MODE) {
                JViewer.getMainFrame().setResizable(true);
                JViewerApp.getInstance().getMainWindow().m_viewSP.setHorizontalScrollBarPolicy(30);
                JViewerApp.getInstance().getMainWindow().m_viewSP.setVerticalScrollBarPolicy(20);
            }
            this.getM_wndFrame().getToolbar().enableZoomSlider(true);
            this.getJVMenu().notifyMenuStateEnable("Zoom In", true);
            this.getJVMenu().notifyMenuStateEnable("Zoom Out", true);
            this.getJVMenu().notifyMenuStateSelected("ActualSize", true);
        } else if (string.equals("FitToClientResolution")) {
            this.getM_wndFrame().getToolbar().resetZoom();
            JViewer.getMainFrame().setLocation(point);
            JViewerApp.getInstance().getMainWindow().m_viewSP.setHorizontalScrollBarPolicy(31);
            JViewerApp.getInstance().getMainWindow().m_viewSP.setVerticalScrollBarPolicy(21);
            JViewer.getMainFrame().setSize(n4, n3);
            JViewerApp.getInstance().getRCView().revalidate();
            JViewerApp.getInstance().getRCView().repaint();
            JViewer.getMainFrame().setResizable(false);
            this.setZoomOption(string);
            this.getM_wndFrame().getToolbar().enableZoomSlider(false);
            if (this.getRCView().GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                this.getM_wndFrame().getToolbar().changeShowCursorOnZoom();
            }
            this.getJVMenu().notifyMenuStateEnable("Zoom In", false);
            this.getJVMenu().notifyMenuStateEnable("Zoom Out", false);
            this.getJVMenu().notifyMenuStateSelected("FitToClientResolution", true);
        } else if (string.equals("FitToHostResolution")) {
            short s = this.getSocframeHdr().getresX();
            short s2 = this.getSocframeHdr().getresY();
            int n5 = JViewer.getMainFrame().getInsets().top + JViewerApp.getInstance().getM_wndFrame().getWindowMenu().getMenuBar().getHeight() + JViewerApp.getInstance().getM_wndFrame().getToolbar().getToolBar().getHeight() + JViewerApp.getInstance().getM_wndFrame().getToolbar().getToolBar().getInsets().top + JViewerApp.getInstance().getM_wndFrame().getToolbar().getToolBar().getInsets().bottom + JViewerApp.getInstance().getM_wndFrame().getM_status().getStatusBar().getHeight() + JViewerApp.getInstance().getM_wndFrame().getM_status().getStatusBar().getInsets().top + JViewerApp.getInstance().getM_wndFrame().getM_status().getStatusBar().getInsets().bottom;
            int n6 = JViewer.getMainFrame().getInsets().left + JViewer.getMainFrame().getInsets().left + this.getRCView().getInsets().left + this.getRCView().getInsets().right;
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            n4 = s + n6;
            n3 = s2 + n5;
            if (n4 + n2 < dimension2.width && n3 + n < dimension2.height) {
                this.getM_wndFrame().getToolbar().resetZoom();
                JViewer.getMainFrame().setLocation(point);
                JViewer.getMainFrame().setExtendedState(0);
                if (s >= 800 && s2 >= 600) {
                    JViewer.getMainFrame().setSize(n4, n3);
                } else {
                    JViewer.getMainFrame().setSize(800, 600);
                }
                JViewerApp.getInstance().getMainWindow().m_viewSP.setHorizontalScrollBarPolicy(31);
                JViewerApp.getInstance().getMainWindow().m_viewSP.setVerticalScrollBarPolicy(21);
                JViewer.getMainFrame().setResizable(false);
                this.setZoomOption(string);
                if (this.getRCView().GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                    this.getM_wndFrame().getToolbar().changeShowCursorOnZoom();
                }
                this.getM_wndFrame().getToolbar().enableZoomSlider(false);
                this.getJVMenu().notifyMenuStateEnable("Zoom In", false);
                this.getJVMenu().notifyMenuStateEnable("Zoom Out", false);
                this.getJVMenu().notifyMenuStateSelected("FitToHostResolution", true);
            }
        }
        this.getM_wndFrame().getM_status().resetStatus();
        this.m_wndFrame.setResizeFrame(false);
        JViewerApp.getInstance().setResolutionChanged(0);
    }

    public String getZoomOption() {
        return this.zoomOption;
    }

    public void setZoomOption(String string) {
        this.zoomOption = string;
    }

    public void onGetPowerControlStatus(byte by) {
        if (by == 1) {
            this.powerStatus = 1;
            try {
                this.getVidClnt().stopPsMonitorTaskAndTimer();
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                exception.printStackTrace();
            }
            if (JViewerApp.getInstance().getSoftKeyboard() != null) {
                JViewerApp.getInstance().getSoftKeyboard().OnUpdateKeyState(true);
            }
        } else if (by == 0) {
            this.powerStatus = 0;
            try {
                this.getVidClnt().startPsMonitorTaskAndTimer();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (JViewerApp.getInstance().getSoftKeyboard() != null) {
                JViewerApp.getInstance().getSoftKeyboard().OnUpdateKeyState(false);
            }
        }
        this.enablePowerControls(true);
    }

    public void onSendPowerControlCommand(String string) {
        if (!JViewer.isPowerPrivEnabled()) {
            return;
        }
        JVFrame jVFrame = JViewerApp.getInstance().getMainWindow();
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        int n = JOptionPane.showConfirmDialog(jVFrame, LocaleStrings.getString("D_43_JVAPP") + string + LocaleStrings.getString("D_44_JVAPP"), LocaleStrings.getString("D_45_JVAPP"), 0);
        if (n == 0) {
            this.enablePowerControls(false);
            if (JViewerApp.getInstance().getSoftKeyboard() != null) {
                JViewerApp.getInstance().getSoftKeyboard().OnUpdateKeyState(false);
            }
            if (string.equals("Reset Server")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)3);
            } else if (string.equals("Immediate Shutdown")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)0);
            } else if (string.equals("Orderly Shutdown")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)5);
            } else if (string.equals("Power On Server")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)1);
            } else if (string.equals("Power Cycle Server")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)2);
            }
        }
    }

    public void enablePowerControls(boolean bl) {
        JViewerApp.getOEMManager().getOEMJVMenu().enableMenuOnPowerControls();
        this.m_wndFrame.getToolbar().getPowerBtn().setEnabled(bl);
        if (bl) {
            if (this.powerStatus == 0) {
                String[] stringArray = new String[]{"VideoCaptureScreen", "VideoExit", "HelpAboutJViewer", "Power On Server", "DeviceMediaDialog", "VideoRecordSettings", "VideoRecordStart", "VideoRecordStop"};
                String[] stringArray2 = JViewerApp.getOEMManager().getOEMJVMenu().getOemPowerControlExceptionList();
                if (stringArray2 != null) {
                    String[] stringArray3 = new String[stringArray.length + stringArray2.length];
                    System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                    System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
                    this.m_frame.getMenu().enableMenu(stringArray3, false, false);
                } else {
                    this.m_frame.getMenu().enableMenu(stringArray, false, false);
                }
                this.m_wndFrame.getToolbar().turnOnPowerButton(false);
                if (KVMSharing.KVM_REQ_GIVEN == 2) {
                    this.m_frame.getMenu().notifyMenuStateEnable("Power On Server", false);
                    this.m_frame.getMenu().notifyMenuStateEnable("DeviceMediaDialog", false);
                } else {
                    this.m_frame.getMenu().notifyMenuStateEnable("Power On Server", true);
                    this.m_frame.getMenu().notifyMenuStateEnable("DeviceMediaDialog", true);
                    this.m_wndFrame.getToolbar().setButtonEnabled(this.m_wndFrame.getToolbar().getPowerBtn(), true);
                }
                this.m_wndFrame.getToolbar().changeToolbarButtonStateOnPowerStatus(false);
            } else if (this.m_RedirectionState == REDIR_STARTED) {
                this.changeMenuItemsStatusOnPauseResume(this.m_frame.getMenu(), true);
                this.m_wndFrame.getToolbar().changeToolbarButtonStateOnPowerStatus(true);
                this.m_frame.getMenu().notifyMenuStateEnable("Power On Server", false);
                this.m_wndFrame.getToolbar().turnOnPowerButton(true);
                this.getVidClnt().setZoomOptionStatus();
            }
        }
    }

    public void onPowerControlResponse(byte by) {
        if (by != 0) {
            InfoDialog.showDialog((Component)JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("D_46_JVAPP"), LocaleStrings.getString("D_45_JVAPP"), 2);
        } else {
            InfoDialog.showDialog((Component)JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("D_47_JVAPP"), LocaleStrings.getString("D_45_JVAPP"), 1);
        }
        this.enablePowerControls(true);
    }

    public Mousecaliberation getMousecaliberation() {
        return this.Mousecaliberation;
    }

    public void setMousecaliberation(Mousecaliberation mousecaliberation) {
        this.Mousecaliberation = mousecaliberation;
    }

    public int getM_cdStatus() {
        return this.m_cdStatus;
    }

    public int getM_hdStatus() {
        return this.m_hdStatus;
    }

    public void setM_cdStatus(int n) {
        this.m_cdStatus = n;
    }

    public void setM_hdStatus(int n) {
        this.m_hdStatus = n;
    }

    public String getMessage() {
        return this.Message;
    }

    public void setMessage(String string) {
        this.Message = string;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public void setServerIP(String string) {
        this.serverIP = string;
    }

    public VideoRecordApp getVideorecordapp() {
        return this.videorecordapp;
    }

    public void setVideorecordapp(VideoRecordApp videoRecordApp) {
        this.videorecordapp = videoRecordApp;
    }

    public int getM_hdPort() {
        return this.m_hdPort;
    }

    public void setM_hdPort(int n) {
        this.m_hdPort = n;
    }

    public int getM_cdPort() {
        return this.m_cdPort;
    }

    public void setM_cdPort(int n) {
        this.m_cdPort = n;
    }

    public boolean isM_bVMUseSSL() {
        return this.m_bVMUseSSL;
    }

    public void setM_bVMUseSSL(boolean bl) {
        this.m_bVMUseSSL = bl;
    }

    public boolean isFullKeyboardEnabled() {
        return this.fullKeyboardEnabled;
    }

    public void setFullKeyboardEnabled(boolean bl) {
        this.fullKeyboardEnabled = bl;
    }

    public boolean isFullPermissionRequest() {
        return this.fullPermissionRequest;
    }

    public void setFullPermissionRequest(boolean bl) {
        this.fullPermissionRequest = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncVMediaRedirection() {
        int n;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        n2 = VMApp.getInstance().getNumCD();
        n3 = VMApp.getInstance().getNumHD();
        Object object = CDROMRedir.getSyncObj();
        synchronized (object) {
            for (n = 0; n < n2; ++n) {
                if (VMApp.getInstance().getIUSBRedirSession().getCdromSession(n) == null) continue;
                VMApp.getInstance().getIUSBRedirSession().getCdromSession(n).setConfModified(true);
                if (!VMApp.getInstance().getIUSBRedirSession().getCdromSession(n).isRedirActive()) continue;
                bl = true;
            }
            CDROMRedir.getSyncObj().notifyAll();
        }
        object = HarddiskRedir.getSyncObj();
        synchronized (object) {
            for (n = 0; n < n3; ++n) {
                if (VMApp.getInstance().getIUSBRedirSession().getHarddiskSession(n) == null) continue;
                VMApp.getInstance().getIUSBRedirSession().getHarddiskSession(n).setConfModified(true);
                if (!VMApp.getInstance().getIUSBRedirSession().getHarddiskSession(n).isRedirActive()) continue;
                bl = true;
            }
            HarddiskRedir.getSyncObj().notifyAll();
        }
        return bl;
    }

    public void OnSendMouseMode(byte by) {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        if (this.m_KVMClnt.SendMouseMode(by) == 1) {
            Debug.out.println("Mouse mode send failured");
        }
        Debug.out.println("Mouse mode send success");
    }

    public void OnSelectKVMMaster() {
        if (KVMClient.getNumUsers() > 1 && KVMSharing.KVM_REQ_GIVEN == 0) {
            if (this.kVMDialog == null) {
                this.kVMDialog = new KVMShareDialog();
            }
            this.kVMDialog.constructDialog((byte)1);
            this.kVMDialog.showDialog();
        }
    }

    public KVMShareDialog getKVMShareDialog() {
        return this.kVMDialog;
    }

    public Hashtable<String, JDialog> getResponseDialogTable() {
        return this.responseDialogTable;
    }

    public void initResponseDialogTable() {
        if (this.responseDialogTable == null) {
            this.responseDialogTable = new Hashtable();
        }
    }

    public void setKVMDialog(KVMShareDialog kVMShareDialog) {
        this.kVMDialog = kVMShareDialog;
    }

    public void sendSelectedMasterInfo(String string) {
        ByteBuffer byteBuffer = this.getKVMClient().getUserDataPacket().createUserDataBuffer(string);
        this.getKVMClient().sendNextMasterInfo(byteBuffer);
    }

    private void onKVMFullPermission() {
        this.getJVMenu().getMenu("SoftKeyboard").setEnabled(true);
        JViewerApp.getInstance().getM_wndFrame().getToolbar().getKbdBtn().setEnabled(this.getJVMenu().getMenuItem("SKBD_English(United States)").isEnabled());
        JViewerApp.getInstance().getM_wndFrame().getM_status().enableStatusBar(true);
        KVMRequestDialogThread kVMRequestDialogThread = null;
        kVMRequestDialogThread = new KVMRequestDialogThread();
        if (KVMSharing.KVM_CLIENT_USERNAME != null && KVMSharing.KVM_CLIENT_IP != null) {
            if (KVMSharing.KVM_REQ_GIVEN != 0) {
                this.setMessage(LocaleStrings.getString("D_38_JVAPP") + KVMSharing.KVM_CLIENT_USERNAME + LocaleStrings.getString("D_39_JVAPP") + KVMSharing.KVM_CLIENT_IP);
            }
        } else if (this.getKVMShareDialog() != null) {
            this.setMessage(LocaleStrings.getString("D_51_JVAPP"));
        }
        if (this.getMessage() != null && this.getMessage().length() > 0) {
            kVMRequestDialogThread.start();
        }
        KVMSharing.KVM_REQ_GIVEN = 0;
        KVMShareDialog.isMasterSession = true;
        if (this.isFullPermissionRequest()) {
            JViewerApp.getInstance().getJVMenu().removeFullPermissionMenuItem();
            JViewerApp.getInstance().getJVMenu().addBlockPermissionMenuItem();
            this.m_KVMClnt.sendGetUserMacro();
            if (this.m_wndMode) {
                this.OnChangeMenuState_KVMPartial(this.getM_wndFrame().getMenu(), true);
                this.getM_wndFrame().getToolbar().OnChangeToolbarIconState_KVMPartial();
            } else {
                this.OnChangeMenuState_KVMPartial(this.getM_fsFrame().getMenu(), true);
            }
        }
        this.getM_frame().onStopVMediaRedirection(1);
    }

    private void onKVMPartialPermission(byte by) {
        byte by2 = by == 6 ? (byte)2 : (byte)by;
        Debug.out.println(" onKVMPartialPermissionpermission: permission" + by + "  kvmpermission:" + by2);
        JViewerApp.getOEMManager().getOEMKvmClient().enableMenuOnKVMPartialPermission(by2);
        if (by2 == 2) {
            KVMRequestDialogThread kVMRequestDialogThread = null;
            kVMRequestDialogThread = new KVMRequestDialogThread();
            if (KVMSharing.KVM_REQ_GIVEN == 0) {
                this.getM_frame().onStopVMediaRedirection(0);
                this.setMessage(LocaleStrings.getString("D_57_JVAPP") + KVMSharing.KVM_CLIENT_USERNAME + LocaleStrings.getString("D_39_JVAPP") + KVMSharing.KVM_CLIENT_IP);
            } else if (by == 6) {
                this.setMessage(LocaleStrings.getString("D_67_JVAPP") + "\n" + LocaleStrings.getString("D_40_JVAPP") + KVMSharing.KVM_CLIENT_USERNAME + LocaleStrings.getString("D_39_JVAPP") + KVMSharing.KVM_CLIENT_IP);
            } else {
                this.setMessage(LocaleStrings.getString("D_40_JVAPP") + KVMSharing.KVM_CLIENT_USERNAME + LocaleStrings.getString("D_39_JVAPP") + KVMSharing.KVM_CLIENT_IP);
            }
            kVMRequestDialogThread.start();
        }
        KVMSharing.KVM_REQ_GIVEN = (byte)2;
        KVMShareDialog.isMasterSession = false;
        if (this.getVMDialog() != null && this.getVMDialog().isShowing()) {
            this.getVMDialog().disposeVMDialog();
        }
        if (this.getSoftKeyboard() != null) {
            this.getSoftKeyboard().closeSoftKeyboard();
        }
        if (this.m_wndMode) {
            this.OnChangeMenuState_KVMPartial(this.getM_wndFrame().getMenu(), false);
            this.getM_wndFrame().getToolbar().OnChangeToolbarIconState_KVMPartial();
        } else {
            this.OnChangeMenuState_KVMPartial(this.getM_fsFrame().getMenu(), false);
        }
        if (this.isFullPermissionRequest()) {
            this.setFullPermissionRequest(false);
        } else {
            this.getJVMenu().removeBlockPermissionMenuItem();
            this.getJVMenu().addFullPermissionMenuItem();
        }
        JViewerApp.getInstance().getJVMenu().getMenu("SoftKeyboard").setEnabled(false);
        JViewerApp.getInstance().getM_wndFrame().getToolbar().getKbdBtn().setEnabled(false);
        JViewerApp.getInstance().getM_wndFrame().getM_status().enableStatusBar(false);
        JViewerApp.getInstance().getJVMenu().getMenuItem("RequestFullPermission").setEnabled(true);
    }

    public void onSendHostLock(byte by) {
        this.m_KVMClnt.onSendLockScreen(by);
        this.changeHostDisplayLockStatus(by);
    }

    public void changeHostDisplayLockStatus(short s) {
        this.getJVMenu().notifyMenuStateEnable("VideoHostDisplayLock", false);
        this.getJVMenu().notifyMenuStateEnable("VideoHostDisplayUnlock", false);
        if (s == 0 || s == 2) {
            if (s == 0) {
                this.getJVMenu().notifyMenuStateEnable("VideoHostDisplayLock", true);
            }
            this.getM_wndFrame().getToolbar().turnOnHostDisplayButton(true);
            this.getJVMenu().getMenuItem("VideoHostDisplayLock").setMnemonic('n');
            this.getJVMenu().getMenuItem("VideoHostDisplayLock").setAccelerator(KeyStroke.getKeyStroke(78, 8));
            this.getJVMenu();
            JVMenu.getMenuMnemonics().put("VideoHostDisplayLock", Character.valueOf('n'));
            this.getJVMenu();
            JVMenu.getMenuAccelerator().put("VideoHostDisplayLock", KeyStroke.getKeyStroke(78, 8));
            this.getJVMenu().getMenuItem("VideoHostDisplayUnlock").setMnemonic('\u0000');
            this.getJVMenu().getMenuItem("VideoHostDisplayUnlock").setAccelerator(null);
            this.getJVMenu();
            JVMenu.getMenuMnemonics().remove("VideoHostDisplayUnlock");
            this.getJVMenu();
            JVMenu.getMenuAccelerator().remove("VideoHostDisplayUnlock");
        } else if (s == 1 || s == 3) {
            if (s == 1) {
                this.getJVMenu().notifyMenuStateEnable("VideoHostDisplayUnlock", true);
            }
            this.getM_wndFrame().getToolbar().turnOnHostDisplayButton(false);
            this.getJVMenu().getMenuItem("VideoHostDisplayUnlock").setMnemonic('n');
            this.getJVMenu().getMenuItem("VideoHostDisplayUnlock").setAccelerator(KeyStroke.getKeyStroke(78, 8));
            this.getJVMenu();
            JVMenu.getMenuMnemonics().put("VideoHostDisplayUnlock", Character.valueOf('n'));
            this.getJVMenu();
            JVMenu.getMenuAccelerator().put("VideoHostDisplayUnlock", KeyStroke.getKeyStroke(78, 8));
            this.getJVMenu().getMenuItem("VideoHostDisplayLock").setMnemonic('\u0000');
            this.getJVMenu().getMenuItem("VideoHostDisplayLock").setAccelerator(null);
            this.getJVMenu();
            JVMenu.getMenuMnemonics().remove("VideoHostDisplayLock");
            this.getJVMenu();
            JVMenu.getMenuAccelerator().remove("VideoHostDisplayLock");
        }
        if (KVMSharing.KVM_REQ_GIVEN == 2 || this.powerStatus == 0) {
            this.getJVMenu().notifyMenuStateEnable("VideoHostDisplayUnlock", false);
            this.getJVMenu().notifyMenuStateEnable("VideoHostDisplayLock", false);
        }
    }

    public String[] getExceptionMenuList(String[] stringArray) {
        String[] stringArray2 = JVMenu.KVMPartialExceptionSOCMenuItems;
        String[] stringArray3 = JVMenu.KVMPartialExceptionOEMMenuItems;
        String[] stringArray4 = null;
        if (stringArray2 != null && stringArray3 != null) {
            stringArray4 = new String[stringArray.length + stringArray2.length + stringArray3.length];
            System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray4, stringArray.length, stringArray2.length);
            System.arraycopy(stringArray3, 0, stringArray4, stringArray.length + stringArray2.length, stringArray3.length);
        } else if (stringArray2 != null) {
            stringArray4 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray4, stringArray.length, stringArray2.length);
        } else if (stringArray3 != null) {
            stringArray4 = new String[stringArray.length + stringArray3.length];
            System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
            System.arraycopy(stringArray3, 0, stringArray4, stringArray.length, stringArray3.length);
        } else {
            return stringArray;
        }
        return stringArray4;
    }

    public void onMediaLicenseStatus(byte by) {
        Debug.out.println("ON MEDIA LICENSE STATE : " + by);
        Debug.out.println("CURRENT MEDIA LICENSE STATUS : " + JViewer.getMediaLicenseStatus());
        if (JViewer.getMediaLicenseStatus() != by) {
            JViewer.setMediaLicenseStatus(by);
            if (JViewerApp.getInstance().IsCDROMRedirRunning() || JViewerApp.getInstance().IsHarddiskRedirRunning()) {
                this.getM_frame().stopVMediaRedirection(LocaleStrings.getString("D_60_JVAPP"));
            }
        }
    }

    public String getClientUserName() {
        String string = "";
        String string2 = "";
        String string3 = null;
        string2 = System.getProperty("user.name");
        if (System.getProperty("os.name").startsWith("Windows")) {
            string3 = System.getenv("USERDOMAIN");
            string3 = string3.trim();
        }
        string = string3 != null && string3.length() > 0 ? string3 + "\\" + string2 : string2;
        return string;
    }

    public void confirmationDialogResponse(int n) {
        if (n == 0) {
            this.m_KVMClnt.sendKeyBoardLang();
        }
    }

    public int getFreeCDNum() {
        return this.freeCDNum;
    }

    public void setFreeCDNum(int n) {
        this.freeCDNum = n;
        VMApp.getInstance().setFreeCDNum(n);
    }

    public int getFreeHDNum() {
        return this.freeHDNum;
    }

    public void setFreeHDNum(int n) {
        this.freeHDNum = n;
        VMApp.getInstance().setFreeHDNum(n);
    }

    public void updateFreeDeviceStatus() {
        if (this.vmDialog != null) {
            VMApp.getVMPane().updateFreeDeviceStatus(0);
            VMApp.getVMPane().updateFreeDeviceStatus(2);
        }
    }

    public boolean isRenderFitToHost() {
        return this.renderFitToHost;
    }

    public void setRenderFitToHost(boolean bl) {
        this.renderFitToHost = bl;
    }

    public int getCurrentSessionId() {
        return this.currentSessionId;
    }

    public void setCurrentSessionId(int n) {
        this.currentSessionId = n;
    }

    public String getMacAddress(int n, String[] stringArray) throws Exception {
        String string;
        String string2 = null;
        String string3 = "ifconfig";
        if (n == 2 && stringArray.length <= 0) {
            return null;
        }
        String string4 = System.getProperty("os.name");
        if (string4.startsWith("Windows")) {
            string3 = "ipconfig /all";
        } else if (string4.startsWith("Linux") || string4.startsWith("Mac")) {
            string3 = "/sbin/ifconfig -a";
        } else {
            Debug.out.println("The current operating system '" + string4 + "' is not supported.");
            return null;
        }
        Process process = Runtime.getRuntime().exec(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Pattern pattern = Pattern.compile("([\\w]{1,2}(-|:)){5}[\\w]{1,2}");
        while (!((string = bufferedReader.readLine()) == null || n == 1 && string.contains(KVMSharing.KVM_CLIENT_OWN_IP) && string2 != null)) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group();
            if (string2.contains(":")) {
                string2 = string2.replaceAll(":", "-");
            }
            if (n != 2) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || string2.compareToIgnoreCase("00-00-00-00-00-00") == 0 || stringArray[i].compareToIgnoreCase(string2) != 0) continue;
                return null;
            }
        }
        bufferedReader.close();
        return string2;
    }

    public long getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTimeInMillis();
    }

    public void setLocalport(int n) {
        this.localport = n;
    }

    public int getLocalport() {
        return this.localport;
    }

    public long getLastPckSent() {
        return this.lastPcktSent;
    }

    public void setLastPckSent() {
        this.lastPcktSent = this.getCurrentTime();
    }

    public void setLastPcktRecvd() {
        this.lastPcktRecvd = this.getCurrentTime();
    }

    public long getLastPcktRecvd() {
        return this.lastPcktRecvd;
    }

    public boolean getSessionLive() {
        return this.sessionLive;
    }

    public void setSessionLive(boolean bl) {
        this.sessionLive = bl;
    }

    public boolean getRetryConnection() {
        return this.retryConnection;
    }

    public void setRetryConnection(boolean bl) {
        this.retryConnection = bl;
    }

    public void onConnFailed() {
        this.m_RedirectionState = REDIR_STOPPED;
        if (!JViewer.isWebPreviewer() && !JViewer.isBSODViewer()) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.getString("D_3_JVAPP"), LocaleStrings.getString("D_4_JVAPP"), 0);
            JViewerApp.getInstance().getM_frame().windowClosed();
        } else {
            JViewerApp.getInstance().setWebPreviewerCaptureStatus(WEB_PREVIEWER_CONNECT_FAILURE);
        }
    }

    public boolean isLinuxClient() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public boolean isWindowsClient() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public boolean isMacClient() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public String getResolutionStatus() {
        return this.resolutionStatus;
    }

    public void setBPPString(String string) {
        this.bppString = string != null && string != " " ? " - " + string : "";
    }

    public String getBPPString() {
        return this.bppString;
    }

    public void setResolutionStatus(int n, int n2) {
        this.resolutionStatus = n <= 0 || n2 <= 0 ? null : n + " x " + n2;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public static IOEMManager getOEMManager() {
        return oemManager;
    }

    public int getResolutionChanged() {
        return this.resolutionChanged;
    }

    public void setResolutionChanged(int n) {
        this.resolutionChanged = n;
    }

    public String getIpmiPrivText(int n) {
        String string = null;
        if (n == this.PRIV_LEVEL_ADMIN) {
            string = LocaleStrings.getString("H_15_KVMS");
        } else if (n == this.PRIV_LEVEL_USER) {
            string = LocaleStrings.getString("H_16_KVMS");
        } else if (n == this.PRIV_LEVEL_OPERATOR) {
            string = LocaleStrings.getString("H_17_KVMS");
        } else if (n == this.PRIV_LEVEL_PROPRIETARY) {
            string = LocaleStrings.getString("H_18_KVMS");
        }
        return string;
    }

    public FrameRateTask getFrameRateTask() {
        return this.frameRateTask;
    }

    public void setFrameRateTask(FrameRateTask frameRateTask) {
        this.frameRateTask = frameRateTask;
    }

    public void setSinglePortKvm(SinglePortKVM singlePortKVM) {
        this.singlePortKvm = singlePortKVM;
    }

    public InfoDialog getHidInitDialog() {
        return this.hidInitDialog;
    }

    public void setHidInitDialog(InfoDialog infoDialog) {
        this.hidInitDialog = infoDialog;
    }

    private boolean validateSessionToken() {
        boolean bl = true;
        URLProcessor uRLProcessor = new URLProcessor(JViewer.getWebSessionToken(), 1);
        int n = uRLProcessor.processRequest(JViewer.getProtocol() + "://" + JViewer.getIp() + ":" + 443 + "/rpc/WEBSES/validate.asp");
        try {
            if (n == 2) {
                bl = false;
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        return bl;
    }

    public int getCurrentRetryCount() {
        return this.currentRetryCount;
    }

    public void setCurrentRetryCount(int n) {
        this.currentRetryCount = n;
    }

    static {
        WEB_PREVIEWER_CAPTURE_SUCCESS = 0;
        WEB_PREVIEWER_CAPTURE_FAILURE = (byte)-1;
        WEB_PREVIEWER_CAPTURE_IN_PROGRESS = (byte)-2;
        WEB_PREVIEWER_CONNECT_FAILURE = (byte)-3;
        WEB_PREVIEWER_INVALID_SERVERIP = (byte)-4;
        WEB_PREVIEWER_HOST_POWER_OFF = (byte)-5;
        WEB_PREVIEWER_INVALID_WEBPORT = (byte)-6;
        WEB_PREVIEWER_INVALID_WEBSECURE = (byte)-7;
        m_webPreviewer_cap_status = WEB_PREVIEWER_CAPTURE_IN_PROGRESS;
        showCursor = false;
        REDIR_STOPPED = 0;
        REDIR_STARTING = 1;
        REDIR_STARTED = 2;
        REDIR_STOPPING = 3;
        REDIR_PAUSING = 4;
    }
}

