/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JVStatusBar;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.hid.KeyProcessor;
import com.ami.kvm.jviewer.hid.USBKeyProcessorEnglish;
import com.ami.kvm.jviewer.hid.USBKeyboardRep;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class JViewerView
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_VIEW_WIDTH = 1600;
    public static final int DEFAULT_VIEW_HEIGHT = 1200;
    public static float MOUSE_ACCELERATION = 2.0f;
    public static int ACCEL_THRESHOLD = 4;
    public static boolean firsttime = true;
    public static float RemainingX = 0.0f;
    public static float RemainingY = 0.0f;
    public static boolean Lost_focus_flag = false;
    public static int Mouse_X = 0;
    public static int Mouse_Y = 0;
    private int m_act_width;
    private int m_act_height;
    private short m_cur_width;
    private short m_cur_height;
    private int m_width;
    private int m_height;
    public RCMouseListener m_mouseListener;
    public RCKeyListener m_keyListener;
    public RCFocusListener m_focuslistener;
    public RCMouseWheelListener m_mousewheelListener;
    public static boolean syncLEDFlag = false;
    private USBKeyboardRep m_USBKeyRep;
    private USBMouseRep m_USBMouseRep;
    byte m_USBMouseMode = USBMouseRep.INVALID_MOUSE_MODE;
    private boolean initMouseMode = true;
    public static final int NUMLOCK = 1;
    public static final int CAPSLOCK = 2;
    public static final int SCROLLLOCK = 4;
    private int lastX = -1;
    private int lastY = -1;
    public Robot robbie;
    private int curX = 0;
    private int curY = 0;
    private boolean m_bLeftCtrlDown = false;
    private boolean m_bRightCtrlDown = false;
    private boolean m_bMouseRedirRunning = false;
    private short keyPressedFlag = 0;
    private BufferedImage localImage = new BufferedImage(1600, 1200, 1);
    private BufferedImage invisCursorImg = null;
    private Cursor invisibleCursor = null;
    public MouseEvent mouse_event;
    public MouseEvent sentmouse_event;
    public Thread mouse_thread;
    private Timer m_mouseTmr;
    private byte[] bdata;
    private int keyCode;
    private int keyLocation;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private boolean mouseCursorOut = false;
    private boolean isCtrlPressed = false;
    private int ctrlKeyLocation;

    public JViewerView(int n, int n2) {
        if (JViewer.isjviewerapp() || JViewer.isStandAloneApp()) {
            this.m_USBKeyRep = new USBKeyboardRep();
            this.m_USBMouseRep = new USBMouseRep();
            this.m_mouseListener = new RCMouseListener();
            this.m_keyListener = new RCKeyListener();
            this.m_focuslistener = new RCFocusListener();
            this.m_mousewheelListener = new RCMouseWheelListener();
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(false);
            this.addFocusListener(new RCFocusListener());
            this.addMouseWheelListener(new RCMouseWheelListener());
            this.m_mouseTmr = new Timer();
            this.m_mouseTmr.schedule((TimerTask)new MousesendTask(), 0L, 60L);
        }
    }

    public void addKMListeners() {
        if (JViewerApp.getInstance().getHidInitDialog() != null) {
            return;
        }
        this.addKeyListener();
        this.addMouseListeners();
    }

    public void addKeyListener() {
        if (JViewerApp.getInstance().getHidInitDialog() != null) {
            return;
        }
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            return;
        }
        KeyListener[] keyListenerArray = this.getKeyListeners();
        if (keyListenerArray.length == 0) {
            this.setkeyprocessor();
            this.addKeyListener(this.m_keyListener);
        }
    }

    public void setkeyprocessor() {
        KeyProcessor keyProcessor = JViewerApp.getInstance().getKeyProcesssor();
        JViewerApp.getInstance().getKeyProcesssor().setAutoKeybreakMode(true);
        this.m_USBKeyRep.setM_USBKeyProcessor(keyProcessor);
    }

    public void removeKeyListener() {
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            return;
        }
        this.removeKeyListener(this.m_keyListener);
        JViewerApp.getInstance().getM_wndFrame().getWindowMenu().getMenuBar().getInputMap(2).put(KeyStroke.getKeyStroke(121, 0), "none");
    }

    public void flushHID() {
        KeyEvent keyEvent = new KeyEvent(this, 401, new Date().getTime(), 130, 17, '0');
        this.m_keyListener.keyPressed(keyEvent);
        keyEvent = new KeyEvent(this, 401, new Date().getTime(), 0, 17, '0');
        this.m_keyListener.keyReleased(keyEvent);
    }

    public void removeKMListener() {
        this.removeKeyListener(this.m_keyListener);
        this.removeMouseListeners();
    }

    public void addMouseListeners() {
        if (JViewerApp.getInstance().getHidInitDialog() != null) {
            return;
        }
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            return;
        }
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        if (mouseListenerArray.length == 0) {
            this.addMouseListener(this.m_mouseListener);
        }
        if (mouseMotionListenerArray.length == 0) {
            this.addMouseMotionListener(this.m_mouseListener);
        }
    }

    public void removeMouseListeners() {
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            return;
        }
        this.removeMouseListener(this.m_mouseListener);
        this.removeMouseMotionListener(this.m_mouseListener);
    }

    public int viewWidth() {
        return this.m_width;
    }

    public int viewHeight() {
        return this.m_height;
    }

    public void setRCView(int n, int n2, int n3) {
        this.m_width = n;
        this.m_act_width = JViewerApp.getInstance().getSocframeHdr().getwidth();
        this.m_act_height = this.m_height = n2;
        this.m_cur_width = JViewerApp.getInstance().getSocframeHdr().getcurwidth();
        this.m_cur_height = JViewerApp.getInstance().getSocframeHdr().getcurheight();
        Debug.out.println("View - width: " + this.m_width + " height: " + this.m_height);
        this.setSize(n, n2);
        this.setPreferredSize(new Dimension(n, n2));
        this.setMaximumSize(new Dimension(n, n2));
        JViewerApp.getInstance().getPrepare_buf().prepareBufImage(n, n2, n3);
    }

    public short getM_cur_width() {
        return this.m_cur_width;
    }

    public void setM_cur_width(int n) {
        this.m_cur_width = (short)n;
    }

    public short getM_cur_height() {
        return this.m_cur_height;
    }

    public void setM_cur_height(int n) {
        this.m_cur_height = (short)n;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public Dimension getPreferredSize() {
        BufferedImage bufferedImage = JViewerApp.getInstance().getPrepare_buf().getM_image();
        if (bufferedImage != null) {
            return new Dimension((int)((double)bufferedImage.getWidth(this) + (double)bufferedImage.getWidth(this) * (this.scaleX - 1.0)), (int)((double)bufferedImage.getHeight(this) + (double)bufferedImage.getHeight(this) * (this.scaleY - 1.0)));
        }
        return new Dimension(1024, 768);
    }

    @Override
    public void paint(Graphics graphics) {
        block11: {
            try {
                BufferedImage bufferedImage = JViewerApp.getInstance().getPrepare_buf().getM_image();
                if (bufferedImage == null) {
                    return;
                }
                this.localImage = bufferedImage;
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (bufferedImage.getType() == 8) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                AffineTransform affineTransform = null;
                Dimension dimension = JViewerApp.getInstance().getCurrentMonitorResolution();
                Dimension dimension2 = JViewerApp.getInstance().getMainWindow().m_viewSP.getSize();
                if (this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE || JViewerApp.getInstance().getZoomOption() == "FitToClientResolution") {
                    this.scaleX = 1.0;
                    this.scaleY = 1.0;
                    if (bufferedImage.getWidth() >= dimension2.width || bufferedImage.getWidth() >= dimension.width) {
                        this.scaleX = (double)dimension2.width / (double)bufferedImage.getWidth();
                    }
                    if (bufferedImage.getHeight() >= dimension2.height || bufferedImage.getHeight() >= dimension.height) {
                        this.scaleY = (double)dimension2.height / (double)bufferedImage.getHeight();
                    }
                }
                affineTransform = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                if (JViewer.isdownloadapp()) {
                    return;
                }
                graphics2D.drawImage(bufferedImage, affineTransform, this);
                if (this.m_USBMouseMode != USBMouseRep.RELATIVE_MOUSE_MODE) break block11;
                JViewerApp.getInstance();
                if (!JViewerApp.showCursor || Mouse_X > this.m_width || Mouse_Y > this.m_height) break block11;
                URL uRL = JViewer.class.getResource("res/cursor.gif");
                BufferedImage bufferedImage2 = null;
                try {
                    bufferedImage2 = ImageIO.read(uRL);
                }
                catch (IOException iOException) {
                    Debug.out.println(iOException);
                }
                graphics.drawImage(bufferedImage2, Mouse_X, Mouse_Y, null);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    public void ShowCursor(boolean bl) {
        if (this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
            Mouse_X = 0;
            Mouse_Y = 0;
            if (this.robbie == null) {
                try {
                    this.robbie = new Robot();
                }
                catch (AWTException aWTException) {
                    this.robbie = null;
                    return;
                }
            }
            Mousecaliberation.resetCursor();
            if (this.invisCursorImg == null) {
                this.invisCursorImg = this.createInvisibleCursor();
            }
            if (this.invisibleCursor == null) {
                this.invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.invisCursorImg, new Point(0, 0), "Invisible Cursor");
            }
            this.setCursor(this.invisibleCursor);
            return;
        }
        if (this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE) {
            if (bl) {
                if (this.robbie == null) {
                    try {
                        this.robbie = new Robot();
                    }
                    catch (AWTException aWTException) {
                        Debug.out.println(aWTException);
                        this.robbie = null;
                        return;
                    }
                }
                JVStatusBar.OTHER_MOUISE_MODE_MSG = LocaleStrings.getString("E_1_JVIEW") + LocaleStrings.getString("E_7_JVIEW") + LocaleStrings.getString("E_2_JVIEW");
                JViewerApp.getInstance().getM_wndFrame().getM_status().resetStatus();
                if (this.invisCursorImg == null) {
                    this.invisCursorImg = this.createInvisibleCursor();
                }
                if (this.invisibleCursor == null) {
                    this.invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.invisCursorImg, new Point(0, 0), "Invisible Cursor");
                }
                this.setCursor(this.invisibleCursor);
            } else {
                this.setCursor(null);
                JVStatusBar.OTHER_MOUISE_MODE_MSG = LocaleStrings.getString("E_1_JVIEW") + LocaleStrings.getString("E_7_JVIEW") + LocaleStrings.getString("E_3_JVIEW");
                JViewerApp.getInstance().getM_wndFrame().getM_status().resetStatus();
            }
            return;
        }
        if (bl) {
            if (this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                Mousecaliberation.resetCursor();
            } else {
                this.setCursor(null);
            }
        } else {
            if (this.invisCursorImg == null) {
                this.invisCursorImg = this.createInvisibleCursor();
            }
            if (this.invisibleCursor == null) {
                this.invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.invisCursorImg, new Point(0, 0), "Invisible Cursor");
            }
            this.setCursor(this.invisibleCursor);
        }
    }

    public void SetUSBMouseMode(byte by) {
        if (this.initMouseMode) {
            this.initMouseMode = false;
        } else {
            InfoDialog.showDialog(JViewer.getMainFrame(), LocaleStrings.getString("E_6_JVIEW"), 5000L);
        }
        this.m_USBMouseMode = by;
        JVMenu.m_mouseMode = by;
    }

    public byte GetUSBMouseMode() {
        return this.m_USBMouseMode;
    }

    public BufferedImage getImage() {
        return this.localImage;
    }

    public void mouse_resync_linux_mode(int n, int n2) {
        if (Lost_focus_flag) {
            return;
        }
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            this.m_mouseListener.splitandsend(-this.m_width, -this.m_height, true);
        } else {
            this.m_mouseListener.splitandsend_Move(-this.m_width, -this.m_height, true);
        }
        Mouse_X = 0;
        Mouse_Y = 0;
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        this.lastX = (int)point.getX();
        this.lastY = (int)point.getY();
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            this.m_mouseListener.splitandsend(this.lastX, this.lastY, true);
        } else {
            this.m_mouseListener.splitandsend_Move(this.lastX, this.lastY, true);
        }
    }

    public boolean USBsyncCursor(boolean bl) {
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            return false;
        }
        if (bl) {
            if (this.m_bMouseRedirRunning) {
                return true;
            }
            if (this.m_USBMouseMode == USBMouseRep.INVALID_MOUSE_MODE) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage(LocaleStrings.getString("E_4_JVIEW"), LocaleStrings.getString("E_5_JVIEW"));
                return false;
            }
            this.addMouseListeners();
            this.m_bMouseRedirRunning = true;
        } else {
            this.removeMouseListeners();
            this.m_bMouseRedirRunning = false;
        }
        return true;
    }

    public boolean getMouseRedirStatus() {
        return this.m_bMouseRedirRunning;
    }

    public USBKeyboardRep getM_USBKeyRep() {
        return this.m_USBKeyRep;
    }

    public void setM_USBKeyRep(USBKeyboardRep uSBKeyboardRep) {
        this.m_USBKeyRep = uSBKeyboardRep;
    }

    public MouseEvent getMouse_event() {
        return this.mouse_event;
    }

    public void setMouse_event(MouseEvent mouseEvent) {
        this.mouse_event = mouseEvent;
    }

    public USBMouseRep getM_USBMouseRep() {
        return this.m_USBMouseRep;
    }

    public void setM_USBMouseRep(USBMouseRep uSBMouseRep) {
        this.m_USBMouseRep = uSBMouseRep;
    }

    public MouseEvent getSentmouse_event() {
        return this.sentmouse_event;
    }

    public void setSentmouse_event(MouseEvent mouseEvent) {
        this.sentmouse_event = mouseEvent;
    }

    private Point calculateCenter() {
        Point point = JViewerApp.getInstance().getRCView().getLocationOnScreen();
        Point point2 = new Point((this.m_cur_width + point.x) / 2, (this.m_cur_height + point.y) / 2);
        return point2;
    }

    public void setScaleFactor(double d, double d2) {
        this.scaleX = d;
        this.scaleY = d2;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(double d) {
        this.scaleX = d;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(double d) {
        this.scaleY = d;
    }

    public boolean isMouseCursorOut() {
        return this.mouseCursorOut;
    }

    public void setMouseCursorOut(boolean bl) {
        this.mouseCursorOut = bl;
    }

    public BufferedImage createInvisibleCursor() {
        BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(1, 0.0f);
        graphics2D.setComposite(alphaComposite);
        return bufferedImage;
    }

    public boolean isCtrlPressed() {
        return this.isCtrlPressed;
    }

    public void setCtrlPressed(boolean bl) {
        this.isCtrlPressed = bl;
    }

    public int getCtrlKeyLocation() {
        return this.ctrlKeyLocation;
    }

    public void setCtrlKeyLocation(int n) {
        this.ctrlKeyLocation = n;
    }

    static /* synthetic */ byte[] access$102(JViewerView jViewerView, byte[] byArray) {
        jViewerView.bdata = byArray;
        return byArray;
    }

    static /* synthetic */ short access$408(JViewerView jViewerView) {
        short s = jViewerView.keyPressedFlag;
        jViewerView.keyPressedFlag = (short)(s + 1);
        return s;
    }

    static /* synthetic */ short access$410(JViewerView jViewerView) {
        short s = jViewerView.keyPressedFlag;
        jViewerView.keyPressedFlag = (short)(s - 1);
        return s;
    }

    class MousesendTask
    extends TimerTask {
        MousesendTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long l;
            long l2;
            MouseEvent mouseEvent = JViewerApp.getInstance().getRCView().getMouse_event();
            MouseEvent mouseEvent2 = JViewerApp.getInstance().getRCView().getSentmouse_event();
            byte by = JViewerView.this.GetUSBMouseMode();
            USBMouseRep uSBMouseRep = JViewerView.this.getM_USBMouseRep();
            byte by2 = JViewerApp.getInstance().getRCView().m_mouseListener.getM_btnStatus();
            if (JViewerView.this.m_cur_width <= 0) {
                JViewerView.this.m_cur_width = JViewerApp.getInstance().getSocframeHdr().getcurwidth();
            }
            if (JViewerView.this.m_cur_height <= 0) {
                JViewerView.this.m_cur_height = JViewerApp.getInstance().getSocframeHdr().getcurheight();
            }
            if (mouseEvent != null && mouseEvent2 != null && (l2 = mouseEvent2.getWhen()) == (l = mouseEvent.getWhen())) {
                return;
            }
            if (mouseEvent != null) {
                JViewerView.this.curX = mouseEvent.getX();
                JViewerView.this.curY = mouseEvent.getY();
                if (JViewerView.this.curX < 0) {
                    JViewerView.this.curX = 0;
                }
                if (JViewerView.this.curY < 0) {
                    JViewerView.this.curY = 0;
                }
                if (by == USBMouseRep.ABSOLUTE_MOUSE_MODE) {
                    if ((double)JViewerView.this.curX < (double)JViewerView.this.m_cur_width * JViewerView.this.scaleX && (double)JViewerView.this.curY < (double)JViewerView.this.m_cur_height * JViewerView.this.scaleY && JViewerApp.getInstance().getPowerStatus() == 1) {
                        KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
                        uSBMouseRep.set(by2, (double)JViewerView.this.curX / JViewerView.this.scaleX, (double)JViewerView.this.curY / JViewerView.this.scaleY, by, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
                        kVMClient.sendKMMessage(uSBMouseRep);
                        JViewerApp.getInstance().getRCView().setSentmouse_event(mouseEvent);
                    }
                } else if (by == USBMouseRep.RELATIVE_MOUSE_MODE) {
                    int n = JViewerView.this.curX - JViewerView.this.lastX;
                    int n2 = JViewerView.this.curY - JViewerView.this.lastY;
                    int n3 = 0;
                    if ((double)JViewerView.this.curX < (double)JViewerView.this.m_cur_width * JViewerView.this.scaleX && (double)JViewerView.this.curY < (double)JViewerView.this.m_cur_height * JViewerView.this.scaleY && JViewerApp.getInstance().getPowerStatus() == 1) {
                        n3 = JViewerApp.getInstance().getRCView().m_mouseListener.splitandsend_Move(n, n2, true);
                    }
                    JViewerApp.getInstance().getRCView().setSentmouse_event(mouseEvent);
                    if (n3 != 0) {
                        // empty if block
                    }
                } else if (by == USBMouseRep.OTHER_MOUSE_MODE) {
                    int n;
                    int n4;
                    Point point;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    if (JViewerApp.getInstance().getJVMenu().getMenuSelected("MouseShowCursor") == false) return;
                    if (JViewerApp.getInstance().getPowerStatus() == 0 || Lost_focus_flag) {
                        return;
                    }
                    if (JViewerView.this.lastX == -1) {
                        point = JViewerView.this.calculateCenter();
                        SwingUtilities.convertPointToScreen(point, JViewerView.this.getTopLevelAncestor());
                        SwingUtilities.convertPointFromScreen(point, JViewerView.this);
                        JViewerView.this.lastX = point.x;
                        JViewerView.this.lastY = point.y;
                    }
                    if (JViewerView.this.lastX - JViewerView.this.curX == n5 && JViewerView.this.lastY - JViewerView.this.curY == n6) {
                        n5 = 0;
                        n6 = 0;
                        JViewerView.this.lastX = JViewerView.this.curX;
                        JViewerView.this.lastY = JViewerView.this.curY;
                        return;
                    }
                    n5 += JViewerView.this.curX - JViewerView.this.lastX;
                    n6 += JViewerView.this.curY - JViewerView.this.lastY;
                    JViewerView.this.lastX = JViewerView.this.curX;
                    JViewerView.this.lastY = JViewerView.this.curY;
                    point = JViewerView.this.calculateCenter();
                    SwingUtilities.convertPointToScreen(point, JViewer.getMainFrame());
                    if (JViewerView.this.robbie == null) {
                        try {
                            JViewerView.this.robbie = new Robot();
                        }
                        catch (AWTException aWTException) {
                            Debug.out.println(aWTException);
                            JViewerView.this.robbie = null;
                            return;
                        }
                    }
                    JViewerView.this.robbie.mouseMove(point.x, point.y);
                    SwingUtilities.convertPointFromScreen(point, JViewerView.this);
                    n7 = point.x;
                    n8 = point.y;
                    if (n7 >= JViewerView.this.m_width) {
                        n7 = JViewerView.this.m_width - 1;
                    }
                    if (n8 >= JViewerView.this.m_height) {
                        n8 = JViewerView.this.m_height - 1;
                    }
                    int n9 = JViewerView.this.curX - n7;
                    int n10 = JViewerView.this.curY - n8;
                    n7 = JViewerView.this.curX;
                    n8 = JViewerView.this.curY;
                    int n11 = n9 >= 0 ? 1 : -1;
                    int n12 = n10 >= 0 ? 1 : -1;
                    n9 = Math.abs(n9);
                    n10 = Math.abs(n10);
                    KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
                    do {
                        n4 = n9 > 126 ? 126 : n9;
                        n = n10 > 126 ? 126 : n10;
                        uSBMouseRep.set(by2, n4 * n11, n * n12, by, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
                        kVMClient.sendKMMessage(uSBMouseRep);
                    } while ((n9 -= n4) > 0 || (n10 -= n) > 0);
                    JViewerApp.getInstance().getRCView().setSentmouse_event(mouseEvent);
                }
                JViewerView.this.repaint();
            }
        }
    }

    class RCMouseWheelListener
    implements MouseWheelListener {
        RCMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            byte by = (byte)mouseWheelEvent.getWheelRotation();
            by = by < 0 ? (byte)1 : -1;
            KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
            JViewerView.this.m_USBMouseRep.set((byte)0, 0.0, 0.0, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, by);
            kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
        }
    }

    class RCFocusListener
    extends FocusAdapter {
        RCFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Lost_focus_flag = false;
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                Mousecaliberation.resetCursor();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Lost_focus_flag = true;
        }
    }

    public class RCMouseListener
    extends MouseInputAdapter {
        public static final byte MOUSE_MOVE = 0;
        public static final byte LBUTTON_DOWN = 1;
        public static final byte RBUTTON_DOWN = 2;
        public static final byte MBUTTON_DOWN = 4;
        private byte m_btnStatus = 0;

        public byte getM_btnStatus() {
            return this.m_btnStatus;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if ((double)JViewerView.this.curX > (double)JViewerView.this.m_cur_width * JViewerView.this.scaleX || (double)JViewerView.this.curY > (double)JViewerView.this.m_cur_height * JViewerView.this.scaleY || JViewerApp.getInstance().getPowerStatus() != 1) {
                return;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE && !JViewerApp.getInstance().getJVMenu().getMenuItem("MouseShowCursor").isSelected()) {
                return;
            }
            JViewerView.this.requestFocus();
            JViewerView.this.curX = mouseEvent.getX();
            JViewerView.this.curY = mouseEvent.getY();
            JViewerView.this.curX = JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE ? mouseEvent.getX() : 0;
            JViewerView.this.curY = JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE ? mouseEvent.getY() : 0;
            if (JViewerView.this.curX < 0) {
                JViewerView.this.curX = 0;
            }
            if (JViewerView.this.curY < 0) {
                JViewerView.this.curY = 0;
            }
            switch (mouseEvent.getButton()) {
                case 1: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 1);
                    break;
                }
                case 2: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 4);
                    break;
                }
                case 3: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 2);
                    break;
                }
                default: {
                    return;
                }
            }
            KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
            JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, (double)JViewerView.this.curX / JViewerView.this.scaleX, (double)JViewerView.this.curY / JViewerView.this.scaleY, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
            kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
            JViewerView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if ((double)JViewerView.this.curX > (double)JViewerView.this.m_cur_width * JViewerView.this.scaleX || (double)JViewerView.this.curY > (double)JViewerView.this.m_cur_height * JViewerView.this.scaleY || JViewerApp.getInstance().getPowerStatus() != 1) {
                return;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE && !JViewerApp.getInstance().getJVMenu().getMenuItem("MouseShowCursor").isSelected()) {
                return;
            }
            JViewerView.this.curX = mouseEvent.getX();
            JViewerView.this.curY = mouseEvent.getY();
            JViewerView.this.curX = JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE ? mouseEvent.getX() : 0;
            JViewerView.this.curY = JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE ? mouseEvent.getY() : 0;
            if (JViewerView.this.curX < 0) {
                JViewerView.this.curX = 0;
            }
            if (JViewerView.this.curY < 0) {
                JViewerView.this.curY = 0;
            }
            switch (mouseEvent.getButton()) {
                case 1: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFE);
                    break;
                }
                case 2: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFB);
                    break;
                }
                case 3: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFD);
                    break;
                }
                default: {
                    return;
                }
            }
            KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
            JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, (double)JViewerView.this.curX / JViewerView.this.scaleX, (double)JViewerView.this.curY / JViewerView.this.scaleY, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
            kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
            JViewerView.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JViewerApp.getInstance().getRCView().setMouse_event(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JViewerApp.getInstance().getRCView().setMouse_event(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JViewerView.this.mouseCursorOut = false;
            if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
                return;
            }
            if (JViewerApp.getInstance().getJVMenu().getMenuItem("MouseShowCursor").isSelected()) {
                JViewerApp.showCursor = true;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE || JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE && !JViewerApp.showCursor || JViewerView.this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE && JViewerApp.showCursor) {
                if (JViewerView.this.invisCursorImg == null) {
                    JViewerView.this.invisCursorImg = JViewerView.this.createInvisibleCursor();
                }
                if (JViewerView.this.invisibleCursor == null) {
                    JViewerView.this.invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(JViewerView.this.invisCursorImg, new Point(0, 0), "Invisible Cursor");
                }
                JViewerView.this.setCursor(JViewerView.this.invisibleCursor);
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE && !Mousecaliberation.isCursorReset()) {
                Mousecaliberation.resetCursor();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JViewerView.this.mouseCursorOut = true;
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE) {
                JViewerApp.getInstance();
                if (JViewerApp.showCursor) {
                    Point point = JViewerView.this.calculateCenter();
                    if (JViewerView.this.robbie == null) {
                        try {
                            JViewerView.this.robbie = new Robot();
                        }
                        catch (AWTException aWTException) {
                            Debug.out.println(aWTException);
                            JViewerView.this.robbie = null;
                            return;
                        }
                    }
                    JViewerView.this.robbie.mouseMove(point.x, point.y);
                    return;
                }
            }
            if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
                return;
            }
            if (JViewerView.this.m_USBMouseMode != USBMouseRep.OTHER_MOUSE_MODE) {
                JViewerView.this.invisCursorImg = null;
                JViewerView.this.setCursor(null);
                JViewerApp.getInstance();
                JViewerApp.showCursor = false;
                JViewerView.this.repaint();
            }
        }

        public int splitandsend_Move(int n, int n2, boolean bl) {
            Point point;
            boolean bl2 = false;
            boolean bl3 = false;
            if (Lost_focus_flag && JViewerView.this.mouseCursorOut) {
                return 0;
            }
            int n3 = this.splitandsend(n, n2, bl);
            if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
                return n3;
            }
            Point point2 = JViewerApp.getInstance().getMainWindow().m_viewSP.getLocationOnScreen();
            int n4 = point2.x - JViewerApp.getInstance().getMainWindow().m_viewSP.getHorizontalScrollBar().getValue();
            int n5 = point2.y - JViewerApp.getInstance().getMainWindow().m_viewSP.getVerticalScrollBar().getValue();
            Point point3 = MouseInfo.getPointerInfo().getLocation();
            int n6 = point2.x + JViewerApp.getInstance().getSocframeHdr().getresX();
            int n7 = point2.y + JViewerApp.getInstance().getSocframeHdr().getresY();
            int n8 = point3.x - (n4 + Mouse_X);
            int n9 = point3.y - (n5 + Mouse_Y);
            if (JViewerView.this.robbie == null) {
                try {
                    JViewerView.this.robbie = new Robot();
                }
                catch (AWTException aWTException) {
                    Debug.out.println(aWTException);
                    JViewerView.this.robbie = null;
                    return n3;
                }
            }
            if ((n8 <= -2 || n8 >= 2) && point3.x < n6) {
                JViewerView.this.removeMouseListeners();
                JViewerView.this.robbie.mouseMove(n4 + Mouse_X, point3.y);
                if (System.getProperty("os.name").startsWith("Mac")) {
                    JViewerView.this.robbie.delay(30);
                }
                point3 = MouseInfo.getPointerInfo().getLocation();
                point = MouseInfo.getPointerInfo().getLocation();
                n3 = 1;
                JViewerView.this.lastX = point.x - n4;
                JViewerView.this.addMouseListeners();
                bl2 = true;
            }
            if ((n9 <= -2 || n9 >= 2) && point3.y < n7) {
                JViewerView.this.removeMouseListeners();
                point3 = MouseInfo.getPointerInfo().getLocation();
                JViewerView.this.robbie.mouseMove(point3.x, n5 + Mouse_Y);
                if (System.getProperty("os.name").startsWith("Mac")) {
                    JViewerView.this.robbie.delay(30);
                }
                point = MouseInfo.getPointerInfo().getLocation();
                n3 = 1;
                JViewerView.this.lastY = point.y - n5;
                JViewerView.this.addMouseListeners();
                bl3 = true;
            }
            if (!bl2) {
                JViewerView.this.lastX = JViewerView.this.curX;
            }
            if (!bl3) {
                JViewerView.this.lastY = JViewerView.this.curY;
            }
            return n3;
        }

        public int splitandsend(int n, int n2, boolean bl) {
            if (Lost_focus_flag && JViewerView.this.mouseCursorOut) {
                return 0;
            }
            int n3 = 0;
            int n4 = n >= 0 ? 1 : -1;
            int n5 = n2 >= 0 ? 1 : -1;
            JViewerView.this.removeMouseListeners();
            n = Math.abs(n);
            n2 = Math.abs(n2);
            do {
                int n6 = n > 126 ? 126 : n;
                int n7 = n2 > 126 ? 126 : n2;
                n -= n6;
                n2 -= n7;
                if (bl) {
                    this.sendto_linux_target(n6 * n4, n7 * n5);
                    int n8 = n6 * n4;
                    int n9 = n7 * n5;
                    if (firsttime) {
                        Mouse_X = JViewerView.this.lastX;
                        Mouse_Y = JViewerView.this.lastY;
                        firsttime = false;
                    }
                    if (this.ABS(n8) + this.ABS(n9) >= ACCEL_THRESHOLD) {
                        float f = (float)n8 * MOUSE_ACCELERATION;
                        float f2 = (float)n9 * MOUSE_ACCELERATION;
                        RemainingX += f % 1.0f;
                        RemainingY += f2 % 1.0f;
                        Mouse_Y += (int)f2;
                        if ((double)this.ABS(RemainingX) >= 1.0 && (Mouse_X += (int)f) > 0) {
                            if ((double)RemainingX >= 1.0) {
                                ++Mouse_X;
                                RemainingX = (float)((double)RemainingX - 1.0);
                            } else {
                                --Mouse_X;
                                RemainingX = (float)((double)RemainingX + 1.0);
                            }
                        }
                        if ((double)this.ABS(RemainingY) >= 1.0 && Mouse_Y > 0) {
                            if ((double)RemainingY >= 1.0) {
                                ++Mouse_Y;
                                RemainingY = (float)((double)RemainingY - 1.0);
                            } else {
                                --Mouse_Y;
                                RemainingY = (float)((double)RemainingY + 1.0);
                            }
                        }
                    } else {
                        Mouse_X += n8;
                        Mouse_Y += n9;
                    }
                    Point point = JViewerApp.getInstance().getMainWindow().m_viewSP.getLocationOnScreen();
                    Point point2 = MouseInfo.getPointerInfo().getLocation();
                    if (JViewerView.this.robbie == null) {
                        try {
                            JViewerView.this.robbie = new Robot();
                        }
                        catch (AWTException aWTException) {
                            Debug.out.println(aWTException);
                            JViewerView.this.robbie = null;
                            return n3;
                        }
                    }
                    if (Mouse_X <= 0) {
                        Mouse_X = 0;
                        JViewerView.this.robbie.mouseMove(point.x, point2.y);
                        if (System.getProperty("os.name").startsWith("Mac")) {
                            JViewerView.this.robbie.delay(30);
                        }
                    }
                    if (Mouse_Y <= 0) {
                        Mouse_Y = 0;
                        JViewerView.this.robbie.mouseMove(point2.x, point.y);
                        if (System.getProperty("os.name").startsWith("Mac")) {
                            JViewerView.this.robbie.delay(30);
                        }
                    }
                    if (Mouse_X >= JViewerView.this.m_cur_width) {
                        Mouse_X = JViewerView.this.m_cur_width - 1;
                    }
                    if (Mouse_Y >= JViewerView.this.m_cur_height) {
                        Mouse_Y = JViewerView.this.m_cur_height - 1;
                    }
                    JViewerView.this.repaint();
                    continue;
                }
                KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
                JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, (double)(n6 * n4) / JViewerView.this.scaleX, (double)(n7 * n5) / JViewerView.this.scaleY, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
                kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
            } while (n > 0 || n2 > 0);
            JViewerView.this.addMouseListeners();
            return n3;
        }

        private int ABS(int n) {
            return n < 0 ? -n : n;
        }

        private float ABS(float f) {
            return f < 0.0f ? -f : f;
        }

        private void sendto_linux_target(int n, int n2) {
            KVMClient kVMClient = JViewerApp.getInstance().getKVMClient();
            JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, (double)n / JViewerView.this.scaleX, (double)n2 / JViewerView.this.scaleY, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
            kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
        }
    }

    class RCKeyListener
    extends KeyAdapter {
        RCKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            JViewerView.this.m_USBKeyRep.setKeyChar(keyEvent.getKeyChar());
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            JVMenu jVMenu;
            Object object;
            byte by = USBKeyProcessorEnglish.getModifiers();
            if ((keyEvent.getKeyCode() == 20 || keyEvent.getKeyCode() == 144 || keyEvent.getKeyCode() == 145) && JViewerApp.getInstance().getPowerStatus() == 0) {
                keyEvent.consume();
                JViewerApp.getInstance().resetLEDStatus();
                return;
            }
            if (JViewerApp.getInstance().isWindowsClient() && keyEvent.getKeyCode() != 65406 && keyEvent.getModifiers() == 32) {
                keyEvent.consume();
                return;
            }
            if ((by & 1) == 1 && (keyEvent.getModifiersEx() & 0x80) != 128 && !JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldLeftCtrlKey").booleanValue()) {
                by = (byte)(by & 0xFFFFFFFE);
            }
            if ((by & 0x10) == 16 && (keyEvent.getModifiersEx() & 0x80) != 128 && !JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldRightCtrlKey").booleanValue()) {
                by = (byte)(by & 0xFFFFFFEF);
            }
            if ((by & 4) == 4 && (keyEvent.getModifiersEx() & 0x200) != 512 && !JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldLeftAltKey").booleanValue()) {
                by = (byte)(by & 0xFFFFFFFB);
            }
            if ((by & 0x40) == 64 && (keyEvent.getModifiersEx() & 0x200) != 512 && !JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldRightAltKey").booleanValue()) {
                by = (byte)(by & 0xFFFFFFBF);
            }
            if ((by & 2) == 2 && (keyEvent.getModifiersEx() & 0x40) != 64) {
                by = (byte)(by & 0xFFFFFFFD);
            }
            if ((by & 0x20) == 32 && (keyEvent.getModifiersEx() & 0x40) != 64) {
                by = (byte)(by & 0xFFFFFFDF);
            }
            USBKeyProcessorEnglish.setModifiers(by);
            try {
                Class<?> clazz = Class.forName("java.awt.AWTEvent");
                object = clazz.getDeclaredField("bdata");
                ((Field)object).setAccessible(true);
                JViewerView.access$102(JViewerView.this, (byte[])((Field)object).get(keyEvent));
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            JViewerView.this.keyCode = keyEvent.getKeyCode();
            JViewerView.this.keyLocation = keyEvent.getKeyLocation();
            JViewerView.access$408(JViewerView.this);
            object = JViewerApp.getInstance().getKVMClient();
            byte by2 = 0;
            if (keyEvent.getKeyCode() == 524) {
                return;
            }
            if ((keyEvent.getModifiersEx() & 0x200) == 512) {
                if (JViewerApp.getInstance().isWindowsClient() && (keyEvent.getModifiersEx() & 0x80) != 128) {
                    if (!JViewerApp.getInstance().isFullKeyboardEnabled()) {
                        if (JViewerApp.getInstance().isFullScreenMode()) {
                            this.OnInvokeMenuShortCutFullscreen(keyEvent);
                            keyEvent.consume();
                        }
                        return;
                    }
                } else if (!JViewerApp.getInstance().isFullKeyboardEnabled()) {
                    if (JViewerApp.getInstance().isFullScreenMode()) {
                        this.OnInvokeMenuShortCutFullscreen(keyEvent);
                        keyEvent.consume();
                    }
                    return;
                }
            }
            if (JViewerApp.getInstance().isLinuxClient() && keyEvent.getKeyCode() == 65406) {
                JViewerView.this.m_USBKeyRep.set(18, 3, true);
                ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
                return;
            }
            if (JViewerApp.getInstance().isWindowsClient() && JViewerApp.getInstance().getJVMenu().getMenuItem("Linux host").isSelected()) {
                if (!JViewerView.this.isCtrlPressed() && keyEvent.getKeyCode() == 17) {
                    JViewerView.this.setCtrlKeyLocation(keyEvent.getKeyLocation());
                    JViewerView.this.setCtrlPressed(true);
                    return;
                }
                if (JViewerView.this.isCtrlPressed() && (keyEvent.getModifiersEx() & 0x200) == 512) {
                    JViewerView.this.m_USBKeyRep.setKeyChar(keyEvent.getKeyChar());
                    JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, true);
                    ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
                    return;
                }
                if (JViewerView.this.isCtrlPressed()) {
                    JViewerView.this.m_USBKeyRep.set(17, JViewerView.this.getCtrlKeyLocation(), true);
                    ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
                }
                JViewerView.this.m_USBKeyRep.setKeyChar(keyEvent.getKeyChar());
                JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, true);
            }
            if ((keyEvent.getModifiersEx() & 0x200) == 512 && keyEvent.getKeyCode() == 67 && JViewerView.this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE && JViewerApp.getInstance().isFullKeyboardEnabled()) {
                boolean bl = JViewerApp.getInstance().getJVMenu().getMenuSelected("MouseShowCursor");
                JViewerApp.getInstance().OnShowCursor(!bl);
                keyEvent.consume();
                return;
            }
            if ((keyEvent.getModifiersEx() & 0x80) == 128 && (keyEvent.getModifiersEx() & 0x40) == 64 && keyEvent.getKeyCode() == 76) {
                if (Debug.MODE != 0) {
                    Debug.out.initDebugLogFileChooser();
                } else if (Debug.out.isRunTimeLogging()) {
                    Debug.MODE = 2;
                    Debug.out.closeLog();
                }
                keyEvent.consume();
                return;
            }
            if ((keyEvent.getModifiersEx() & 0x80) == 128) {
                if (keyEvent.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftCtrlDown = true;
                } else {
                    JViewerView.this.m_bRightCtrlDown = true;
                }
                if (keyEvent.getKeyCode() == 112 && !JViewerApp.getInstance().isFullKeyboardEnabled()) {
                    JViewerApp.getInstance().OnHelpAboutJViewer();
                    keyEvent.consume();
                    return;
                }
            }
            if (keyEvent.getKeyCode() == 127 && ((jVMenu = JViewerApp.getInstance().getJVMenu()).getMenuSelected("KeyboardHoldLeftCtrlKey").booleanValue() && jVMenu.getMenuSelected("KeyboardHoldRightCtrlKey").booleanValue() && jVMenu.getMenuSelected("KeyboardHoldRightAltKey").booleanValue() || jVMenu.getMenuSelected("KeyboardHoldLeftCtrlKey").booleanValue() && jVMenu.getMenuSelected("KeyboardHoldRightCtrlKey").booleanValue() && jVMenu.getMenuSelected("KeyboardHoldLeftAltKey").booleanValue())) {
                return;
            }
            by2 = JViewerApp.getInstance().getHostKeyboardLEDStatus();
            if (keyEvent.getKeyCode() == 144 || keyEvent.getKeyCode() == 20 || keyEvent.getKeyCode() == 145) {
                if (keyEvent.getKeyCode() == 144) {
                    by2 = (byte)(by2 ^ 1);
                }
                if (keyEvent.getKeyCode() == 20) {
                    by2 = (byte)(by2 ^ 2);
                }
                if (keyEvent.getKeyCode() == 145) {
                    by2 = (byte)(by2 ^ 4);
                }
                JViewerApp.getInstance().getM_wndFrame().getM_status().setKeyboardLEDStatus(by2);
                JViewerApp.getInstance().getM_fsFrame().getM_menuBar().getLedStatusBar().setLEDStatus(by2);
                JViewerApp.getInstance().setHostKeyboardLEDStatus(by2);
                if (JViewerApp.getInstance().getAutokeylayout() != null && JViewerApp.getInstance().getAutokeylayout().OnkeyPressed(keyEvent)) {
                    return;
                }
            }
            if (JViewerView.this.bdata != null && JViewerView.this.bdata[14] == 115) {
                JViewerView.this.keyCode = 226;
            }
            JViewerView.this.m_USBKeyRep.setKeyChar(keyEvent.getKeyChar());
            if (System.getProperty("os.name").startsWith("Mac") && keyEvent.getKeyCode() == 20) {
                JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, false);
                ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
            }
            if (System.getProperty("os.name").startsWith("Linux") && JViewerView.this.keyCode >= 65 && JViewerView.this.keyCode <= 90) {
                JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, 1, true);
                ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
            } else {
                JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, true);
                ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
            }
            keyEvent.consume();
        }

        private void OnInvokeMenuShortCutFullscreen(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 70: {
                    JViewerApp.getInstance().OnVideoFullScreen(false);
                    break;
                }
                case 69: {
                    JViewerApp.getInstance().OnVideoRefreshRedirection();
                    break;
                }
                case 80: {
                    JViewerApp.getInstance().setM_userPause(true);
                    JViewerApp.getInstance().OnVideoPauseRedirection();
                    break;
                }
                case 82: {
                    JViewerApp.getInstance().OnVideoResumeRedirection();
                    break;
                }
                case 84: {
                    if (JViewerView.this.m_USBMouseMode != USBMouseRep.RELATIVE_MOUSE_MODE || JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STARTED) break;
                    boolean bl = JViewerApp.getInstance().getJVMenu().getMenuSelected("Calibrate Mouse Threshold");
                    JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("Calibrate Mouse Threshold", !bl);
                    JViewerApp.getInstance().OnCalibareteMouse(!bl);
                    JViewerApp.getInstance().getRCView().requestFocus();
                    break;
                }
                case 67: {
                    boolean bl = JViewerApp.getInstance().getJVMenu().getMenuSelected("MouseShowCursor");
                    JViewerApp.getInstance().OnShowCursor(!bl);
                    break;
                }
                case 78: {
                    if (JViewerApp.getInstance().getKVMClient().getHostLockStatus() == 0) {
                        if (!JViewerApp.getInstance().getJVMenu().getMenuItem("VideoHostDisplayLock").isEnabled()) break;
                        JViewerApp.getInstance().onSendHostLock((byte)1);
                        break;
                    }
                    if (JViewerApp.getInstance().getKVMClient().getHostLockStatus() != 1 || !JViewerApp.getInstance().getJVMenu().getMenuItem("VideoHostDisplayUnlock").isEnabled()) break;
                    JViewerApp.getInstance().onSendHostLock((byte)0);
                    break;
                }
                default: {
                    JViewerApp.getInstance().getSoc_App().OnInvokeSocMenuShortCutFullscreen(keyEvent);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            Object object;
            try {
                Class<?> clazz = Class.forName("java.awt.AWTEvent");
                object = clazz.getDeclaredField("bdata");
                ((Field)object).setAccessible(true);
                JViewerView.access$102(JViewerView.this, (byte[])((Field)object).get(keyEvent));
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            JViewerView.this.setCtrlPressed(false);
            JViewerView.this.keyCode = keyEvent.getKeyCode();
            JViewerView.this.keyLocation = keyEvent.getKeyLocation();
            if (JViewerView.this.bdata != null && JViewerView.this.bdata[14] == 115) {
                JViewerView.this.keyCode = 226;
            }
            JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, false);
            object = JViewerApp.getInstance().getKVMClient();
            if (JViewerApp.getInstance().isLinuxClient() && (keyEvent.getModifiers() & 0x20) == 32) {
                JViewerView.this.m_USBKeyRep.set(18, 3, false);
                ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
                return;
            }
            if ((keyEvent.getModifiersEx() & 0x80) == 128) {
                if (JViewerView.this.keyLocation == 2) {
                    JViewerView.this.m_bLeftCtrlDown = false;
                } else {
                    JViewerView.this.m_bRightCtrlDown = false;
                }
            }
            if (JViewerView.this.keyCode != 16 && JViewerView.this.keyCode != 17 && JViewerView.this.keyCode != 18 && JViewerView.this.keyCode != 65406 && JViewerApp.getInstance().getAutokeylayout() != null && JViewerApp.getInstance().getAutokeylayout().OnkeyReleased(keyEvent)) {
                keyEvent.consume();
                JViewerView.this.m_USBKeyRep.setKeyChar('\u0000');
                return;
            }
            if (JViewerApp.getInstance().isWindowsClient() && JViewerView.this.keyCode != 65406 && keyEvent.getModifiers() == 32) {
                keyEvent.consume();
                JViewerView.this.m_USBKeyRep.setKeyChar('\u0000');
                return;
            }
            JViewerView.this.m_USBKeyRep.setKeyChar(keyEvent.getKeyChar());
            if (System.getProperty("os.name").startsWith("Mac") && keyEvent.getKeyCode() == 20) {
                JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, true);
                ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
            }
            JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, false);
            ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
            if (keyEvent.getKeyCode() == 154 && JViewerView.this.keyPressedFlag == 0) {
                JViewerView.access$408(JViewerView.this);
            }
            if (JViewerView.this.keyPressedFlag == 0) {
                JViewerView.this.m_USBKeyRep.set(keyEvent.getKeyCode(), keyEvent.getKeyLocation(), true);
                ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_USBKeyRep.set(keyEvent.getKeyCode(), keyEvent.getKeyLocation(), false);
                ((KVMClient)object).sendKMMessage(JViewerView.this.m_USBKeyRep);
            } else {
                JViewerView.access$410(JViewerView.this);
            }
            keyEvent.consume();
            JViewerView.this.m_USBKeyRep.setKeyChar('\u0000');
        }
    }
}

