/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JVStatusBar;
import com.ami.kvm.jviewer.gui.JVToolBar;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.Macrows;
import com.ami.kvm.jviewer.gui.RecorderToolBar;
import com.ami.kvm.jviewer.gui.WindowMenu;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WindowFrame
extends JVFrame {
    private WindowMenu m_menu;
    private JVStatusBar m_status;
    public Macrows macrows;
    private JVToolBar toolbar;
    private String m_label;
    private Dimension frameDimension = null;
    private boolean resizeFrame = false;

    public WindowFrame() {
        this.setTitle(LocaleStrings.getString("C_1_JVF"));
        this.constructUserIf();
        this.setDefaultCloseOperation(0);
        this.frameDimension = JViewer.getMainFrame().getSize();
        if (JViewer.isStandalone()) {
            JViewer.getMainFrame().addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    if (JViewer.isjviewerapp() || JViewer.isStandAloneApp()) {
                        if ((JViewer.getOEMFeatureStatus() & 0x200L) != 512L) {
                            JViewerApp.getInstance().setInitClientLEDStatus(JViewerApp.getInstance().getClientKeyboardLEDStatus());
                        }
                        JViewerView.syncLEDFlag = false;
                        JViewerView.Lost_focus_flag = false;
                        if (JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPED && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPING) {
                            if (JViewerApp.getInstance().getKVMClient() != null) {
                                JViewerApp.getInstance().getKVMClient().sendLEDRequest();
                            }
                            if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() != USBMouseRep.INVALID_MOUSE_MODE) {
                                JViewerApp.getInstance().getRCView().USBsyncCursor(true);
                            }
                            JViewerApp.getInstance().resetModifiers();
                        }
                        if (JViewerApp.getInstance().getResolutionChanged() == 1) {
                            if (JViewerApp.getInstance().getVidClnt() != null) {
                                JViewerApp.getInstance().getVidClnt().setZoomOptionStatus();
                            }
                            JViewerApp.getInstance().setResolutionChanged(0);
                        }
                        WindowFrame.this.getM_status().resetStatus();
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent windowEvent) {
                    if (JViewer.isjviewerapp() || JViewer.isStandAloneApp()) {
                        JViewerView.syncLEDFlag = true;
                        JViewerView.Lost_focus_flag = true;
                        WindowFrame.this.resizeFrame = true;
                        if (JViewerApp.getInstance().GetRedirectionState() == JViewerApp.REDIR_STARTED) {
                            JViewerApp.getInstance().getRCView().USBsyncCursor(false);
                        }
                        WindowFrame.this.frameDimension = JViewer.getMainFrame().getSize();
                        if ((JViewer.getOEMFeatureStatus() & 0x200L) != 512L) {
                            JViewerApp.getInstance().setClientKeyboardLEDStatus(JViewerApp.getInstance().getInitClientLEDStatus());
                        }
                    }
                }
            });
            JViewer.getMainFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    WindowFrame.this.windowClosed();
                }
            });
        } else {
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                    if (!JViewer.isStandalone()) {
                        JViewer.getMainFrame().setJMenuBar(WindowFrame.this.m_menu.getMenuBar());
                    }
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    WindowFrame.this.windowClosed();
                }
            });
        }
    }

    @Override
    public JVMenu getMenu() {
        return this.m_menu;
    }

    @Override
    public void setStatus(String string) {
        this.m_status.setStatus(string);
    }

    @Override
    public void resetStatus() {
        this.m_status.resetStatus();
    }

    @Override
    public void exitApp() {
        this.windowClosed();
    }

    @Override
    public void refreshTitle() {
        if (JViewerApp.getOEMManager().setWndFrameTitle(this.m_label) == 0) {
            if (JViewer.isStandalone() || JViewer.isplayerapp()) {
                String string = JViewerApp.getInstance().getResolutionStatus();
                if (string != null) {
                    JViewer.getMainFrame().setTitle(JViewer.getTitle() + " [" + m_serverIP + "] - " + "[ " + string + " ] - " + this.m_label);
                } else {
                    JViewer.getMainFrame().setTitle(JViewer.getTitle() + " [" + m_serverIP + "] - " + this.m_label);
                }
            } else {
                this.setTitle(JViewer.getTitle() + " - " + m_serverIP + " - " + this.m_label);
            }
        }
    }

    @Override
    public void setWndLabel(String string) {
        this.m_label = string;
        if (JViewerApp.getOEMManager().setWndFrameTitle(string) == 0) {
            if (JViewer.isStandalone() || JViewer.isplayerapp()) {
                String string2 = JViewerApp.getInstance().getResolutionStatus();
                if (JViewerApp.getInstance().getBPPString() == null) {
                    JViewerApp.getInstance().setBPPString(" ");
                }
                if (string2 != null) {
                    JViewer.getMainFrame().setTitle(JViewer.getTitle() + " [" + m_serverIP + "] - " + "[ " + string2 + JViewerApp.getInstance().getBPPString() + " ] - " + this.m_label);
                } else {
                    JViewer.getMainFrame().setTitle(JViewer.getTitle() + " [" + m_serverIP + "] - " + this.m_label);
                }
            } else {
                this.setTitle(JViewer.getTitle() + " - " + m_serverIP + " - " + string);
            }
        }
    }

    private void constructUserIf() {
        Container container = this.getContentPane();
        container.removeAll();
        container.setLayout(new BorderLayout());
        if (!JViewer.isdownloadapp()) {
            if (JViewer.isplayerapp()) {
                this.setToolbar(new RecorderToolBar());
                container.add((Component)RecorderToolBar.getPanel(), "Last");
            } else {
                this.m_menu = new WindowMenu();
                if (JViewer.isStandalone()) {
                    this.setJMenuBar(this.m_menu.getMenuBar());
                } else {
                    JViewer.getMainFrame().setJMenuBar(this.m_menu.getMenuBar());
                    JViewer.getMainFrame().setVisible(true);
                }
                this.m_status = new JVStatusBar();
                this.macrows = new Macrows(this.m_status);
                container.add((Component)this.m_status.getStatusBar(), "Last");
                this.m_status.setStatus(LocaleStrings.getString("W_1_WF"));
                this.setToolbar(new JVToolBar());
            }
            container.add((Component)this.getToolbar().getToolBar(), "First");
        }
        if (JViewer.isStandalone()) {
            URL uRL = JViewer.class.getResource("res/jviewer.jpg");
            JViewer.getMainFrame().setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
    }

    public JVStatusBar getM_status() {
        return this.m_status;
    }

    public void setM_status(JVStatusBar jVStatusBar) {
        this.m_status = jVStatusBar;
    }

    public WindowMenu getWindowMenu() {
        return this.m_menu;
    }

    public Dimension getFrameDimension() {
        return this.frameDimension;
    }

    public boolean isResizeFrame() {
        return this.resizeFrame;
    }

    public void setResizeFrame(boolean bl) {
        this.resizeFrame = bl;
    }

    public JVToolBar getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(JVToolBar jVToolBar) {
        this.toolbar = jVToolBar;
    }
}

