/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.jvvideo;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.common.ISOCJVVideo;
import com.ami.kvm.jviewer.gui.FrameRateTask;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.PowerStatusMonitor;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;

public class JVVideo {
    public static final int MIN_X_RESOLUTION = 300;
    public static final int MIN_Y_RESOLUTION = 200;
    public static final int MAX_X_RESOLUTION = 1920;
    public static final int MAX_Y_RESOLUTION = 1200;
    private Timer m_frTmr = null;
    private int m_frameRate;
    private JViewerView m_view = JViewerApp.getInstance().getRCView();
    private ISOCFrameHdr m_frameHdr;
    private boolean newFrame = false;
    private PowerStatusMonitor psMonitor = null;
    private Timer psMonitorTimer = null;
    ISOCJVVideo VideoSOC;

    public JVVideo() {
        this.m_view.setRCView(1920, 1200, 0);
        this.m_frameHdr = JViewerApp.getSoc_manager().getSOCFramehdr();
        this.VideoSOC = JViewerApp.getSoc_manager().getSOCJVVideo();
        this.VideoSOC.setframehdr(this.m_frameHdr);
        this.VideoSOC.VideoBuffer_Initialize();
        if (!JViewer.isWebPreviewer() && !JViewer.isBSODViewer()) {
            if (this.m_frTmr == null) {
                this.m_frTmr = new Timer();
            } else {
                this.m_frTmr.cancel();
            }
            JViewerApp.getInstance().setFrameRateTask(new FrameRateTask());
            this.m_frTmr.schedule((TimerTask)JViewerApp.getInstance().getFrameRateTask(), 0L, 1000L);
            this.m_frameRate = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onNewFrame(ByteBuffer byteBuffer) {
        Object object;
        ++this.m_frameRate;
        this.m_frameHdr.setHeader(byteBuffer);
        JViewerApp.getInstance().setSocframeHdr(this.m_frameHdr);
        this.VideoSOC.Newframevalidate();
        this.setNewFrame(true);
        if (!(this.m_view.viewWidth() == this.m_frameHdr.getresX() && this.m_view.viewHeight() == this.m_frameHdr.getresY() || this.onResolutionChange())) {
            return 0;
        }
        ByteBuffer byteBuffer2 = this.VideoSOC.decompressframe(this.m_frameHdr, byteBuffer);
        this.VideoSOC.SOC_Specific(byteBuffer2);
        if (VideoRecord.Recording_Started) {
            object = JViewerApp.getInstance().getM_videorecord().obj;
            synchronized (object) {
                JViewerApp.getInstance().getM_videorecord().obj.notify();
            }
        }
        if (this.psMonitor != null && this.psMonitor.isMonitorRunning()) {
            object = this.psMonitor.getSyncObj();
            synchronized (object) {
                this.psMonitor.getSyncObj().notify();
            }
        }
        this.m_view.repaint();
        return 0;
    }

    public boolean isNewFrame() {
        return this.newFrame;
    }

    public void setNewFrame(boolean bl) {
        this.newFrame = bl;
    }

    public boolean onResolutionChange() {
        Debug.out.println("Resolution change " + this.m_frameHdr.getresX() + ":" + this.m_frameHdr.getresY());
        if (this.m_frameHdr.getresX() < 300 || this.m_frameHdr.getresX() > 1920 || this.m_frameHdr.getresY() < 200 || this.m_frameHdr.getresY() > 1200) {
            Debug.out.println("Invalid resolution");
            return false;
        }
        if (JViewer.isWebPreviewer() || JViewer.isBSODViewer() || JViewer.isplayerapp() || JViewer.isdownloadapp()) {
            this.m_view.setRCView(this.m_frameHdr.getresX(), this.m_frameHdr.getresY(), this.m_frameHdr.getFrameType());
            if (JViewer.isplayerapp()) {
                JViewerApp.getInstance().setResolutionStatus(this.m_frameHdr.getresX(), this.m_frameHdr.getresY());
            }
            return true;
        }
        if (JViewer.isjviewerapp() || JViewer.isStandAloneApp()) {
            if (JViewerApp.getInstance().getResolutionChanged() != -1) {
                JViewerApp.getInstance().setResolutionChanged(1);
            } else {
                JViewerApp.getInstance().setResolutionChanged(0);
            }
            JViewerApp.getInstance().setResolutionStatus(this.m_frameHdr.getresX(), this.m_frameHdr.getresY());
            this.setFullScreenMode();
            this.setZoomOptionStatus();
            this.m_view.setRCView(this.m_frameHdr.getresX(), this.m_frameHdr.getresY(), this.m_frameHdr.getFrameType());
            if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                Mousecaliberation.resetCursor();
            }
            if (JViewerApp.getInstance().getZoomOption() == "FitToHostResolution") {
                JViewerApp.getInstance().onChangeZoomOptions("FitToHostResolution");
            }
            if (this.m_view.getMouseRedirStatus()) {
                this.m_view.USBsyncCursor(false);
                this.m_view.USBsyncCursor(true);
            }
            if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
                if (JViewerApp.getInstance().getJVMenu().getMenuItem("MouseShowCursor").isSelected()) {
                    JViewerApp.getInstance().OnShowCursor(false);
                    JViewerApp.getInstance().OnShowCursor(true);
                } else {
                    JViewerApp.getInstance().OnShowCursor(false);
                }
            }
        }
        System.gc();
        return true;
    }

    public void onCompressionChange() {
        this.VideoSOC.soccompressionchange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBlankScreen() {
        this.VideoSOC.SOCBlankscreen();
        try {
            JViewerApp.getInstance().getPrepare_buf().clearImage();
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            JViewerApp.getInstance().getKVMClient().m_isBlank = false;
        }
        URL uRL = JViewer.class.getResource("res/nosignal.jpg");
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
        }
        JViewerApp.getInstance().getPrepare_buf().SetImage(bufferedImage);
        this.m_view.setM_cur_width(bufferedImage.getWidth());
        this.m_view.setM_cur_height(bufferedImage.getHeight());
        if (VideoRecord.Recording_Started) {
            Object object = JViewerApp.getInstance().getM_videorecord().obj;
            synchronized (object) {
                JViewerApp.getInstance().getM_videorecord().obj.notify();
            }
        }
        this.m_view.repaint();
        JViewerApp.getInstance().setResolutionStatus(0, 0);
        this.setNewFrame(false);
        this.setZoomOptionStatus();
        this.setFullScreenMode();
        if (JViewer.isjviewerapp() || JViewer.isStandAloneApp()) {
            this.startPsMonitorTaskAndTimer();
        }
    }

    public void reset() {
        this.m_view.repaint();
        this.m_frTmr.cancel();
        this.m_frTmr = null;
        JViewerApp.getInstance().setFrameRateTask(null);
        this.VideoSOC.SOCreset();
        JViewerApp.getInstance().setAppWndLabel("0 fps");
    }

    public void refresh() {
        if (this.m_frTmr == null || JViewerApp.getInstance().getFrameRateTask() == null) {
            this.m_frameRate = 0;
            this.m_frTmr = new Timer();
            JViewerApp.getInstance().setFrameRateTask(new FrameRateTask());
            this.m_frTmr.schedule((TimerTask)JViewerApp.getInstance().getFrameRateTask(), 0L, 1000L);
        }
    }

    public ISOCFrameHdr getM_frameHdr() {
        return this.m_frameHdr;
    }

    public ISOCJVVideo getVideoSOC() {
        return this.VideoSOC;
    }

    public void setVideoSOC(ISOCJVVideo iSOCJVVideo) {
        this.VideoSOC = iSOCJVVideo;
    }

    public int getM_frameRate() {
        return this.m_frameRate;
    }

    public void setM_frameRate(int n) {
        this.m_frameRate = n;
    }

    public void setFullScreenMode() {
        Dimension dimension = JViewerApp.getInstance().getCurrentMonitorResolution();
        if (dimension.height == this.m_frameHdr.getresY() && dimension.width == this.m_frameHdr.getresX()) {
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoFullScreen", true);
            JViewerApp.getInstance().getM_wndFrame().getToolbar().getFullScreenBtn().setToolTipText(LocaleStrings.getString("Q_6_JVT"));
        } else {
            if (JViewerApp.getInstance().getJVMenu().getMenuItem("VideoFullScreen").isSelected() && this.isNewFrame()) {
                JViewerApp.getInstance().OnVideoFullScreen(false);
            }
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoFullScreen", false);
            JViewerApp.getInstance().getM_wndFrame().getToolbar().getFullScreenBtn().setToolTipText(LocaleStrings.getString("D_29_JVAPP"));
        }
    }

    public void setZoomOptionStatus() {
        if (JViewerView.syncLEDFlag) {
            JViewerApp.getInstance().getM_wndFrame().setResizeFrame(false);
            return;
        }
        JViewerApp.getInstance().setRenderFitToHost(true);
        if (!this.isNewFrame()) {
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("FitToHostResolution", false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("FitToClientResolution", false);
        } else {
            if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() == USBMouseRep.OTHER_MOUSE_MODE) {
                if (JViewerApp.getInstance().getZoomOption() == "FitToHostResolution") {
                    JViewerApp.getInstance().onChangeZoomOptions("ActualSize");
                    if ((JViewer.getOEMFeatureStatus() & 1L) == 1L) {
                        JViewerApp.getInstance().setZoomOption("FitToHostResolution");
                        JViewerApp.getInstance().getJVMenu().getMenuItem("FitToHostResolution").setSelected(true);
                    }
                } else {
                    JViewerApp.getInstance().setZoomOption("ActualSize");
                }
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("FitToHostResolution", false);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("FitToClientResolution", false);
                JViewerApp.getInstance().getM_wndFrame().getToolbar().enableZoomSlider(false);
                return;
            }
            if (JViewerApp.getInstance().getJVMenu().getMenuItem("FitToClientResolution").isSelected()) {
                JViewerApp.getInstance().onChangeZoomOptions("FitToClientResolution");
            } else if (JViewerApp.getInstance().getJVMenu().getMenuItem("FitToHostResolution").isSelected()) {
                JViewerApp.getInstance().onChangeZoomOptions("FitToHostResolution");
            }
            JViewerApp.getInstance().getM_wndFrame().getToolbar().enableZoomSlider(true);
            Dimension dimension = JViewerApp.getInstance().getCurrentMonitorResolution();
            GraphicsConfiguration graphicsConfiguration = JViewerApp.getInstance().getM_wndFrame().getGraphicsConfiguration();
            Insets insets = new Insets(0, 0, 0, 0);
            try {
                insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            int n = JViewer.getMainFrame().getInsets().left + JViewer.getMainFrame().getInsets().left + JViewerApp.getInstance().getRCView().getInsets().left + JViewerApp.getInstance().getRCView().getInsets().right;
            int n2 = JViewer.getMainFrame().getInsets().top + JViewerApp.getInstance().getM_wndFrame().getWindowMenu().getMenuBar().getHeight() + JViewerApp.getInstance().getM_wndFrame().getToolbar().getToolBar().getHeight() + JViewerApp.getInstance().getM_wndFrame().getToolbar().getToolBar().getInsets().top + JViewerApp.getInstance().getM_wndFrame().getToolbar().getToolBar().getInsets().bottom + JViewerApp.getInstance().getM_wndFrame().getM_status().getStatusBar().getHeight() + JViewerApp.getInstance().getM_wndFrame().getM_status().getStatusBar().getInsets().top + JViewerApp.getInstance().getM_wndFrame().getM_status().getStatusBar().getInsets().bottom + insets.top + insets.bottom + insets.left + insets.right;
            if (dimension.height <= this.m_frameHdr.getresY() + n2 || dimension.width <= this.m_frameHdr.getresX() + n) {
                JViewerApp.getInstance().setRenderFitToHost(false);
                if (JViewerApp.getInstance().getZoomOption() == "FitToHostResolution") {
                    JViewerApp.getInstance().getJVMenu().getMenuItem("ActualSize").setSelected(true);
                    JViewerApp.getInstance().onChangeZoomOptions("ActualSize");
                    if ((JViewer.getOEMFeatureStatus() & 1L) == 1L) {
                        JViewerApp.getInstance().setZoomOption("FitToHostResolution");
                        JViewerApp.getInstance().getJVMenu().getMenuItem("FitToHostResolution").setSelected(true);
                    }
                }
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("FitToHostResolution", false);
            } else {
                if ((JViewer.getOEMFeatureStatus() & 1L) == 1L && JViewerApp.getInstance().getZoomOption() != "ActualSize") {
                    JViewerApp.getInstance().onChangeZoomOptions("FitToHostResolution");
                }
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("FitToHostResolution", true);
            }
            if (dimension.height > this.m_frameHdr.getresY() || dimension.width > this.m_frameHdr.getresX()) {
                if (JViewerApp.getInstance().getZoomOption() == "FitToClientResolution") {
                    JViewerApp.getInstance().getJVMenu().getMenuItem("ActualSize").setSelected(true);
                    JViewerApp.getInstance().onChangeZoomOptions("ActualSize");
                }
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("FitToClientResolution", false);
            } else {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("FitToClientResolution", true);
            }
        }
        if (JViewerApp.getInstance().getZoomOption() != null && JViewerApp.getInstance().getZoomOption() != "ActualSize" && JViewerApp.getInstance().getZoomOption() != "ZoomOption None") {
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("Zoom In", false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("Zoom Out", false);
        }
    }

    public PowerStatusMonitor getPsMonitor() {
        return this.psMonitor;
    }

    public void setPsMonitor(PowerStatusMonitor powerStatusMonitor) {
        this.psMonitor = powerStatusMonitor;
    }

    public Timer getPsMonitorTimer() {
        return this.psMonitorTimer;
    }

    public void setPsMonitorTimer(Timer timer) {
        this.psMonitorTimer = timer;
    }

    public void stopPsMonitorTaskAndTimer() {
        if (this.psMonitor != null && !this.psMonitor.isMonitorRunning()) {
            this.psMonitor.cancel();
            this.psMonitor = null;
            if (this.psMonitorTimer != null) {
                this.psMonitorTimer.cancel();
                this.psMonitorTimer.purge();
                this.psMonitorTimer = null;
            }
        }
    }

    public void startPsMonitorTaskAndTimer() {
        if (this.psMonitor != null) {
            return;
        }
        this.psMonitor = new PowerStatusMonitor();
        if (!this.psMonitor.isMonitorRunning()) {
            if (this.psMonitorTimer != null) {
                return;
            }
            this.psMonitorTimer = new Timer(true);
            try {
                this.psMonitorTimer.schedule((TimerTask)this.psMonitor, 0L, 30000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

