/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.communication.Client;
import com.ami.kvm.jviewer.communication.NWListener;
import com.ami.kvm.jviewer.gui.AddMacro;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.KVMShareDialog;
import com.ami.kvm.jviewer.gui.KVMSharing;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.hid.USBMessage;
import com.ami.kvm.jviewer.jvvideo.JVVideo;
import com.ami.kvm.jviewer.kvmpkts.AutoDetectBw;
import com.ami.kvm.jviewer.kvmpkts.CfgBandwidth;
import com.ami.kvm.jviewer.kvmpkts.ConfPkt;
import com.ami.kvm.jviewer.kvmpkts.CtrlReader;
import com.ami.kvm.jviewer.kvmpkts.FragNumReader;
import com.ami.kvm.jviewer.kvmpkts.FragReader;
import com.ami.kvm.jviewer.kvmpkts.HeaderReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KMCrypt;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import com.ami.kvm.jviewer.kvmpkts.NullReader;
import com.ami.kvm.jviewer.kvmpkts.UserDataPacket;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.VMDialog;
import java.awt.Component;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class KVMClient
extends Client {
    public static final int MAX_FRAGMENT_SIZE = 0x480000;
    public static final int USER_DATA_LENGTH = 134;
    private static final int TIMEOUT_VALUE = 6000;
    public IVTPPktHdr m_pktHdr;
    public short m_fragNum;
    public ByteBuffer m_ctrlMsg;
    private HeaderReader m_hdrReader;
    private FragNumReader m_fragNumReader;
    private FragReader m_fragReader;
    private CtrlReader m_ctrlReader;
    private NullReader m_nullReader;
    private KVMReader m_reader;
    private JVVideo m_vidClnt;
    private NWListener m_NWListener;
    private volatile Thread m_NWThread;
    private boolean m_redirection = false;
    private KMCrypt m_kmCrypt;
    private boolean m_encrypt = false;
    private static String[] userData;
    private static int numUsers;
    public static final int INVALID_SESSION = 0;
    public static final int VALID_SESSION = 1;
    public static final int KVM_DISABLED = 2;
    public static final int STOP_SESSION_IMMEDIATE = 2;
    public static final int INVALID_VIDEO_SESSION_INFO = 3;
    public static final int INVALID_CDROM_SESSION_TOKEN = 4;
    public static final int INVALID_FLOPPY_SESSION_TOKEN = 5;
    public static final int INVALID_CLIENT_IP = 6;
    public static final int INVALID_MAC_ADDR = 7;
    public static final int SESSION_UNREGISTERED = 8;
    public static boolean DISABLE_ENCRPT_FLAG;
    public static final int STOP_SESSION_CONF_CHANGE = 5;
    public static final int STOP_SESSION_WEB_LOGOUT = 7;
    public static final int STOP_SESSION_LICENSE_EXP = 8;
    public static final int STOP_SESSION_TIMED_OUT = 9;
    public static final int STOP_SESSION_KVM_DSCONNECT = 10;
    public static final int STOP_SESSION_WEBSERVER_RESTART = 11;
    public static final int STOP_SESSION_WARM_RESET = 12;
    public static final int STOP_SESSION_RESTORE_DEFAULT = 13;
    public IVTPPktHdr m_pktPreLoginHdr = null;
    public static final int HOST_LOCK_FEATURE_DISABLED = 0;
    public static final int HOST_LOCK_FEATURE_ENABLED = 1;
    public static final byte GET_HOST_LOCK_STATUS = 2;
    public static final byte MAX_SESSION_REACHED = 0;
    public static final byte SAME_KVM_CLIENT_USER = 1;
    public static final int TERMINATE_SESSION_PKT_SIZE = 5;
    private boolean m_bUseSSL = false;
    public boolean m_isBlank = false;
    private boolean Host_OS_shutdown = false;
    private long m_startTS;
    private long m_stopTS;
    private ConfPkt[] confPacket = null;
    private UserDataPacket userDataPacket = null;
    private short hostLockStatus = (short)-1;
    byte hostLockFeatureStatus = 1;
    private boolean stopSignalReceived = false;

    public KVMClient(byte[] byArray, int n, JVVideo jVVideo, boolean bl) {
        super(byArray, n);
        this.m_vidClnt = jVVideo;
        this.m_hdrReader = new HeaderReader(this);
        this.m_fragNumReader = new FragNumReader(this);
        this.m_fragReader = new FragReader(this);
        this.m_ctrlReader = new CtrlReader(this);
        this.m_nullReader = new NullReader(this);
        this.m_bUseSSL = bl;
        this.m_reader = this.m_hdrReader;
        this.m_kmCrypt = new KMCrypt();
    }

    @Override
    public void onReadEvent() {
        Socket socket = this.getSocket();
        if (JViewer.isKVMReconnectEnabled() && JViewerApp.getInstance().getLocalport() != socket.getLocalPort()) {
            return;
        }
        int n = this.m_reader.read(socket);
        JVFrame jVFrame = JViewerApp.getInstance().getMainWindow();
        if (-1 == n) {
            try {
                if (JViewer.isKVMReconnectEnabled() && (JViewer.isjviewerapp() || JViewer.isStandAloneApp())) {
                    if (JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPING && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPED && !JViewerApp.getInstance().getRetryConnection()) {
                        JViewerApp.getInstance().onReconnect();
                    }
                } else {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
            if (!JViewer.isKVMReconnectEnabled() && !JViewer.isWebPreviewer()) {
                JViewerApp.getInstance().setRedirectionStatus(JViewerApp.REDIR_STOPPED);
                JOptionPane.showMessageDialog(jVFrame, LocaleStrings.getString("2_1_KVMCLIENT"), LocaleStrings.getString("2_2_KVMCLIENT"), 0);
                JViewerApp.getInstance().getMainWindow().windowClosed();
            }
        } else if (JViewer.isKVMReconnectEnabled()) {
            JViewerApp.getInstance().setLastPcktRecvd();
        }
    }

    public void setState(KVMReader kVMReader) {
        this.m_reader = kVMReader;
    }

    public HeaderReader getHdrReader() {
        return this.m_hdrReader;
    }

    public FragNumReader getFragNumReader() {
        return this.m_fragNumReader;
    }

    public FragReader getFragReader() {
        return this.m_fragReader;
    }

    public CtrlReader getCtrlReader() {
        return this.m_ctrlReader;
    }

    public NullReader getNullReader() {
        return this.m_nullReader;
    }

    public boolean onNewFrame(ByteBuffer byteBuffer) {
        if (JViewerApp.getInstance().m_refresh) {
            JViewerApp.getInstance().m_refresh = false;
            JViewerApp.getInstance().OnVideoPauseRedirection();
        }
        if (this.m_vidClnt.onNewFrame(byteBuffer) != 0) {
            Debug.out.println("onNewFrame failed.");
            return false;
        }
        return true;
    }

    public void onControlMessage() {
        Debug.out.println("CMDTYPE::" + this.m_pktHdr.type);
        if (JViewer.isKVMReconnectEnabled()) {
            JViewerApp.getInstance().setLastPcktRecvd();
        }
        if (JViewerApp.getOEMManager() != null && JViewerApp.getOEMManager().getOEMKvmClient() != null && JViewerApp.getOEMManager().getOEMKvmClient().handleControlPackets(this.m_pktHdr, this.m_ctrlMsg) == 1) {
            Debug.out.println("OEM handled CMDTYPE::" + this.m_pktHdr.type);
            return;
        }
        switch (this.m_pktHdr.type) {
            case 9: {
                Debug.out.println("*** Blank screen");
                if (this.m_isBlank) break;
                this.m_vidClnt.onBlankScreen();
                this.m_isBlank = true;
                break;
            }
            case 8: {
                Debug.out.println("*** Stop session Status : " + this.m_pktHdr.status());
                this.stopSignalReceived = true;
                if (JViewer.isKVMReconnectEnabled()) {
                    JViewerApp.getInstance().setSessionLive(false);
                }
                if (JViewerApp.getInstance().getKVMShareDialog() != null && KVMSharing.KVM_REQ_GIVEN == 0 && JViewerApp.getInstance().getKVMShareDialog().getKVMShareResponseDialog() != null) {
                    JViewerApp.getInstance().getKVMShareDialog().disposeKVMShareResponseDialog();
                }
                JViewerApp.getInstance().OnVideoStopRedirection();
                JViewerApp.getInstance().getM_frame().windowClosed();
                if (this.m_pktHdr.status() == 5) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_3_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                } else if (this.m_pktHdr.status() == 7) {
                    if (JViewer.isjviewerapp()) {
                        JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_5_KVMCLIENT") + JViewer.getTitle() + LocaleStrings.getString("2_22_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                    }
                } else if (this.m_pktHdr.status() == 2) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_6_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                } else if (this.m_pktHdr.status() == 8) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_26_KVMCLIENT") + LocaleStrings.getString("2_6_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                } else if (this.m_pktHdr.status() == 9) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_27_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                } else if (this.m_pktHdr.status() == 10) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_28_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                } else if (this.m_pktHdr.status() == 11) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_30_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                } else if (this.m_pktHdr.status() == 12) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_31_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                } else if (this.m_pktHdr.status() == 13) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_32_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                }
                JViewer.exit(0);
                break;
            }
            case 14: {
                Debug.out.println("*** Encryption Status");
                JViewerApp.getInstance().OnEncryptionStatus();
                break;
            }
            case 15: {
                Debug.out.println("*** Initial Encryption Status");
                JViewerApp.getInstance().OnInitialEncryptionStatus();
                break;
            }
            case 10: {
                Debug.out.println("*** Get Mouse Mode Response");
                JViewerApp.getInstance().OnGetMouseMode(this.m_ctrlMsg.get());
                break;
            }
            case 19: {
                Debug.out.println("*** ADVISER_VALIDATE_VIDEO_SESSION_RESPONSE:" + this.m_pktHdr.pktSize);
                byte by = this.m_ctrlMsg.get();
                byte by2 = -1;
                if (this.m_pktHdr.pktSize > 1) {
                    by2 = this.m_ctrlMsg.get();
                }
                JViewerApp.getInstance().OnValidateVideoSessionResp(by, by2);
                break;
            }
            case 20: {
                if (JViewer.isWebPreviewer() && JViewer.isBSODViewer()) break;
                byte by = this.m_ctrlMsg.get();
                if (JViewerView.Lost_focus_flag) break;
                JViewerApp.getInstance().onKeybdLED(by);
                JViewerApp.getInstance().getM_wndFrame().getM_status().setKeyboardLEDStatus(by);
                JViewerApp.getInstance().getM_fsFrame().getM_menuBar().getLedStatusBar().setLEDStatus(by);
                break;
            }
            case 23: {
                if (this.m_pktHdr.status > 0) {
                    short s = this.m_pktHdr.status;
                    JViewerApp.getInstance();
                    if (s != JViewerApp.getSoc_manager().getSOCID()) {
                        JVFrame jVFrame = JViewerApp.getInstance().getM_frame();
                        String string = LocaleStrings.getString("A_5_GLOBAL");
                        StringBuilder stringBuilder = new StringBuilder().append(LocaleStrings.getString("2_33_KVMCLIENT")).append(JViewer.getSOC(this.m_pktHdr.status)).append(" ").append(LocaleStrings.getString("2_35_KVMCLIENT")).append(".\n").append(LocaleStrings.getString("2_34_KVMCLIENT"));
                        JViewerApp.getInstance();
                        jVFrame.generalErrorMessage(string, stringBuilder.append(JViewerApp.getSoc_manager().getSOC()).append(" ").append(LocaleStrings.getString("2_35_KVMCLIENT")).append(".").toString());
                        JViewer.exit(0);
                    }
                }
                KVMShareDialog.isMasterSession = true;
                if (JViewer.isWebPreviewer()) {
                    JViewerApp.getInstance().onSendWebPreviewerSession();
                    break;
                }
                if (this.m_pktHdr.pktSize > 0) {
                    byte[] byArray = null;
                    byArray = new byte[this.m_pktHdr.pktSize];
                    this.m_ctrlMsg.get(byArray);
                    String string = new String(byArray);
                    if (!JViewerApp.getInstance().getRetryConnection() && null != string) {
                        int n = 0;
                        int n2 = 48;
                        int n3 = this.m_pktHdr.pktSize / n2;
                        String[] stringArray = new String[n3];
                        for (int i = 0; i < n3; ++i) {
                            n = i * n2;
                            stringArray[i] = string.substring(n, n + n2).trim();
                        }
                        try {
                            if (null == JViewerApp.getInstance().getMacAddress(2, stringArray)) {
                                JVFrame jVFrame = JViewerApp.getInstance().getMainWindow();
                                JViewerApp.getInstance().getKVMClient().setM_redirection(true);
                                JViewerApp.getInstance().OnVideoStopRedirection();
                                JOptionPane.showMessageDialog(jVFrame, LocaleStrings.getString("D_30_JVAPP") + JViewer.getIp() + LocaleStrings.getString("D_31_JVAPP"), LocaleStrings.getString("D_32_JVAPP"), 1);
                                JViewerApp.getInstance().OnVideoExit();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                JViewerApp.getInstance().OnsendWebsessionToken();
                break;
            }
            case 22: {
                JViewerApp.getInstance().OnVideoStopRedirection();
                if (this.m_pktHdr.status() == 0) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("2_11_KVMCLIENT"), LocaleStrings.getString("2_4_KVMCLIENT"), 0);
                } else if (this.m_pktHdr.status() == 1) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), LocaleStrings.getString("D_30_JVAPP") + JViewer.getIp() + LocaleStrings.getString("D_31_JVAPP"), LocaleStrings.getString("D_32_JVAPP"), 1);
                }
                if (JViewer.isStandalone()) {
                    JViewer.exit(0);
                    break;
                }
                JViewerApp.getInstance().getMainWindow().dispose();
                break;
            }
            case 33: {
                JViewerApp.getInstance().onStopConcurrentSession();
                break;
            }
            case 32: 
            case 50: {
                if (this.m_pktHdr.pktSize > 0) {
                    ByteBuffer byteBuffer = null;
                    byte[] byArray = null;
                    byArray = new byte[134];
                    this.m_ctrlMsg.get(byArray);
                    byte[] byArray2 = new byte[64];
                    byteBuffer = ByteBuffer.wrap(byArray);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byteBuffer.get(byArray2);
                    KVMSharing.KVM_CLIENT_USERNAME = new String(byArray2).trim();
                    byArray2 = new byte[65];
                    byteBuffer.get(byArray2);
                    KVMSharing.KVM_CLIENT_IP = new String(byArray2).trim();
                    KVMSharing.KVM_CLIENT_SESSION_INDEX = Integer.toString(byteBuffer.get());
                    KVMSharing.KVM_CLIENT_IPMI_PRIV = byteBuffer.getInt();
                    Debug.out.println(KVMSharing.KVM_CLIENT_USERNAME + " : " + KVMSharing.KVM_CLIENT_IP + " : " + KVMSharing.KVM_CLIENT_SESSION_INDEX + " :: " + KVMSharing.KVM_CLIENT_IPMI_PRIV);
                }
                if (this.m_pktHdr.type == 32) {
                    JViewerApp.getInstance().OnKvmPrevilage(this.m_pktHdr.status);
                } else {
                    JViewerApp.getInstance().onGetFullPermissionRequest(this.m_pktHdr.status);
                }
                JViewerApp.getInstance().getJVMenu().updateUserMenu();
                break;
            }
            case 27: {
                JViewerApp.getInstance().setWebPreviewerCaptureStatus(this.m_ctrlMsg.get());
                break;
            }
            case 34: {
                if (!JViewer.isjviewerapp() && !JViewer.isStandAloneApp()) break;
                byte by = (byte)this.m_pktHdr.status();
                if (!this.Host_OS_shutdown) {
                    Debug.out.println("POWER STATUS : " + by);
                    JViewerApp.getInstance().onGetPowerControlStatus(by);
                    break;
                }
                if (by == 1) {
                    try {
                        Thread.sleep(2000L);
                        this.sendPowerStatusRequest();
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                    }
                    break;
                }
                JViewerApp.getInstance().onGetPowerControlStatus(by);
                this.Host_OS_shutdown = false;
                break;
            }
            case 36: {
                byte by = (byte)this.m_pktHdr.status();
                Debug.out.println("RESPONSE : " + by);
                JViewerApp.getInstance().onPowerControlResponse(by);
                break;
            }
            case 37: {
                this.readConfServiceData();
                break;
            }
            case 38: {
                try {
                    this.onreadmouse_media_count();
                }
                catch (Exception exception) {
                    Debug.out.println(exception);
                }
                break;
            }
            case 39: {
                if (!JViewer.isjviewerapp() && !JViewer.isStandAloneApp()) break;
                this.readUserData();
                JViewerApp.getInstance().getJVMenu().updateUserMenu();
                this.sendFullScreenRequest();
                break;
            }
            case 40: {
                this.processUserMacroPacket(this.m_ctrlMsg);
                break;
            }
            case 49: {
                JViewerApp.getInstance().onGetIPMICommandResponse(this.m_ctrlMsg, this.m_pktHdr.status);
                break;
            }
            case 52: {
                JFrame jFrame = JViewer.getMainFrame();
                short s = this.m_pktHdr.status();
                if (s == this.hostLockStatus) break;
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoHostDisplayUnlock", false);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoHostDisplayLock", false);
                if (s == 0) {
                    if (KVMSharing.KVM_REQ_GIVEN == 0) {
                        JViewerApp.getInstance().changeHostDisplayLockStatus((short)0);
                    } else {
                        JViewerApp.getInstance().getM_wndFrame().getToolbar().turnOnHostDisplayButton(true);
                    }
                    if (this.hostLockStatus > 0 && this.hostLockStatus != 2) {
                        InfoDialog.showDialog((Component)jFrame, LocaleStrings.getString("2_23_KVMCLIENT"), LocaleStrings.getString("2_25_KVMCLIENT"), 1);
                    }
                    this.setHostLockStatus(s);
                    break;
                }
                if (s == 1) {
                    if (KVMSharing.KVM_REQ_GIVEN == 0) {
                        JViewerApp.getInstance().changeHostDisplayLockStatus((short)1);
                    } else {
                        JViewerApp.getInstance().getM_wndFrame().getToolbar().turnOnHostDisplayButton(false);
                    }
                    if (this.hostLockStatus >= 0 && this.hostLockStatus != 1 && this.hostLockStatus != 3) {
                        InfoDialog.showDialog((Component)jFrame, LocaleStrings.getString("2_24_KVMCLIENT"), LocaleStrings.getString("2_25_KVMCLIENT"), 1);
                    }
                    this.setHostLockStatus(s);
                    break;
                }
                if (s == 2) {
                    JViewerApp.getInstance().changeHostDisplayLockStatus((short)2);
                    if (this.hostLockStatus > 0 && this.hostLockStatus != 3) {
                        InfoDialog.showDialog((Component)jFrame, LocaleStrings.getString("2_29_KVMCLIENT"), LocaleStrings.getString("2_25_KVMCLIENT"), 1);
                    }
                    this.setHostLockStatus(s);
                    break;
                }
                if (s != 3) break;
                JViewerApp.getInstance().changeHostDisplayLockStatus((short)3);
                if (this.hostLockStatus >= 0 && this.hostLockStatus != 1 && this.hostLockStatus != 3) {
                    InfoDialog.showDialog((Component)jFrame, LocaleStrings.getString("2_24_KVMCLIENT"), LocaleStrings.getString("2_25_KVMCLIENT"), 1);
                }
                this.setHostLockStatus(s);
                break;
            }
            case 53: {
                JViewerApp.getInstance().onMediaLicenseStatus((byte)this.m_pktHdr.status());
                break;
            }
            case 56: {
                this.getVMediaFreeInstanceStatus(this.m_ctrlMsg);
                break;
            }
            case 57: {
                break;
            }
            case 59: {
                JViewerApp.getInstance().onConnFailed();
                break;
            }
            default: {
                JViewerApp.getInstance().getSockvmclient().onSocControlMessage(this.m_pktHdr, this.m_ctrlMsg);
            }
        }
    }

    public void sendFullScreenRequest() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)11, 0, (short)1);
    }

    public boolean redirection() {
        return this.m_redirection;
    }

    public int OnFormIVTPHdr_Send(short s, int n, short s2) {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(s, n, s2);
        int n2 = this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size());
        if (n2 != iVTPPktHdr.size()) {
            return -1;
        }
        return n2;
    }

    public void resumeRedirection() {
        this.m_redirection = true;
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)6, 0, (short)0);
        this.m_vidClnt.refresh();
        this.sendLEDRequest();
    }

    public void Stop_Cmd_Redirection() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)8, 0, (short)0);
    }

    public void sendLEDRequest() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)20, 0, (short)0);
    }

    public void sendPowerStatusRequest() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)34, 0, (short)0);
    }

    public void sendPowerControlCommand(byte by) {
        if (by == 5 || by == 0) {
            this.Host_OS_shutdown = true;
        }
        Debug.out.println("sendPowerControlCommand, command = " + by);
        this.OnFormIVTPHdr_Send((short)35, 0, by);
    }

    public int startRedirection() {
        if (this.m_redirection) {
            return 0;
        }
        if (JViewer.isSinglePortEnabled()) {
            if (JViewer.isKVMReconnectEnabled()) {
                if (JViewerApp.getInstance().getRetryConnection() && 0 > JViewerApp.getInstance().getSinglePortKvm().startConnect()) {
                    return -1;
                }
                JViewerApp.getInstance().setLocalport(JViewerApp.getInstance().getSinglePortKvm().getHttpsock().getLocalPort());
            }
            this.SetSocket(JViewerApp.getInstance().getSinglePortKvm().getHttpsock());
            String string = this.m_sock.getLocalAddress().toString();
            String[] stringArray = string.split("/");
            KVMSharing.KVM_CLIENT_OWN_IP = stringArray[1];
            if (KVMSharing.KVM_CLIENT_OWN_IP.compareToIgnoreCase("127.0.0.1") == 0) {
                try {
                    KVMSharing.KVM_CLIENT_OWN_IP = InetAddress.getLocalHost().getHostAddress().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (KVMSharing.KVM_CLIENT_OWN_IP.compareToIgnoreCase("0.0.0.0") == 0) {
                KVMSharing.KVM_CLIENT_OWN_IP = this.getipv6IP();
            }
            Debug.out.println("SPKVM m_sock.socket().getLocalAddress()" + string.toString());
            Debug.out.println("SPKVM m_sock.socket().getLocalAddress()" + KVMSharing.KVM_CLIENT_OWN_IP);
        } else if (-1 == this.connectVideo(this.m_bUseSSL)) {
            return -1;
        }
        Debug.out.println("Video socket approval received");
        this.m_NWListener = new NWListener(this);
        this.m_NWThread = new Thread((Runnable)this.m_NWListener, "listener");
        this.m_NWListener.startListener();
        this.m_NWThread.start();
        return 0;
    }

    public int OnValidVideoSession() {
        this.m_redirection = true;
        JViewerApp.getSoc_manager().getSOCApp().SOC_Session_validated();
        if (!JViewer.isWebPreviewer() && !JViewer.isBSODViewer()) {
            this.sendPowerStatusRequest();
            this.onSendLockScreen((byte)2);
            this.OnGetUserMacro();
            Debug.out.println("KVM Redirection Started!");
        }
        return 0;
    }

    private void OnGetUserMacro() {
        this.sendGetUserMacro();
    }

    public int sendGetUserMacro() {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(40, 0, 0);
        if (this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
            return 1;
        }
        return 0;
    }

    public boolean isKMEncryptionEnabled() {
        return this.m_encrypt;
    }

    public void notifyEncryption(boolean bl) {
        if (!this.m_redirection) {
            return;
        }
        this.m_encrypt = bl;
    }

    public void stopRedirection() {
        if (!this.m_redirection && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPING) {
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        this.VideoSocketclose();
        this.m_NWListener.destroyListener();
        this.m_redirection = false;
        try {
            this.m_vidClnt.reset();
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        this.m_kmCrypt.close();
    }

    public void pauseRedirection() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)4, 0, (short)0);
        this.m_vidClnt.reset();
        this.m_redirection = false;
    }

    public void MediaRedirectionState(byte by) {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)24, 0, by);
    }

    public int read_data(Socket socket, byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int n3 = -1;
        while (n2 != 0) {
            try {
                n3 = socket.getInputStream().read(byArray, n, n2);
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                if (JViewer.isKVMReconnectEnabled() && (JViewer.isjviewerapp() || JViewer.isStandAloneApp())) {
                    JViewerApp.getInstance().onReconnect();
                }
                return -1;
            }
            if (n3 <= 0) {
                return n3;
            }
            n2 -= n3;
            n += n3;
        }
        n3 = byArray.length;
        return n3;
    }

    public int sendKMMessage(USBMessage uSBMessage) {
        if (KVMSharing.KVM_REQ_GIVEN != 0 || JViewerApp.getInstance().getPowerStatus() != 1) {
            return -1;
        }
        if (this.m_redirection) {
            byte[] byArray = this.m_encrypt && this.m_kmCrypt.isInitialized() ? uSBMessage.encryptedReport(this.m_kmCrypt) : uSBMessage.report();
            if (JViewerApp.getInstance().getM_USBKeyRep().KeyBoardDataNull) {
                JViewerApp.getInstance().getM_USBKeyRep().KeyBoardDataNull = false;
                return 0;
            }
            if (byArray == null) {
                return 0;
            }
            if (this.sendMessage(byArray, byArray.length) != byArray.length) {
                Debug.out.println("Error sending USB Keyboard/Mouse packet");
                return -1;
            }
        }
        return 0;
    }

    public int SendKVMPrevilage(byte by, String string) {
        ByteBuffer byteBuffer = null;
        int n = -1;
        byte[] byArray = null;
        int n2 = -1;
        String string2 = null;
        String string3 = null;
        Debug.out.println("User2_status" + by);
        short s = (short)(1 + (by << 8));
        Debug.out.println("send_status" + s);
        n2 = string.indexOf(58);
        string2 = string.substring(0, n2).trim();
        string3 = string.substring(n2 + 2, string.indexOf(58, n2 + 2)).trim();
        int n3 = Integer.parseInt(string.substring(string.lastIndexOf(58) + 1, string.length()).trim());
        byArray = new byte[64];
        byArray = string2.getBytes();
        byteBuffer = ByteBuffer.allocate(134);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        byteBuffer.put(byArray);
        for (n2 = byteBuffer.position(); n2 < 64; ++n2) {
            byteBuffer.put((byte)0);
        }
        byArray = new byte[65];
        byArray = string3.getBytes();
        byteBuffer.put(byArray);
        for (n2 = byteBuffer.position(); n2 < 129; ++n2) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.put((byte)n3);
        byteBuffer.rewind();
        byteBuffer.position(0);
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(32, byteBuffer.limit(), s);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(iVTPPktHdr.size() + iVTPPktHdr.pktSize());
        byteBuffer2.position(0);
        byteBuffer2.put(iVTPPktHdr.array());
        byteBuffer2.put(byteBuffer.array());
        byteBuffer2.position(0);
        byte[] byArray2 = new byte[byteBuffer2.limit()];
        byteBuffer2.get(byArray2, 0, byteBuffer2.limit());
        n = this.sendMessage(byArray2, byArray2.length);
        if (byArray2.length != n) {
            return -1;
        }
        return 0;
    }

    public int sendKVMFullPermissionRequest() {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(50, 0, 0);
        if (this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
            return -1;
        }
        return 0;
    }

    public int sendKeepAliveRequest() {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(57, 0, 0);
        try {
            if (this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
                return 0;
            }
            this.getSocket().getOutputStream().flush();
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkReconnect() {
        if (!JViewerApp.getInstance().getRetryConnection()) {
            this.m_redirection = false;
            JViewerApp.getInstance().setSessionLive(false);
            JViewerApp.getInstance().setRetryConnection(true);
            JViewerApp.getInstance().OnVideoStopRedirection();
        }
        if (JViewerApp.getInstance().getVMDialog() != null) {
            JViewerApp.getInstance().getVMDialog().showDialog(false);
        }
        InfoDialog.showDialog((Component)JViewer.getMainFrame(), LocaleStrings.getString("D_64_JVAPP"), 4, JViewer.getRetryInterval());
        Object object = JViewerApp.getInstance().getRetryCountSync();
        synchronized (object) {
            try {
                JViewerApp.getInstance().getRetryCountSync().wait();
                JViewerApp.getInstance().setCurrentRetryCount(JViewerApp.getInstance().getCurrentRetryCount() + 1);
            }
            catch (InterruptedException interruptedException) {
                Debug.out.println(interruptedException);
            }
        }
    }

    public int SendMouseMode(byte by) {
        Debug.out.println("MouseMode" + by);
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(28, 0, by);
        if (this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
            return 1;
        }
        return 0;
    }

    public void setEncryption(boolean bl) {
        if (!this.m_redirection) {
            return;
        }
        if (bl) {
            this.m_encrypt = true;
            this.OnFormIVTPHdr_Send((short)12, 0, (short)0);
        } else {
            this.m_encrypt = false;
            DISABLE_ENCRPT_FLAG = true;
            this.OnFormIVTPHdr_Send((short)13, 0, (short)0);
        }
    }

    public KMCrypt getCrypt() {
        return this.m_kmCrypt;
    }

    public int setBandwidth(int n) {
        if (!this.m_redirection) {
            return -1;
        }
        CfgBandwidth cfgBandwidth = new CfgBandwidth(n);
        if (cfgBandwidth.size() != this.sendMessage(cfgBandwidth.report(), cfgBandwidth.size())) {
            Debug.out.println("Failed to send Config Bandwidth message");
            return -1;
        }
        return 0;
    }

    public int autoDetect() {
        if (!this.m_redirection) {
            return -1;
        }
        AutoDetectBw autoDetectBw = new AutoDetectBw(0xC80000);
        if (autoDetectBw.size() != this.sendMessage(autoDetectBw.report(), autoDetectBw.size())) {
            Debug.out.println("Failed to send auto detect message");
            return -1;
        }
        return 0;
    }

    public void onStartReading() {
        this.m_startTS = System.currentTimeMillis();
    }

    public void onStopReading() {
        this.m_stopTS = System.currentTimeMillis();
        int n = CfgBandwidth.determineBandwidth(this.m_stopTS - this.m_startTS);
        Debug.out.println("Time " + (this.m_stopTS - this.m_startTS) + ", Bandwidth " + n);
        String string = "unknown";
        JViewerApp.getInstance().OnOptionsBandwidth(n);
        switch (n) {
            case 0xC80000: {
                string = "100mbps";
                break;
            }
            case 0x140000: {
                string = "10mbps";
                break;
            }
            case 131072: {
                string = "1mbps";
                break;
            }
            case 65536: {
                string = "512kbps";
                break;
            }
            case 32768: {
                string = "256kbps";
            }
        }
        JViewerApp.getInstance().updateBandwidthMsg(string);
    }

    public KVMReader getSocReader(short s) {
        return (KVMReader)JViewerApp.getInstance().getSockvmclient().getSOCReader(s);
    }

    public boolean isM_redirection() {
        return this.m_redirection;
    }

    public void setM_redirection(boolean bl) {
        this.m_redirection = bl;
    }

    public void processUserMacroPacket(ByteBuffer byteBuffer) {
        if (JViewerApp.getInstance().getAddMacro() == null) {
            JViewerApp.getInstance().setAddMacro(new AddMacro(byteBuffer));
        } else {
            JViewerApp.getInstance().getAddMacro().setMacroBuffer(byteBuffer);
        }
        JViewerApp.getInstance().getAddMacro().parseDataToMenu();
        if (KVMSharing.KVM_REQ_GIVEN != 2 && !KVMShareDialog.isMasterSession) {
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("Add Hotkeys", true);
        }
    }

    public int sendUserMacroData(byte[] byArray) {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(41, 960, 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + iVTPPktHdr.pktSize());
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        byte[] byArray2 = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray2, 0, byteBuffer.limit());
        if (byArray2.length != this.sendMessage(byArray2, byArray2.length)) {
            return -1;
        }
        return 0;
    }

    public void readConfServiceData() {
        block6: {
            if (this.m_pktHdr.pktSize <= 0) break block6;
            byte[] byArray = new byte[285];
            this.m_ctrlMsg.get(byArray);
            int n = 0;
            if (this.confPacket == null) {
                this.confPacket = new ConfPkt[5];
                byte[] byArray2 = new byte[57];
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < 57; ++j) {
                        byArray2[j] = byArray[j + n];
                    }
                    this.confPacket[i] = new ConfPkt(byArray2);
                    n += 57;
                }
            } else {
                ConfPkt[] confPktArray = new ConfPkt[5];
                byte[] byArray3 = new byte[57];
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < 57; ++j) {
                        byArray3[j] = byArray[j + n];
                    }
                    confPktArray[i] = new ConfPkt(byArray3);
                    this.compareConfData(confPktArray[i], i);
                    n += 57;
                }
            }
        }
    }

    public void compareConfData(ConfPkt confPkt, int n) {
        if (JViewer.isStandAloneApp() && confPkt.getServiceName().equals("web")) {
            return;
        }
        String string = "";
        if (confPkt.getCurrentState() != this.confPacket[n].getCurrentState()) {
            string = confPkt.getCurrentState() == 0 ? string + "* " + LocaleStrings.getString("2_12_KVMCLIENT") + " : " + LocaleStrings.getString("2_13_KVMCLIENT") + "\n" : string + "* " + LocaleStrings.getString("2_12_KVMCLIENT") + " : " + LocaleStrings.getString("2_14_KVMCLIENT") + "\n";
            this.confPacket[n].setCurrentState(confPkt.getCurrentState());
            this.onChangeState(confPkt, confPkt.getServiceName());
        }
        if (!confPkt.getInterfaceName().equals(this.confPacket[n].getInterfaceName())) {
            string = string + "* " + LocaleStrings.getString("2_15_KVMCLIENT") + "\n";
            this.confPacket[n].setInterfaceName(confPkt.getInterfaceName().toCharArray());
        }
        if (confPkt.getNonSecureAccessPort() != this.confPacket[n].getNonSecureAccessPort()) {
            string = string + "* " + LocaleStrings.getString("2_16_KVMCLIENT") + "\n";
            this.confPacket[n].setNonSecureAccessPort(confPkt.getNonSecureAccessPort());
            this.onChangeNonSecurePort(confPkt, confPkt.getServiceName());
        }
        if (confPkt.getSecureAccessPort() != this.confPacket[n].getSecureAccessPort()) {
            string = string + "* " + LocaleStrings.getString("2_17_KVMCLIENT") + "\n";
            this.confPacket[n].setSecureAccessPort(confPkt.getSecureAccessPort());
            this.onChangeSecurePort(confPkt, confPkt.getServiceName());
        }
        if (confPkt.getSessionInactivityTimeout() != this.confPacket[n].getSessionInactivityTimeout()) {
            string = string + "* " + LocaleStrings.getString("2_18_KVMCLIENT") + "\n";
            this.confPacket[n].setSessionInactivityTimeout(confPkt.getSessionInactivityTimeout());
        }
        if (confPkt.getMaxAllowedSessions() != this.confPacket[n].getMaxAllowedSessions()) {
            string = string + "* " + LocaleStrings.getString("2_19_KVMCLIENT") + "\n";
            this.confPacket[n].setMaxAllowedSessions(confPkt.getMaxAllowedSessions());
        }
        if (confPkt.getMaxSessionInactivityTimeout() != this.confPacket[n].getMaxSessionInactivityTimeout()) {
            string = string + "* " + LocaleStrings.getString("2_20_KVMCLIENT") + "\n";
            this.confPacket[n].setMaxSessionInactivityTimeout(confPkt.getMaxSessionInactivityTimeout());
        }
        if (confPkt.getMinSessionInactivityTimeout() != this.confPacket[n].getMinSessionInactivityTimeout()) {
            string = string + "* " + LocaleStrings.getString("2_21_KVMCLIENT") + "\n";
            this.confPacket[n].setMinSessionInactivityTimeout(confPkt.getMinSessionInactivityTimeout());
        }
        if (!string.equals(null) && string.length() != 0) {
            this.confPacket[n].showConfDataChangeMsg(string);
        }
    }

    public void onChangeState(ConfPkt confPkt, String string) {
        if (string.equals("cd-media")) {
            JViewer.setCD_State(confPkt.getCurrentState());
        }
        if (string.equals("hd-media")) {
            JViewer.setHD_State(confPkt.getCurrentState());
        }
    }

    public void onChangeSecurePort(ConfPkt confPkt, String string) {
        if (!JViewerApp.getInstance().isM_bVMUseSSL()) {
            return;
        }
        if (string.compareTo("cd-media") == 0) {
            JViewerApp.getInstance().setM_cdPort(confPkt.getSecureAccessPort());
        }
        if (string.compareTo("hd-media") == 0) {
            JViewerApp.getInstance().setM_hdPort(confPkt.getSecureAccessPort());
        }
        if (JViewerApp.getInstance().getVMDialog() != null) {
            JViewerApp.getInstance().getVMDialog().setVisible(false);
        }
    }

    public void onChangeNonSecurePort(ConfPkt confPkt, String string) {
        if (JViewerApp.getInstance().isM_bVMUseSSL()) {
            return;
        }
        if (string.compareTo("cd-media") == 0) {
            JViewerApp.getInstance().setM_cdPort(confPkt.getNonSecureAccessPort());
        }
        if (string.compareTo("hd-media") == 0) {
            JViewerApp.getInstance().setM_hdPort(confPkt.getNonSecureAccessPort());
        }
        if (JViewerApp.getInstance().getVMDialog() != null) {
            JViewerApp.getInstance().getVMDialog().setVisible(false);
        }
    }

    private void onreadmouse_media_count() {
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = new byte[this.m_pktHdr.pktSize()];
        this.m_ctrlMsg.get(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte by = 0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        VMDialog vMDialog = JViewerApp.getInstance().getVMDialog();
        if (JViewer.isKVMReconnectEnabled()) {
            JViewer.setRetryCount(byteBuffer.getInt());
            JViewer.setRetryInterval(byteBuffer.getInt());
        }
        by = byteBuffer.get();
        this.hostLockFeatureStatus = byteBuffer.get();
        this.hostLockFeatureStatus = (byte)(this.hostLockFeatureStatus & 1);
        n = byteBuffer.getInt();
        n2 = byteBuffer.getInt();
        n3 = byteBuffer.getInt();
        n4 = byteBuffer.getInt();
        n5 = byteBuffer.getInt();
        n6 = byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        n7 = byteBuffer.getInt();
        n8 = byteBuffer.getInt();
        n9 = byteBuffer.getInt();
        JViewer.setPowerSaveMode((byte)n7);
        if (JViewer.getNum_CD() != n4) {
            bl2 = true;
        }
        if (JViewer.getNum_HD() != n5) {
            bl2 = true;
        }
        if (!bl2 && (JViewer.getOEMFeatureStatus() & 0x80L) == 128L) {
            if (JViewer.getKVM_Num_CD() != n8) {
                bl2 = true;
            }
            if (JViewer.getKVM_Num_HD() != n9) {
                bl2 = true;
            }
        }
        if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() != by) {
            JViewerApp.getInstance().getRCView().removeKMListener();
            JViewerApp.getInstance().getRCView().USBsyncCursor(false);
            JViewerApp.getInstance().OnGetMouseMode(by);
        } else if (this.hostLockFeatureStatus == 1) {
            JViewerApp.getInstance().changeHostDisplayLockStatus(this.hostLockStatus);
        } else if (this.hostLockFeatureStatus != 1) {
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoHostDisplayUnlock", false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoHostDisplayLock", false);
        } else if (!bl2 && (bl = JViewerApp.getInstance().syncVMediaRedirection())) {
            bl2 = true;
        }
        if (bl2) {
            bl = JViewerApp.getInstance().syncVMediaRedirection();
            JFrame jFrame = JViewer.getMainFrame();
            if (JViewerApp.getInstance().getVMDialog() != null && JViewerApp.getInstance().getVMDialog().isShowing()) {
                InfoDialog.showDialog((Component)jFrame, LocaleStrings.getString("2_7_KVMCLIENT"), LocaleStrings.getString("2_10_KVMCLIENT"), 1);
                if (bl) {
                    JViewerApp.getInstance().getM_frame().stopVMediaRedirection(null);
                }
            } else if (bl) {
                InfoDialog.showDialog((Component)jFrame, LocaleStrings.getString("2_7_KVMCLIENT") + LocaleStrings.getString("2_9_KVMCLIENT"), LocaleStrings.getString("2_10_KVMCLIENT"), 1);
                JViewerApp.getInstance().getM_frame().stopVMediaRedirection(null);
            } else {
                InfoDialog.showDialog((Component)jFrame, LocaleStrings.getString("2_7_KVMCLIENT"), LocaleStrings.getString("2_10_KVMCLIENT"), 1);
            }
            if ((JViewer.getOEMFeatureStatus() & 0x80L) == 128L) {
                JViewer.setKVM_Num_CD((byte)n8);
                JViewer.setKVM_Num_HD((byte)n9);
                JViewerApp.getInstance().setFreeCDNum(n8);
                JViewerApp.getInstance().setFreeHDNum(n9);
            } else {
                JViewer.setNum_CD((byte)n4);
                JViewer.setNum_HD((byte)n5);
                JViewerApp.getInstance().setFreeCDNum(n4);
                JViewerApp.getInstance().setFreeHDNum(n5);
            }
            if (vMDialog != null) {
                vMDialog.reInitialize();
            }
            VMApp.getInstance().getIUSBRedirSession().updateCDToolbarButtonStatus(false);
            VMApp.getInstance().getIUSBRedirSession().updateHDToolbarButtonStatus(false);
            JViewerApp.getInstance().updateFreeDeviceStatus();
        }
    }

    public void readUserData() {
        if (this.m_pktHdr.pktSize > 0) {
            byte[] byArray = null;
            byArray = new byte[this.m_pktHdr.pktSize];
            this.m_ctrlMsg.get(byArray);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.userDataPacket = new UserDataPacket(byteBuffer);
            userData = this.userDataPacket.getUserInfo();
            numUsers = this.userDataPacket.getNumUsers();
        }
    }

    public UserDataPacket getUserDataPacket() {
        return this.userDataPacket;
    }

    public static int getNumUsers() {
        return numUsers;
    }

    public static String[] getUserData() {
        return userData;
    }

    public int sendNextMasterInfo(ByteBuffer byteBuffer) {
        int n = -1;
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(50, byteBuffer.limit(), 0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(iVTPPktHdr.size() + iVTPPktHdr.pktSize());
        byteBuffer2.position(0);
        byteBuffer2.put(iVTPPktHdr.array());
        byteBuffer2.put(byteBuffer.array());
        byteBuffer2.position(0);
        byte[] byArray = new byte[byteBuffer2.limit()];
        byteBuffer2.get(byArray, 0, byteBuffer2.limit());
        n = this.sendMessage(byArray, byArray.length);
        if (byArray.length != n) {
            return -1;
        }
        return 0;
    }

    public int onSendLockScreen(byte by) {
        byte by2 = 0;
        by2 = by;
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(51, 1, 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + 1);
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.put(by2);
        byteBuffer.position(0);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray, 0, byteBuffer.limit());
        if (byArray.length != this.sendMessage(byArray, byArray.length)) {
            Debug.out.println("Failed to send the lockstatus to the card");
            return -1;
        }
        return 0;
    }

    public short getHostLockStatus() {
        return this.hostLockStatus;
    }

    public void setHostLockStatus(short s) {
        this.hostLockStatus = s;
    }

    public byte getHostLockFeatureStatus() {
        return this.hostLockFeatureStatus;
    }

    public boolean isStopSignalRecieved() {
        return this.stopSignalReceived;
    }

    public int sendKeyBoardLang() {
        String string = JViewer.getKeyboardLayout();
        Debug.out.println("KBD lang" + string);
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(55, string.length(), 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + iVTPPktHdr.pktSize());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.put(string.getBytes());
        byteBuffer.position(0);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray, 0, byteBuffer.limit());
        if (byArray.length != this.sendMessage(byArray, byArray.length)) {
            System.out.println("Failed to send the keyboard language to the card");
            return -1;
        }
        return 0;
    }

    private void getVMediaFreeInstanceStatus(ByteBuffer byteBuffer) {
        int n = 0;
        int n2 = 0;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        n = byteBuffer.getInt();
        n2 = byteBuffer.getInt();
        JViewerApp.getInstance().setFreeCDNum(n);
        JViewerApp.getInstance().setFreeHDNum(n2);
        JViewerApp.getInstance().updateFreeDeviceStatus();
    }

    public void setSocketTimeout() {
        if (JViewer.isKVMReconnectEnabled()) {
            try {
                this.getSocket().setSoTimeout(6000);
            }
            catch (SocketException socketException) {
                Debug.out.println(socketException);
            }
        }
    }

    public boolean isHost_OS_shutdown() {
        return this.Host_OS_shutdown;
    }

    public void setHost_OS_shutdown(boolean bl) {
        this.Host_OS_shutdown = bl;
    }

    public int SendKillSession(byte by, int n) {
        int n2 = 0;
        ByteBuffer byteBuffer = null;
        IVTPPktHdr iVTPPktHdr = null;
        byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        byteBuffer.put(by);
        byteBuffer.putInt(n);
        byteBuffer.rewind();
        byteBuffer.position(0);
        iVTPPktHdr = new IVTPPktHdr(54, byteBuffer.limit(), 0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(iVTPPktHdr.size() + iVTPPktHdr.pktSize());
        byteBuffer2.position(0);
        byteBuffer2.put(iVTPPktHdr.array());
        byteBuffer2.put(byteBuffer.array());
        byteBuffer2.position(0);
        byte[] byArray = new byte[byteBuffer2.limit()];
        byteBuffer2.get(byArray, 0, byteBuffer2.limit());
        n2 = this.sendMessage(byArray, byArray.length);
        if (byArray.length != n2) {
            return -1;
        }
        return n2;
    }

    static {
        numUsers = 0;
        DISABLE_ENCRPT_FLAG = false;
    }
}

