/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc.video;

import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.jvvideo.JVVideo;
import com.ami.kvm.jviewer.soc.SOCCreateBufferImage;
import com.ami.kvm.jviewer.soc.SOCJVVideo;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class HardwareCursor {
    private short[] m_pattern = new short[4096];
    private byte[] CursorColorData = new byte[3];
    private int CursorData;
    private int Alpha;
    private byte ANDBit;
    private byte XORBit;
    private int cursorType;
    private int checksum;
    private short xpos;
    private short ypos;
    private short xoffset;
    private short yoffset;
    private boolean m_firstTime = true;
    private Rectangle m_prevCursorRect;
    private Rectangle m_currCursorRect;
    private JViewerView viewerView = JViewerApp.getInstance().getRCView();
    private SOCJVVideo socVideo;

    public HardwareCursor(JVVideo jVVideo) {
        this.socVideo = (SOCJVVideo)jVVideo.getVideoSOC();
        this.m_prevCursorRect = new Rectangle(0, 0, 0, 0);
        this.m_currCursorRect = new Rectangle(0, 0, 64, 64);
    }

    public void set(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.cursorType = byteBuffer.get();
        this.checksum = byteBuffer.getInt();
        this.xpos = byteBuffer.getShort();
        this.ypos = byteBuffer.getShort();
        this.xoffset = byteBuffer.getShort();
        this.yoffset = byteBuffer.getShort();
        if (byteBuffer.remaining() > 0) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get(this.m_pattern);
        }
    }

    public void drawCursor() {
        int n = 0;
        int n2 = this.viewerView.viewWidth();
        int n3 = this.viewerView.viewHeight();
        if (!this.m_firstTime) {
            this.socVideo.RestoreScreenContent(this.m_prevCursorRect);
            this.viewerView.repaint(this.m_prevCursorRect);
        } else {
            this.m_firstTime = false;
        }
        this.m_currCursorRect.setLocation(this.xpos, this.ypos);
        int n4 = n2 - this.xpos < 64 ? n2 - this.xpos : 64;
        int n5 = n3 - this.ypos < 64 ? n3 - this.ypos : 64;
        this.m_currCursorRect.setSize(n4, n5);
        this.socVideo.SaveScreenContent(this.m_currCursorRect);
        this.m_prevCursorRect.setBounds(this.m_currCursorRect);
        byte[] byArray = ((SOCCreateBufferImage)JViewerApp.getInstance().getPrepare_buf()).imageMemoryByte();
        for (int i = 0; i < 64 - this.yoffset; ++i) {
            if (i + this.ypos >= n3) continue;
            for (int j = 0; j < 64 - this.xoffset; ++j) {
                if (j + this.xpos >= n2) continue;
                n = ((i + this.ypos) * n2 + (j + this.xpos)) * 3;
                this.CursorData = this.m_pattern[(i + this.yoffset) * 64 + (j + this.xoffset)];
                this.CursorColorData[0] = (byte)((this.CursorData & 0xF00) >> 4);
                this.CursorColorData[1] = (byte)(this.CursorData & 0xF0);
                this.CursorColorData[2] = (byte)((this.CursorData & 0xF) << 4);
                if (this.cursorType == 1) {
                    this.Alpha = (this.CursorData & 0xF000) >> 12;
                    byArray[n + 2] = (byte)((15 - this.Alpha) * byArray[n + 2] / 15 + this.Alpha * this.CursorColorData[0] / 15);
                    byArray[n + 1] = (byte)((15 - this.Alpha) * byArray[n + 1] / 15 + this.Alpha * this.CursorColorData[1] / 15);
                    byArray[n] = (byte)((15 - this.Alpha) * byArray[n] / 15 + this.Alpha * this.CursorColorData[2] / 15);
                    continue;
                }
                this.ANDBit = (byte)((this.CursorData & 0x8000) >> 15);
                this.XORBit = (byte)((this.CursorData & 0x4000) >> 14);
                if (this.ANDBit == 0) {
                    byArray[n + 2] = this.CursorColorData[0];
                    byArray[n + 1] = this.CursorColorData[1];
                    byArray[n + 0] = this.CursorColorData[2];
                    continue;
                }
                if (this.XORBit == 0) continue;
                byArray[n + 2] = ~byArray[n + 2];
                byArray[n + 1] = ~byArray[n + 1];
                byArray[n] = ~byArray[n];
            }
        }
        this.viewerView.repaint(this.m_currCursorRect);
    }
}

