/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.DevicePanel;

public class RedirectionStatusMonitor
extends Thread {
    private boolean cdRedirected = false;
    private boolean hdRedirected = false;
    private IUSBRedirSession iusbRedirSession = VMApp.getInstance().getIUSBRedirSession();
    private boolean run = true;

    public RedirectionStatusMonitor() {
        this.start();
    }

    @Override
    public void run() {
        DevicePanel devicePanel = null;
        while (this.run) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                Debug.out.println(interruptedException);
            }
            if (this.iusbRedirSession == null) continue;
            try {
                int n;
                int n2 = 0;
                int n3 = 0;
                n2 = VMApp.getInstance().getNumCD();
                n3 = VMApp.getInstance().getNumHD();
                this.cdRedirected = false;
                this.hdRedirected = false;
                for (n = 0; n < n2; ++n) {
                    try {
                        if (this.iusbRedirSession.getCdromSession(n) == null) continue;
                        devicePanel = VMApp.getVMPane().getDeviceControlPanel(0, n).getDevicePanel();
                        if (this.iusbRedirSession.getCdromSession(n).isCdRedirectionKilled()) {
                            this.iusbRedirSession.getCdromSession(n).setCdRedirectionKilled(false);
                            this.iusbRedirSession.StopCDROMRedir(n, 2);
                            if (!devicePanel.isImageSelected()) {
                                VMApp.getVMPane().physicalDriveChangeState(0, n, devicePanel.getSelectedDeviceString(), true);
                            }
                            VMApp.getVMPane().getDeviceControlPanel(0, n).updateDeviceControlPanel();
                            continue;
                        }
                        if (this.iusbRedirSession.getCdromSession(n).isCdImageEjected()) {
                            if (this.iusbRedirSession.getCdromSession(n).isCdImageRedirected()) {
                                this.iusbRedirSession.StopISORedir(n, 1);
                            } else {
                                this.iusbRedirSession.StopCDROMRedir(n, 1);
                            }
                            if (!devicePanel.isImageSelected()) {
                                VMApp.getVMPane().physicalDriveChangeState(0, n, devicePanel.getSelectedDeviceString(), true);
                            }
                            VMApp.getVMPane().getDeviceControlPanel(0, n).updateDeviceControlPanel();
                            continue;
                        }
                        if (this.iusbRedirSession.getCdromSession(n).isCdServiceRestarted()) {
                            if (this.iusbRedirSession.getCdromSession(n).isCdImageRedirected()) {
                                this.iusbRedirSession.StopISORedir(n, 4);
                            } else {
                                this.iusbRedirSession.StopCDROMRedir(n, 4);
                            }
                            if (!devicePanel.isImageSelected()) {
                                VMApp.getVMPane().physicalDriveChangeState(0, n, devicePanel.getSelectedDeviceString(), true);
                            }
                            VMApp.getVMPane().getDeviceControlPanel(0, n).updateDeviceControlPanel();
                            continue;
                        }
                        this.cdRedirected = true;
                        continue;
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                        VMApp.getVMPane().getDeviceControlPanel(0, n).updateDeviceControlPanel();
                    }
                }
                if (!JViewer.isVMApp() && !this.cdRedirected) {
                    this.iusbRedirSession.updateCDToolbarButtonStatus(this.cdRedirected);
                }
                for (n = 0; n < n3; ++n) {
                    try {
                        if (this.iusbRedirSession.getHarddiskSession(n) == null) continue;
                        devicePanel = VMApp.getVMPane().getDeviceControlPanel(2, n).getDevicePanel();
                        if (this.iusbRedirSession.getHarddiskSession(n).isHdRedirectionKilled()) {
                            this.iusbRedirSession.getHarddiskSession(n).setHdRedirectionKilled(false);
                            this.iusbRedirSession.StopHarddiskImageRedir(n, 2);
                            if (!devicePanel.isImageSelected()) {
                                VMApp.getVMPane().physicalDriveChangeState(2, n, devicePanel.getSelectedDeviceString(), true);
                            }
                            VMApp.getVMPane().getDeviceControlPanel(2, n).updateDeviceControlPanel();
                            continue;
                        }
                        if (this.iusbRedirSession.getHarddiskSession(n).isHdImageEjected()) {
                            if (this.iusbRedirSession.getHarddiskSession(n).isHdImageRedirected()) {
                                this.iusbRedirSession.StopHarddiskImageRedir(n, 1);
                            } else {
                                this.iusbRedirSession.StopHarddiskRedir(n, 1);
                            }
                            if (!devicePanel.isImageSelected()) {
                                VMApp.getVMPane().physicalDriveChangeState(2, n, devicePanel.getSelectedDeviceString(), true);
                            }
                            VMApp.getVMPane().getDeviceControlPanel(2, n).updateDeviceControlPanel();
                            continue;
                        }
                        if (this.iusbRedirSession.getHarddiskSession(n).isHdServiceRestarted()) {
                            if (this.iusbRedirSession.getHarddiskSession(n).isHdImageRedirected()) {
                                this.iusbRedirSession.StopHarddiskImageRedir(n, 4);
                            } else {
                                this.iusbRedirSession.StopHarddiskRedir(n, 4);
                            }
                            if (!devicePanel.isImageSelected()) {
                                VMApp.getVMPane().physicalDriveChangeState(2, n, devicePanel.getSelectedDeviceString(), true);
                            }
                            VMApp.getVMPane().getDeviceControlPanel(2, n).updateDeviceControlPanel();
                            continue;
                        }
                        this.hdRedirected = true;
                        continue;
                    }
                    catch (Exception exception) {
                        Debug.out.println(exception);
                        VMApp.getVMPane().getDeviceControlPanel(2, n).updateDeviceControlPanel();
                    }
                }
                if (JViewer.isVMApp() || this.hdRedirected) continue;
                this.iusbRedirSession.updateHDToolbarButtonStatus(this.hdRedirected);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    public void stopRedirectionStatusMonitior() {
        this.run = false;
    }
}

