/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.DevicePanel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

public class VMActionListener
implements ActionListener {
    public static final String CD_IMAGE_PATH_ACTION_CMD = "CD_IMAGE_PATH_ADDRESS_";
    public static final String HD_IMAGE_PATH_ACTION_CMD = "HD_IMAGE_PATH_ADDRESS_";
    public static final String CD_CONNECT_ACTION_CMD = "CONNECT_CD_";
    public static final String HD_CONNECT_ACTION_CMD = "CONNECT_HD_";
    public static final String CD_BROWSE_ACTION_CMD = "BROWSE_CD_";
    public static final String HD_BROWSE_ACTION_CMD = "BROWSE_HD_";

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith(CD_BROWSE_ACTION_CMD)) {
            String string2;
            int n = this.getDeviceIndex(string);
            DevicePanel devicePanel = VMApp.getVMPane().getDeviceControlPanel(0, n).getDevicePanel();
            if (devicePanel.getSelectedImagePath() == null) {
                devicePanel.setSelectedImagePath(VMApp.cdImagePath[n][0]);
            }
            if ((string2 = VMApp.getInstance().getIUSBRedirSession().cdImageSelector(devicePanel.getSelectedImagePath())) != null) {
                devicePanel.setImagePath(string2, 0, n);
                devicePanel.setSelectedImagePath(string2);
            }
        } else if (string.startsWith(HD_BROWSE_ACTION_CMD)) {
            String string3;
            int n = this.getDeviceIndex(string);
            DevicePanel devicePanel = VMApp.getVMPane().getDeviceControlPanel(2, n).getDevicePanel();
            if (devicePanel.getSelectedImagePath() == null) {
                devicePanel.setSelectedImagePath(VMApp.hdImagePath[n][0]);
            }
            if ((string3 = VMApp.getInstance().getIUSBRedirSession().floppyImageSelector(devicePanel.getSelectedImagePath())) != null) {
                devicePanel.setImagePath(string3, 2, n);
                devicePanel.setSelectedImagePath(string3);
            }
        } else if (string.startsWith(CD_CONNECT_ACTION_CMD)) {
            int n = this.getDeviceIndex(string);
            if (!JViewer.isCdServiceEnabled()) {
                Window window = null;
                if (JViewer.isVMApp()) {
                    VMApp.getInstance();
                    window = VMApp.getVMFrame();
                }
                window = JViewerApp.getInstance().getVMDialog();
                Debug.out.println("cdrom service disabled");
                JOptionPane.showMessageDialog(window, LocaleStrings.getString("G_27_VMD"), LocaleStrings.getString("G_26_VMD"), 0);
                return;
            }
            VMApp.getInstance().getRedirectionController().handleDeviceRedirection(0, n);
        } else if (string.startsWith(HD_CONNECT_ACTION_CMD)) {
            int n = this.getDeviceIndex(string);
            if (!JViewer.isHdServiceEnabled()) {
                Window window = null;
                if (JViewer.isVMApp()) {
                    VMApp.getInstance();
                    window = VMApp.getVMFrame();
                } else {
                    window = JViewerApp.getInstance().getVMDialog();
                }
                Debug.out.println("harddisk service disabled");
                JOptionPane.showMessageDialog(window, LocaleStrings.getString("G_31_VMD"), LocaleStrings.getString("G_30_VMD"), 0);
                return;
            }
            VMApp.getInstance().getRedirectionController().handleDeviceRedirection(2, n);
        }
    }

    private int getDeviceIndex(String string) {
        int n = 0;
        String string2 = string.substring(string.lastIndexOf(95) + 1, string.length());
        n = Integer.parseInt(string2);
        return n;
    }
}

