/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia.gui;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.DeviceControlPanel;
import com.ami.vmedia.gui.DevicePanel;
import com.ami.vmedia.gui.StatusTabPanel;
import com.ami.vmedia.gui.StatusTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VMPane
extends JPanel {
    public static final String CD_DEV_CTRL_PANEL_KEY = "CD_DEV_CTRL_PANEL_";
    public static final String HD_DEV_CTRL_PANEL_KEY = "HD_DEV_CTRL_PANEL_";
    private StatusTable cdStatusTable;
    private StatusTable hdStatusTable;
    private StatusTabPanel statusTabPanel;
    private JTabbedPane vmDevicePane;
    private int numCD;
    private int numHD;
    private HashMap<String, Object> deviceControlPanelMap;

    public VMPane() {
        this.initializeVMPane();
    }

    public void initializeVMPane() {
        this.deviceControlPanelMap = new HashMap();
        VMApp.getInstance().createIUSBRedirectionSession();
        this.numCD = VMApp.getInstance().getNumCD();
        this.numHD = VMApp.getInstance().getNumHD();
        this.setSize(VMApp.getWidth(), VMApp.getHeight());
        this.constructUI();
        this.setVisible(true);
        VMApp.getInstance().initDeviceDetector();
        VMApp.getInstance().initRedirectionStatusMonitor();
    }

    public void constructUI() {
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.createDevicePane();
        this.add((Component)this.vmDevicePane, gridBagConstraints);
    }

    private JScrollPane createControlScrollPane(int n) {
        int n2 = 0;
        String string = "";
        JPanel jPanel = new JPanel(new GridBagLayout());
        DeviceControlPanel deviceControlPanel = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Border border = BorderFactory.createLoweredBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, LocaleStrings.getString("AK_1_VMP"), 0, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        switch (n) {
            case 0: {
                n2 = this.numCD;
                string = CD_DEV_CTRL_PANEL_KEY;
                break;
            }
            case 2: {
                n2 = this.numHD;
                string = HD_DEV_CTRL_PANEL_KEY;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        for (int i = 0; i < n2; ++i) {
            String string2 = string;
            gridBagConstraints.gridy = i;
            string2 = string2 + i;
            deviceControlPanel = new DeviceControlPanel(n, i);
            this.deviceControlPanelMap.put(string2, deviceControlPanel);
            jPanel.add((Component)deviceControlPanel, gridBagConstraints);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setMaximumSize(new Dimension(VMApp.getWidth(), 100));
        jScrollPane.setBorder(titledBorder);
        return jScrollPane;
    }

    private void createDevicePane() {
        this.vmDevicePane = new JTabbedPane();
        this.statusTabPanel = new StatusTabPanel();
        this.vmDevicePane.addTab(this.formatTabTitle(LocaleStrings.getString("AK_3_VMP")), this.getImageIcon("DVD_tab.png"), this.createVMDeviceTabPanel(0));
        this.vmDevicePane.addTab(this.formatTabTitle(LocaleStrings.getString("AK_5_VMP")), this.getImageIcon("HD_tab.png"), this.createVMDeviceTabPanel(2));
        this.vmDevicePane.addTab(this.formatTabTitle(LocaleStrings.getString("AK_6_VMP")), this.getImageIcon("status.png"), this.statusTabPanel);
        this.updateDeviceControls(0, JViewer.isCdServiceEnabled());
        this.updateDeviceControls(2, JViewer.isHdServiceEnabled());
        this.vmDevicePane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JViewerApp.getInstance().setSelectedVMTab(VMPane.this.vmDevicePane.getSelectedIndex());
                VMPane.this.showMessageForSelectedTab(VMPane.this.vmDevicePane.getSelectedIndex());
            }
        });
        if (!JViewer.isVMApp()) {
            this.vmDevicePane.setSelectedIndex(JViewerApp.getInstance().getSelectedVMTab());
        }
    }

    private String formatTabTitle(String string) {
        String string2 = "<html><body leftmargin=15 topmargin=8 marginwidth=10 marginheight=6>" + string + "</body></html>";
        return string2;
    }

    public ImageIcon getImageIcon(String string) {
        URL uRL = null;
        ImageIcon imageIcon = null;
        try {
            uRL = JViewer.class.getResource("res/" + string);
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        if (uRL != null) {
            try {
                imageIcon = new ImageIcon(uRL);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
        return imageIcon;
    }

    private JPanel createVMDeviceTabPanel(int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 400;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.95;
        jPanel.add((Component)this.createControlScrollPane(n), gridBagConstraints);
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        gridBagConstraints.ipady = 75;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.05;
        JScrollPane jScrollPane = this.createStatusScrollPane(n);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.updateFreeDeviceStatus(n);
        return jPanel;
    }

    private JScrollPane createStatusScrollPane(int n) {
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = null;
        String string = "";
        StatusTable statusTable = new StatusTable(n);
        JScrollPane jScrollPane = new JScrollPane(statusTable.getStatusTable(), 20, 30);
        switch (n) {
            case 0: {
                this.cdStatusTable = statusTable;
                string = LocaleStrings.getString("AK_3_VMP") + " " + LocaleStrings.getString("AK_2_VMP");
                break;
            }
            case 2: {
                this.hdStatusTable = statusTable;
                string = LocaleStrings.getString("AK_5_VMP") + " " + LocaleStrings.getString("AK_2_VMP");
            }
        }
        titledBorder = BorderFactory.createTitledBorder(border, string, 0, 1);
        jScrollPane.setBorder(titledBorder);
        return jScrollPane;
    }

    public DeviceControlPanel getDeviceControlPanel(int n, int n2) {
        DeviceControlPanel deviceControlPanel = null;
        switch (n) {
            case 0: {
                deviceControlPanel = (DeviceControlPanel)this.deviceControlPanelMap.get(CD_DEV_CTRL_PANEL_KEY + n2);
                break;
            }
            case 2: {
                deviceControlPanel = (DeviceControlPanel)this.deviceControlPanelMap.get(HD_DEV_CTRL_PANEL_KEY + n2);
            }
        }
        return deviceControlPanel;
    }

    public JTable getCDStatusTable() {
        return this.cdStatusTable.getStatusTable();
    }

    public JTable getHDStatusTable() {
        return this.hdStatusTable.getStatusTable();
    }

    /*
     * Unable to fully structure code
     */
    public void updateDeviceControlPanel(int var1_1, String[] var2_2) {
        var3_3 = null;
        switch (var1_1) {
            case 0: {
                for (var4_4 = 0; var4_4 < VMApp.getInstance().getNumCD(); ++var4_4) {
                    var3_3 = (DeviceControlPanel)this.deviceControlPanelMap.get("CD_DEV_CTRL_PANEL_" + var4_4);
                    this.updateDevicePanel(var1_1, var4_4, var2_2, var3_3);
                }
                break;
            }
            case 2: {
                for (var4_5 = 0; var4_5 < VMApp.getInstance().getNumHD(); ++var4_5) {
                    var3_3 = (DeviceControlPanel)this.deviceControlPanelMap.get("HD_DEV_CTRL_PANEL_" + var4_5);
                    if (!JViewer.IsClientAdmin() || !System.getProperty("os.name").toLowerCase().contains("windows")) ** GOTO lbl27
                    if (var2_2 == null) ** GOTO lbl22
                    for (String var8_9 : var2_2) {
                        if (!var8_9.startsWith(LocaleStrings.getString("A_5_DP"))) continue;
                        if (var3_3.getPhysicalDrive() != null) {
                            var3_3.getPhysicalDrive().setVisible(true);
                        }
                        if (var3_3.getLogicalDrive() != null) {
                            var3_3.getLogicalDrive().setVisible(true);
                        }
                        ** GOTO lbl27
                    }
                    ** GOTO lbl27
lbl22:
                    // 1 sources

                    if (var3_3.getPhysicalDrive() != null) {
                        var3_3.getPhysicalDrive().setVisible(false);
                        var3_3.getPhysicalDrive().setSelected(true);
                    }
                    if (var3_3.getLogicalDrive() != null) {
                        var3_3.getLogicalDrive().setVisible(false);
                    }
lbl27:
                    // 6 sources

                    this.updateDevicePanel(var1_1, var4_5, var2_2, var3_3);
                }
                break;
            }
        }
    }

    private void updateDevicePanel(int n, int n2, String[] stringArray, DeviceControlPanel deviceControlPanel) {
        DevicePanel devicePanel = null;
        deviceControlPanel.getInstanceScrollPane().setViewportView(null);
        devicePanel = new DevicePanel(stringArray, n, n2);
        deviceControlPanel.getInstanceScrollPane().setViewportView(devicePanel);
        deviceControlPanel.setDevicePanel(devicePanel);
        deviceControlPanel.updateDeviceControlPanel();
        deviceControlPanel.revalidate();
        deviceControlPanel.repaint();
    }

    public void physicalDriveChangeState(int n, int n2, String string, boolean bl) {
        int n3 = 0;
        DeviceControlPanel deviceControlPanel = null;
        String string2 = null;
        switch (n) {
            case 0: {
                n3 = VMApp.getInstance().getNumCD();
                string2 = CD_DEV_CTRL_PANEL_KEY;
                break;
            }
            case 2: {
                n3 = VMApp.getInstance().getNumHD();
                string2 = HD_DEV_CTRL_PANEL_KEY;
            }
        }
        for (int i = 0; i < n3; ++i) {
            if (i == n2 || VMApp.getInstance().getIUSBRedirSession().getDeviceRedirStatus(n, i) == 1) continue;
            deviceControlPanel = (DeviceControlPanel)this.deviceControlPanelMap.get(string2 + i);
            deviceControlPanel.getDevicePanel().updatePhysicalDeviceState(n, string, bl);
        }
    }

    public void updateJVToolbar(int n) {
        int n2 = 0;
        boolean bl = false;
        JButton jButton = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        switch (n) {
            case 0: {
                n2 = VMApp.getInstance().getNumCD();
                jButton = JViewerApp.getInstance().getM_wndFrame().getToolbar().getCDBtn();
                string = "CD.png";
                string3 = LocaleStrings.getString("G_20_VMD");
                string2 = "CDR.png";
                string4 = LocaleStrings.getString("G_21_VMD");
                break;
            }
            case 2: {
                n2 = VMApp.getInstance().getNumHD();
                jButton = JViewerApp.getInstance().getM_wndFrame().getToolbar().getHardddiskBtn();
                string = "HD.png";
                string3 = LocaleStrings.getString("G_24_VMD");
                string2 = "HDR.png";
                string4 = LocaleStrings.getString("G_25_VMD");
            }
        }
        for (int i = 0; i < n2; ++i) {
            if (VMApp.getInstance().getIUSBRedirSession().getDeviceRedirStatus(n, i) != 1) continue;
            bl = true;
            break;
        }
        if (bl) {
            jButton.setIcon(this.getImageIcon(string2));
            jButton.setToolTipText(string4);
        } else {
            jButton.setIcon(this.getImageIcon(string));
            jButton.setToolTipText(string3);
        }
    }

    public void updateDeviceStatusTable(int n, int n2, boolean bl) {
        IUSBRedirSession iUSBRedirSession = VMApp.getInstance().getIUSBRedirSession();
        JTable jTable = null;
        String string = LocaleStrings.getString("AL_8_ST");
        String string2 = LocaleStrings.getString("AL_8_ST");
        switch (n) {
            case 0: {
                jTable = this.getCDStatusTable();
                if (!bl) break;
                string = LocaleStrings.getString("AL_5_ST") + " : " + iUSBRedirSession.getCDInstanceNumber(n2);
                break;
            }
            case 2: {
                jTable = this.getHDStatusTable();
                if (!bl) break;
                string = LocaleStrings.getString("AL_7_ST") + " : " + iUSBRedirSession.getHDInstanceNumber(n2);
            }
        }
        if (bl) {
            string2 = iUSBRedirSession.getDeviceRedirSource(n, n2);
        } else {
            string2 = LocaleStrings.getString("AL_8_ST");
            string = LocaleStrings.getString("AL_8_ST");
        }
        jTable.setValueAt(string, n2, 1);
        jTable.setValueAt(string2, n2, 2);
    }

    public void updateFreeDeviceStatus(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        IUSBRedirSession iUSBRedirSession = VMApp.getInstance().getIUSBRedirSession();
        JButton jButton = null;
        DevicePanel devicePanel = null;
        switch (n) {
            case 0: {
                if (!JViewer.isCdServiceEnabled()) {
                    return;
                }
                n3 = VMApp.getInstance().getNumCD();
                n4 = VMApp.getInstance().getFreeCDNum();
                break;
            }
            case 2: {
                if (!JViewer.isHdServiceEnabled()) {
                    return;
                }
                n3 = VMApp.getInstance().getNumHD();
                n4 = VMApp.getInstance().getFreeHDNum();
                break;
            }
            default: {
                Debug.out.println("Invalid device type : " + n);
            }
        }
        for (int i = 0; i < n3; ++i) {
            jButton = this.getDeviceControlPanel(n, i).getConnectButton();
            devicePanel = this.getDeviceControlPanel(n, i).getDevicePanel();
            if (iUSBRedirSession.getDeviceRedirStatus(n, i) == 1) continue;
            devicePanel.enableAll();
            jButton.setEnabled(true);
            iUSBRedirSession.setDeviceStatus(n, i, 1);
            if (n2 < n4) {
                ++n2;
                continue;
            }
            devicePanel.disableAll();
            jButton.setEnabled(false);
            iUSBRedirSession.setDeviceStatus(n, i, 0);
            devicePanel.revalidate();
            devicePanel.repaint();
        }
    }

    public StatusTabPanel getStatusTabPanel() {
        return this.statusTabPanel;
    }

    public void setStatusTabPanel(StatusTabPanel statusTabPanel) {
        this.statusTabPanel = statusTabPanel;
    }

    public void setSelectedTab(int n) {
        this.vmDevicePane.setSelectedIndex(n);
    }

    public JTabbedPane getVmDevicePane() {
        return this.vmDevicePane;
    }

    public void setVmDevicePane(JTabbedPane jTabbedPane) {
        this.vmDevicePane = jTabbedPane;
    }

    public void updateDeviceControls(int n, boolean bl) {
        int n2 = 0;
        JButton jButton = null;
        DevicePanel devicePanel = null;
        switch (n) {
            case 0: {
                n2 = VMApp.getInstance().getNumCD();
                if (JViewer.isVMApp() || n2 <= VMApp.getInstance().getFreeCDNum()) break;
                n2 = VMApp.getInstance().getFreeCDNum();
                break;
            }
            case 2: {
                n2 = VMApp.getInstance().getNumHD();
                if (JViewer.isVMApp() || n2 <= VMApp.getInstance().getFreeHDNum()) break;
                n2 = VMApp.getInstance().getFreeHDNum();
                break;
            }
            default: {
                Debug.out.println("Invalid device type : " + n);
            }
        }
        for (int i = 0; i < n2; ++i) {
            jButton = this.getDeviceControlPanel(n, i).getConnectButton();
            devicePanel = this.getDeviceControlPanel(n, i).getDevicePanel();
            if (bl) {
                devicePanel.enableAll();
                jButton.setEnabled(true);
                continue;
            }
            devicePanel.disableAll();
            jButton.setEnabled(false);
            devicePanel.revalidate();
            devicePanel.repaint();
        }
    }

    public void showMessageForSelectedTab(int n) {
        switch (n) {
            case 0: {
                if (JViewer.getCDState() == 0) {
                    VMApp.getVMStatusPanel().setStatusMessage(LocaleStrings.getString("G_27_VMD"));
                    break;
                }
                VMApp.getVMStatusPanel().setStatusMessage("");
                break;
            }
            case 1: {
                if (JViewer.getHDState() == 0) {
                    VMApp.getVMStatusPanel().setStatusMessage(LocaleStrings.getString("G_31_VMD"));
                    break;
                }
                if (JViewer.IsClientAdmin()) {
                    if ((JViewer.getOEMFeatureStatus() & 2L) == 2L) {
                        VMApp.getVMStatusPanel().setStatusMessage(LocaleStrings.getString("G_36_VMD"));
                        break;
                    }
                    VMApp.getVMStatusPanel().setStatusMessage("");
                    break;
                }
                if (JViewer.IsClientAdmin()) break;
                VMApp.getVMStatusPanel().setStatusMessage(LocaleStrings.getString("G_35_VMD"));
                break;
            }
            case 2: {
                VMApp.getVMStatusPanel().setStatusMessage("");
                break;
            }
            default: {
                Debug.out.println("Invalid index : " + n);
            }
        }
    }
}

