/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.commands;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.engines.EngineTask;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import java.util.concurrent.CancellationException;

public final class CommandTask
implements EngineTask<CommandTaskRecords> {
    private volatile String taskID;
    private volatile Thread currentThread;
    private volatile AbstractLoggerWriter loggerWriter;
    private CommandTaskRecords records;

    public CommandTask(AbstractCommand<?> command) {
        this.taskID = command.getCommandID();
        this.loggerWriter = new DefaultLoggerWriter(this.getClass());
        this.records = new CommandTaskRecords(command);
    }

    @Override
    public CommandTaskRecords call() throws CancellationException {
        this.currentThread = Thread.currentThread();
        if (this.currentThread.isInterrupted()) {
            this.loggerWriter.appendPath(this.records.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.taskID, "[" + this.taskID.split("_")[0] + "] Total elapsed time : " + this.records.getCommand().getElapsedTimes());
            return this.records.setStates(EngineRecordStates.Fail);
        }
        if (!this.records.getCommand().checkAll()) {
            this.loggerWriter.appendPath(this.records.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.taskID, "[" + this.taskID.split("_")[0] + "] Total elapsed time : " + this.records.getCommand().getElapsedTimes());
            return this.records.setStates(EngineRecordStates.Fail);
        }
        this.loggerWriter.appendPath(this.records.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.taskID, "[" + this.taskID.split("_")[0] + "] Command arguments check OK.");
        this.records.setStates(EngineRecordStates.Running);
        if (this.records.getCommand().execute()) {
            this.loggerWriter.appendPath(this.records.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.taskID, "[" + this.taskID.split("_")[0] + "] Command execute success.");
            this.loggerWriter.appendPath(this.records.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.taskID, "[" + this.taskID.split("_")[0] + "] Total elapsed time : " + this.records.getCommand().getElapsedTimes());
            return this.records.setStates(EngineRecordStates.Pass);
        }
        this.loggerWriter.appendPath(this.records.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.taskID, "[" + this.taskID.split("_")[0] + "] Command execute fail.");
        this.loggerWriter.appendPath(this.records.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.taskID, "[" + this.taskID.split("_")[0] + "] Total elapsed time : " + this.records.getCommand().getElapsedTimes());
        return this.records.setStates(EngineRecordStates.Fail);
    }

    @Override
    public String getTaskID() {
        return this.taskID;
    }

    @Override
    public CommandTaskRecords getResult() {
        return this.records;
    }

    @Override
    public void close() throws Exception {
        this.records.getCommand().close();
        this.loggerWriter.close();
        this.loggerWriter = null;
        this.currentThread = null;
    }
}

