/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.commands;

import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.CPLD.GetCPLDCommand;
import Gbt.utility.CUPS.CUPSCommand;
import Gbt.utility.Chassis.ChassisPowerCommand;
import Gbt.utility.Chassis.PowerCommand;
import Gbt.utility.ConfigSave.ConfigSaveCommand;
import Gbt.utility.Configdeploy.ConfigDeployCommand;
import Gbt.utility.FRU.FRUType;
import Gbt.utility.FRU.GetFRUCommand;
import Gbt.utility.GPUFanPolicy.GetGPUFanPolicyCommand;
import Gbt.utility.HDDInfo.HwInfoCommand;
import Gbt.utility.IKVM.LaunchiKVMCommand;
import Gbt.utility.IPSrc.IPSrcCommand;
import Gbt.utility.IPv6Config.IPv6ConfigCommand;
import Gbt.utility.Identify.IdentifyCommand;
import Gbt.utility.LoadDefault.LoadDefaultCommand;
import Gbt.utility.Local.LocalSubCommand;
import Gbt.utility.LogoChange.LogoChangeCommand;
import Gbt.utility.MSR.MSRCommand;
import Gbt.utility.MultiNode.GetMultiNodeCommand;
import Gbt.utility.NTP.NtpCommand;
import Gbt.utility.NTP.NtpJsonData;
import Gbt.utility.OSdeploy.OSDeployCommand;
import Gbt.utility.PEF.PEFCommand;
import Gbt.utility.PEF.PEFEntry;
import Gbt.utility.PEF.PEFIpmiOptions;
import Gbt.utility.RAW.IPMIRawCommand;
import Gbt.utility.SDR.SDRCommand;
import Gbt.utility.SDR.SDRIpmiOptions;
import Gbt.utility.SDR.SetSensorThresholdsCommand;
import Gbt.utility.SDR.record.FullSensorRecord;
import Gbt.utility.SEL.SELCommand;
import Gbt.utility.SEL.SELIPMIOptions;
import Gbt.utility.SMBIOS.GetSMBIOSCommand;
import Gbt.utility.SMTP.SMTPCommand;
import Gbt.utility.Trap.TrapCommand;
import Gbt.utility.Trap.TrapData;
import Gbt.utility.Update.MainUpdateCommand;
import Gbt.utility.Update.PreUpdateCommand;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.bmcinfo.GetBMCInfoCommand;
import Gbt.utility.bmclanconfig.BMCLanConfigCommand;
import Gbt.utility.bmclanconfig.BMCLanConfigData;
import Gbt.utility.bmclanconfig.BMCLanConfigIPSource;
import Gbt.utility.bmcwebutils.BMCUtilCommand;
import Gbt.utility.bmcwebutils.PhantomJSOptions;
import Gbt.utility.bootoptions.BootOptions;
import Gbt.utility.bootoptions.SetBootOptionCommand;
import Gbt.utility.imageChecksum.ImageChecksumCommand;
import Gbt.utility.maclist.GetMACListCommand;
import Gbt.utility.meversion.MeVersionCommand;
import Gbt.utility.networkconfig.BMCNetworkConfigCommand;
import Gbt.utility.postcode.PostCodeCommand;
import Gbt.utility.postcode.PostCodeOptions;
import Gbt.utility.power.GetPowerReadingCommand;
import Gbt.utility.power.PowerIpmiOptions;
import Gbt.utility.power.PowerLimitCommand;
import Gbt.utility.power.PowerLimitExceptionActions;
import Gbt.utility.redfish.RedfishCommand;
import Gbt.utility.rest.RestCommand;
import Gbt.utility.scan.ScanCommand;
import Gbt.utility.scan.ScanResultsData;
import Gbt.utility.useraccounts.UserAccountCommand;
import Gbt.utility.useraccounts.UserAccountCommandActions;
import Gbt.utility.vmclitool.VmcliCommand;
import Gbt.utility.vmclitool.VmcliMountInfo;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class GbtCommandBuilders {
    private GbtCommandBuilders() {
    }

    public static final ChassisPowerCommand.Builder chassis(String bmcIP, String username, String password, PowerCommand powerCommand) {
        return new ChassisPowerCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setPowerCommand(powerCommand);
    }

    public static final PowerLimitCommand.Builder limit(String bmcIP, String username, String password, PowerIpmiOptions option, PowerLimitExceptionActions actions, BigDecimal powerLimit, BigDecimal correctionTime, BigDecimal period) {
        return new PowerLimitCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setPowerOption(option).setPowerLimitExceptionAction(actions).setPowerLimit(powerLimit).setCorrectionTime(correctionTime).setSamplingPeriod(period);
    }

    public static final SetBootOptionCommand.Builder boot(String bmcIP, String username, String password, BootOptions bootOptions, boolean uefiMode) {
        return new SetBootOptionCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setBootOption(bootOptions).setUEFIMode(uefiMode);
    }

    public static final TrapCommand.Builder setTrap(String bmcIP, String username, String password, List<TrapData> trapDataList) {
        return new TrapCommand.Builder().setBMCIP(bmcIP).setBMCPassword(password).setBMCUsername(username).setTrapDataList(trapDataList).setGetTrap(false);
    }

    public static final TrapCommand.Builder getTrap(String bmcIP, String username, String password) {
        return new TrapCommand.Builder().setBMCIP(bmcIP).setBMCPassword(password).setBMCUsername(username).setGetTrap(true);
    }

    public static final PEFCommand.Builder getPEF(String bmcIP, String username, String password) {
        return new PEFCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setCommandOption(PEFIpmiOptions.GET);
    }

    public static final PEFCommand.Builder setPEF(String bmcIP, String username, String password, List<PEFEntry> pefTable) {
        return new PEFCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setPEFTable(pefTable).setCommandOption(PEFIpmiOptions.SET);
    }

    public static final PEFCommand.Builder pef() {
        return new PEFCommand.Builder();
    }

    @Deprecated
    public static final IPv6ConfigCommand.Builder ipv6() {
        return new IPv6ConfigCommand.Builder();
    }

    public static final GetPowerReadingCommand.Builder power(String bmcIP, String username, String password) {
        return new GetPowerReadingCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final SELCommand.Builder getSEL(String bmcIP, String username, String password, SELIPMIOptions options) {
        return new SELCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setSELOption(options);
    }

    public static final SELCommand.Builder setSELTime(String bmcIP, String username, String password, SELIPMIOptions options, Date date) {
        return new SELCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setSELOption(options);
    }

    public static final GetFRUCommand.Builder fru(String bmcIP, String username, String password) {
        return new GetFRUCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final SDRCommand.Builder sdr(String bmcIP, String username, String password, boolean listMode) {
        return new SDRCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setOption(SDRIpmiOptions.GET_SDR_SENSOR_RECORDS);
    }

    public static final SetSensorThresholdsCommand.Builder setSensorThreshold(String bmcIP, String username, String password, FullSensorRecord record) {
        return new SetSensorThresholdsCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setSensorRecord(record);
    }

    public static final MSRCommand.Builder msr(String bmcIP, String username, String password) {
        return new MSRCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final IPSrcCommand.Builder getIPsrc(String bmcIP, String username, String password) {
        return new IPSrcCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final IPSrcCommand.Builder setIPsrc(String bmcIP, String username, String password, BMCLanConfigIPSource ipSource) {
        return new IPSrcCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setIpSource(ipSource);
    }

    public static final LogoChangeCommand.Builder logochange(String bmcIP, String username, String password, String bgImg, String lfImg) {
        return new LogoChangeCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setBackgroundLOGO(bgImg).setLeftLOGO(lfImg);
    }

    public static final HwInfoCommand.Builder hwinfo(String bmcIP, String username, String password) {
        return new HwInfoCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final GetSMBIOSCommand.Builder smbios(String bmcIP, String username, String password) {
        return new GetSMBIOSCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final LoadDefaultCommand.Builder loaddfBMC(String bmcIP, String username, String password, String bmcFilePath) {
        return new LoadDefaultCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setCommandType("bmc").setBmcFilePath(bmcFilePath);
    }

    public static final LoadDefaultCommand.Builder loaddfBIOS(String bmcIP, String username, String password, String biosFilePath) {
        return new LoadDefaultCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setCommandType("bios").setBiosFilePath(biosFilePath);
    }

    public static final GetMultiNodeCommand.Builder multinode(String bmcIP, String username, String password) {
        return new GetMultiNodeCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final LocalSubCommand.Builder localSaveDf() {
        return new LocalSubCommand.Builder().setComType("savedf");
    }

    public static final LocalSubCommand.Builder localUpdate(String updateType) {
        return new LocalSubCommand.Builder().setComType("onlineupdate").setUpdtaeType(updateType);
    }

    public static final LaunchiKVMCommand.Builder ikvm(String bmcIP, String username, String password) {
        return new LaunchiKVMCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final IdentifyCommand.Builder identify(String bmcIP, String username, String password, int lightTime) {
        return new IdentifyCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setLightTime(lightTime);
    }

    public static final GetBMCInfoCommand.Builder mcinfo(String bmcIP, String username, String password) {
        return new GetBMCInfoCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final IPMIRawCommand.Builder raw(String bmcIP, String username, String password, byte[] rawData) {
        return new IPMIRawCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setRawData(rawData);
    }

    public static final UserAccountCommand.Builder userappList(String bmcIP, String username, String password) {
        return new UserAccountCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction(UserAccountCommandActions.LIST);
    }

    public static final UserAccountCommand.Builder userappSET(String bmcIP, String username, String password, String accountUsername, String accountPassword, byte userID, PrivilegeLevel privLevel) {
        return new UserAccountCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction(UserAccountCommandActions.SET).setAccountName(accountUsername).setAccountPassword(accountPassword).setAccountIDNumber(userID).setPrivilegeLevel(privLevel).setEnableUser(Boolean.TRUE).setEnableSol(Boolean.TRUE);
    }

    public static final UserAccountCommand.Builder userappEnable(String bmcIP, String username, String password, byte userID) {
        return new UserAccountCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction(UserAccountCommandActions.ENABLE).setAccountIDNumber(userID).setEnableUser(Boolean.TRUE).setEnableSol(Boolean.TRUE);
    }

    public static final UserAccountCommand.Builder userappDisable(String bmcIP, String username, String password, byte userID) {
        return new UserAccountCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction(UserAccountCommandActions.DISABLE).setAccountIDNumber(userID).setEnableUser(Boolean.FALSE).setEnableSol(Boolean.FALSE);
    }

    public static final VmcliCommand.Builder vmcliMount(String bmcIP, String username, String password, VmcliMountInfo vmcliMountInfo) {
        return new VmcliCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setvmcliMountInfo(vmcliMountInfo);
    }

    public static final VmcliCommand.Builder vmcliMount(String bmcIP, String toolPath, String username, String password, VmcliMountInfo vmcliMountInfo) {
        return new VmcliCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setToolPath(toolPath).setvmcliMountInfo(vmcliMountInfo);
    }

    public static final VmcliCommand.Builder vmcliUnmount(String bmcIP, String username, String password) {
        return new VmcliCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).unmount();
    }

    public static final VmcliCommand.Builder vmcliUnmount(String bmcIP, String toolPath, String username, String password) {
        return new VmcliCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setToolPath(toolPath).unmount();
    }

    public static final NtpCommand.Builder ntpSet(String bmcIP, String username, String password, NtpJsonData ntpUploadData) {
        return new NtpCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction(true).setNtpUploadData(ntpUploadData);
    }

    public static final NtpCommand.Builder ntpGet(String bmcIP, String username, String password) {
        return new NtpCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction(false);
    }

    public static final BMCUtilCommand.Builder bmcutil(String bmcIP, String username, String password, PhantomJSOptions option, File path) {
        return new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setOption(option).setFilePath(path);
    }

    public static final GetMACListCommand.Builder getMACList(String bmcIP, String username, String password) {
        return new GetMACListCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).retrieveAllGroups();
    }

    public static final GetGPUFanPolicyCommand.Builder getGPUFanPolicy(String bmcIP, String username, String password) {
        return new GetGPUFanPolicyCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction("get");
    }

    public static final GetGPUFanPolicyCommand.Builder setGPUFanPolicy(String bmcIP, String username, String password, int policyID) {
        return new GetGPUFanPolicyCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction("set").setPolicyID(policyID);
    }

    public static final OSDeployCommand.Builder osdeploy(String bmcIP, String username, String password, String osISOName, String serverIP, String osType) {
        return new OSDeployCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setOSImage(osISOName).setServerIP(serverIP).setOSType(osType);
    }

    public static final SMTPCommand.Builder setSMTPInfo(String bmcIP, String username, String password, String info) {
        return new SMTPCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setSenderInfo(info);
    }

    public static final SMTPCommand.Builder setSMTPEmail(String bmcIP, String username, String password, int emailID, boolean enable, String emailAddr, String description, boolean isIpv4) {
        return new SMTPCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setEmailAddress(emailID, enable, emailAddr, description, isIpv4);
    }

    public static final SMTPCommand.Builder setSMTPServer(String bmcIP, String username, String password, int port, String serverAddr) {
        return new SMTPCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setServerAddress(port, serverAddr);
    }

    public static final SMTPCommand.Builder setSMTPAutority(String bmcIP, String username, String password, boolean enable, String smtpUser, String smtpPass, SMTPCommand.Builder.TLSModeOptions tlsOption, SMTPCommand.Builder.SASLModeOptions saslOption) {
        return new SMTPCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setServerAuthority(enable, username, password, tlsOption, saslOption);
    }

    public static final SMTPCommand.Builder getSMTP(String bmcIP, String username, String password) {
        return new SMTPCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).getFullConfig();
    }

    public static final GetFRUCommand.Builder bpinfo(String bmcIP, String username, String password) {
        return new GetFRUCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setFRUType(FRUType.BPB);
    }

    public static final GetFRUCommand.Builder psuinfo(String bmcIP, String username, String password) {
        return new GetFRUCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setFRUType(FRUType.PSU);
    }

    public static final ConfigDeployCommand.Builder configdeploy(String bmcIP, String username, String password, String miniISOName, String serverIP, String configPkgName) {
        return new ConfigDeployCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setMiniOSImage(miniISOName).setConfigPkg(configPkgName).setServerIP(serverIP);
    }

    public static final ConfigSaveCommand.Builder configsave(String bmcIP, String username, String password, String miniISOName, String serverIP, String configPkgName) {
        return new ConfigSaveCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setMiniOSImage(miniISOName).setConfigPkg(configPkgName).setServerIP(serverIP);
    }

    public static final PostCodeCommand.Builder postcode(String bmcIP, String username, String password, PostCodeOptions option) {
        return new PostCodeCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setPostCodeOptions(option);
    }

    public static final MeVersionCommand.Builder meversion(String bmcIP, String username, String password) {
        return new MeVersionCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final BMCLanConfigCommand.Builder getLanConfig(String bmcIP, String username, String password) {
        return new BMCLanConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction(true);
    }

    public static final BMCLanConfigCommand.Builder setLanConfig(String bmcIP, String username, String password, BMCLanConfigData data) {
        return new BMCLanConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setBmcLanConfigData(data).setAction(false);
    }

    public static final BMCNetworkConfigCommand.Builder getHostname(String bmcIP, String username, String password) {
        return new BMCNetworkConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setAction(false);
    }

    public static final PreUpdateCommand.Builder preUpdate(String bmcIP, String username, String password, String firmwarePath, UpdateType type) {
        return new PreUpdateCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setFWPackage(firmwarePath).setUpdateType(type);
    }

    public static final MainUpdateCommand.Builder mainUpdate(String bmcIP, String username, String password, AbstractJSONPOJO fwInfo, UpdateType type) {
        return new MainUpdateCommand.Builder().setBMCIP(bmcIP).setBMCPassword(password).setBMCUsername(username).setPreUpdateFWInfo(fwInfo).setUpdateType(type);
    }

    public static final CUPSCommand.Builder getCUPS(String bmcIP, String username, String password) {
        return new CUPSCommand.Builder().setBMCIP(bmcIP).setBMCPassword(password).setBMCUsername(username);
    }

    public static final GetCPLDCommand.Builder getCPLD(String bmcIP, String username, String password) {
        return new GetCPLDCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password);
    }

    public static final ImageChecksumCommand.Builder compareImageChecksum(String bmcIP, String username, String password, String imagePath) {
        return new ImageChecksumCommand.Builder().setBMCIP(bmcIP).setBMCUsername(username).setBMCPassword(password).setImagePath(imagePath);
    }

    public static final List<PreUpdateCommand.Builder> update(String startIP, String endIP, String bmcUsername, String bmcPassword, UpdateType updateType, List<File> fwPkgs) {
        ArrayList<PreUpdateCommand.Builder> list = new ArrayList<PreUpdateCommand.Builder>();
        ScanCommand scanCommand = new ScanCommand.Builder().setStartIP(startIP).setEndIP(endIP).setScanType(ScanCommand.ScanType.RMCP).build();
        if (!scanCommand.checkAll()) {
            try {
                scanCommand.close();
            }
            catch (Exception e) {
                scanCommand = null;
            }
            return list;
        }
        if (!scanCommand.execute()) {
            try {
                scanCommand.close();
            }
            catch (Exception e) {
                scanCommand = null;
            }
            return list;
        }
        try {
            scanCommand.close();
        }
        catch (Exception e) {
            scanCommand = null;
            return list;
        }
        for (AbstractJSONPOJO results : scanCommand.getCommandResults()) {
            list.add(new PreUpdateCommand.Builder().setBMCIP(results.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setUpdateType(updateType).setFWPackages(fwPkgs));
        }
        return list;
    }

    public static final List<AbstractCommandBuilder> createBuilders(String startIP, String endIP, String bmcUsername, String bmcPassword, String commandName) {
        ArrayList<AbstractCommandBuilder> list = new ArrayList<AbstractCommandBuilder>();
        ScanCommand scanCommand = new ScanCommand.Builder().setStartIP(startIP).setEndIP(endIP).setScanType(ScanCommand.ScanType.RMCP).build();
        if (!scanCommand.checkAll()) {
            try {
                scanCommand.close();
            }
            catch (Exception e) {
                scanCommand = null;
            }
            return list;
        }
        if (!scanCommand.execute()) {
            try {
                scanCommand.close();
            }
            catch (Exception e) {
                scanCommand = null;
            }
            return list;
        }
        try {
            scanCommand.close();
        }
        catch (Exception e) {
            scanCommand = null;
            return list;
        }
        switch (commandName) {
            case "chassis": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new ChassisPowerCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "limit": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new PowerLimitCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "boot": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new SetBootOptionCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "trap": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new TrapCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "pef": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new PEFCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "ipv6": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new IPv6ConfigCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "power": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetPowerReadingCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "sel": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new SELCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "fru": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetFRUCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword).setFRUType(FRUType.FRU));
                }
                return list;
            }
            case "sdr": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new SDRCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "msr": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new MSRCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "ipsrc": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new IPSrcCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "hwinfo": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new HwInfoCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "logochange": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new LogoChangeCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "smbios": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetSMBIOSCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "loaddf": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new LoadDefaultCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "multinode": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetMultiNodeCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "local": {
                list.add(new LocalSubCommand.Builder());
                return list;
            }
            case "ikvm": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new LaunchiKVMCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "identify": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new IdentifyCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "mcinfo": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetBMCInfoCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "raw": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new IPMIRawCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "userapp": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new UserAccountCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "vmcli": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new VmcliCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "ntp": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new NtpCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "bmcutil": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new BMCUtilCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "mac": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetMACListCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "redfish": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new RedfishCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "gpufan": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetGPUFanPolicyCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "osdeploy": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new OSDeployCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "smtp": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new SMTPCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "bpinfo": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetFRUCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setFRUType(FRUType.BPB).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "psuinfo": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetFRUCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setFRUType(FRUType.PSU).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "rest": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new RestCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "configdeploy": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new ConfigDeployCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "configsave": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new ConfigSaveCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "postcode": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new PostCodeCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "meversion": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new MeVersionCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "lanprint": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new BMCLanConfigCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
            case "fwlist": {
                for (AbstractJSONPOJO result : scanCommand.getCommandResults()) {
                    list.add(new GetCPLDCommand.Builder().setBMCIP(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress()).setBMCUsername(bmcUsername).setBMCPassword(bmcPassword));
                }
                return list;
            }
        }
        return list;
    }
}

