/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines;

import Gbt.core.engines.AbstractEngineThreadFactory;
import Gbt.core.engines.AbstractSingleTask;
import Gbt.core.engines.EngineTask;
import Gbt.core.engines.TaskManager;
import Gbt.core.engines.records.EngineGroupRecords;
import Gbt.core.engines.records.EngineRecords;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractMultipleTask
extends Observable
implements EngineTask<EngineGroupRecords> {
    protected volatile String taskID;
    protected volatile Thread currentTread;
    protected volatile TaskManager<EngineRecords, AbstractSingleTask> taskManager;
    protected volatile AbstractLoggerWriter loggerWriter;

    protected <T extends MultiTaskBuilder<T>> AbstractMultipleTask(MultiTaskBuilder<T> taskBuilder) {
        this.taskID = taskBuilder.poolFactory.getPoolName();
        this.loggerWriter = new DefaultLoggerWriter(this.getClass());
        for (Observer observer : taskBuilder.feedBackControllerList) {
            if (observer == null) continue;
            this.addObserver(observer);
        }
    }

    public abstract <T extends AbstractSingleTask.TaskBuilder<T>> boolean restartSubTask(AbstractSingleTask.TaskBuilder<T> var1);

    public boolean cancelSubTask(String taskID) {
        return this.taskManager.terminateTask(taskID, false, null);
    }

    public synchronized boolean cancelAllSubTask() {
        boolean allDone = false;
        while (!allDone) {
            allDone = true;
            for (String subTaskID : this.taskManager.getTaskIDs()) {
                if (this.taskManager.isTaskRunning(subTaskID)) {
                    this.loggerWriter.appendPath(this.taskID).writeLogs(GbtLogLevel.WARN, subTaskID, "Start cancel the running task executions.");
                    this.taskManager.getTask(subTaskID).cancelConsideration();
                }
                allDone &= this.cancelSubTask(subTaskID);
            }
        }
        int count = 0;
        do {
            this.loggerWriter.appendPath(this.taskID).writeLogs(GbtLogLevel.INFO, this.taskID, "Wait for all sub-tasks done ... (" + ++count + ")");
        } while (!this.taskManager.isAllTasksComplete() && count < 500);
        try {
            this.taskManager.close();
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(this.taskID).writeLogs(GbtLogLevel.ERROR, this.taskID, "Task manager close error.", e);
        }
        return true;
    }

    protected void notifyEngineController(Object trigger, boolean remove) {
        this.loggerWriter.appendPath(this.taskID).writeLogs(GbtLogLevel.INFO, this.taskID, "Before complete, notify the engine controller.");
        this.setChanged();
        this.notifyObservers(trigger);
        if (remove) {
            this.deleteObservers();
        }
    }

    public EngineRecords getSubTaskResult(String taskID) {
        return this.taskManager.getSingleResult(taskID);
    }

    public Map<String, EngineRecords> getSubTaskResults() {
        return this.taskManager.getAllResults();
    }

    @Override
    public String getTaskID() {
        return this.taskID;
    }

    public static abstract class MultiTaskBuilder<T extends MultiTaskBuilder<T>> {
        protected AbstractEngineThreadFactory poolFactory;
        protected List<Observer> feedBackControllerList = new ArrayList<Observer>();

        protected MultiTaskBuilder() {
        }

        public abstract T getThis();

        public abstract AbstractMultipleTask build();

        public T setPoolFactory(AbstractEngineThreadFactory poolFactory) {
            this.poolFactory = poolFactory;
            return this.getThis();
        }

        public T setFeedBackController(Observer feedBackController) {
            this.feedBackControllerList.add(feedBackController);
            return this.getThis();
        }

        public AbstractEngineThreadFactory getPoolFactory() {
            return this.poolFactory;
        }
    }
}

