/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines;

import Gbt.core.engines.AbstractEngineThreadFactory;
import Gbt.core.engines.EngineTask;
import Gbt.core.engines.TaskManager;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class DefaultTaskManager<R, T extends EngineTask<R>>
implements TaskManager<R, T> {
    private static final String REGEX_ITEM = "_";
    private final String poolName;
    private volatile ExecutorService pool;
    private volatile AbstractLoggerWriter loggerWriter = new DefaultLoggerWriter(this.getClass());
    private volatile boolean isWorking;
    private volatile boolean allTaskComplete;
    private volatile Map<String, Boolean> singleDoneTags;
    private volatile Map<String, Boolean> singleRestartTag;
    private volatile Map<String, T> gbtTaskList;
    private volatile Map<String, Future<R>> futures;
    private volatile Map<String, R> futureResults;

    public DefaultTaskManager(AbstractEngineThreadFactory poolFactory) {
        this.pool = poolFactory.createThreadPool();
        this.poolName = poolFactory.getPoolName();
        this.isWorking = false;
        this.allTaskComplete = false;
        this.singleDoneTags = new ConcurrentHashMap<String, Boolean>();
        this.singleRestartTag = new ConcurrentHashMap<String, Boolean>();
        this.gbtTaskList = new ConcurrentHashMap<String, T>();
        this.futures = new ConcurrentHashMap<String, Future<R>>();
        this.futureResults = new ConcurrentHashMap<String, R>();
    }

    @Override
    public void addEngineTask(T EngineTask2) {
        this.gbtTaskList.put(EngineTask2.getTaskID(), EngineTask2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeTasks() {
        if (!this.singleDoneTags.isEmpty()) {
            this.singleDoneTags.clear();
        }
        if (!this.futureResults.isEmpty()) {
            this.futureResults.clear();
        }
        if (!this.futures.isEmpty()) {
            this.futures.clear();
        }
        for (String taskID : this.gbtTaskList.keySet()) {
            this.singleDoneTags.put(taskID, Boolean.FALSE);
            this.singleRestartTag.put(taskID, Boolean.FALSE);
            if (this.submitConfirm(taskID)) continue;
            return false;
        }
        this.isWorking = true;
        boolean complete = false;
        do {
            complete = true;
            Iterator<String> iterator = this.gbtTaskList.keySet().iterator();
            while (iterator.hasNext()) {
                AbstractLoggerWriter abstractLoggerWriter;
                String folderPath;
                String taskID = iterator.next();
                String string = folderPath = taskID.split(REGEX_ITEM).length > 1 ? taskID.split(REGEX_ITEM)[1] : this.poolName;
                if (!this.futures.containsKey(taskID)) continue;
                complete &= this.futures.get(taskID).isDone();
                if (!this.futures.get(taskID).isDone() || this.singleDoneTags.get(taskID).booleanValue()) continue;
                try {
                    Object result = this.futures.get(taskID).get();
                    if (result != null) {
                        this.futureResults.put(taskID, result);
                    }
                    this.singleDoneTags.put(taskID, Boolean.TRUE);
                }
                catch (InterruptedException ie) {
                    abstractLoggerWriter = this.loggerWriter;
                    synchronized (abstractLoggerWriter) {
                        this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "Target task : " + taskID + " has interrupted : ", ie);
                    }
                    this.singleDoneTags.put(taskID, Boolean.TRUE);
                    this.futureResults.put(taskID, ((EngineTask)this.gbtTaskList.get(taskID)).getResult());
                }
                catch (CancellationException ce) {
                    if (this.singleRestartTag.get(taskID).booleanValue()) {
                        do {
                            abstractLoggerWriter = this.loggerWriter;
                            synchronized (abstractLoggerWriter) {
                                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Target task : " + taskID + " waiting for terminate.");
                            }
                        } while (!this.futures.get(taskID).isDone() || !this.futures.get(taskID).isCancelled());
                        this.futures.remove(taskID);
                        abstractLoggerWriter = this.loggerWriter;
                        synchronized (abstractLoggerWriter) {
                            this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Target task : " + taskID + " has terminated and going to restart.");
                        }
                        if (this.submitConfirm(taskID)) {
                            do {
                                abstractLoggerWriter = this.loggerWriter;
                                synchronized (abstractLoggerWriter) {
                                    this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Restarting target task : " + taskID + " ....");
                                }
                            } while (!this.isTaskRunning(taskID));
                            this.singleDoneTags.put(taskID, Boolean.FALSE);
                            this.singleRestartTag.put(taskID, Boolean.FALSE);
                            complete = false;
                            continue;
                        }
                        abstractLoggerWriter = this.loggerWriter;
                        synchronized (abstractLoggerWriter) {
                            this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Target task : " + taskID + " has rejected and going to terminate.");
                        }
                        this.singleDoneTags.put(taskID, Boolean.TRUE);
                        continue;
                    }
                    abstractLoggerWriter = this.loggerWriter;
                    synchronized (abstractLoggerWriter) {
                        this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Target task : " + taskID + " has cancelled and going to terminate.");
                    }
                    this.singleDoneTags.put(taskID, Boolean.TRUE);
                    this.futureResults.put(taskID, ((EngineTask)this.gbtTaskList.get(taskID)).getResult());
                }
                catch (ExecutionException ee) {
                    abstractLoggerWriter = this.loggerWriter;
                    synchronized (abstractLoggerWriter) {
                        this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Target task : " + taskID + " get execution exception messages : ", ee);
                    }
                    this.singleDoneTags.put(taskID, Boolean.TRUE);
                    this.futureResults.put(taskID, ((EngineTask)this.gbtTaskList.get(taskID)).getResult());
                }
                finally {
                    if (!this.singleDoneTags.get(taskID).booleanValue()) continue;
                    try {
                        ((EngineTask)this.gbtTaskList.get(taskID)).close();
                        this.gbtTaskList.remove(taskID);
                        this.singleRestartTag.remove(taskID);
                        this.futures.remove(taskID);
                        iterator.remove();
                        AbstractLoggerWriter ie = this.loggerWriter;
                        synchronized (ie) {
                            this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Remove the complete task object : " + taskID + " done.");
                            this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.DEBUG, taskID, folderPath + " process complete ... (" + (this.singleDoneTags.size() - this.gbtTaskList.size()) + "/" + this.singleDoneTags.size() + ")");
                        }
                    }
                    catch (Exception e) {
                        abstractLoggerWriter = this.loggerWriter;
                        synchronized (abstractLoggerWriter) {
                            this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Remove the complete task object : " + taskID + " fail.", e);
                        }
                    }
                }
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            for (String taskID : this.gbtTaskList.keySet()) {
                this.terminateTask(taskID, false, null);
            }
        } while (!complete);
        this.isWorking = false;
        this.allTaskComplete = true;
        this.singleDoneTags.clear();
        return this.allTaskComplete;
    }

    @Override
    public boolean isAllTasksComplete() {
        return this.allTaskComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTaskRunning(String taskID) {
        if (!this.gbtTaskList.containsKey(taskID)) {
            AbstractLoggerWriter abstractLoggerWriter = this.loggerWriter;
            synchronized (abstractLoggerWriter) {
                String folderPath = taskID.split(REGEX_ITEM).length > 1 ? taskID.split(REGEX_ITEM)[1] : this.poolName;
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, taskID + " not exist in task manager.");
                return false;
            }
        }
        return !this.futures.get(taskID).isDone();
    }

    @Override
    public Set<String> getTaskIDs() {
        return this.gbtTaskList.keySet();
    }

    @Override
    public T getTask(String taskID) {
        if (this.gbtTaskList.containsKey(taskID)) {
            return (T)((EngineTask)this.gbtTaskList.get(taskID));
        }
        return null;
    }

    @Override
    public Map<String, R> getAllResults() {
        return this.futureResults;
    }

    @Override
    public R getSingleResult(String taskID) {
        if (this.futureResults.containsKey(taskID)) {
            return this.futureResults.get(taskID);
        }
        if (this.gbtTaskList.containsKey(taskID)) {
            return ((EngineTask)this.gbtTaskList.get(taskID)).getResult();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean terminateTask(String taskID, boolean restart, T EngineTask2) {
        AbstractLoggerWriter ie3;
        AbstractLoggerWriter abstractLoggerWriter;
        String folderPath;
        String string = folderPath = taskID.split(REGEX_ITEM).length > 1 ? taskID.split(REGEX_ITEM)[1] : this.poolName;
        if (this.pool.isShutdown()) {
            AbstractLoggerWriter abstractLoggerWriter2 = this.loggerWriter;
            synchronized (abstractLoggerWriter2) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Thread pool has been shut down.");
                return false;
            }
        }
        int count = 0;
        while (!this.isWorking) {
            abstractLoggerWriter = this.loggerWriter;
            synchronized (abstractLoggerWriter) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Waiting for the task manager works ... (" + count + ")");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie2) {
                AbstractLoggerWriter abstractLoggerWriter3 = this.loggerWriter;
                synchronized (abstractLoggerWriter3) {
                    this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "Interrupted terminate request.");
                    return !restart;
                }
            }
            if (++count <= 300) continue;
            ie3 = this.loggerWriter;
            synchronized (ie3) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Waiting for the task manager activated timeout.");
                return !restart;
            }
        }
        if (!this.isTaskExistBefore(taskID)) {
            if (restart) {
                this.addEngineTask(EngineTask2);
                if (this.submitConfirm(taskID)) {
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie3) {
                            AbstractLoggerWriter abstractLoggerWriter4 = this.loggerWriter;
                            synchronized (abstractLoggerWriter4) {
                                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "Interrupted waiting for new task : " + taskID + " submit complete.");
                                return false;
                            }
                        }
                    } while (!this.isTaskRunning(taskID));
                    this.singleDoneTags.put(taskID, Boolean.FALSE);
                    this.singleRestartTag.put(taskID, Boolean.FALSE);
                    return true;
                }
                return false;
            }
            ie3 = this.loggerWriter;
            synchronized (ie3) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "The target task : " + taskID + " can not cancel because it's not exist.");
                return true;
            }
        }
        if (this.isTaskRunning(taskID)) {
            ie3 = this.loggerWriter;
            synchronized (ie3) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Start terminate running task : " + taskID + ".");
            }
            if (this.futures.get(taskID).cancel(true)) {
                if (restart) {
                    this.addEngineTask(EngineTask2);
                    this.singleRestartTag.put(taskID, Boolean.TRUE);
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie4) {
                            AbstractLoggerWriter abstractLoggerWriter5 = this.loggerWriter;
                            synchronized (abstractLoggerWriter5) {
                                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "Interrupted running target task : " + taskID + " waiting for cancellation handles complete.");
                                return false;
                            }
                        }
                    } while (this.singleRestartTag.get(taskID).booleanValue());
                    ie3 = this.loggerWriter;
                    synchronized (ie3) {
                        this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Target running task : " + taskID + " restart complete.");
                    }
                }
                return true;
            }
            ie3 = this.loggerWriter;
            synchronized (ie3) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Target task : " + taskID + " can not cancel, because it is going to completed.");
                return false;
            }
        }
        if (this.isTaskComplete(taskID)) {
            if (restart) {
                ie3 = this.loggerWriter;
                synchronized (ie3) {
                    this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Start to restart completed task : " + taskID + ".");
                }
                this.addEngineTask(EngineTask2);
                if (this.submitConfirm(taskID)) {
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie5) {
                            AbstractLoggerWriter abstractLoggerWriter6 = this.loggerWriter;
                            synchronized (abstractLoggerWriter6) {
                                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Interrupted restart process of completed task : " + taskID + ".");
                                return false;
                            }
                        }
                    } while (!this.isTaskRunning(taskID));
                    this.singleDoneTags.put(taskID, Boolean.FALSE);
                    this.singleRestartTag.put(taskID, Boolean.FALSE);
                    return true;
                }
                ie3 = this.loggerWriter;
                synchronized (ie3) {
                    this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Target task : " + taskID + " can not submit.");
                    return false;
                }
            }
            ie3 = this.loggerWriter;
            synchronized (ie3) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "Target task : " + taskID + " can not cancel because it has completed.");
                return true;
            }
        }
        ie3 = this.loggerWriter;
        synchronized (ie3) {
            this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.TRACE, taskID, "Start to terminate scheduled tasks.");
        }
        if (this.futures.get(taskID).cancel(true)) {
            if (restart) {
                this.singleRestartTag.put(taskID, Boolean.TRUE);
                do {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie6) {
                        AbstractLoggerWriter abstractLoggerWriter7 = this.loggerWriter;
                        synchronized (abstractLoggerWriter7) {
                            this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "Interrupted the scheduled task : " + taskID + " waiting for submit complete.");
                            return false;
                        }
                    }
                } while (this.singleRestartTag.get(taskID).booleanValue());
            }
            return true;
        }
        abstractLoggerWriter = this.loggerWriter;
        synchronized (abstractLoggerWriter) {
            this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Scheduled task : " + taskID + " can not cancel.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        String folderPath;
        AbstractLoggerWriter abstractLoggerWriter;
        if (!this.pool.isTerminated()) {
            this.pool.shutdown();
            try {
                do {
                    Thread.sleep(1L);
                } while (!this.pool.awaitTermination(1L, TimeUnit.SECONDS));
            }
            catch (InterruptedException ie) {
                abstractLoggerWriter = this.loggerWriter;
                synchronized (abstractLoggerWriter) {
                    for (String taskID : this.futureResults.keySet()) {
                        folderPath = taskID.split(REGEX_ITEM).length > 1 ? taskID.split(REGEX_ITEM)[1] : this.poolName;
                        this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "Wait for executor services terminate process has interrupted.");
                    }
                }
            }
        }
        if (!this.pool.isTerminated()) {
            this.pool.shutdownNow();
            try {
                do {
                    Thread.sleep(1L);
                } while (!this.pool.awaitTermination(1L, TimeUnit.SECONDS));
            }
            catch (InterruptedException ie) {
                abstractLoggerWriter = this.loggerWriter;
                synchronized (abstractLoggerWriter) {
                    for (String taskID : this.futureResults.keySet()) {
                        folderPath = taskID.split(REGEX_ITEM).length > 1 ? taskID.split(REGEX_ITEM)[1] : this.poolName;
                        this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.WARN, taskID, "Wait for executor services terminate process has interrupted.");
                    }
                }
            }
        }
        this.isWorking = false;
        this.allTaskComplete = true;
        this.singleDoneTags.clear();
        this.singleRestartTag.clear();
        this.gbtTaskList.clear();
        this.futures.clear();
        for (String taskID : this.futureResults.keySet()) {
            String folderPath2 = taskID.split(REGEX_ITEM).length > 1 ? taskID.split(REGEX_ITEM)[1] : this.poolName;
            this.loggerWriter.appendPath(folderPath2).writeLogs(GbtLogLevel.TRACE, taskID, "Task manager close complete.");
        }
        this.loggerWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean submitConfirm(String taskID) {
        String folderPath;
        String string = folderPath = taskID.split(REGEX_ITEM).length > 1 ? taskID.split(REGEX_ITEM)[1] : this.poolName;
        if (this.pool.isShutdown()) {
            AbstractLoggerWriter abstractLoggerWriter = this.loggerWriter;
            synchronized (abstractLoggerWriter) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "Thread pool has been shut down, reject the request task : " + taskID);
                return false;
            }
        }
        try {
            this.futures.put(taskID, this.pool.submit((Callable)this.gbtTaskList.get(taskID)));
            return true;
        }
        catch (NullPointerException | RejectedExecutionException ree) {
            AbstractLoggerWriter abstractLoggerWriter = this.loggerWriter;
            synchronized (abstractLoggerWriter) {
                this.loggerWriter.appendPath(folderPath).writeLogs(GbtLogLevel.ERROR, taskID, "The task : " + taskID + " has been rejected.");
                return false;
            }
        }
    }

    private boolean isTaskExistBefore(String taskID) {
        return this.singleDoneTags.containsKey(taskID);
    }

    private boolean isTaskComplete(String taskID) {
        return this.singleDoneTags.get(taskID);
    }
}

