/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers;

import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtLocalCmdOptions;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.LocalCmdRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.AbstractCommandReceiver;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.Common.ZipUtils;
import Gbt.utility.FRU.record.FruRecord;
import Gbt.utility.bmcinfo.AdditionalDeviceSupport;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BMCPlatform;
import Gbt.utility.vmclitool.VmcliMountInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public final class GbtLocalCommandReceiver
extends AbstractCommandReceiver {
    private static volatile GbtLocalCommandReceiver localReceiver;

    private GbtLocalCommandReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final GbtLocalCommandReceiver getInstance() {
        if (localReceiver != null) return localReceiver;
        Class<GbtLocalCommandReceiver> clazz = GbtLocalCommandReceiver.class;
        synchronized (GbtLocalCommandReceiver.class) {
            if (localReceiver != null) return localReceiver;
            localReceiver = new GbtLocalCommandReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return localReceiver;
        }
    }

    @Override
    public String getReceiverName() {
        return "Gbt LocalCmd Receiver";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean closeReceivers() {
        if (localReceiver != null) {
            Class<GbtLocalCommandReceiver> clazz = GbtLocalCommandReceiver.class;
            synchronized (GbtLocalCommandReceiver.class) {
                if (localReceiver != null) {
                    try {
                        localReceiver.close();
                        localReceiver = null;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return true;
                    }
                    catch (Exception e) {
                        this.taskPool.shutdownNow();
                        this.taskPool = null;
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), this.getReceiverName(), "Close " + this.getReceiverName() + " fail.", e);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return false;
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalCmdRecords executeLocalCommand(String cmd, GbtLogLevel logLevel, String commandName, String commandID) {
        LocalCmdRecords records = new LocalCmdRecords(commandID);
        Process p = null;
        BufferedReader buffer = null;
        String[] exe = null;
        if (CommonFunction.isUnix()) {
            exe = new String[]{"/bin/bash", "-c", cmd};
        } else if (CommonFunction.isWindows()) {
            exe = new String[]{"cmd ", "/c", cmd};
        } else {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unsupported Operation System.");
            return records.addMessages("Unsupported Operation System : " + CommonFunction.getPlatform(), true).setStates(EngineRecordStates.Fail);
        }
        try {
            p = Runtime.getRuntime().exec(exe);
            String bufferString = null;
            buffer = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((bufferString = buffer.readLine()) != null) {
                records.addMessages(bufferString, false);
                this.writeLogs(logLevel, commandName, commandID, bufferString);
            }
            buffer = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((bufferString = buffer.readLine()) != null) {
                records.addMessages(bufferString, true);
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, bufferString);
            }
            p.waitFor();
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Local command cannot execute : ", ioe);
            LocalCmdRecords localCmdRecords = records.addMessages("Local command cannot execute.", true).setStates(EngineRecordStates.Fail);
            return localCmdRecords;
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Local command execution has been interrupted : ", ie);
            LocalCmdRecords localCmdRecords = records.addMessages("Local command execution has been interrupted.", true).setStates(EngineRecordStates.Fail);
            return localCmdRecords;
        }
        finally {
            try {
                buffer.close();
            }
            catch (IOException ioe) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Buffer reader close fail : ", ioe);
            }
            p.destroy();
        }
        if (records.getErrors().length() != 0) {
            return records.setStates(EngineRecordStates.Fail);
        }
        this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Local command execution success.");
        return records.setStates(EngineRecordStates.Pass);
    }

    public LocalCmdRecords executeLocalCommand(String cmd, String commandName, String commandID) {
        return this.executeLocalCommand(cmd, GbtLogLevel.INFO, commandName, commandID);
    }

    public LocalCmdRecords executeLocalCommand(String cmd) {
        return this.executeLocalCommand(cmd, GbtLogLevel.INFO, this.getReceiverName(), "localCmd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalCmdRecords executeLocalCommand(String cmd, String dir, GbtLogLevel logLevel, String commandName, String commandID) {
        LocalCmdRecords records = new LocalCmdRecords(commandID);
        Process p = null;
        BufferedReader buffer = null;
        String[] exe = null;
        if (CommonFunction.isUnix()) {
            exe = new String[]{"/bin/bash", "-c", cmd};
        } else if (CommonFunction.isWindows()) {
            exe = new String[]{"cmd ", "/c", cmd};
        } else {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unsupported Operation System.");
            return records.addMessages("Unsupported Operation System : " + CommonFunction.getPlatform(), true).setStates(EngineRecordStates.Fail);
        }
        ProcessBuilder pb = new ProcessBuilder(exe);
        try {
            pb.directory(new File(dir));
            pb.environment();
        }
        catch (NullPointerException ne) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "The given execution path does not exist.", ne);
            return records.addMessages("The given execution path does not exist.", true).setStates(EngineRecordStates.Fail);
        }
        catch (SecurityException se) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Local command has security problems : ", se);
            return records.addMessages("Local command has security problems.", true).setStates(EngineRecordStates.Fail);
        }
        try {
            p = pb.start();
            String bufferString = null;
            buffer = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((bufferString = buffer.readLine()) != null) {
                records.addMessages(bufferString, false);
                this.writeLogs(logLevel, commandName, commandID, bufferString);
            }
            buffer = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((bufferString = buffer.readLine()) != null) {
                records.addMessages(bufferString, true);
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, bufferString);
            }
            p.waitFor();
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Local command cannot execute : ", ioe);
            LocalCmdRecords localCmdRecords = records.addMessages("Local command cannot execute.", true).setStates(EngineRecordStates.Fail);
            return localCmdRecords;
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Local command execution has been interrupted : ", ie);
            LocalCmdRecords localCmdRecords = records.addMessages("Local command execution has been interrupted.", true).setStates(EngineRecordStates.Fail);
            return localCmdRecords;
        }
        finally {
            try {
                buffer.close();
            }
            catch (IOException ioe) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Buffer reader close fail : ", ioe);
            }
            p.destroy();
        }
        if (records.getErrors().length() != 0) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Local command execution fail.");
            return records.setStates(EngineRecordStates.Fail);
        }
        this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Local command execution success.");
        return records.setStates(EngineRecordStates.Pass);
    }

    public LocalCmdRecords executeLocalCommand(String cmd, String dir, String commandName, String commandID) {
        return this.executeLocalCommand(cmd, dir, GbtLogLevel.INFO, commandName, commandID);
    }

    public LocalCmdRecords executeLocalCommand(String cmd, String dir) {
        return this.executeLocalCommand(cmd, dir, GbtLogLevel.INFO, this.getReceiverName(), "localCmd");
    }

    public <T extends AbstractCommandBuilder<T>> LocalCmdRecords executeLocalCommand(GbtLocalCmdOptions<T> shellOptions, T commandArgs, GbtLogLevel logLevel, String commandName, String commandID) {
        this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Execute command : " + shellOptions.buildShell(commandArgs));
        this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Execution path  : " + shellOptions.getExecDir());
        return this.executeLocalCommand(shellOptions.buildShell(commandArgs), shellOptions.getExecDir(), logLevel, commandName, commandID);
    }

    public void changeFilePermission(String files, String commandName, String commandID) {
        if (CommonFunction.isUnix()) {
            LocalCmdRecords records = this.executeLocalCommand("chmod -R 755 " + files, GbtLogLevel.TRACE, commandName, commandID);
            if (records.getStates().isPass()) {
                this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "The file or folders : " + files + " has to change the 755 permission.");
            } else {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Cannot change permission : \n" + records.getErrors());
            }
        }
    }

    public boolean vmcliMount(VmcliMountInfo vmcliMountInfo, String commandName, String commandID) {
        if (!CommonFunction.isUnix()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Command not support OS : " + System.getProperty("os.name"));
            return false;
        }
        String vmcliArgs = this.reBuildVMCLIArgs(vmcliMountInfo.getPort(), vmcliMountInfo.getCdROM(), vmcliMountInfo.getFloppy(), vmcliMountInfo.getRemovable());
        if (vmcliArgs.equals("")) {
            return false;
        }
        this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + " , vmcli args : " + vmcliArgs);
        String dir = this.getVMCLIExecutionPath(commandName, commandID);
        if (dir == null) {
            return false;
        }
        LocalCmdRecords records = this.executeLocalCommand("lsof -i | grep VMCLI | grep " + vmcliMountInfo.getBmcIP(), dir, GbtLogLevel.TRACE, commandName, commandID);
        if (records.getStates().isFail()) {
            return false;
        }
        if (records.getResults().contains("VMCLIValk")) {
            this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + " Virtual media has been mounted.");
            records.clearMesg();
            return false;
        }
        this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + " No virtual media mounted currently.");
        records.clearMesg();
        records = this.executeLocalCommand("./VMCLIValkyrie -a " + vmcliMountInfo.getBmcIP() + " -u " + vmcliMountInfo.getBmcUsername() + " -p " + vmcliMountInfo.getBmcPassword() + " " + vmcliArgs + "> " + vmcliMountInfo.getBmcIP() + "_vmcliRunning.log 2>&1 &", dir, GbtLogLevel.TRACE, commandName, commandID);
        if (records.getStates().isFail()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "vmcli utility does not exist.");
            records.clearMesg();
            return false;
        }
        this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + " start check mount states.");
        records.clearMesg();
        boolean stage = false;
        int retryCount = 0;
        int pid = 0;
        do {
            if ((records = this.executeLocalCommand("sleep 5\nlsof -i | grep VMCLI | grep " + vmcliMountInfo.getBmcIP() + " | awk '{print $2}'", dir, GbtLogLevel.TRACE, commandName, commandID)).getStates().isPass()) {
                try {
                    pid = Integer.parseInt(records.getResults().trim());
                }
                catch (Exception e) {
                    pid = 0;
                    e.printStackTrace();
                }
                if (pid <= 0) {
                    stage = false;
                    ++retryCount;
                } else {
                    stage = true;
                    this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + ", get WCHAN success.");
                }
            }
            records.clearMesg();
        } while (!stage && retryCount < 60);
        if (retryCount >= 5) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Vertual media mount on : " + vmcliMountInfo.getBmcIP() + " fail.");
            return false;
        }
        if (pid > 0) {
            this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "vmcli process PID : " + pid);
            this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Vertual media mount on : " + vmcliMountInfo.getBmcIP() + " successfully.");
            return true;
        }
        records.clearMesg();
        this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Vertual media mount on : " + vmcliMountInfo.getBmcIP() + " fail.");
        return false;
    }

    public boolean vmcliMount(VmcliMountInfo vmcliMountInfo, String toolPath, String commandName, String commandID) {
        if (!CommonFunction.isUnix()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Command not support OS : " + System.getProperty("os.name"));
            return false;
        }
        String vmcliArgs = this.reBuildVMCLIArgs(vmcliMountInfo.getPort(), vmcliMountInfo.getCdROM(), vmcliMountInfo.getFloppy(), vmcliMountInfo.getRemovable());
        if (vmcliArgs.equals("")) {
            return false;
        }
        this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + " , vmcli args : " + vmcliArgs);
        File toolFile = new File(toolPath);
        if (!toolFile.exists()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, toolFile.getAbsolutePath() + " is not exist!");
            return false;
        }
        String dir = FilenameUtils.getFullPathNoEndSeparator((String)toolFile.getAbsolutePath());
        String toolName = toolFile.getName();
        String processName = toolName.substring(0, 5);
        if (dir == null) {
            return false;
        }
        localReceiver.changeFilePermission(dir, commandName, commandID);
        LocalCmdRecords records = this.executeLocalCommand("lsof -i | grep " + processName + " | grep " + vmcliMountInfo.getBmcIP() + " | awk '{print $1}'", dir, GbtLogLevel.TRACE, commandName, commandID);
        if (records.getStates().isFail()) {
            return false;
        }
        if (records.getResults().contains(processName)) {
            this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + " Virtual media has been mounted.");
            records.clearMesg();
            return false;
        }
        this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + " No virtual media mounted currently.");
        records.clearMesg();
        records = this.executeLocalCommand("./" + toolName + " -a " + vmcliMountInfo.getBmcIP() + " -u " + vmcliMountInfo.getBmcUsername() + " -p " + vmcliMountInfo.getBmcPassword() + " " + vmcliArgs + "> " + vmcliMountInfo.getBmcIP() + "_vmcliRunning.log 2>&1 &", dir, GbtLogLevel.TRACE, commandName, commandID);
        if (records.getStates().isFail()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "vmcli utility does not exist.");
            records.clearMesg();
            return false;
        }
        this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + " start check mount states.");
        records.clearMesg();
        boolean stage = false;
        int retryCount = 0;
        int pid = 0;
        do {
            if ((records = this.executeLocalCommand("sleep 5\nlsof -i | grep " + processName + " | grep " + vmcliMountInfo.getBmcIP() + " | awk '{print $2}'", dir, GbtLogLevel.TRACE, commandName, commandID)).getStates().isPass()) {
                try {
                    pid = Integer.parseInt(records.getResults().trim());
                }
                catch (Exception e) {
                    pid = 0;
                    e.printStackTrace();
                }
                if (pid <= 0) {
                    stage = false;
                    ++retryCount;
                } else {
                    stage = true;
                    this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Target node : " + vmcliMountInfo.getBmcIP() + ", get WCHAN success.");
                }
            }
            records.clearMesg();
        } while (!stage && retryCount < 60);
        if (retryCount >= 5) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Virtual media mount on : " + vmcliMountInfo.getBmcIP() + " fail.");
            return false;
        }
        if (pid > 0) {
            this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "vmcli process PID : " + pid);
            this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Virtual media mount on : " + vmcliMountInfo.getBmcIP() + " successfully.");
            return true;
        }
        records.clearMesg();
        this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Virtual media mount on : " + vmcliMountInfo.getBmcIP() + " fail.");
        return false;
    }

    public boolean vmcliUnmount(String ipAddress, String commandName, String commandID) {
        if (!CommonFunction.isUnix()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Command not support OS : " + System.getProperty("os.name"));
            return false;
        }
        String dir = this.getVMCLIExecutionPath(commandName, commandID);
        if (dir == null) {
            return false;
        }
        LocalCmdRecords records = this.executeLocalCommand("sleep 5\nlsof -i | grep VMCLI | grep " + ipAddress + " | awk '{print $2}'", dir, GbtLogLevel.TRACE, commandName, commandID);
        if (records.getStates().isPass()) {
            int pid = 0;
            try {
                pid = Integer.parseInt(records.getResults().trim());
            }
            catch (Exception e) {
                pid = 0;
                e.printStackTrace();
            }
            if (pid > 0) {
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "vmcli mount process target node : " + ipAddress + " PID = " + pid);
                records = this.executeLocalCommand("kill " + pid, dir, GbtLogLevel.TRACE, commandName, commandID);
                if (records.getStates().isPass()) {
                    this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Target node : " + ipAddress + " unmount successful.");
                    return true;
                }
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Kill thread fail of target node : " + ipAddress);
                return false;
            }
            this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Virtual media has been unmounted or not mounted.");
            return false;
        }
        this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Get process info fail of vmcli of target node : " + ipAddress);
        return false;
    }

    public boolean vmcliUnmount(String ipAddress, String toolPath, String commandName, String commandID) {
        if (!CommonFunction.isUnix()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Command not support OS : " + System.getProperty("os.name"));
            return false;
        }
        File toolFile = new File(toolPath);
        if (!toolFile.exists()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, toolFile.getAbsolutePath() + " is not exist!");
            return false;
        }
        String dir = FilenameUtils.getFullPathNoEndSeparator((String)toolFile.getAbsolutePath());
        String toolName = toolFile.getName();
        String processName = toolName.substring(0, 5);
        if (dir == null) {
            return false;
        }
        LocalCmdRecords records = this.executeLocalCommand("lsof -i | grep " + processName + " | grep " + ipAddress + " | awk '{print $2}'", dir, GbtLogLevel.TRACE, commandName, commandID);
        if (records.getStates().isPass()) {
            int pid = 0;
            try {
                pid = Integer.parseInt(records.getResults().trim());
            }
            catch (Exception e) {
                pid = 0;
                e.printStackTrace();
            }
            if (pid > 0) {
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "vmcli mount process target node : " + ipAddress + " PID = " + pid);
                records = this.executeLocalCommand("kill " + pid, dir, GbtLogLevel.TRACE, commandName, commandID);
                if (records.getStates().isPass()) {
                    this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Target node : " + ipAddress + " unmount successful.");
                    return true;
                }
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Kill thread fail of target node : " + ipAddress);
                return false;
            }
            this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Virtual media has been unmounted or not mounted.");
            return false;
        }
        this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Get process info fail of vmcli of target node : " + ipAddress);
        return false;
    }

    private String getVMCLIExecutionPath(String commandName, String commandID) {
        this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Start detect OS Arch.");
        LocalCmdRecords records = null;
        if (CommonFunction.isUnix()) {
            records = this.executeLocalCommand("uname -m", "./", GbtLogLevel.TRACE, commandName, commandID);
            if (records.getStates().isPass()) {
                if (records.getResults().contains("i686")) {
                    this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Get execution path : ./tools/vmcliUtility/Linux86");
                    return "./tools/vmcliUtility/Linux86";
                }
                if (records.getResults().contains("x86_64")) {
                    this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Get execution path : ./tools/vmcliUtility/Linux64");
                    return "./tools/vmcliUtility/Linux64";
                }
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unknown arch type : " + records.getResults());
                return null;
            }
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Detect OS Arch fail.");
            return null;
        }
        if (CommonFunction.isWindows()) {
            records = this.executeLocalCommand("wmic OS get OSArchitecture", "C:\\", GbtLogLevel.TRACE, commandName, commandID);
            if (records.getStates().isPass()) {
                if (records.getResults().contains("32")) {
                    this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Get execution path : tools\\vmcliUtility\\Win32");
                    return "tools\\vmcliUtility\\Win32";
                }
                if (records.getResults().contains("64")) {
                    this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Get execution path : tools\\vmcliUtility\\Win64");
                    return "tools\\vmcliUtility\\Win64";
                }
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unknown arch type : " + records.getResults());
                return null;
            }
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Detect OS Arch fail.");
            return null;
        }
        this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unsupported Operation System : " + CommonFunction.getPlatform());
        return null;
    }

    private String reBuildVMCLIArgs(int port, String isoName, String floppyName, String removableDev) {
        StringBuilder builder = new StringBuilder();
        if (port != 0) {
            builder.append("-o ").append(port).append(" ");
        }
        if (isoName != null) {
            if (!isoName.substring(0, 1).equals("/") && !isoName.substring(0, 4).equals("$PWD")) {
                builder.append("-c ").append("$PWD/../../../").append(isoName).append(" ");
            } else {
                builder.append("-c ").append(isoName).append(" ");
            }
        }
        if (floppyName != null) {
            if (!floppyName.substring(0, 1).equals("/") && !floppyName.substring(0, 4).equals("$PWD")) {
                builder.append("-f ").append("$PWD/../../../").append(floppyName).append(" ");
            } else {
                builder.append("-f ").append(floppyName).append(" ");
            }
        }
        if (removableDev != null) {
            if (!removableDev.substring(0, 1).equals("/") && !removableDev.substring(0, 4).equals("$PWD")) {
                builder.append("-r ").append("$PWD/../../../").append(removableDev).append(" ");
            } else {
                builder.append("-r ").append(removableDev).append(" ");
            }
        }
        if (builder.length() == 0) {
            return "";
        }
        return builder.toString();
    }

    public String findDHCPIPbyMAC(String MAC, String commandName, String commandID) {
        if (MAC.equals("00:00:00:00:00:00") || MAC.equals("FF:FF:FF:FF:FF:FF") || MAC.equals("ff:ff:ff:ff:ff:ff")) {
            this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Invalid MAC address : " + MAC);
            return "0.0.0.0";
        }
        LocalCmdRecords records = this.executeLocalCommand("cat /var/lib/dhcp/dhcpd.leases | grep -B10 -i " + MAC + " | grep lease | tail -n1 | awk '{print $2}'", GbtLogLevel.TRACE, commandName, commandID);
        if (records.getStates().isFail()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Find " + MAC + " in dhcpd lease file fail.");
            return "0.0.0.0";
        }
        if (records.getResults().isEmpty() || records.getResults().length() == 0) {
            this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Cannot find DHCP IP of given MAC address : " + MAC);
            return "0.0.0.0";
        }
        this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "Find DHCP IP : " + records.getResults().replace("\n", "") + " of given MAC address : " + MAC);
        return records.getResults().replace("\n", "").trim();
    }

    public String getActivateDHCPIP(Map<String, String> macs, String commandName, String commandID) {
        String dataLANIP = "0.0.0.0";
        int count = 0;
        block2: do {
            if (Thread.currentThread().isInterrupted()) {
                this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Interrupt the get activate DHCP IP process.");
                break;
            }
            for (String lan : macs.keySet()) {
                if (!lan.equals("BMC") && !(dataLANIP = this.findDHCPIPbyMAC(macs.get(lan), commandName, commandID)).equals("0.0.0.0")) {
                    this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Get data " + lan + " IP : " + dataLANIP);
                    if (this.pingDataLAN(dataLANIP, commandName, commandID)) {
                        this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "ping data " + lan + " IP : " + dataLANIP + " success");
                        continue block2;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } while (dataLANIP.equals("0.0.0.0") && ++count < 3);
        if (dataLANIP.equals("0.0.0.0")) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "No activate data LAN IP.");
        }
        return dataLANIP;
    }

    public boolean pingDataLAN(String dataLANIP, String commandName, String commandID) {
        try {
            InetAddress address = InetAddress.getByName(dataLANIP);
            Thread.sleep(1050L);
            if (address.isReachable(5250)) {
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, dataLANIP + " is alive.");
                return true;
            }
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, dataLANIP + " is unreachable.");
            return false;
        }
        catch (UnknownHostException ue) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unknown host : " + dataLANIP, ue);
            return false;
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Network connection fail.", ioe);
            return false;
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Interrupt the check IP alive process.", ie);
            return false;
        }
    }

    public boolean detectOSArchitecture() {
        return this.detectOSArchitecture(this.getReceiverName(), "detectOSAuth");
    }

    public boolean detectOSArchitecture(String commandName, String commandID) {
        boolean isX64 = false;
        if (CommonFunction.isUnix()) {
            LocalCmdRecords records = this.executeLocalCommand("uname -m", "./", GbtLogLevel.TRACE, commandName, commandID);
            if (records.getStates().isPass()) {
                if (records.getResults().contains("i686")) {
                    isX64 = false;
                } else if (records.getResults().contains("x86_64")) {
                    isX64 = true;
                }
            } else {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Detect OS architecture fail : " + records.getErrors());
            }
        } else if (CommonFunction.isWindows()) {
            LocalCmdRecords records = this.executeLocalCommand("wmic OS get OSArchitecture", "C:\\", GbtLogLevel.TRACE, commandName, commandID);
            if (records.getStates().isPass()) {
                if (records.getResults().contains("32")) {
                    isX64 = false;
                } else if (records.getResults().contains("64")) {
                    isX64 = true;
                }
            } else {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Detect OS architecture fail : " + records.getErrors());
            }
        } else {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unsupport OS platform : " + CommonFunction.getPlatform());
        }
        return isX64;
    }

    public synchronized boolean checkBMCUtilPkg(String commandName, String commandID) {
        LocalCmdRecords records = null;
        if (CommonFunction.isUnix()) {
            records = this.executeLocalCommand("ls | grep \"bmcWebUtils\" | grep -v \".zip\"", GbtLogLevel.TRACE, commandName, commandID);
            if (!records.getResults().contains("bmcWebUtils")) {
                records = this.executeLocalCommand("ls | grep \"bmcWebUtils.zip\"", GbtLogLevel.TRACE, commandName, commandID);
                if (!records.getResults().contains("bmcWebUtils.zip")) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Fatal error : \"bmcWebUtils.zip\" not exist!!");
                    return false;
                }
                records = this.executeLocalCommand("echo $PWD/bmcWebUtils.zip", GbtLogLevel.TRACE, commandName, commandID);
                try {
                    ZipUtils.decompress(records.getResults().replace("\n", ""), true);
                    this.changeFilePermission("bmcWebUtils", commandName, commandID);
                    this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "bmcWebUtil.zip unzip OK.");
                }
                catch (Exception e) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "bmcWebUtil.zip unzip Fail.", e);
                    return false;
                }
            }
        } else if (CommonFunction.isWindows() && !(records = this.executeLocalCommand("dir bmcWebUtils", GbtLogLevel.TRACE, commandName, commandID)).getResults().contains("bmcWebUtils")) {
            records = this.executeLocalCommand("dir bmcWebUtils.zip", GbtLogLevel.TRACE, commandName, commandID);
            if (!records.getResults().contains("bmcWebUtils.zip")) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Fatal error : \"bmcWebUtils.zip\" not exist!!");
                return false;
            }
            records = this.executeLocalCommand("echo %cd%\\bmcWebUtils.zip", GbtLogLevel.TRACE, commandName, commandID);
            try {
                ZipUtils.decompress(records.getResults().replace("\n", ""), true);
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "bmcWebUtil.zip unzip OK.");
            }
            catch (Exception e) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "bmcWebUtil.zip unzip Fail..", e);
                return false;
            }
        }
        return true;
    }

    public BMCInfoJSONData getBMCInfoByLocalCmd(String commandName, String commandID) {
        int i;
        BMCInfoJSONData mcinfo = new BMCInfoJSONData();
        LocalCmdRecords records = null;
        if (CommonFunction.isWindows()) {
            records = this.executeLocalCommand("kcs_wmi.exe 18 01", "tools\\ipmitool", commandName, commandID);
        } else if (CommonFunction.isUnix()) {
            records = this.executeLocalCommand("ipmitool raw 0x06 0x01", commandName, commandID);
        } else {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unsupport this OS environment.");
            return mcinfo;
        }
        if (records.getStates().isFail()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Get local BMC info fail.");
            return mcinfo;
        }
        byte[] response = null;
        if (CommonFunction.isWindows()) {
            if (records.getLineResults().size() != 3) {
                return mcinfo;
            }
            String[] splitArr = ("A" + records.getLineResults().get(2)).trim().substring(1).replace(" ", " 0x").trim().split(" ");
            byte[] temp = GbtCommonConverters.stringArray2ByteArray(splitArr);
            response = new byte[temp.length - 1];
            System.arraycopy(temp, 1, response, 0, response.length);
        } else {
            String[] stringRawBytes = records.getResults().replace(" ", " 0x").trim().split(" ");
            response = GbtCommonConverters.stringArray2ByteArray(stringRawBytes);
        }
        byte deviceID = response[0];
        mcinfo.setDeviceID(deviceID);
        int deviceVer = response[1] & 0xF;
        mcinfo.setDeviceRevision(deviceVer);
        String fwRev = (response[2] & 0xFF) + "." + GbtCommonConverters.bytesToHex(new byte[]{(byte)(response[3] & 0xFF & 0xFF)});
        mcinfo.setFirmwareRevision(fwRev);
        int IPMIMajorVer = response[4] & 0xF;
        int IPMIMinorVer = (response[4] & 0xFFFFFFF0) >> 4;
        String ipmiRev = IPMIMajorVer + "." + IPMIMinorVer;
        mcinfo.setIpmiVersion(ipmiRev);
        int mfgID = ((response[8] & 0xFF) << 16) + ((response[7] & 0xFF) << 8) + (response[6] & 0xFF);
        mcinfo.setManufacturerID(mfgID);
        byte[] manuName = new byte[]{response[7], response[6]};
        mcinfo.setManufacturerName("Unknown (0x" + GbtCommonConverters.bytesToHex(manuName) + ")");
        byte[] productID = new byte[]{response[10], response[9]};
        mcinfo.setProductID(GbtCommonConverters.bytesToHex(productID));
        mcinfo.setProductName(BMCPlatform.parserPlatformByID(productID));
        mcinfo.setDeviceAvailable((response[4] & 0x80) >> 7 == 0);
        mcinfo.setProvidesDeviceSDRs((response[1] & 0x80) >> 7 == 1);
        for (i = 0; i < 8; ++i) {
            byte checkVar = (byte)(response[5] & 0xFFFFFFFF & 1 << i);
            mcinfo.setAdditionalDeviceSupport(AdditionalDeviceSupport.parserByCode(checkVar));
        }
        for (i = 0; i < 4; ++i) {
            mcinfo.setAuxFWRevInfo(GbtCommonConverters.bytesToHex(response[i + 11]));
        }
        return mcinfo;
    }

    public String getModelName(String commandName, String commandID) {
        String modelNameGet = null;
        String getModelName = null;
        if (CommonFunction.isWindows()) {
            modelNameGet = "wmic baseboard get product";
        } else if (CommonFunction.isUnix()) {
            modelNameGet = "sudo dmidecode -t 1 | grep Product | awk '{print $3}'";
        }
        try {
            String line;
            Process process = Runtime.getRuntime().exec(modelNameGet);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String[] line_linux = new String[2];
            int countNum = 0;
            while ((line = reader.readLine()) != null) {
                if (line.contains("Product") && CommonFunction.isUnix()) {
                    line_linux = line.split(": ");
                    getModelName = line_linux[1];
                    continue;
                }
                if (!CommonFunction.isWindows()) continue;
                if (countNum != 2) {
                    ++countNum;
                    continue;
                }
                if (countNum != 2) continue;
                countNum = 0;
                getModelName = line;
                break;
            }
            process.waitFor();
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Get model name fail.");
        }
        return getModelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FruRecord> getFRURecordsByLocalCmd(BMCInfoJSONData bmcInfo, String commandName, String commandID) {
        StringBuilder resultString = new StringBuilder();
        String executeCommand = null;
        Process process = null;
        BufferedReader reader = null;
        try {
            block11: for (int i = 0; i < 16; ++i) {
                String line;
                int count = 1;
                executeCommand = CommonFunction.isUnix() ? "ipmitool raw 0x0a 0x11 0x" + (bmcInfo.isAST2400() || bmcInfo.isCMC() ? "00" : "01") + " 0x" + Integer.toString(i, 16) + "0 0x00 0x10" : "tools\\ipmitool\\kcs_wmi.exe 28 11 " + (bmcInfo.isAST2400() || bmcInfo.isCMC() ? "00" : "01 ") + Integer.toString(i, 16) + "0 00 10";
                process = Runtime.getRuntime().exec(executeCommand);
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (CommonFunction.isWindows()) {
                        if (line.contains("Microsoft_IPMI Error")) continue block11;
                        if (count != 3) {
                            ++count;
                            continue;
                        }
                        resultString.append(" ").append(line.trim().split("00 10 ")[1]);
                        continue;
                    }
                    if (!line.startsWith(" 10") && count != 2) continue block11;
                    if (count == 1) {
                        line = "A" + line;
                        resultString.append(" ").append(line.trim().split("A 10 ")[1]);
                        ++count;
                        continue;
                    }
                    if (count != 2) continue;
                    resultString.append(" ").append(line.trim());
                }
            }
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Local get Produce & Board Name fail! ", e);
            List<FruRecord> list = null;
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "Local get Produce & Board Name close fail! ", e);
                }
            }
            if (process != null) {
                process.destroy();
            }
        }
        String[] temp1 = resultString.toString().replace(" ", " 0x").trim().split(" ");
        return FruRecord.decodeFruData(GbtCommonConverters.stringArray2ByteArray(temp1));
    }

    public boolean executeBMCProg(String parameters, String executePath, String commandName, String commandID) {
        System.out.println("parameters:" + parameters);
        System.out.println("executePath:" + executePath);
        if (CommonFunction.isUnix()) {
            this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Get execution path : " + executePath);
            this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "./bmcprog " + parameters);
            this.executeLocalCommand("chmod -R 755 *", executePath);
            LocalCmdRecords records = this.executeLocalCommand("./bmcprog " + parameters, executePath, GbtLogLevel.TRACE, commandName, commandID);
            if (records.getStates().isFail()) {
                return false;
            }
        } else if (CommonFunction.isWindows()) {
            this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "Get execution path : " + executePath);
            this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "./bmcprog.exe " + parameters);
            LocalCmdRecords records = this.executeLocalCommand("bmcprog.exe " + parameters, executePath, GbtLogLevel.TRACE, commandName, commandID);
            if (records.getStates().isFail()) {
                return false;
            }
        } else {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unsupported Operation System : " + CommonFunction.getPlatform());
            return false;
        }
        return true;
    }

    public String localGetCPUVendor(String commandName, String commandID) {
        String vendor = "";
        if (CommonFunction.isUnix()) {
            LocalCmdRecords records = this.executeLocalCommand("dmidecode -t 4 | grep \"Version:\" | sed 's/\tVersion: //g' | sed -n 1p", GbtLogLevel.DEBUG, commandName, commandID);
            List<String> stdOutList = records.getLineResults();
            if (stdOutList.get(0).contains("Intel")) {
                vendor = "Intel";
            } else if (stdOutList.get(0).contains("AMD")) {
                vendor = "AMD";
            }
        } else if (CommonFunction.isWindows()) {
            LocalCmdRecords records = this.executeLocalCommand("wmic CPU get Caption", GbtLogLevel.DEBUG, commandName, commandID);
            List<String> stdOutList = records.getLineResults();
            if (stdOutList.get(2).contains("Intel")) {
                vendor = "Intel";
            } else if (stdOutList.get(2).contains("AMD")) {
                vendor = "AMD";
            }
        }
        return vendor;
    }
}

