/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.rest;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.rest.models.AMIRestSessionData;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Cookie;

public abstract class RESTRequest {
    private static final String CSRF_TOKEN_KEY = "x-csrftoken";
    protected RESTProtocolHeaders protocolHeader;
    protected String hostname;
    protected int port;
    protected RESTHttpMethods httpMethods;
    protected String contentType;
    protected Map<String, String> queryPair;
    protected Map<String, String> headers;
    protected Map<String, Object> formData;
    protected Object rawJsonData;
    protected Map<String, Cookie> cookies;
    protected String uploadFileName;
    protected InputStream inputStream;

    protected <T extends Builder<T>> RESTRequest(Builder<T> builder) {
        this.protocolHeader = ((Builder)builder).protocolHeader;
        this.hostname = ((Builder)builder).hostname;
        this.port = ((Builder)builder).port;
        this.httpMethods = ((Builder)builder).httpMethods;
        this.contentType = ((Builder)builder).contentType;
        this.queryPair = ((Builder)builder).queryPair;
        this.headers = ((Builder)builder).headers;
        this.formData = ((Builder)builder).formData;
        this.rawJsonData = ((Builder)builder).rawJsonData;
        this.cookies = ((Builder)builder).cookies;
        this.uploadFileName = ((Builder)builder).uploadFileName;
        this.inputStream = ((Builder)builder).inputStream;
    }

    public abstract String getRestURI();

    public String getHostname() {
        return this.hostname;
    }

    public RESTHttpMethods getHttpMethod() {
        return this.httpMethods;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getQueryPair() {
        return this.queryPair;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getFormData() {
        return this.formData;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Object getRawJsonData() {
        return this.rawJsonData;
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public final RESTRequest setRawJsonAsFormData(AbstractJSONPOJO inputData) {
        this.formData.putAll(inputData.parserToFormData());
        return this;
    }

    public final RESTRequest setRawJsonAsFormData(AbstractJSONPOJO inputData, String allowTag) {
        this.formData.putAll(inputData.parserToFormData(allowTag));
        return this;
    }

    public static final RESTRequestImpl.Builder create() {
        return new RESTRequestImpl.Builder();
    }

    private static final boolean isValidString(String arg) {
        if (arg == null) {
            return false;
        }
        return !arg.trim().isEmpty();
    }

    public static abstract class Builder<T extends Builder<T>> {
        private RESTProtocolHeaders protocolHeader = RESTProtocolHeaders.HTTPS;
        private String hostname;
        private int port;
        private RESTHttpMethods httpMethods;
        private String contentType;
        private final Map<String, String> queryPair = new HashMap<String, String>();
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, Object> formData = new HashMap<String, Object>();
        private String uploadFileName;
        private InputStream inputStream;
        private Object rawJsonData;
        private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();

        protected abstract T getThis();

        public abstract RESTRequest build();

        public T setProtocolHeader(RESTProtocolHeaders protocolHeader) {
            this.protocolHeader = protocolHeader;
            return this.getThis();
        }

        public T setHostname(String hostname) {
            this.hostname = hostname;
            return this.getThis();
        }

        public T setPort(int port) {
            this.port = port;
            return this.getThis();
        }

        public T setHttpMethods(RESTHttpMethods httpMethods) {
            this.httpMethods = httpMethods;
            return this.getThis();
        }

        public T setContentType(String contentType) {
            this.contentType = contentType;
            return this.getThis();
        }

        public T setQueryPair(String name, String value) {
            if (!RESTRequest.isValidString(name)) {
                return this.getThis();
            }
            if (!RESTRequest.isValidString(value)) {
                return this.getThis();
            }
            this.queryPair.put(name, value);
            return this.getThis();
        }

        public T setQueryPair(Map<String, String> queryPair) {
            this.queryPair.putAll(queryPair);
            return this.getThis();
        }

        public T setHeaders(String name, String value) {
            if (!RESTRequest.isValidString(name)) {
                return this.getThis();
            }
            if (!RESTRequest.isValidString(value)) {
                return this.getThis();
            }
            this.headers.put(name, value);
            return this.getThis();
        }

        public T setHeaders(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this.getThis();
        }

        public T setFormData(String key, Object data) {
            if (!RESTRequest.isValidString(key)) {
                return this.getThis();
            }
            if (data == null) {
                return this.getThis();
            }
            this.formData.put(key, data);
            return this.getThis();
        }

        public T setFormData(Map<String, Object> formData) {
            this.formData.putAll(formData);
            return this.getThis();
        }

        public T setUploadFileName(String uploadFileName) {
            this.uploadFileName = uploadFileName;
            return this.getThis();
        }

        public T setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this.getThis();
        }

        public T setRawJsonData(Object rawJsonData) {
            this.rawJsonData = rawJsonData;
            return this.getThis();
        }

        public T setCookies(AMIRestSessionData sessionData) {
            if (sessionData == null) {
                return this.getThis();
            }
            if (!"".equals(sessionData.getCSRFToken())) {
                this.headers.put(RESTRequest.CSRF_TOKEN_KEY, sessionData.getCSRFToken());
            }
            this.cookies.putAll(sessionData.getCookies());
            return this.getThis();
        }
    }
}

