/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.API;

import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.BatchedInvoker;
import Gbt.core.commands.CommandTask;
import Gbt.core.commands.ConcurrentInvoker;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.engines.DefaultTaskManager;
import Gbt.core.engines.EngineThreadPoolFactory;
import Gbt.core.engines.EngineThreadPoolTypes;
import Gbt.core.engines.records.CommandTaskRecords;
import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.Chassis.ChassisPowerCommand;
import Gbt.utility.Chassis.PowerCommand;
import Gbt.utility.FRU.FRUType;
import Gbt.utility.FRU.GetFRUCommand;
import Gbt.utility.GPUFanPolicy.GetGPUFanPolicyCommand;
import Gbt.utility.HDDInfo.HwInfoCommand;
import Gbt.utility.IKVM.LaunchiKVMCommand;
import Gbt.utility.IPSrc.IPSrcCommand;
import Gbt.utility.IPv6Config.IPv6ConfigCommand;
import Gbt.utility.Identify.IdentifyCommand;
import Gbt.utility.LoadDefault.LoadDefaultCommand;
import Gbt.utility.Local.LocalSubCommand;
import Gbt.utility.LogoChange.LogoChangeCommand;
import Gbt.utility.MSR.MSRCommand;
import Gbt.utility.NTP.NtpCommand;
import Gbt.utility.NTP.NtpJsonData;
import Gbt.utility.NTP.NtpOperationMode;
import Gbt.utility.PEF.PEFCommand;
import Gbt.utility.PEF.PefActions;
import Gbt.utility.RAW.IPMIRawCommand;
import Gbt.utility.SDR.SDRCommand;
import Gbt.utility.SDR.SDRIpmiOptions;
import Gbt.utility.SEL.SELCommand;
import Gbt.utility.SEL.SELIPMIOptions;
import Gbt.utility.SMBIOS.GetSMBIOSCommand;
import Gbt.utility.SMTP.SMTPCommand;
import Gbt.utility.Trap.TrapCommand;
import Gbt.utility.bmcinfo.GetBMCInfoCommand;
import Gbt.utility.bmclanconfig.BMCLanConfigCommand;
import Gbt.utility.bmclanconfig.BMCLanConfigIPSource;
import Gbt.utility.bmcwebutils.BMCUtilCommand;
import Gbt.utility.bmcwebutils.PhantomJSOptions;
import Gbt.utility.bootoptions.BootOptions;
import Gbt.utility.bootoptions.SetBootOptionCommand;
import Gbt.utility.maclist.GetMACListCommand;
import Gbt.utility.meversion.MeVersionCommand;
import Gbt.utility.postcode.PostCodeCommand;
import Gbt.utility.power.GetPowerReadingCommand;
import Gbt.utility.power.PowerIpmiOptions;
import Gbt.utility.power.PowerLimitCommand;
import Gbt.utility.scan.ScanCommand;
import Gbt.utility.scan.ScanResultsData;
import Gbt.utility.useraccounts.UserAccountCommand;
import Gbt.utility.useraccounts.UserAccountCommandActions;
import Gbt.utility.vmclitool.VmcliCommand;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class GbtUtilityAPI {
    private GbtUtilityAPI() {
    }

    public static final List<String> scan(String startIP, String endIP) {
        ScanCommand command = new ScanCommand.Builder().setStartIP(startIP).setEndIP(endIP).build();
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return null;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return null;
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return null;
        }
        ArrayList<String> ipList = new ArrayList<String>();
        for (AbstractJSONPOJO result : command.getCommandResults()) {
            ipList.add(result.castConcreteJSON(ScanResultsData.class).getBmcIpAddress());
        }
        return ipList;
    }

    public static final CommandTaskRecords chassisPowerCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, PowerCommand chassisType) {
        ChassisPowerCommand command = new ChassisPowerCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setPowerCommand(chassisType).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords chassisPowerCommand(String bmcIP, PowerCommand chassisType) {
        return GbtUtilityAPI.chassisPowerCommand(bmcIP, "admin", "password", chassisType);
    }

    public static final List<CommandTaskRecords> chassisPowerCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, PowerCommand chassisType) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("chassis")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            ChassisPowerCommand command = new ChassisPowerCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setPowerCommand(chassisType).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> chassisPowerCommand(String startIP, String endIP, PowerCommand chassisType) {
        return GbtUtilityAPI.chassisPowerCommand(startIP, endIP, "admin", "password", chassisType);
    }

    public static final CommandTaskRecords chassisPowerCommand(ChassisPowerCommand.Builder builder) {
        ChassisPowerCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> chassisPowerCommand(String startIP, String endIP, ChassisPowerCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("chassis")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            ChassisPowerCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords trapCommand(TrapCommand.Builder builder) {
        TrapCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> trapCommand(List<TrapCommand.Builder> builderList) {
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("trap")).setThreadNumber(builderList.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (TrapCommand.Builder builder : builderList) {
            TrapCommand command = builder.build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (builderList.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords hwinfoCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        HwInfoCommand command = new HwInfoCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords hwinfoCommand(String bmcIP) {
        return GbtUtilityAPI.hwinfoCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> hwinfoCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("hwinfo")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            HwInfoCommand command = new HwInfoCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> hwinfoCommand(String startIP, String endIP) {
        return GbtUtilityAPI.hwinfoCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords hwinfoCommand(HwInfoCommand.Builder builder) {
        HwInfoCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> hwinfoCommand(String startIP, String endIP, HwInfoCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("hwinfo")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            HwInfoCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords smbiosCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        GetSMBIOSCommand command = new GetSMBIOSCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords smbiosCommand(String bmcIP) {
        return GbtUtilityAPI.smbiosCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> smbiosCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("smbios")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetSMBIOSCommand command = new GetSMBIOSCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> smbiosCommand(String startIP, String endIP) {
        return GbtUtilityAPI.smbiosCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords smbiosCommand(GetSMBIOSCommand.Builder builder) {
        GetSMBIOSCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> smbiosCommand(String startIP, String endIP, GetSMBIOSCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        ArrayList<CommandTaskRecords> records = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("smbios")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String string : ipAddresses) {
            GetSMBIOSCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                records.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return records;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            records.add(((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class));
            if (!((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class).getStates().isPass()) continue;
            ++success;
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return records;
    }

    public static final CommandTaskRecords iKVMCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        LaunchiKVMCommand command = new LaunchiKVMCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords iKVMCommand(String bmcIP) {
        return GbtUtilityAPI.iKVMCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> iKVMCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ikvm")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            LaunchiKVMCommand command = new LaunchiKVMCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> iKVMCommand(String startIP, String endIP) {
        return GbtUtilityAPI.iKVMCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords iKVMCommand(LaunchiKVMCommand.Builder builder) {
        LaunchiKVMCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> iKVMCommand(String startIP, String endIP, LaunchiKVMCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ikvm")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            LaunchiKVMCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords gpuFanPolicyGetCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        String actionString = "get";
        GetGPUFanPolicyCommand command = new GetGPUFanPolicyCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(actionString).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords gpuFanPolicyGetCommand(String bmcIP) {
        return GbtUtilityAPI.gpuFanPolicyGetCommand(bmcIP, "admin", "password");
    }

    public static final CommandTaskRecords gpuFanPolicySetCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, int policyID) {
        String actionString = "set";
        GetGPUFanPolicyCommand command = new GetGPUFanPolicyCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(actionString).setPolicyID(policyID).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords gpuFanPolicySetCommand(String bmcIP, int policyID) {
        return GbtUtilityAPI.gpuFanPolicySetCommand(bmcIP, "admin", "password", policyID);
    }

    public static final List<CommandTaskRecords> gpuFanPolicyGetCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        String actionString = "get";
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("gpufan")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetGPUFanPolicyCommand command = new GetGPUFanPolicyCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(actionString).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> gpuFanPolicyGetCommand(String startIP, String endIP) {
        return GbtUtilityAPI.gpuFanPolicyGetCommand(startIP, endIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> gpuFanPolicySetCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, int policyID) {
        String actionString = "set";
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("gpufan")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetGPUFanPolicyCommand command = new GetGPUFanPolicyCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(actionString).setPolicyID(policyID).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> gpuFanPolicySetCommand(String startIP, String endIP, int policy) {
        return GbtUtilityAPI.gpuFanPolicySetCommand(startIP, endIP, "admin", "password", policy);
    }

    public static final CommandTaskRecords gpuFanPolicyCommand(GetGPUFanPolicyCommand.Builder builder) {
        GetGPUFanPolicyCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> gpuFanPolicyCommand(String startIP, String endIP, GetGPUFanPolicyCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("gpufan")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetGPUFanPolicyCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords pefCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, PefActions item, boolean doPET) {
        PEFCommand command = new PEFCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setPefActions(item).setEnable(doPET).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords pefCommand(String bmcIP, PefActions item, boolean doPET) {
        return GbtUtilityAPI.pefCommand(bmcIP, "admin", "password", item, doPET);
    }

    public static final List<CommandTaskRecords> pefCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, PefActions item, boolean doPET) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("pef")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            PEFCommand command = new PEFCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setPefActions(item).setEnable(doPET).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> pefCommand(String startIP, String endIP, PefActions item, boolean doPET) {
        return GbtUtilityAPI.pefCommand(startIP, endIP, "admin", "password", item, doPET);
    }

    public static final CommandTaskRecords pefCommand(PEFCommand.Builder builder) {
        PEFCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> pefCommand(String startIP, String endIP, PEFCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("pef")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            PEFCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords ntpSetReqModeDisableCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        NtpCommand command = new NtpCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(true).setNtpUploadData(new NtpJsonData().setOperationMode(NtpOperationMode.Disable)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords ntpSetReqModeDisableCommand(String bmcIP) {
        return GbtUtilityAPI.ntpSetReqModeDisableCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> ntpSetReqModeDisableCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ntp")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            NtpCommand command = new NtpCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(true).setNtpUploadData(new NtpJsonData().setOperationMode(NtpOperationMode.Disable)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> ntpSetReqModeDisableCommand(String startIP, String endIP) {
        return GbtUtilityAPI.ntpSetReqModeDisableCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords ntpGetCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, int serverID) {
        NtpCommand command = new NtpCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(false).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords ntpGetCommand(String bmcIP, int serverID) {
        return GbtUtilityAPI.ntpGetCommand(bmcIP, "admin", "password", serverID);
    }

    public static final List<CommandTaskRecords> ntpGetCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, int serverID) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ntp")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            NtpCommand command = new NtpCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(false).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> ntpGetCommand(String startIP, String endIP, int serverID) {
        return GbtUtilityAPI.ntpGetCommand(startIP, endIP, "admin", "password", serverID);
    }

    public static final CommandTaskRecords ntpSetCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, NtpJsonData uploadData) {
        NtpCommand command = new NtpCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(true).setNtpUploadData(uploadData).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords ntpSetCommand(String bmcIP, NtpJsonData uploadData) {
        return GbtUtilityAPI.ntpSetCommand(bmcIP, "admin", "password", uploadData);
    }

    public static final List<CommandTaskRecords> ntpSetCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, NtpJsonData uploadData) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ntp")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            NtpCommand command = new NtpCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(true).setNtpUploadData(uploadData).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> ntpSetCommand(String startIP, String endIP, NtpJsonData uploadData) {
        return GbtUtilityAPI.ntpSetCommand(startIP, endIP, "admin", "password", uploadData);
    }

    public static final CommandTaskRecords ntpCommand(NtpCommand.Builder builder) {
        NtpCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> ntpCommand(String startIP, String endIP, NtpCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ntp")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            NtpCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords bpInfoCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        GetFRUCommand command = new GetFRUCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setFRUType(FRUType.BPB).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bpInfoCommand(String bmcIP) {
        return GbtUtilityAPI.bpInfoCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> bpInfoCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("fru")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetFRUCommand command = new GetFRUCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setFRUType(FRUType.BPB).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bpInfoCommand(String startIP, String endIP) {
        return GbtUtilityAPI.bpInfoCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords bpInfoCommand(GetFRUCommand.Builder builder) {
        GetFRUCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> bpInfoCommand(String startIP, String endIP, GetFRUCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("fru")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetFRUCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords psuInfoCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        GetFRUCommand command = new GetFRUCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setFRUType(FRUType.PSU).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords psuInfoCommand(String bmcIP) {
        return GbtUtilityAPI.psuInfoCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> psuInfoCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("fru")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetFRUCommand command = new GetFRUCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setFRUType(FRUType.PSU).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> psuInfoCommand(String startIP, String endIP) {
        return GbtUtilityAPI.psuInfoCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords psuInfoCommand(GetFRUCommand.Builder builder) {
        GetFRUCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> psuInfoCommand(String startIP, String endIP, GetFRUCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("fru")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetFRUCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords vmcliUnmountCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        VmcliCommand command = new VmcliCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).unmount().build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords vmcliUnmountCommand(String bmcIP) {
        return GbtUtilityAPI.vmcliUnmountCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> vmcliUnmountCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("vmcli")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            VmcliCommand command = new VmcliCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).unmount().build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> vmcliUnmountCommand(String startIP, String endIP) {
        return GbtUtilityAPI.vmcliUnmountCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords vmcliMountCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, int port, String iso, String floppy, String removable) {
        VmcliCommand command = new VmcliCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).mount().setFreePort(port).setISOImages(iso).setFloppyImages(floppy).setRemovableDev(removable).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords vmcliMountCommand(String bmcIP, int port, String iso, String floppy, String removable) {
        return GbtUtilityAPI.vmcliMountCommand(bmcIP, "admin", "password", port, iso, floppy, removable);
    }

    public static final List<CommandTaskRecords> vmcliMountCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, int port, String iso, String floppy, String removable) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("vmcli")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            VmcliCommand command = new VmcliCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).mount().setFreePort(port).setISOImages(iso).setFloppyImages(floppy).setRemovableDev(removable).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> vmcliMountCommand(String startIP, String endIP, int port, String iso, String floppy, String removable) {
        return GbtUtilityAPI.vmcliMountCommand(startIP, endIP, "admin", "password", port, iso, floppy, removable);
    }

    public static final CommandTaskRecords vmcliCommand(VmcliCommand.Builder builder) {
        VmcliCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> vmcliCommand(String startIP, String endIP, VmcliCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("vmcli")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            VmcliCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords bmcUtilRobootCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        PhantomJSOptions option = PhantomJSOptions.Reboot;
        BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcUtilRobootCommand(String bmcIP) {
        return GbtUtilityAPI.bmcUtilRobootCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> bmcUtilRobootCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        PhantomJSOptions option = PhantomJSOptions.Reboot;
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcUtilRobootCommand(String startIP, String endIP) {
        return GbtUtilityAPI.bmcUtilRobootCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords bmcUtilPrtscCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.Dump;
        BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcUtilPrtscCommand(String bmcIP, String path) {
        return GbtUtilityAPI.bmcUtilPrtscCommand(bmcIP, "admin", "password", path);
    }

    public static final List<CommandTaskRecords> bmcUtilPrtscCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.Dump;
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcUtilPrtscCommand(String startIP, String endIP, String path) {
        return GbtUtilityAPI.bmcUtilPrtscCommand(startIP, endIP, "admin", "password", path);
    }

    public static final CommandTaskRecords bmcUtilBackupCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.Backup;
        BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcUtilBackupCommand(String bmcIP, String path) {
        return GbtUtilityAPI.bmcUtilBackupCommand(bmcIP, "admin", "password", path);
    }

    public static final List<CommandTaskRecords> bmcUtilBackupCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.Backup;
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcUtilBackupCommand(String startIP, String endIP, String path) {
        return GbtUtilityAPI.bmcUtilBackupCommand(startIP, endIP, "admin", "password", path);
    }

    public static final CommandTaskRecords bmcUtilPhyInfoCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.PHYInfo;
        BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcUtilPhyInfoCommand(String bmcIP, String path) {
        return GbtUtilityAPI.bmcUtilPhyInfoCommand(bmcIP, "admin", "password", path);
    }

    public static final List<CommandTaskRecords> bmcUtilPhyInfoCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.PHYInfo;
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcUtilPhyInfoCommand(String startIP, String endIP, String path) {
        return GbtUtilityAPI.bmcUtilPhyInfoCommand(startIP, endIP, "admin", "password", path);
    }

    public static final CommandTaskRecords bmcUtilBiosExportCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.BIOSexport;
        BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcUtilBiosExportCommand(String bmcIP, String path) {
        return GbtUtilityAPI.bmcUtilBiosExportCommand(bmcIP, "admin", "password", path);
    }

    public static final List<CommandTaskRecords> bmcUtilBiosExportCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.BIOSexport;
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcUtilBiosExportCommand(String startIP, String endIP, String path) {
        return GbtUtilityAPI.bmcUtilBiosExportCommand(startIP, endIP, "admin", "password", path);
    }

    public static final CommandTaskRecords bmcUtilGetSMARTHddCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.GetSmartHDD;
        BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcUtilGetSMARTHddCommand(String bmcIP, String path) {
        return GbtUtilityAPI.bmcUtilGetSMARTHddCommand(bmcIP, "admin", "password", path);
    }

    public static final List<CommandTaskRecords> bmcUtilGetSMARTHddCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.GetSmartHDD;
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcUtilGetSMARTHddCommand(String startIP, String endIP, String path) {
        return GbtUtilityAPI.bmcUtilGetSMARTHddCommand(startIP, endIP, "admin", "password", path);
    }

    public static final CommandTaskRecords bmcUtilRestoreCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.Restore;
        BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcUtilRestoreCommand(String bmcIP, String path) {
        return GbtUtilityAPI.bmcUtilRestoreCommand(bmcIP, "admin", "password", path);
    }

    public static final List<CommandTaskRecords> bmcUtilRestoreCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.Restore;
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcUtilRestoreCommand(String startIP, String endIP, String path) {
        return GbtUtilityAPI.bmcUtilRestoreCommand(startIP, endIP, "admin", "password", path);
    }

    public static final CommandTaskRecords bmcUtilBIOSImportCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.BIOSimport;
        BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcUtilBIOSImportCommand(String bmcIP, String path) {
        return GbtUtilityAPI.bmcUtilBIOSImportCommand(bmcIP, "admin", "password", path);
    }

    public static final List<CommandTaskRecords> bmcUtilBIOSImportCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String path) {
        PhantomJSOptions option = PhantomJSOptions.BIOSimport;
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = new BMCUtilCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(option).setFilePath(new File(path)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcUtilBIOSImportCommand(String startIP, String endIP, String path) {
        return GbtUtilityAPI.bmcUtilBIOSImportCommand(startIP, endIP, "admin", "password", path);
    }

    public static final CommandTaskRecords BMCUtilCommand(BMCUtilCommand.Builder builder) {
        BMCUtilCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> BMCUtilCommand(String startIP, String endIP, BMCUtilCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("bmcutil")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCUtilCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords ipv6Command(String bmcIP, String bmcUserName, String bmcUserPasswd, int command) {
        IPv6ConfigCommand configCommand = new IPv6ConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setCommand(command).build();
        CommandTaskRecords record = new CommandTaskRecords(configCommand);
        if (!configCommand.checkAll()) {
            try {
                configCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!configCommand.execute()) {
            try {
                configCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            configCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords ipv6Command(String bmcIP, int command) {
        return GbtUtilityAPI.ipv6Command(bmcIP, "admin", "password", command);
    }

    public static final List<CommandTaskRecords> ipv6Command(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, int command) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ipv6")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            IPv6ConfigCommand configCommand = new IPv6ConfigCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setCommand(command).build();
            CommandTaskRecords record = new CommandTaskRecords(configCommand);
            if (!configCommand.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(configCommand));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> ipv6Command(String startIP, String endIP, int command) {
        return GbtUtilityAPI.ipv6Command(startIP, endIP, "admin", "password", command);
    }

    public static final CommandTaskRecords ipv6Command(IPv6ConfigCommand.Builder builder) {
        IPv6ConfigCommand configCommand = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(configCommand);
        if (!configCommand.checkAll()) {
            try {
                configCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!configCommand.execute()) {
            try {
                configCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            configCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> ipv6Command(String startIP, String endIP, IPv6ConfigCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ipv6")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            IPv6ConfigCommand configCommand = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(configCommand);
            if (!configCommand.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(configCommand));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords msrCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        MSRCommand msrCommand = new MSRCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(msrCommand);
        if (!msrCommand.checkAll()) {
            try {
                msrCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!msrCommand.execute()) {
            try {
                msrCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            msrCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords msrCommand(String bmcIP) {
        return GbtUtilityAPI.msrCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> msrCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("msr")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            MSRCommand msrCommand = new MSRCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(msrCommand);
            if (!msrCommand.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(msrCommand));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> msrCommand(String startIP, String endIP) {
        return GbtUtilityAPI.msrCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords msrCommand(MSRCommand.Builder builder) {
        MSRCommand msrCommand = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(msrCommand);
        if (!msrCommand.checkAll()) {
            try {
                msrCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!msrCommand.execute()) {
            try {
                msrCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            msrCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> msrCommand(String startIP, String endIP, MSRCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("msr")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            MSRCommand msrCommand = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(msrCommand);
            if (!msrCommand.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(msrCommand));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords ipSrcCommandGet(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        IPSrcCommand ipSrcCommand = new IPSrcCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(ipSrcCommand);
        if (!ipSrcCommand.checkAll()) {
            try {
                ipSrcCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!ipSrcCommand.execute()) {
            try {
                ipSrcCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            ipSrcCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords ipSrcCommandGet(String bmcIP) {
        return GbtUtilityAPI.ipSrcCommandGet(bmcIP, "admin", "password");
    }

    public static final CommandTaskRecords ipSrcCommandSet(String bmcIP, String bmcUserName, String bmcUserPasswd, int value) {
        IPSrcCommand ipSrcCommand = new IPSrcCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setIpSource(BMCLanConfigIPSource.parseByByte((byte)value)).build();
        CommandTaskRecords record = new CommandTaskRecords(ipSrcCommand);
        if (!ipSrcCommand.checkAll()) {
            try {
                ipSrcCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!ipSrcCommand.execute()) {
            try {
                ipSrcCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            ipSrcCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords ipSrcCommandSet(String bmcIP, int value) {
        return GbtUtilityAPI.ipSrcCommandSet(bmcIP, "admin", "password", (byte)value);
    }

    public static final List<CommandTaskRecords> ipSrcCommandGet(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ipsrc")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            IPSrcCommand ipSrCommand = new IPSrcCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(ipSrCommand);
            if (!ipSrCommand.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(ipSrCommand));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> ipSrcCommandGet(String startIP, String endIP) {
        return GbtUtilityAPI.ipSrcCommandGet(startIP, endIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> ipSrcCommandSet(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, int value) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ipsrc")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            IPSrcCommand ipSrCommand = new IPSrcCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setIpSource(BMCLanConfigIPSource.parseByByte((byte)value)).build();
            CommandTaskRecords record = new CommandTaskRecords(ipSrCommand);
            if (!ipSrCommand.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(ipSrCommand));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> ipSrcCommandSet(String startIP, String endIP, int value) {
        return GbtUtilityAPI.ipSrcCommandSet(startIP, endIP, "admin", "password", value);
    }

    public static final CommandTaskRecords ipSrcCommand(IPSrcCommand.Builder builder) {
        IPSrcCommand ipSrcCommand = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(ipSrcCommand);
        if (!ipSrcCommand.checkAll()) {
            try {
                ipSrcCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!ipSrcCommand.execute()) {
            try {
                ipSrcCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            ipSrcCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record;
    }

    public static final List<CommandTaskRecords> ipSrcCommand(String startIP, String endIP, IPSrcCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("ipsrc")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            IPSrcCommand ipSrCommand = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(ipSrCommand);
            if (!ipSrCommand.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(ipSrCommand));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords logoChangeCommand(String bmcIP, String bmcUsername, String bmcPassword, String logo_background, String logo_left) {
        LogoChangeCommand logoChangeCommand = new LogoChangeCommand.Builder().setBMCIP(bmcIP).setLOGOImages(logo_background, logo_left).build();
        CommandTaskRecords record = new CommandTaskRecords(logoChangeCommand);
        if (!logoChangeCommand.checkAll()) {
            try {
                logoChangeCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!logoChangeCommand.execute()) {
            try {
                logoChangeCommand.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            logoChangeCommand.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords logoChangeCommand(String bmcIP, String logo_background, String logo_left) {
        return GbtUtilityAPI.logoChangeCommand(bmcIP, "admin", "password", logo_background, logo_left);
    }

    public static final List<CommandTaskRecords> logoChangeCommand(String startIP, String endIP, String bmcUsername, String bmcPassword, String logo_background, String logo_left) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("logochange")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            LogoChangeCommand command = new LogoChangeCommand.Builder().setBMCIP(string).setLOGOImages(logo_background, logo_left).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> logoChangeCommand(String startIP, String endIP, String logo_background, String logo_left) {
        return GbtUtilityAPI.logoChangeCommand(startIP, endIP, "admin", "password", logo_background, logo_left);
    }

    public static final CommandTaskRecords logoChangeCommand(LogoChangeCommand.Builder builder) {
        LogoChangeCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> logoChangeCommand(String startIP, String endIP, LogoChangeCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("logochange")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            LogoChangeCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords loadDefaultCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String cmdType) {
        LoadDefaultCommand command = new LoadDefaultCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setCommandType(cmdType).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords loadDefaultCommand(String bmcIP, String cmdType) {
        return GbtUtilityAPI.loadDefaultCommand(bmcIP, "admin", "password", cmdType);
    }

    public static final List<CommandTaskRecords> loadDefaultCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String cmdType) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("loaddf")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            LoadDefaultCommand command = new LoadDefaultCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setCommandType(cmdType).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> loadDefaultCommand(String startIP, String endIP, String cmdType) {
        return GbtUtilityAPI.loadDefaultCommand(startIP, endIP, "admin", "password", cmdType);
    }

    public static final CommandTaskRecords loadDefaultCommand(LoadDefaultCommand.Builder builder) {
        LoadDefaultCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> loadDefaultCommand(String startIP, String endIP, LoadDefaultCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("loaddf")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            LoadDefaultCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords localCommandOnlineUpdate(String updateType) {
        String comType = "onlineupdate";
        LocalSubCommand command = new LocalSubCommand.Builder().setComType(comType).setUpdtaeType(updateType).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords localCommandSavedf() {
        String comType = "savedf";
        LocalSubCommand command = new LocalSubCommand.Builder().setComType(comType).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords localCommand(LocalSubCommand.Builder builder) {
        LocalSubCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords getBMCInfoCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        GetBMCInfoCommand command = new GetBMCInfoCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords getBMCInfoCommand(String bmcIP) {
        return GbtUtilityAPI.getBMCInfoCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> getBMCInfoCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("mcinfo")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetBMCInfoCommand command = new GetBMCInfoCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> getBMCInfoCommand(String startIP, String endIP) {
        return GbtUtilityAPI.getBMCInfoCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords getBMCInfoCommand(GetBMCInfoCommand.Builder builder) {
        GetBMCInfoCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> getBMCInfoCommand(String startIP, String endIP, GetBMCInfoCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("mcinfo")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetBMCInfoCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords GetMACListCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, int groupID) {
        GetMACListCommand command = new GetMACListCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setGroupID(groupID).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords GetMACListCommand(String bmcIP, int groupID) {
        return GbtUtilityAPI.GetMACListCommand(bmcIP, "admin", "password", groupID);
    }

    public static final List<CommandTaskRecords> GetMACListCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, int groupID) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("mac")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetMACListCommand command = new GetMACListCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setGroupID(groupID).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> GetMACListCommand(String startIP, String endIP, int groupID) {
        return GbtUtilityAPI.GetMACListCommand(startIP, endIP, "admin", "password", groupID);
    }

    public static final CommandTaskRecords GetMACListCommand(GetMACListCommand.Builder builder) {
        GetMACListCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> GetMACListCommand(String startIP, String endIP, GetMACListCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("mac")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetMACListCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords powerLimitSetCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, int limitNum) {
        PowerLimitCommand command = new PowerLimitCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setPowerOption(PowerIpmiOptions.SET).setPowerLimit(limitNum).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords powerLimitCloseCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        PowerLimitCommand command = new PowerLimitCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setPowerOption(PowerIpmiOptions.DEACTIVATE).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords powerLimitSetCommand(String bmcIP, int limitNum) {
        return GbtUtilityAPI.powerLimitSetCommand(bmcIP, "admin", "password", limitNum);
    }

    public static final CommandTaskRecords powerLimitCloseCommand(String bmcIP) {
        return GbtUtilityAPI.powerLimitCloseCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> powerLimitSetCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, int limitNum) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("limit")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            PowerLimitCommand command = new PowerLimitCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setPowerOption(PowerIpmiOptions.SET).setPowerLimit(limitNum).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> powerLimitCloseCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("limit")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            PowerLimitCommand command = new PowerLimitCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setPowerOption(PowerIpmiOptions.DEACTIVATE).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> powerLimitSetCommand(String startIP, String endIP, int limitNum) {
        return GbtUtilityAPI.powerLimitSetCommand(startIP, endIP, "admin", "password", limitNum);
    }

    public static final List<CommandTaskRecords> powerLimitCloseCommand(String startIP, String endIP) {
        return GbtUtilityAPI.powerLimitCloseCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords powerLimitCommand(PowerLimitCommand.Builder builder) {
        PowerLimitCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> powerLimitCommand(String startIP, String endIP, PowerLimitCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("limit")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            PowerLimitCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords setBootOptionCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, String option) {
        SetBootOptionCommand command = new SetBootOptionCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setBootOption(BootOptions.parserOptions(option)).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords setBootOptionCommand(String bmcIP, String option) {
        return GbtUtilityAPI.setBootOptionCommand(bmcIP, "admin", "password", option);
    }

    public static final List<CommandTaskRecords> setBootOptionCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String option) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("boot")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            SetBootOptionCommand command = new SetBootOptionCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setBootOption(BootOptions.parserOptions(option)).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> setBootOptionCommand(String startIP, String endIP, String option) {
        return GbtUtilityAPI.setBootOptionCommand(startIP, endIP, "admin", "password", option);
    }

    public static final CommandTaskRecords setBootOptionCommand(SetBootOptionCommand.Builder builder) {
        SetBootOptionCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> setBootOptionCommand(String startIP, String endIP, SetBootOptionCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("boot")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            SetBootOptionCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords getPowerReadingCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        GetPowerReadingCommand command = new GetPowerReadingCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords getPowerReadingCommand(String bmcIP) {
        return GbtUtilityAPI.getPowerReadingCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> getPowerReadingCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("power")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetPowerReadingCommand command = new GetPowerReadingCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> getPowerReadingCommand(String startIP, String endIP) {
        return GbtUtilityAPI.getPowerReadingCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords getPowerReadingCommand(GetPowerReadingCommand.Builder builder) {
        GetPowerReadingCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> getPowerReadingCommand(String startIP, String endIP, GetPowerReadingCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("power")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetPowerReadingCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords selCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, SELIPMIOptions option) {
        SELCommand command = new SELCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setSELOption(option).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords selCommand(String bmcIP, SELIPMIOptions option) {
        return GbtUtilityAPI.selCommand(bmcIP, "admin", "password", option);
    }

    public static final CommandTaskRecords selCommandTimeSet(String bmcIP, String bmcUserName, String bmcUserPasswd, Date date) {
        SELCommand command = new SELCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setSELOption(SELIPMIOptions.TimeSet).setSELDate(date).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords selCommandTimeSet(String bmcIP, Date date) {
        return GbtUtilityAPI.selCommandTimeSet(bmcIP, "admin", "password", date);
    }

    public static final CommandTaskRecords selCommandTimeGet(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        SELCommand command = new SELCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setSELOption(SELIPMIOptions.TimeGet).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords selCommandTimeGet(String bmcIP) {
        return GbtUtilityAPI.selCommandTimeGet(bmcIP, "admin", "password");
    }

    public static final CommandTaskRecords selCommand(SELCommand.Builder builder) {
        SELCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> selCommand(String startIP, String endIP, SELCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("sel")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            SELCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords fruCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        GetFRUCommand command = new GetFRUCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords fruCommand(String bmcIP) {
        return GbtUtilityAPI.fruCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> fruCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("fru")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetFRUCommand command = new GetFRUCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> fruCommand(String startIP, String endIP) {
        return GbtUtilityAPI.fruCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords fruCommand(GetFRUCommand.Builder builder) {
        GetFRUCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> fruCommand(String startIP, String endIP, GetFRUCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("fru")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            GetFRUCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords identifyCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, int lightTime) {
        IdentifyCommand command = new IdentifyCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setLightTime(lightTime).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords identifyCommand(String bmcIP, int lightTime) {
        return GbtUtilityAPI.identifyCommand(bmcIP, "admin", "password", lightTime);
    }

    public static final List<CommandTaskRecords> identifyCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, int lightTime) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("identify")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            IdentifyCommand command = new IdentifyCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setLightTime(lightTime).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> identifyCommand(String startIP, String endIP, int lightTime) {
        return GbtUtilityAPI.identifyCommand(startIP, endIP, "admin", "password", lightTime);
    }

    public static final CommandTaskRecords identifyCommand(IdentifyCommand.Builder builder) {
        IdentifyCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> identifyCommand(String startIP, String endIP, IdentifyCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("identify")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            IdentifyCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords userAccountCommandList(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        UserAccountCommand command = new UserAccountCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(UserAccountCommandActions.LIST).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords userAccountCommandList(String bmcIP) {
        return GbtUtilityAPI.userAccountCommandList(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> userAccountCommandList(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("userapp")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            UserAccountCommand command = new UserAccountCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAction(UserAccountCommandActions.LIST).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> userAccountCommandList(String startIP, String endIP) {
        return GbtUtilityAPI.userAccountCommandList(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords userAccountCommandSet(String bmcIP, String bmcUserName, String bmcUserPasswd, String accountName, String accountPassword, int accountIDNumber, PrivilegeLevel level) {
        UserAccountCommand command = new UserAccountCommand.Builder().setAction(UserAccountCommandActions.SET).setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAccountName(accountName).setAccountPassword(accountPassword).setAccountIDNumber((byte)accountIDNumber).setPrivilegeLevel(level).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords userAccountCommandSet(String bmcIP, String accountName, String accountPassword, int accountIDNumber, PrivilegeLevel level) {
        return GbtUtilityAPI.userAccountCommandSet(bmcIP, "admin", "password", accountName, accountPassword, accountIDNumber, level);
    }

    public static final List<CommandTaskRecords> userAccountCommandSet(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, String accountName, String accountPassword, int accountIDNumber, PrivilegeLevel level) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("userapp")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            UserAccountCommand command = new UserAccountCommand.Builder().setAction(UserAccountCommandActions.SET).setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setAccountName(accountName).setAccountPassword(accountPassword).setAccountIDNumber((byte)accountIDNumber).setPrivilegeLevel(level).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> userAccountCommandSet(String startIP, String endIP, String accountName, String accountPassword, int accountIDNumber, PrivilegeLevel level) {
        return GbtUtilityAPI.userAccountCommandSet(startIP, endIP, "admin", "password", accountName, accountPassword, accountIDNumber, level);
    }

    public static final CommandTaskRecords userAccountCommand(UserAccountCommand.Builder builder) {
        UserAccountCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> userAccountCommand(String startIP, String endIP, UserAccountCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("userapp")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            UserAccountCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords sdrCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, boolean listModeString) {
        SDRCommand command = new SDRCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(SDRIpmiOptions.GET_SDR_SENSOR_RECORDS).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords sdrCommand(String bmcIP, boolean listModeString) {
        return GbtUtilityAPI.sdrCommand(bmcIP, "admin", "password", listModeString);
    }

    public static final List<CommandTaskRecords> sdrCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, boolean listModeString) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("sdr")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            SDRCommand command = new SDRCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setOption(SDRIpmiOptions.GET_SDR_SENSOR_RECORDS).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> sdrCommand(String startIP, String endIP, boolean listModeString) {
        return GbtUtilityAPI.sdrCommand(startIP, endIP, "admin", "password", listModeString);
    }

    public static final CommandTaskRecords sdrCommand(SDRCommand.Builder builder) {
        SDRCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> sdrCommand(String startIP, String endIP, SDRCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("sdr")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            SDRCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final CommandTaskRecords meVersionCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        MeVersionCommand command = new MeVersionCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords meVersionCommand(String bmcIP) {
        return GbtUtilityAPI.meVersionCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> meVersionCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("meversion")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            MeVersionCommand command = new MeVersionCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> meVersionCommand(String startIP, String endIP) {
        return GbtUtilityAPI.meVersionCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords meVersionCommand(MeVersionCommand.Builder builder) {
        MeVersionCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> meVersionCommand(String startIP, String endIP, MeVersionCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        ArrayList<CommandTaskRecords> records = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("meversion")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String string : ipAddresses) {
            MeVersionCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                records.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return records;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            records.add(((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class));
            if (!((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class).getStates().isPass()) continue;
            ++success;
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return records;
    }

    public static final CommandTaskRecords postCodeCommand(String bmcIP, String bmcUserName, String bmcUserPasswd) {
        PostCodeCommand command = new PostCodeCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords postCodeCommand(String bmcIP) {
        return GbtUtilityAPI.postCodeCommand(bmcIP, "admin", "password");
    }

    public static final List<CommandTaskRecords> postCodeCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("postcode")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            PostCodeCommand command = new PostCodeCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> postCodeCommand(String startIP, String endIP) {
        return GbtUtilityAPI.postCodeCommand(startIP, endIP, "admin", "password");
    }

    public static final CommandTaskRecords postCodeCommand(PostCodeCommand.Builder builder) {
        PostCodeCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> postCodeCommand(String startIP, String endIP, PostCodeCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        ArrayList<CommandTaskRecords> records = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("postcode")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String string : ipAddresses) {
            PostCodeCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                records.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return records;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            records.add(((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class));
            if (!((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class).getStates().isPass()) continue;
            ++success;
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return records;
    }

    public static final CommandTaskRecords rawCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, byte[] rawData) {
        IPMIRawCommand command = new IPMIRawCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setRawData(rawData).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords rawCommand(String bmcIP, byte[] rawData) {
        return GbtUtilityAPI.rawCommand(bmcIP, "admin", "password", rawData);
    }

    public static final List<CommandTaskRecords> rawCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, byte[] rawData) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("raw")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            IPMIRawCommand command = new IPMIRawCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setRawData(rawData).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> rawCommand(String startIP, String endIP, byte[] rawData) {
        return GbtUtilityAPI.rawCommand(startIP, endIP, "admin", "password", rawData);
    }

    public static final CommandTaskRecords rawCommand(IPMIRawCommand.Builder builder) {
        IPMIRawCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> rawCommand(String startIP, String endIP, IPMIRawCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        ArrayList<CommandTaskRecords> records = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("raw")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String string : ipAddresses) {
            IPMIRawCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                records.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return records;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            records.add(((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class));
            if (!((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class).getStates().isPass()) continue;
            ++success;
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return records;
    }

    public static final CommandTaskRecords bmcLanConfigCommand(String bmcIP, String bmcUserName, String bmcUserPasswd, byte channel) {
        BMCLanConfigCommand command = new BMCLanConfigCommand.Builder().setBMCIP(bmcIP).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setChannel(channel).build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            record.setStates(EngineRecordStates.Fail);
            return record;
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final CommandTaskRecords bmcLanConfigCommand(String bmcIP, byte channel) {
        return GbtUtilityAPI.bmcLanConfigCommand(bmcIP, "admin", "password", channel);
    }

    public static final List<CommandTaskRecords> bmcLanConfigCommand(String startIP, String endIP, String bmcUserName, String bmcUserPasswd, byte channel) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("lanprint")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        ArrayList<CommandTaskRecords> commandTaskRecordsList = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        for (String string : ipAddresses) {
            BMCLanConfigCommand command = new BMCLanConfigCommand.Builder().setBMCIP(string).setBMCUsername(bmcUserName).setBMCPassword(bmcUserPasswd).setChannel(channel).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                commandTaskRecordsList.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return commandTaskRecordsList;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            CommandTaskRecords records = ((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class);
            if (records.getStates().isPass()) {
                ++success;
            }
            commandTaskRecordsList.add(records);
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return commandTaskRecordsList;
    }

    public static final List<CommandTaskRecords> bmcLanConfigCommand(String startIP, String endIP, byte channel) {
        return GbtUtilityAPI.bmcLanConfigCommand(startIP, endIP, "admin", "password", channel);
    }

    public static final CommandTaskRecords bmcLanConfigCommand(BMCLanConfigCommand.Builder builder) {
        BMCLanConfigCommand command = builder.build();
        CommandTaskRecords record = new CommandTaskRecords(command);
        if (!command.checkAll()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        if (!command.execute()) {
            try {
                command.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return record.setStates(EngineRecordStates.Fail);
        }
        try {
            command.close();
        }
        catch (Exception e) {
            System.out.println("Resources close error.");
            return record.setStates(EngineRecordStates.Fail);
        }
        return record.setStates(EngineRecordStates.Pass);
    }

    public static final List<CommandTaskRecords> bmcLanConfigCommand(String startIP, String endIP, BMCLanConfigCommand.Builder builder) {
        List<String> ipAddresses = GbtUtilityAPI.scan(startIP, endIP);
        ArrayList<CommandTaskRecords> records = new ArrayList<CommandTaskRecords>();
        boolean checkAllFlag = false;
        EngineThreadPoolFactory factory = ((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)((EngineThreadPoolFactory.FactoryBuilder)new EngineThreadPoolFactory.FactoryBuilder().setPoolName("lanprint")).setThreadNumber(ipAddresses.size())).setPoolType(EngineThreadPoolTypes.FIXED)).setPriority(5)).build();
        DefaultTaskManager taskManager = new DefaultTaskManager(factory);
        for (String string : ipAddresses) {
            BMCLanConfigCommand command = builder.setBMCIP(string).build();
            CommandTaskRecords record = new CommandTaskRecords(command);
            if (!command.checkAll()) {
                record.setStates(EngineRecordStates.Fail);
                records.add(record);
                checkAllFlag = true;
            }
            taskManager.addEngineTask(new CommandTask(command));
        }
        if (checkAllFlag) {
            try {
                taskManager.close();
            }
            catch (Exception e) {
                System.out.println("Resources close error.");
            }
            return records;
        }
        taskManager.executeTasks();
        int success = 0;
        for (String taskID : taskManager.getAllResults().keySet()) {
            records.add(((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class));
            if (!((CommandTaskRecords)taskManager.getAllResults().get(taskID)).castSubRecords(CommandTaskRecords.class).getStates().isPass()) continue;
            ++success;
        }
        System.out.println("Total success nodes : " + success + "\t fail nodes : " + (ipAddresses.size() - success));
        try {
            taskManager.close();
        }
        catch (Exception exception) {
            System.out.println("Resources close error.");
        }
        return records;
    }

    public static final CommandTaskRecords setSMTPSenderInfo(String bmcIP, String senderInfo) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.setSMTPInfo(bmcIP, "admin", "password", senderInfo));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final CommandTaskRecords setSMTPSenderInfo(String bmcIP, String bmcUsername, String bmcPassword, String senderInfo) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.setSMTPInfo(bmcIP, bmcUsername, bmcPassword, senderInfo));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final List<CommandTaskRecords> setSMTPSenderInfo(String startIP, String endIP, String senderInfo) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.setSMTPInfo(ip, "admin", "password", senderInfo));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final List<CommandTaskRecords> setSMTPSenderInfo(String startIP, String endIP, String bmcUsername, String bmcPassword, String senderInfo) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.setSMTPInfo(ip, bmcUsername, bmcPassword, senderInfo));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final CommandTaskRecords setSMTPEmailAddress(String bmcIP, int emailID, boolean enable, String emailAddr, String description, boolean isIpv4) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.setSMTPEmail(bmcIP, "admin", "password", emailID, enable, emailAddr, description, isIpv4));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final CommandTaskRecords setSMTPEmailAddress(String bmcIP, String bmcUsername, String bmcPassword, int emailID, boolean enable, String emailAddr, String description, boolean isIpv4) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.setSMTPEmail(bmcIP, bmcUsername, bmcPassword, emailID, enable, emailAddr, description, isIpv4));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final List<CommandTaskRecords> setSMTPEmailAddress(String startIP, String endIP, int emailID, boolean enable, String emailAddr, String description, boolean isIpv4) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.setSMTPEmail(ip, "admin", "password", emailID, enable, emailAddr, description, isIpv4));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final List<CommandTaskRecords> setSMTPEmailAddress(String startIP, String endIP, String bmcUsername, String bmcPassword, int emailID, boolean enable, String emailAddr, String description, boolean isIpv4) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.setSMTPEmail(ip, bmcUsername, bmcPassword, emailID, enable, emailAddr, description, isIpv4));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final CommandTaskRecords setSMTPServerAddress(String bmcIP, int port, String serverAddr) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.setSMTPServer(bmcIP, "admin", "password", port, serverAddr));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final CommandTaskRecords setSMTPServerAddress(String bmcIP, int port, String bmcUsername, String bmcPassword, String serverAddr) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.setSMTPServer(bmcIP, bmcUsername, bmcPassword, port, serverAddr));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final List<CommandTaskRecords> setSMTPServerAddress(String startIP, String endIP, int port, String serverAddr) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.setSMTPServer(ip, "admin", "password", port, serverAddr));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final List<CommandTaskRecords> setSMTPServerAddress(String startIP, String endIP, String bmcUsername, String bmcPassword, int port, String serverAddr) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.setSMTPServer(ip, bmcUsername, bmcPassword, port, serverAddr));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final CommandTaskRecords setSMTPServerAuthority(String bmcIP, boolean enable, String serverUsername, String serverPassword, SMTPCommand.Builder.TLSModeOptions TLSMode, SMTPCommand.Builder.SASLModeOptions SASLMode) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.setSMTPAutority(bmcIP, "admin", "password", enable, serverUsername, serverPassword, TLSMode, SASLMode));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final CommandTaskRecords setSMTPServerAuthority(String bmcIP, String bmcUsername, String bmcPassword, boolean enable, String serverUsername, String serverPassword, SMTPCommand.Builder.TLSModeOptions TLSMode, SMTPCommand.Builder.SASLModeOptions SASLMode) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.setSMTPAutority(bmcIP, bmcUsername, bmcPassword, enable, serverUsername, serverPassword, TLSMode, SASLMode));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final List<CommandTaskRecords> setSMTPServerAuthority(String startIP, String endIP, boolean enable, String serverUsername, String serverPassword, SMTPCommand.Builder.TLSModeOptions TLSMode, SMTPCommand.Builder.SASLModeOptions SASLMode) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.setSMTPAutority(ip, "admin", "password", enable, serverUsername, serverPassword, TLSMode, SASLMode));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final List<CommandTaskRecords> setSMTPServerAuthority(String startIP, String endIP, String bmcUsername, String bmcPassword, boolean enable, String serverUsername, String serverPassword, SMTPCommand.Builder.TLSModeOptions TLSMode, SMTPCommand.Builder.SASLModeOptions SASLMode) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.setSMTPAutority(ip, bmcUsername, bmcPassword, enable, serverUsername, serverPassword, TLSMode, SASLMode));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final CommandTaskRecords getSMTPConfigurations(String bmcIP) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.getSMTP(bmcIP, "admin", "password"));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final CommandTaskRecords getSMTPConfigurations(String bmcIP, String bmcUsername, String bmcPassword) {
        BatchedInvoker invoker = new BatchedInvoker();
        invoker.invoke(GbtCommandBuilders.getSMTP(bmcIP, "admin", "password"));
        return invoker.getCommandTaskRecords().get(0);
    }

    public static final List<CommandTaskRecords> getSMTPConfigurations(String startIP, String endIP) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.getSMTP(ip, "admin", "password"));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final List<CommandTaskRecords> getSMTPConfigurations(String startIP, String endIP, String bmcUsername, String bmcPassword) {
        ArrayList<AbstractCommandBuilder> builders = new ArrayList<AbstractCommandBuilder>();
        List<String> ipList = GbtUtilityAPI.scan(startIP, endIP);
        for (String ip : ipList) {
            builders.add(GbtCommandBuilders.getSMTP(ip, "admin", "password"));
        }
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builders);
        return invoker.getCommandTaskRecords();
    }

    public static final CommandTaskRecords parserCommandRecord(List<CommandTaskRecords> records, String bmcIP) {
        System.out.println("size:" + records.size());
        for (CommandTaskRecords record : records) {
            System.out.println("ID:" + record.getRecordsID());
            if (!record.getRecordsID().contains(bmcIP)) continue;
            return record;
        }
        return null;
    }

    public static final CommandTaskRecords commonCommand(AbstractCommandBuilder builder) {
        ConcurrentInvoker invoker = new ConcurrentInvoker();
        invoker.invoke(builder);
        return invoker.getCommandTaskRecords().get(0);
    }
}

