/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import Gbt.utility.Common.CommonFunction;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public final class GbtCommonConverters {
    private static final String HEXES = "0123456789ABCDEF";

    private GbtCommonConverters() {
    }

    public static final String addPathQuotationMarks(String input) {
        StringBuilder output = new StringBuilder();
        String[] StringArray = input.split("/");
        for (int i = 0; i < StringArray.length; ++i) {
            if (StringArray[i].indexOf(" ") > 0) {
                StringArray[i] = "\"" + StringArray[i] + "\"";
            }
            output.append(StringArray[i]).append("/");
        }
        return output.substring(0, output.length() - 1);
    }

    public static final int IDtoSlot(int id) {
        int slotIndex = 0;
        slotIndex = id % 2 == 0 ? 80 - id + 2 : 80 - id;
        return slotIndex;
    }

    public static final int OR20IDtoSlot(int id) {
        int slotIndex = 0;
        if (id > 51) {
            id -= 12;
        }
        slotIndex = 84 - (id -= 10);
        return slotIndex;
    }

    public static final int OR25IDtoSlot(int id) {
        int slotIndex = 0;
        if (id > 51) {
            id -= 10;
        }
        slotIndex = 84 - (id -= 10);
        return slotIndex;
    }

    public static final String OR20IDtoPosition(int id) {
        int index = 0;
        index = 96 - (id -= 10);
        return (int)Math.ceil((float)index / 2.0f) + (index % 2 == 1 ? "A" : "B");
    }

    public static final String OR25IDtoPosition(int id) {
        int index = 0;
        index = 96 - (id -= 10);
        return (int)Math.ceil((float)index / 2.0f) + (index % 2 == 1 ? "A" : "B");
    }

    public static final String OCPIDtoPosition(int id) {
        int index = 0;
        index = 124 - (id -= 10);
        return (int)Math.ceil((float)index / 2.0f) + (index % 2 == 1 ? "A" : "B");
    }

    public static final int OCPIDtoSlot(int id) {
        int slotIndex = 0;
        if (id > 51) {
            id -= 12;
        }
        slotIndex = 120 - (id -= 10);
        return slotIndex;
    }

    public static final int IDtoArrayindex(int id) {
        int arrayIndex = 0;
        arrayIndex = id % 2 == 0 ? 80 - id + 1 : 80 - id - 1;
        return arrayIndex;
    }

    public static final int OR20IDtoArrayindex(int id) {
        int arrayIndex = 0;
        if (id > 51) {
            id -= 12;
        }
        arrayIndex = (id -= 10) < 0 ? id + 10 : 84 - id - 1;
        return arrayIndex;
    }

    public static final int OR25IDtoArrayindex(int id) {
        int arrayIndex = 0;
        if (id > 51) {
            id -= 10;
        }
        arrayIndex = (id -= 10) < 0 ? id + 10 : 84 - id - 1;
        return arrayIndex;
    }

    public static final int ByteArraytoInt(byte[] byteArray) {
        int value = 0;
        for (int i = byteArray.length - 1; i >= 0; --i) {
            value = value << 8 | byteArray[i] & 0xFF;
        }
        return value;
    }

    public static final long ByteArraytoLong(byte[] byteArray) {
        long value = 0L;
        for (int i = byteArray.length - 1; i >= 0; --i) {
            value = value << 8 | (long)(byteArray[i] & 0xFF);
        }
        return value;
    }

    public static final byte intToByte(int value) throws IllegalArgumentException {
        if (value > 255 || value < 0) {
            throw new IllegalArgumentException("Value must be in range 0-255.");
        }
        return value < 128 ? (byte)value : (byte)(value - 256);
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static final byte[] LongToByteArray(long value) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < bytes.length; ++i) {
            long mask = 255L;
            bytes[i] = (byte)((value & (mask <<= i * 8)) >> i * 8);
        }
        return bytes;
    }

    public static final String bytesToHex(byte bytes) {
        return "0x" + GbtCommonConverters.bytesToHex(new byte[]{bytes});
    }

    public static final String bytesToHexWith0x(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        hex.append("0x");
        for (byte b : bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static final String bytesToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static final String bytesToHexReverse(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        hex.append("0x");
        for (int i = bytes.length - 1; i >= 0; --i) {
            hex.append(HEXES.charAt((bytes[i] & 0xF0) >> 4)).append(HEXES.charAt(bytes[i] & 0xF));
        }
        return hex.toString();
    }

    public static final BigInteger bytesToDecReverse(byte[] bytes) {
        char[] HEX_ARRAY = HEXES.toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            int v = bytes[i] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        BigInteger bigInt = new BigInteger(new String(hexChars), 16);
        return bigInt;
    }

    public static final String bytesToHexWithSpace(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hex.append("0x").append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF)).append(" ");
        }
        return hex.toString();
    }

    public static final String bytesToHexIpv6look(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static final String bytesToMacAddress(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF)).append(":");
        }
        return hex.toString().substring(0, hex.length() - 1);
    }

    public static final String bytesToMacAddressPure(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString().substring(0, hex.length());
    }

    public static final String bytesToIPv6Address(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        int s = 0;
        for (byte b : bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
            if (s % 2 == 1) {
                hex.append(":");
            }
            ++s;
        }
        String IPv6 = hex.toString().substring(0, hex.length() - 1);
        if (IPv6.equals("0000:0000:0000:0000:0000:0000:0000:0000")) {
            IPv6 = "::";
        }
        return IPv6;
    }

    public static final String bytesToIPv4Address(byte[] bytes) {
        if (bytes.length == 4) {
            return (bytes[0] & 0xFF) + "." + (bytes[1] & 0xFF) + "." + (bytes[2] & 0xFF) + "." + (bytes[3] & 0xFF);
        }
        return "0.0.0.0";
    }

    public static final long swap(long value) {
        long b1 = value >> 0 & 0xFFL;
        long b2 = value >> 8 & 0xFFL;
        long b3 = value >> 16 & 0xFFL;
        long b4 = value >> 24 & 0xFFL;
        long b5 = value >> 32 & 0xFFL;
        long b6 = value >> 40 & 0xFFL;
        long b7 = value >> 48 & 0xFFL;
        long b8 = value >> 56 & 0xFFL;
        return b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 << 0;
    }

    public static final int swap(int value) {
        int b1 = value >> 0 & 0xFF;
        int b2 = value >> 8 & 0xFF;
        int b3 = value >> 16 & 0xFF;
        int b4 = value >> 24 & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
    }

    public static final BigInteger ipToBigInteger(String ipAddress) {
        byte[] bytes;
        if (!CommonFunction.isValidateIP(ipAddress = ipAddress.replace(" ", "").trim())) {
            return null;
        }
        if (ipAddress.contains(":")) {
            if (ipAddress.indexOf("%") > 0) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf("%"));
            }
            bytes = GbtCommonConverters.ipv6ToBytes(ipAddress);
        } else {
            bytes = GbtCommonConverters.ipv4ToBytes(ipAddress);
        }
        return new BigInteger(bytes);
    }

    public static final String BigIntegerToIp(BigInteger ipAddress) {
        byte[] bytes = ipAddress.toByteArray();
        byte[] unsignedBytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        if (bytes.length == 4 || bytes.length == 16) {
            unsignedBytes = bytes;
        }
        try {
            String ip = InetAddress.getByAddress(unsignedBytes).getHostAddress();
            if (bytes.length == 16) {
                ip = ip.replaceAll("((?::0\\b){2,}):?(?!\\S*\\b\\1:0\\b)(\\S*)", "::$2");
            }
            return ip.substring(ip.indexOf(47) + 1).trim();
        }
        catch (UnknownHostException e) {
            if (bytes.length == 16) {
                return "::";
            }
            return "0.0.0.0";
        }
    }

    public static final byte[] ipv6ToBytes(String ipv6) {
        byte[] output = new byte[16];
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipv6);
            byte[] temp = ipAddress.getAddress();
            if (temp.length == 16) {
                System.arraycopy(temp, 0, output, 0, temp.length);
            } else {
                System.out.println("The host is not IPv6");
            }
            return output;
        }
        catch (UnknownHostException e) {
            System.out.println("Unknown host " + ipv6);
            return output;
        }
    }

    public static final byte[] ipv6ToBytesWithIDCode(String ipv6) {
        byte[] output = new byte[17];
        output[0] = 1;
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipv6);
            byte[] temp = ipAddress.getAddress();
            if (temp.length == 16) {
                System.arraycopy(temp, 0, output, 1, temp.length);
            } else {
                System.out.println("The host is not IPv6");
            }
            return output;
        }
        catch (UnknownHostException e) {
            System.out.println("Unknown host " + ipv6);
            return output;
        }
    }

    public static final byte[] ipv4ToBytes(String ipv4) {
        byte[] output = new byte[4];
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipv4);
            byte[] temp = ipAddress.getAddress();
            if (temp.length == 4) {
                System.arraycopy(temp, 0, output, 0, temp.length);
            } else {
                System.out.println("The host is not IPv4");
            }
            return output;
        }
        catch (UnknownHostException e) {
            System.out.println("Unknown host " + ipv4);
            return output;
        }
    }

    public static final byte[] ipv4ToBytesWithIDCode(String ipv4) {
        byte[] output = new byte[5];
        output[0] = 0;
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipv4);
            byte[] temp = ipAddress.getAddress();
            if (temp.length == 4) {
                System.arraycopy(temp, 0, output, 1, temp.length);
            } else {
                System.out.println("The host is not IPv4");
            }
            return output;
        }
        catch (UnknownHostException e) {
            System.out.println("Unknown host " + ipv4);
            return output;
        }
    }

    public static final long ipv4Tolong(String ipAddress) {
        long longIP = 0L;
        byte[] IPbytes = GbtCommonConverters.ipv4ToBytes(ipAddress);
        for (int i = 1; i < 5; ++i) {
            long l = IPbytes[i];
            long mask = 255L;
            int shift = 24 - 8 * (i - 1);
            l = l << shift & (mask <<= shift);
            longIP += l;
        }
        return longIP;
    }

    public static final byte[] ArrayListToRawdata(ArrayList<byte[]> rawdataList) {
        int length = 0;
        ArrayList<Byte> byteArrayList = new ArrayList<Byte>();
        for (byte[] B : rawdataList) {
            length += B.length;
            for (byte b : B) {
                byteArrayList.add(b);
            }
        }
        byte[] rawdata = new byte[length];
        for (int i = 0; i < rawdata.length; ++i) {
            rawdata[i] = (Byte)byteArrayList.get(i);
        }
        return rawdata;
    }

    public static final byte stringToByte(String data) {
        if (data.contains("0x")) {
            data = data.replace("0x", "");
            return (byte)Integer.parseInt(data, 16);
        }
        return (byte)Integer.parseInt(data, 10);
    }

    public static final byte[] stringArray2ByteArray(String[] data) {
        byte[] resultArr = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            resultArr[i] = !data[i].contains("0x") ? GbtCommonConverters.stringToByte("0x" + data[i]) : GbtCommonConverters.stringToByte(data[i]);
        }
        return resultArr;
    }

    public static final byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static final byte[] invertByteArray(byte[] bytes) {
        byte[] temp = new byte[bytes.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = bytes[temp.length - 1 - i];
        }
        return temp;
    }

    public static final byte[] encodePowerLimitRequestData(int value) {
        byte[] ReqData = new byte[2];
        int byteUpperBound = 255;
        int wordUpperBound = Short.MAX_VALUE;
        if (value > byteUpperBound) {
            if (value < wordUpperBound + 1) {
                ReqData[1] = (byte)(value / (byteUpperBound + 1));
                ReqData[0] = (byte)(value % (byteUpperBound + 1));
            } else {
                ReqData[1] = 0;
                ReqData[0] = -36;
            }
        } else {
            ReqData[1] = 0;
            ReqData[0] = (byte)value;
        }
        return ReqData;
    }

    public static final byte[] javaDateToIPMIFRUBytes(String dateDate) {
        DateFormat df = DateFormat.getDateInstance(3, Locale.ENGLISH);
        byte[] output = new byte[3];
        try {
            byte[] buffer = new byte[4];
            buffer = GbtCommonConverters.LongToByteArray(GbtCommonConverters.stringToJavaDate(dateDate).getTime() - df.parse("01/01/96").getTime());
            System.arraycopy(buffer, 0, output, 0, output.length);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return output;
    }

    public static final byte[] javaDateToIPMIBytes(String dateDate) {
        byte[] buffer = new byte[4];
        try {
            buffer = TypeConverter.intToLittleEndianByteArray((int)(GbtCommonConverters.stringToJavaDate(dateDate).getTime() / 1000L));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return buffer;
    }

    public static final byte[] javaDateToIPMIBytes(Date dateDate) {
        byte[] buffer = new byte[4];
        try {
            buffer = TypeConverter.intToLittleEndianByteArray((int)(dateDate.getTime() / 1000L));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return buffer;
    }

    public static final Date ipmiFruBytesToJavaDate(byte[] fruDate) throws ParseException {
        DateFormat df = DateFormat.getDateInstance(3, Locale.ENGLISH);
        byte[] buffer = new byte[4];
        System.arraycopy(fruDate, 0, buffer, 0, buffer.length - 1);
        return new Date(df.parse("01/01/96").getTime() + (long)TypeConverter.littleEndianByteArrayToInt(buffer) * 60000L);
    }

    public static final Date ipmiBytesToJavaDate(byte[] Date2) {
        return new Date((long)TypeConverter.littleEndianByteArrayToInt(Date2) * 1000L);
    }

    public static final Date stringToJavaDate(String source) {
        DateTimeParser[] dateTimeParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss zzz yyyy").getParser(), DateTimeFormat.forPattern((String)"yyyy.MM.dd G 'at' HH:mm:ss z").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ").getParser(), DateTimeFormat.forPattern((String)"yyyyy.MMMMM.dd GGG hh:mm aaa").getParser(), DateTimeFormat.forPattern((String)"EEE, MMM d, ''yy").getParser(), DateTimeFormat.forPattern((String)"EEE, d MMM yyyy HH:mm:ss Z").getParser()};
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(null, dateTimeParsers).toFormatter();
        DateTime date1 = formatter.parseDateTime(source);
        return date1.toDate();
    }

    public static final DateTime stringToJodaDate(String source) {
        DateTimeParser[] dateTimeParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy.MM.dd G 'at' HH:mm:ss z").getParser(), DateTimeFormat.forPattern((String)"yyyyy.MMMMM.dd GGG hh:mm aaa").getParser(), DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss zzz yyyy").getParser(), DateTimeFormat.forPattern((String)"EEE, MMM d, ''yy").getParser(), DateTimeFormat.forPattern((String)"EEE, d MMM yyyy HH:mm:ss Z").getParser()};
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(null, dateTimeParsers).toFormatter();
        return formatter.parseDateTime(source);
    }

    public static final String asciiBytesToString(byte[] asciiBytesArray) {
        if (asciiBytesArray == null || asciiBytesArray.length == 0) {
            return "";
        }
        char[] result = new char[asciiBytesArray.length];
        int count = 0;
        for (int i = 0; i < asciiBytesArray.length; ++i) {
            if (asciiBytesArray[i] != 0) {
                result[i] = (char)asciiBytesArray[i];
                ++count;
                continue;
            }
            result[i] = '\u0000';
        }
        if (count != 0) {
            return new String(result).substring(0, count);
        }
        return "None";
    }

    public static final BigDecimal ipmiBytesToBigDecimal(byte[] rawByte) {
        int value = 0;
        for (int i = 0; i < rawByte.length; ++i) {
            value = (rawByte[i] & 0xFF) << 8 * i | value;
        }
        return new BigDecimal(value);
    }

    public static final File stringToJavaIoFile(String fileName) {
        return new File(!fileName.startsWith("/") && !fileName.contains("\\") ? "./" + fileName : fileName);
    }
}

