/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.FRU;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.FRU.FRUType;
import Gbt.utility.FRU.GbtPowerCapacityIpmiOptions;
import Gbt.utility.FRU.GbtPowerCapacityJSONData;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ChassisInfo;
import Gbt.utility.FRU.record.FruRecord;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.bmcinfo.BMCVendor;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.util.ArrayList;
import java.util.List;

public final class GetFRUCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "fru";
    public static final String BPB_COMMAND_NAME = "bpinfo";
    public static final String PSU_COMMAND_NAME = "psuinfo";
    private static final int FRU_READ_SIZE = 16;
    private static final int PSU_DEFAULT_NUMBER = 2;
    private final GbtIPMICommandReceiver ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    private String _COMMAND_NAME;

    protected GetFRUCommand(Builder commandArgs) {
        super(commandArgs);
        switch (((Builder)this.commandArgs).fruType) {
            case FRU: {
                this._COMMAND_NAME = COMMAND_NAME;
                break;
            }
            case BPB: {
                this._COMMAND_NAME = BPB_COMMAND_NAME;
                break;
            }
            case PSU: {
                this._COMMAND_NAME = PSU_COMMAND_NAME;
                break;
            }
            default: {
                this._COMMAND_NAME = COMMAND_NAME;
            }
        }
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + this._COMMAND_NAME;
    }

    @Override
    public String getCommandName() {
        return this._COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return this._COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this._COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, this.getCommandName(), this.commandID);
        switch (bmcVendor) {
            case VERTIV: 
            case AMI: {
                break;
            }
            case OPENBMC: {
                if (((Builder)this.commandArgs).fruType == FRUType.FRU || ((Builder)this.commandArgs).fruType == FRUType.BPB) break;
                this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
        }
        this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get " + ((Builder)this.commandArgs).fruType.toString() + ".");
        switch (((Builder)this.commandArgs).fruType) {
            case FRU: {
                List<FruRecord> bmcfruData = this.ipmiReceiver.getFRU(handle, ((Builder)this.commandArgs).fruType.getFRUID(), 16, this._COMMAND_NAME, this.commandID);
                if (bmcfruData == null) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this._COMMAND_NAME, this.commandID);
                    this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.commandResults.addAll(bmcfruData);
                this.printFRU();
                break;
            }
            case BPB: {
                List<FruRecord> bpbfruData = this.ipmiReceiver.getFRU(handle, ((Builder)this.commandArgs).fruType.getFRUID(), 16, this._COMMAND_NAME, this.commandID);
                if (bpbfruData == null) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this._COMMAND_NAME, this.commandID);
                    this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.commandResults.addAll(bpbfruData);
                this.printFRU();
                break;
            }
            case PSU: {
                Integer powerNumber = this.getPowerNumber(handle);
                if (powerNumber == null) {
                    powerNumber = 2;
                }
                for (int i = 0; i < powerNumber; ++i) {
                    List<FruRecord> psufruData = this.ipmiReceiver.getFRU(handle, ((Builder)this.commandArgs).fruType.getFRUID() + i, 16, this._COMMAND_NAME, this.commandID);
                    if (psufruData == null) continue;
                    this.commandResults.addAll(psufruData);
                }
                if (this.commandResults.isEmpty()) {
                    this.ipmiReceiver.closeIPMIConnection(handle, this._COMMAND_NAME, this.commandID);
                    this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.printFRU();
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this._COMMAND_NAME, this.commandID);
        this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get " + ((Builder)this.commandArgs).fruType.toString() + " complete.");
        this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public final List<ProductInfo> getProductInfo() {
        if (this.commandResults.isEmpty()) {
            return null;
        }
        ArrayList<ProductInfo> results = new ArrayList<ProductInfo>();
        for (AbstractJSONPOJO record : this.commandResults) {
            if (!(record instanceof ProductInfo)) continue;
            results.add((ProductInfo)record);
        }
        return results;
    }

    public BoardInfo getBoardInfo() {
        if (this.commandResults.isEmpty()) {
            return null;
        }
        for (AbstractJSONPOJO record : this.commandResults) {
            if (!(record instanceof BoardInfo)) continue;
            return (BoardInfo)record;
        }
        return null;
    }

    public ChassisInfo getChassisInfo() {
        if (this.commandResults.isEmpty()) {
            return null;
        }
        for (AbstractJSONPOJO record : this.commandResults) {
            if (!(record instanceof ChassisInfo)) continue;
            return (ChassisInfo)record;
        }
        return null;
    }

    private void printFRU() {
        List<ProductInfo> piList;
        BoardInfo bi;
        if (this.commandResults.isEmpty()) {
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] FRU info is empty.");
            return;
        }
        ChassisInfo ci = this.getChassisInfo();
        if (ci != null) {
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Chassis Serial Number : " + (ci.getChassisSerialNumber() == null ? "NULL" : ci.getChassisSerialNumber()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Chassis Part Number   : " + (ci.getChassisPartNumber() == null ? "NULL" : ci.getChassisPartNumber()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Chassis Type          : " + (ci.getChassisType() == null ? "NULL" : ci.getChassisType()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Chassis Extra info    : " + (ci.getCustomChassisInfo() == null ? "NULL" : ci.getCustomChassisInfo()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "---------------------------------------");
        }
        if ((bi = this.getBoardInfo()) != null) {
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Board Mfg Date        : " + (bi.getMfgDate() == null ? "NULL" : bi.getMfgDate()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Board Mfg             : " + (bi.getBoardManufacturer() == null ? "NULL" : bi.getBoardManufacturer()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Board Product         : " + (bi.getBoardProductName() == null ? "NULL" : bi.getBoardProductName()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Board Serial Number   : " + (bi.getBoardSerialNumber() == null ? "NULL" : bi.getBoardSerialNumber()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Board Part Number     : " + (bi.getBoardPartNumber() == null ? "NULL" : bi.getBoardPartNumber()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Board Extra info      : " + (bi.getCustomBoardInfo() == null ? "NULL" : bi.getCustomBoardInfo()));
            this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "---------------------------------------");
        }
        if ((piList = this.getProductInfo()) != null) {
            for (ProductInfo pi : piList) {
                this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Product Manufacturer  : " + (pi.getManufacturerName() == null ? "NULL" : pi.getManufacturerName()));
                this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Product Name          : " + (pi.getProductName() == null ? "NULL" : pi.getProductName()));
                this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Product Serial Number : " + (pi.getProductSerialNumber() == null ? "NULL" : pi.getProductSerialNumber()));
                this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Product Part Number   : " + (pi.getProductModelNumber() == null ? "NULL" : pi.getProductModelNumber()));
                this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Product Version       : " + (pi.getProductVersion() == null ? "NULL" : pi.getProductVersion()));
                this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Product Asset Tag     : " + (pi.getAssetTag() == null ? "NULL" : pi.getAssetTag()));
                this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "Product Extra info    : " + (pi.getCustomProductInfo() == null ? "NULL" : pi.getCustomProductInfo()));
                this.loggerWriter.appendPath(this._COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "---------------------------------------");
            }
        }
    }

    public static final <T extends FruRecord> T parseFRUrecords(List<FruRecord> records, Class<T> clazz) {
        if (records == null) {
            return null;
        }
        for (FruRecord record : records) {
            if (record.getClass() != clazz) continue;
            return (T)((FruRecord)clazz.cast(record));
        }
        return null;
    }

    private Integer getPowerNumber(ConnectionHandle handle) {
        List<AbstractJSONPOJO> commandResults = this.ipmiReceiver.sendGbtOEMCommand(handle, GbtPowerCapacityIpmiOptions.GET, this.commandArgs, COMMAND_NAME, this.commandID);
        this.commandResults.addAll(commandResults);
        if (commandResults.get(0) instanceof GbtPowerCapacityJSONData) {
            return commandResults.get(0).castConcreteJSON(GbtPowerCapacityJSONData.class).getPsuNmuber();
        }
        return null;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private FRUType fruType = FRUType.FRU;

        @Override
        public boolean checkArgs() {
            if (this.args != null && this.args.length != 0) {
                return false;
            }
            if (this.bmcIP == null) {
                return false;
            }
            return this.fruType != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public GetFRUCommand build() {
            return new GetFRUCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.fruType = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setFRUType(FRUType fruType) {
            this.fruType = fruType;
            return this.getThis();
        }
    }
}

