/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.FRU.record;

import Gbt.utility.FRU.record.FruRecord;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public final class BoardInfo
extends FruRecord {
    private Date mfgDate;
    private String boardManufacturer;
    private String boardProductName;
    private String boardSerialNumber;
    private String boardPartNumber;
    private byte[] fruFileId;
    private String customBoardInfo;

    public BoardInfo(byte[] fruData, int offset) {
        if (fruData[offset] != 1) {
            throw new IllegalArgumentException("Invalid format version");
        }
        int languageCode = TypeConverter.byteToInt(fruData[offset + 2]);
        byte[] buffer = new byte[]{fruData[offset + 3], fruData[offset + 4], fruData[offset + 5], 0};
        DateFormat df = DateFormat.getDateInstance(3, Locale.ENGLISH);
        try {
            this.setMfgDate(new Date(df.parse("01/01/96").getTime() + (long)TypeConverter.littleEndianByteArrayToInt(buffer) * 60000L));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int partNumber = TypeConverter.byteToInt(fruData[offset + 6]);
        offset += 7;
        int index = 0;
        StringBuilder builder = new StringBuilder();
        block9: while (partNumber != 193 && offset < fruData.length) {
            int partType = (partNumber & 0xC0) >> 6;
            int partDataLength = partNumber & 0x3F;
            if (partDataLength > 0 && partDataLength + offset < fruData.length) {
                byte[] partNumberData = new byte[partDataLength];
                System.arraycopy(fruData, offset, partNumberData, 0, partDataLength);
                offset += partDataLength;
                switch (index) {
                    case 0: {
                        this.setBoardManufacturer(BoardInfo.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 1: {
                        this.setBoardProductName(BoardInfo.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 2: {
                        this.setBoardSerialNumber(BoardInfo.decodeString(partType, partNumberData, true));
                        break;
                    }
                    case 3: {
                        this.setBoardPartNumber(BoardInfo.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                        break;
                    }
                    case 4: {
                        this.setFruFileId(partNumberData);
                        break;
                    }
                    default: {
                        if (partDataLength == 0) {
                            partNumber = TypeConverter.byteToInt(fruData[offset]);
                            ++offset;
                            continue block9;
                        }
                        builder.append(BoardInfo.decodeString(partType, partNumberData, languageCode != 0 && languageCode != 25));
                    }
                }
            }
            partNumber = TypeConverter.byteToInt(fruData[offset]);
            ++offset;
            ++index;
        }
        if (builder.length() > 0) {
            this.customBoardInfo = builder.toString();
        }
    }

    @JsonProperty(value="MfgDate")
    public Date getMfgDate() {
        return this.mfgDate;
    }

    public void setMfgDate(Date mfgDate) {
        this.mfgDate = mfgDate;
    }

    @JsonProperty(value="BoardManufacturer")
    public String getBoardManufacturer() {
        return this.boardManufacturer;
    }

    public void setBoardManufacturer(String boardManufacturer) {
        this.boardManufacturer = boardManufacturer;
    }

    @JsonProperty(value="BoardProductName")
    public String getBoardProductName() {
        return this.boardProductName;
    }

    public void setBoardProductName(String boardProductName) {
        this.boardProductName = boardProductName;
    }

    @JsonProperty(value="BoardSerialNumber")
    public String getBoardSerialNumber() {
        return this.boardSerialNumber;
    }

    public void setBoardSerialNumber(String boardSerialNumber) {
        this.boardSerialNumber = boardSerialNumber;
    }

    @JsonProperty(value="BoardPartNumber")
    public String getBoardPartNumber() {
        return this.boardPartNumber;
    }

    public void setBoardPartNumber(String boardPartNumber) {
        this.boardPartNumber = boardPartNumber;
    }

    @JsonProperty(value="FruFileId")
    public byte[] getFruFileId() {
        return this.fruFileId;
    }

    public void setFruFileId(byte[] fruFileId) {
        this.fruFileId = fruFileId;
    }

    @JsonProperty(value="CustomBoardInfo")
    public String getCustomBoardInfo() {
        return this.customBoardInfo;
    }

    public void setCustomBoardInfo(String customBoardInfo) {
        this.customBoardInfo = customBoardInfo;
    }
}

