/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HDDInfo.parsers;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.HDDInfo.HwInfoCollection;
import Gbt.utility.HDDInfo.data.DriveHddInfo;
import Gbt.utility.HDDInfo.data.HddFullInfo;
import Gbt.utility.HDDInfo.data.SasHddInfo;
import Gbt.utility.HDDInfo.parsers.HwInfoParser;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class ParserHDDInfo
extends HwInfoParser {
    public ParserHDDInfo(File binFile) {
        super(binFile, HwInfoCollection.HDD_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractJSONPOJO> parseHwInfo() {
        ArrayList<AbstractJSONPOJO> dataList = new ArrayList<AbstractJSONPOJO>();
        if (this.offset == -1) {
            return dataList;
        }
        FilterInputStream dis = null;
        HddFullInfo hddFullInfo = new HddFullInfo();
        try {
            ArrayList<AbstractJSONPOJO> sasHddInfos;
            byte[] driveType;
            int i;
            dis = new DataInputStream(new FileInputStream(this.binFile));
            ((DataInputStream)dis).skipBytes(this.offset);
            byte[] signature = new byte[4];
            ((DataInputStream)dis).read(signature, 0, signature.length);
            byte[] version = new byte[4];
            ((DataInputStream)dis).read(version, 0, version.length);
            hddFullInfo.setVersion(new String(version, StandardCharsets.UTF_8).trim());
            hddFullInfo.setIntelSataDevCount(new BigDecimal(((DataInputStream)dis).readByte()));
            hddFullInfo.setFirstIntelSataPortNo(new BigDecimal(((DataInputStream)dis).readByte()));
            hddFullInfo.setIntelSSataDevCount(new BigDecimal(((DataInputStream)dis).readByte()));
            hddFullInfo.setFirstIntelSSataPortNo(new BigDecimal(((DataInputStream)dis).readByte()));
            hddFullInfo.setLsiSasDevCount(new BigDecimal(((DataInputStream)dis).readByte()));
            hddFullInfo.setFirstLsiSasPortNo(new BigDecimal(((DataInputStream)dis).readByte()));
            hddFullInfo.setTotalSataDeviceCount(new BigDecimal(((DataInputStream)dis).readByte()));
            hddFullInfo.setTotalSasDeviceCount(new BigDecimal(((DataInputStream)dis).readByte()));
            if (hddFullInfo.getTotalSataDeviceCount().intValue() > 0) {
                ArrayList<DriveHddInfo> driveHddInfos = new ArrayList<DriveHddInfo>();
                hddFullInfo.setDriveHdds(driveHddInfos);
                for (i = 0; i < hddFullInfo.getTotalSataDeviceCount().intValue(); ++i) {
                    DriveHddInfo driveHDD = new DriveHddInfo();
                    driveType = new byte[4];
                    ((DataInputStream)dis).read(driveType, 0, driveType.length);
                    driveHDD.setDriveType(GbtCommonConverters.bytesToHexWith0x(driveType));
                    driveHDD.setPortNumber(new BigDecimal(((DataInputStream)dis).readByte()));
                    byte[] serialNo = new byte[20];
                    ((DataInputStream)dis).read(serialNo, 0, serialNo.length);
                    driveHDD.setSerialNo(new String(serialNo, StandardCharsets.UTF_8).trim());
                    byte[] firmwareVer = new byte[8];
                    ((DataInputStream)dis).read(firmwareVer, 0, firmwareVer.length);
                    driveHDD.setFirmwareVer(new String(firmwareVer, StandardCharsets.UTF_8).trim());
                    byte[] driveName = new byte[40];
                    ((DataInputStream)dis).read(driveName, 0, driveName.length);
                    driveHDD.setDriveName(new String(driveName, StandardCharsets.UTF_8).trim());
                    driveHDD.setSerialAtaCapabilities(new BigDecimal(((DataInputStream)dis).readShort()));
                    driveHDD.setSecurityStatus(new BigDecimal(((DataInputStream)dis).readShort()));
                    byte[] driveSize = new byte[8];
                    ((DataInputStream)dis).read(driveSize, 0, driveSize.length);
                    driveHDD.setDriveSize(new BigInteger(driveSize));
                    int reservedLength = 171;
                    byte[] reserved = new byte[reservedLength];
                    ((DataInputStream)dis).read(reserved, 0, reserved.length);
                    driveHddInfos.add(driveHDD);
                }
            }
            if (hddFullInfo.getTotalSasDeviceCount().intValue() > 0) {
                sasHddInfos = new ArrayList<SasHddInfo>();
                hddFullInfo.setSasHdds(sasHddInfos);
                for (i = 0; i < hddFullInfo.getTotalSasDeviceCount().intValue(); ++i) {
                    SasHddInfo sasHDD = new SasHddInfo();
                    driveType = new byte[4];
                    ((DataInputStream)dis).read(driveType, 0, driveType.length);
                    sasHDD.setDriveType(GbtCommonConverters.bytesToHexWith0x(driveType));
                    byte[] driveSize = new byte[8];
                    ((DataInputStream)dis).read(driveSize, 0, driveSize.length);
                    sasHDD.setDirveSize(new BigInteger(driveSize));
                    byte[] driveName = new byte[40];
                    ((DataInputStream)dis).read(driveName, 0, driveName.length);
                    sasHDD.setDriveName(new String(driveName, StandardCharsets.UTF_8).trim());
                    int reservedLength = 460;
                    byte[] reserved = new byte[reservedLength];
                    ((DataInputStream)dis).read(reserved, 0, reserved.length);
                    sasHddInfos.add(sasHDD);
                }
            }
            dataList.add(hddFullInfo);
            sasHddInfos = dataList;
            return sasHddInfos;
        }
        catch (IOException ioe) {
            ArrayList<AbstractJSONPOJO> arrayList = dataList;
            return arrayList;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    dis = null;
                }
            }
        }
    }
}

