/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.HDDInfo.parsers;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.HDDInfo.HwInfoCollection;
import Gbt.utility.HDDInfo.data.LanDeviceInfo;
import Gbt.utility.HDDInfo.data.LanFullInfo;
import Gbt.utility.HDDInfo.parsers.HwInfoParser;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class ParserLANInfo
extends HwInfoParser {
    public ParserLANInfo(File binFile) {
        super(binFile, HwInfoCollection.LAN_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractJSONPOJO> parseHwInfo() {
        ArrayList<AbstractJSONPOJO> dataList = new ArrayList<AbstractJSONPOJO>();
        if (this.offset == -1) {
            return dataList;
        }
        LanFullInfo lanFullInfo = new LanFullInfo();
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(this.binFile));
            ((DataInputStream)dis).skipBytes(this.offset);
            byte[] signature = new byte[8];
            ((DataInputStream)dis).read(signature, 0, signature.length);
            byte[] checkSum = new byte[2];
            ((DataInputStream)dis).read(checkSum, 0, checkSum.length);
            lanFullInfo.setVersion(((DataInputStream)dis).readByte());
            lanFullInfo.setNumberOfLan(new BigDecimal(((DataInputStream)dis).readByte()));
            int reservedLength = 20;
            byte[] reserved = new byte[reservedLength];
            ((DataInputStream)dis).read(reserved, 0, reserved.length);
            if (lanFullInfo.getNumberOfLan().intValue() > 0) {
                ArrayList<LanDeviceInfo> lanDeviceInfos = new ArrayList<LanDeviceInfo>();
                lanFullInfo.setLanDevices(lanDeviceInfos);
                for (int i = 0; i < lanFullInfo.getNumberOfLan().intValue(); ++i) {
                    LanDeviceInfo lanInfo = new LanDeviceInfo();
                    byte[] deviceName = new byte[32];
                    ((DataInputStream)dis).read(deviceName, 0, deviceName.length);
                    lanInfo.setDeviceName(new String(deviceName, StandardCharsets.UTF_8).trim());
                    lanInfo.setDeviceId(new BigDecimal(((DataInputStream)dis).readShort()));
                    lanInfo.setBusNo(((DataInputStream)dis).readByte());
                    lanInfo.setDevNo(((DataInputStream)dis).readByte());
                    lanInfo.setFunNo(((DataInputStream)dis).readByte());
                    lanInfo.setOnBoardLan(((DataInputStream)dis).readBoolean());
                    byte[] macAddress = new byte[6];
                    ((DataInputStream)dis).read(macAddress, 0, macAddress.length);
                    lanInfo.setMacAddress(GbtCommonConverters.bytesToMacAddress(macAddress));
                    int deviceReservedLength = 84;
                    byte[] deviceReserved = new byte[deviceReservedLength];
                    ((DataInputStream)dis).read(deviceReserved, 0, deviceReserved.length);
                    lanDeviceInfos.add(lanInfo);
                }
            }
            dataList.add(lanFullInfo);
            ArrayList<AbstractJSONPOJO> arrayList = dataList;
            return arrayList;
        }
        catch (IOException ioe) {
            ArrayList<AbstractJSONPOJO> arrayList = dataList;
            return arrayList;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    dis = null;
                }
            }
        }
    }
}

